/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010 Zimbra, Inc.
 *
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 * @author Raja Rao DV rrao@zimbra.com
 *
 * Checks for attach* word in email and also if there is an attachment.
 * If the email does not have an attachment, throws missing-attachment alert dialog
 */

/**
 * Constructor
 */
function com_zimbra_forcereadreceipt_HandlerObj() {
}

com_zimbra_forcereadreceipt_HandlerObj.prototype = new ZmZimletBase();
com_zimbra_forcereadreceipt_HandlerObj.prototype.constructor = com_zimbra_forcereadreceipt_HandlerObj;

/**
 * Simplify Zimlet handler name.
 */
var ForceReadReceiptZimlet = com_zimbra_forcereadreceipt_HandlerObj;

ForceReadReceiptZimlet.prototype.init =
function() {
	this.setSendReceiptToAlways();
	setInterval(AjxCallback.simpleClosure(this.setSendReceiptToAlways, this), 5*60*60*1000);//check every 5 hours
};

/**
 * Using emailErrorCheck hook(as it in at the right place in the flow) to modify request_read_receipt preference.
 */
ForceReadReceiptZimlet.prototype.emailErrorCheck =
function() {
	if (appCtxt.get(ZmSetting.MAIL_READ_RECEIPT_ENABLED)) {
	    var controller = appCtxt.getApp(ZmApp.MAIL).getComposeController(appCtxt.getApp(ZmApp.MAIL).getCurrentSessionId(ZmId.VIEW_COMPOSE));

		var menu = controller._toolbar.getButton(ZmOperation.COMPOSE_OPTIONS).getMenu();
		var mi = menu.getItemById(ZmOperation.KEY_ID, ZmOperation.REQUEST_READ_RECEIPT);
		mi.setChecked(true, true);
	} 
};

/**
 * Sets Send read-receipt to "Always"
 */
ForceReadReceiptZimlet.prototype.setSendReceiptToAlways =
function() {
	if(appCtxt.getActiveAccount().settings.get("MAIL_SEND_READ_RECEIPTS") == "always") {
		return;
	}
	if (appCtxt.get(ZmSetting.MAIL_READ_RECEIPT_ENABLED)) {
		var soapDoc = AjxSoapDoc.create("ModifyPrefsRequest", "urn:zimbraAccount");
		var node = soapDoc.set("pref", "always");
		node.setAttribute("name", "zimbraPrefMailSendReadReceipts");
		var respCallback = new AjxCallback(this, this._handlePrefChangeResponse);
		appCtxt.getAppController().sendRequest({soapDoc:soapDoc, asyncMode:true, callback:respCallback});
	}
};

ForceReadReceiptZimlet.prototype._handlePrefChangeResponse =
function() {
//do nothing as this should happen in the background.
};
