/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2009, 2010 Zimbra, Inc.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */

//////////////////////////////////////////////////////////////////////////////
// Based on the original emaildownloader zimlet this new one allow the user to download also folders.
// @author Lorenzo Fasc
//////////////////////////////////////////////////////////////////////////////

// This function prints objects in a new tab, usefull for degug
function mostra(inobj){
		var op = window.open();
		op.document.open('text/plain');
		for (var objprop in inobj) {
			op.document.write(objprop + ' => ' + inobj[objprop] + '\n');
		}
		op.document.close();
}

function it_seacom_fbackup() {}

it_seacom_fbackup.prototype = new ZmZimletBase();
it_seacom_fbackup.prototype.constructor = it_seacom_fbackup;

var fbackup = it_seacom_fbackup;

fbackup.prototype.init =
function(obj) {
	// I use an hidden frame
	var idFrame = 'framebackupBackup';
	if (document.getElementById(idFrame)){ 
			this._rifFrame = document.getElementById(idFrame) 
	}else{
		this._rifFrame = document.createElement("iframe");
		this._rifFrame.id = idFrame;
		this._rifFrame.style.width = "0px";
		this._rifFrame.style.height = "0px";
		this._rifFrame.style.border = "0";
		document.body.appendChild(this._rifFrame);
	}
};


fbackup.prototype.initializeToolbar =
function(app, toolbar, controller, view) {
	if ((view == "TV-main") || (view == "TV-SR-Mail-1")){
		var actionMenu = toolbar.getActionsMenu();	
		if (actionMenu.getOp("DOWNLOAD_MENU")) {
			return;
		}
		var downloadMenu = actionMenu.createOp("DOWNLOAD_MENU", {
			text : "Download",
			image : "fbackup-panelIcon",
			enabled : true
		});
		downloadMenu.addSelectionListener(new AjxListener(this, this._downloadMenuListener, [controller]));
	}	
};

fbackup.prototype._downloadMenuListener = 
function(controller){
	var ids = [];
	for (var i = 0; i < controller.getSelection().length; i++) {
		ids.push(controller.getSelection()[i].id);
	}
	this._getUrl(ids.join(","), this._setFilenameZip(controller.getSelection()[0].subject));
}	

fbackup.prototype.doDrop =
function(obj) {
	if (typeof(obj.TYPE) == 'undefined') {
		if(obj.length > 1) {
			var	objType = obj[0].TYPE;
			// Se ho un array devo fare un ciclo for per scaricare tutti gli oggetti
			switch (objType) {
				case "ZmFolder":
					this._folderDropped(obj[0]);
					break;
				case "ZmMailMsg":
					this._messageDropped(obj);
					break;
				case "ZmConv":
					this._convDropped(obj);
					break;
				default:this._showWarningMsg(this.getMessage("invalidObject"));
			}
		} else {
			var singleObj = obj[0]; 
			var	objType = singleObj.TYPE;
			switch (objType) {
				case "ZmFolder":
					this._folderDropped(singleObj);
					break;
				case "ZmMailMsg":
					this._messageDropped(singleObj);
					break;
				case "ZmConv":
					this._convDropped(singleObj);
					break;
				default:this._showWarningMsg(this.getMessage("invalidObject"));
			}
		}	
	} else {
		switch (obj.TYPE) {
			case "ZmFolder":
				this._folderDropped(obj);
			break;
			case "ZmMailMsg":
				this._messageDropped(obj);
			break;
			case "ZmConv":
				this._convDropped(obj);
			break;
			default:this._showWarningMsg(this.getMessage("invalidObject"));
		}
	}

};

fbackup.prototype.doubleClicked =
function() {
	this.singleClicked();
}

// Called by the Zimbra framework when the panel item was clicked
fbackup.prototype.singleClicked = function() {
	this._setFolderBtnListener();
}

//------------------------------------------------
//					EMAILS
//------------------------------------------------

fbackup.prototype._convDropped =
function(convObj) {
	if (convObj.length > 1) {
		this._showWarningMsg(this.getMessage("moreThanOneConv"));
		return;
	} else {
		if (typeof(convObj) == 'undefined') {
			this._getMsgIdsFromConv(convObj[0].srcObj)
		} else	{	
			this._getMsgIdsFromConv(convObj.srcObj)
		}	
	}		
};

fbackup.prototype._getMsgIdsFromConv =
function(conv) {
	var callback = new AjxCallback(this, this._getMsgIdsFromConvCallback);
	this.getMsgsForConv(callback, conv);
};
		
fbackup.prototype._getMsgIdsFromConvCallback =
function(response) {
	var filename = "";
	var ids = new Array();
	if(typeof(response[0]) != "undefined"){
		for(var i = 0; i < response.length; i++){
			ids.push(response[i].id);
		}
		filename = "[conv]" + this._setFilenameZip(response[0].subject);
	}else{
		ids.push(response.id);
		filename = this._setFilenameZip(response.subject);
	}
	this._getUrl(ids.join(","), filename);
};

fbackup.prototype._messageDropped =
function(msgObj) {
	if (msgObj.length > 1) {
		var ids = [];
		for (var i = 0; i < msgObj.length; i++) {
			ids.push(msgObj[i].id);
		}
		this._getUrl(ids.join(","),  this._setFilenameZip(msgObj[0].subject));
	} else 	{
		this._getUrl(msgObj.id, this._setFilenameZip(msgObj.subject));
	}
};

fbackup.prototype._getUrl =
function(ids, filename) {
	var d = new Date();
	var curr_date = d.getDate();
	var curr_month = d.getMonth()+1;
	var curr_year = d.getFullYear();
	var today = curr_date + "-" + curr_month + "-" + curr_year;
	var url = [];
	var i = 0;
	var proto = location.protocol;
	var port = Number(location.port);
	url[i++] = proto;
	url[i++] = "//";
	url[i++] = location.hostname;
	if (port && ((proto == ZmSetting.PROTO_HTTP && port != ZmSetting.HTTP_DEFAULT_PORT) 
		|| (proto == ZmSetting.PROTO_HTTPS && port != ZmSetting.HTTPS_DEFAULT_PORT))) {
		url[i++] = ":";
		url[i++] = port;
	}
	url[i++] = "/home/";
	url[i++]= AjxStringUtil.urlComponentEncode(appCtxt.getActiveAccount().name);
	url[i++] = "/?fmt=zip";
	url[i++] = "&list=";
	url[i++] = ids;
	url[i++] = "&filename=" + filename;

	var getUrl = url.join(""); 
	this._rifFrame.contentWindow.location.href = getUrl;
};

fbackup.prototype._setFilenameZip =
function(str) {
	if (typeof(str) == "undefined") {
		str = "NO-Subject"
	}
	var d = new Date();
	var curr_date = d.getDate();
	var curr_month = d.getMonth() + 1;
	var curr_year = d.getFullYear();
	var today = curr_date + "-" + curr_month + "-" + curr_year;
	str = str.replace(/[\*\[]\]\<\>\=\+\'\"\\\/\,\.\:\; !/g, "");
	str = (str.length > 16) ? str.substring(0, 15) : str;
	return str + "-" + today;
};

//------------------------------------------------
//					FOLDER
//------------------------------------------------


fbackup.prototype._folderDropped =
function(folderObj) {
	this._downloadFolder(this._setFilenameZip(folderObj.name), folderObj.url);
};

fbackup.prototype._setFolderBtnListener =
function() {
	if (!this._chooseFolderDialog) {
		AjxDispatcher.require("Extras");
		this._chooseFolderDialog = new ZmChooseFolderDialog(appCtxt.getShell());
	}
	this._chooseFolderDialog.reset();
	this._chooseFolderDialog.registerCallback(DwtDialog.OK_BUTTON, this._chooseFolderOkBtnListener, this, this._chooseFolderDialog);
	// This doesn't show trash and spam folder
	var omitParam = {};
	omitParam[ZmFolder.ID_TRASH] = true;
	omitParam[ZmFolder.ID_SPAM] = true;
	
	var params = {
		treeIds:		[ZmOrganizer.FOLDER],
		title:			ZmMsg.chooseFolder,
		overviewId:		this.toString(),
		description:	ZmMsg.chooseFolder,
		skipReadOnly:	false,
		hideNewButton:	true,
		appName:		ZmApp.MAIL,
		omit:			omitParam
	};
	this._chooseFolderDialog.popup(params);
};
		
fbackup.prototype._chooseFolderOkBtnListener =
function(dlg, folder) {
	dlg.popdown();
	this._downloadFolder(this._setFilenameZip(folder.name), folder.getRestUrl());
};		
		
fbackup.prototype._downloadFolder =
function(fileName, folderUrl) {
	var url = folderUrl + "?fmt=zip&filename=" + fileName;
	this._rifFrame.contentWindow.location.href = url;
};		

// Mostra un warning in stile finestra zimbra
fbackup.prototype._showWarningMsg = function(message, field) {
	if (message.length > 1000) {
		message = message.substring(0, 999) + "...";
	}
	var style = DwtMessageDialog.WARNING_STYLE;
	this.warningDialog = new DwtMessageDialog({
		parent : this.getShell(),
		buttons : [ DwtDialog.OK_BUTTON ]
	});
	if (field) {
		this.warningDialog.setButtonListener(DwtDialog.OK_BUTTON,
				new AjxListener(this, this._warningDialogOkBtnListener, field));
	}
	this.warningDialog.setMessage(message, style);
	this.warningDialog.popup();
};

// Se e' specificato un campo sposta il focus
fbackup.prototype._warningDialogOkBtnListener = function(field, ev) {
	this.warningDialog.popdown();
	field.focus();
};	