//////////////////////////////////////////////////////////////////////////////
// Based on the original emaildownloader zimlet. This one allows download email in text format without compression
// @author Eric Ros
//////////////////////////////////////////////////////////////////////////////

function saveAsEml_Handler() {
}

saveAsEml_Handler.prototype = new ZmZimletBase();
saveAsEml_Handler.prototype.constructor = saveAsEml_Handler;

saveAsEml_Handler.prototype.onActionMenuInitialized = 
function (controller, menu) {
	this.addMenuButton(controller, menu);
};

saveAsEml_Handler.prototype.onParticipantActionMenuInitialized = 
function (controller, menu) {
	this.addMenuButton(controller, menu);
}

saveAsEml_Handler.prototype.onShowView = 
function (view) {
	if (view.startsWith("MSG-")) {
		this.addMenuButton(null, appCtxt.getCurrentView().getController().getCurrentToolbar().getActionsMenu());
	}
}

saveAsEml_Handler.prototype.addMenuButton = 
function (controller, actionMenu) {
	if (actionMenu.getOp("SAVE_AS_EML_BUTTON") == null) {
		var opPrint = actionMenu.getOp(ZmOperation.PRINT);
		var opPrintIndex = actionMenu.getItemIndex(opPrint);

		actionMenu.createOp("EML_SAVE_CONTEXT_SECTION", {
		    style: DwtMenuItem.SEPARATOR_STYLE,
		    index: opPrintIndex + 1
		});

		menuItemAttr = {
		    text: this.getMessage("EMLDLabel"),
		    image: "emldownloaderIcon",
		    index: opPrintIndex + 2
		};
		var saveEmlButton = actionMenu.createOp("SAVE_AS_EML_BUTTON", menuItemAttr);
		
		if (controller != null) {
			saveEmlButton.addSelectionListener(new AjxListener(this, this._addedButtonListener, [controller]));
			controller.operationsToEnableOnMultiSelection.push("SAVE_AS_EML_BUTTON");
		}
		else {
			saveEmlButton.addSelectionListener(new AjxListener(this, this._actionButtonListener, []));
		}
	}
}

saveAsEml_Handler.prototype._actionButtonListener =
function () {
	var srcMsgObj = appCtxt.getCurrentView().getMsg();
	this._downloadMsg(srcMsgObj);
}

saveAsEml_Handler.prototype._downloadMsg =
function (srcMsgObj) {
	var filename = "file.eml";
	if (srcMsgObj.type == "CONV")
	{
		srcMsgObj = srcMsgObj.getFirstHotMsg();
	}
	var url = [];
	var proto = location.protocol;
	var port = Number(location.port);
	var i = 0;
	url[i++] = proto;
	url[i++] = "//";
	url[i++] = location.hostname;
	if (port && ((proto == ZmSetting.PROTO_HTTP && port != ZmSetting.HTTP_DEFAULT_PORT) 
		|| (proto == ZmSetting.PROTO_HTTPS && port != ZmSetting.HTTPS_DEFAULT_PORT))) {
		url[i++] = ":";
		url[i++] = port;
	}
	url[i++] = "/home/";
	url[i++]= AjxStringUtil.urlComponentEncode(appCtxt.getActiveAccount().name);
	url[i++] = "/?auth=co&id=";
	url[i++] = srcMsgObj.id;
	try {
		var subject = srcMsgObj.subject.replace(/\*/g, "").replace(/\[/g, "").replace(/\]/g, "").replace(/\</g, "").replace(/\>/g, "").replace(/\=/g, "").replace(/\+/g, "").replace(/\'/g, "").replace(/\"/g, "").replace(/\\/g, "").replace(/\//g, "").replace(/\,/g, "").replace(/\./g, "").replace(/\:/g, "").replace(/\;/g, "").replace(/ /g, "_").replace(/!/g, ""); 
		if(subject.length > 64) {
			subject = subject.substring(0,63);
		}
		filename = subject + ".eml";
	} 
	catch(e) {
	}
	var getUrl = url.join("");

	var response = AjxRpc.invoke(null, getUrl, null, null, true);

	if (response.success == true) {
		uriContent = "data:application/octet-stream," + encodeURIComponent(response.text);
		var link = document.createElement("a");
		link.download = filename;
		link.href = uriContent;
		document.body.appendChild(link);
		link.click();
		document.body.removeChild(link);
	}	
}

saveAsEml_Handler.prototype._addedButtonListener =
function (controller) {
	try
	{
		var selection = controller._listView[controller._currentViewId].getSelection();

		for (var j = 0; j < selection.length; j++) {
			this._downloadMsg(selection[j]);			
		}
	}
	catch (e)
	{
		this.displayErrorMessage(this.getMessage("EMLDError") + e);
	}
};

