/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2009, 2010 Zimbra, Inc.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */

/**
 * Allows downloading a single email message.
 * 
 * @author Raja Rao DV
 */
/**
 * init
 *
 */
var downloaderInstance;
function it_wordpower_emaildownloader_HandlerObject() {
}

it_wordpower_emaildownloader_HandlerObject.prototype = new ZmZimletBase();
it_wordpower_emaildownloader_HandlerObject.prototype.constructor = it_wordpower_emaildownloader_HandlerObject;

/**
 * Simplify handler object
 *
 */
var EmailDownloaderZimlet = it_wordpower_emaildownloader_HandlerObject;

/**
 * Called by the framework on an droppedItem drop.
 * 
 * @param	{ZmConv|ZmMailMsg}	droppedItem		the dropped message object
 */

it_wordpower_emaildownloader_HandlerObject.prototype.init= function() {
	downloaderInstance = appCtxt._zimletMgr.getZimletByName('it_wordpower_emaildownloader').handlerObject;
};

/************** PREFERENCES DIALOG **********************/
/**
 * Called when the zimlet is double-clicked.
 */
it_wordpower_emaildownloader_HandlerObject.prototype.doubleClicked = function() {
	this._displayPrefDialog();
};



it_wordpower_emaildownloader_HandlerObject.prototype._displayPrefDialog = function() {
	if(downloaderInstance.prefDlg)
	{
		downloaderInstance.prefDlg.popup();
		return;	
	}
	
	var del_after=downloaderInstance.getUserProperty("delete_after_export");
	//console.log(del_after);
	
	downloaderInstance.pView = new DwtComposite(downloaderInstance.getShell());
	downloaderInstance.pView.getHtmlElement().style.overflow = "auto";
	
	var html='<table><tr><td><input type="checkbox" id="delete_enabled"  '+(del_after == "1"?'checked':'')+' /></td><td>'+downloaderInstance.getMessage("EmailDownloaderZimlet_preferences_label")+'</td></tr></table>';
	
	//console.log(html);
	downloaderInstance.pView.getHtmlElement().innerHTML = html;
	
	downloaderInstance.prefDlg = downloaderInstance._createDialog({title:downloaderInstance.getMessage("EmailDownloaderZimlet_preferences_title"), view:downloaderInstance.pView, standardButtons:[DwtDialog.OK_BUTTON, DwtDialog.CANCEL_BUTTON]});
	downloaderInstance.prefDlg.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(downloaderInstance, downloaderInstance._prefOKBtnListener));
	downloaderInstance.prefDlg.popup();
};

it_wordpower_emaildownloader_HandlerObject.prototype._prefOKBtnListener = function() {

	var c_del = document.getElementById("delete_enabled").checked?"1":"0";
	//console.log(c_del);
	
	downloaderInstance.setUserProperty("delete_after_export", c_del, true);

	downloaderInstance.prefDlg.popdown();
};
/**************  DIALOG **********************/
/************** DIALOG ELIMINAZIONE **********/
it_wordpower_emaildownloader_HandlerObject.prototype._displayDelDialog = function(ids_to_del, type, folder_objs) {
	
	console.log(folder_objs);
	
	if(downloaderInstance.delDlg)
	{
		downloaderInstance.delDlg.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(downloaderInstance, downloaderInstance._delOKBtnListener, [ids_to_del, type, folder_objs]));
		downloaderInstance.delDlg.popup();
		return;	
	}
	
	var del_after=downloaderInstance.getUserProperty("delete_after_export");
	//console.log(del_after);
	
	downloaderInstance.pView = new DwtComposite(downloaderInstance.getShell());
	downloaderInstance.pView.getHtmlElement().style.overflow = "auto";
	
	var html='<table><tr><td>'+downloaderInstance.getMessage("EmailDownloaderZimlet_soap_question")+'</td></tr></table>';
	
	//console.log(html);
	downloaderInstance.pView.getHtmlElement().innerHTML = html;
	
	downloaderInstance.delDlg = downloaderInstance._createDialog({title:downloaderInstance.getMessage("EmailDownloaderZimlet_soap_question_title"), view:downloaderInstance.pView, standardButtons:[DwtDialog.OK_BUTTON, DwtDialog.CANCEL_BUTTON]});
	downloaderInstance.delDlg.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(downloaderInstance, downloaderInstance._delOKBtnListener, [ids_to_del, type, folder_objs]));
	downloaderInstance.delDlg.popup();
};

it_wordpower_emaildownloader_HandlerObject.prototype._delOKBtnListener = function(ids_to_del, type, folder_objs) {
	//console.log(ids_to_del);
	
	
	if (folder_objs != 'undefined') {
		
		//console.log(folder_objs);
		//moves all children before move to the trash folder
		for(fbjs=0; fbjs<folder_objs.length; fbjs++) {
		
			var this_object = folder_objs[fbjs];
			
			var parent_folder = this_object.parent;
						
			if('children' in this_object) {
			
				var array_children = this_object['children']['_array'];
				for(ch=0; ch<array_children.length; ch++) {
					
					//console.log('eccoci');
					array_children[ch].move(parent_folder, false, '');
				
				}
			
			}
		
		}
		
	}
	
	downloaderInstance.soapActoin(ids_to_del, type);
	downloaderInstance.delDlg.popdown();
	
};
/************** DIALOG ***********************/
/************** SOAP PART ********************/

EmailDownloaderZimlet.prototype.soapActoin = function(ids, type) {
	
	var soapDoc = AjxSoapDoc.create(type+"ActionRequest", "urn:zimbraMail");
    var mNode = soapDoc.set("action");
    mNode.setAttribute("id", ids);
    mNode.setAttribute("op", 'trash');
    console.log(soapDoc.getXml());
    
	//appCtxt.getAppController().setStatusMsg(downloaderInstance.getMessage("EmailDownloaderZimlet_soap_error"),ZmStatusView.LEVEL_CRITICAL)
	//appCtxt.getAppController().setStatusMsg(downloaderInstance.getMessage("EmailDownloaderZimlet_soap_success")),
	console.log(appCtxt.getAppController());
	
    var params = {
            soapDoc: soapDoc,
            asyncMode: true,
            callback: appCtxt.getAppController().setStatusMsg(downloaderInstance.getMessage("EmailDownloaderZimlet_soap_success"))
    };
	
    appCtxt.getAppController().sendRequest(params);
	
}

/************** SOAP *************************/

function _getMsgIdsFromConv(convSrcObj) {
	
	return  convSrcObj.msgIds;
	
};

function httpGet(theUrl) {
	
    var xmlHttp = new XMLHttpRequest();
    xmlHttp.open( "GET", theUrl, false ); // false for synchronous request
    xmlHttp.send( null );
    return xmlHttp.responseText;
}

function create_url(fmt, path) {
	
	var url = [];
	var i = 0;
	var proto = location.protocol;
	var port = Number(location.port);
	url[i++] = proto;
	url[i++] = "//";
	url[i++] = location.hostname;
	if (port && ((proto == ZmSetting.PROTO_HTTP && port != ZmSetting.HTTP_DEFAULT_PORT) 
		|| (proto == ZmSetting.PROTO_HTTPS && port != ZmSetting.HTTPS_DEFAULT_PORT))) {
		url[i++] = ":";
		url[i++] = port;
	}
	url[i++] = "/home/";
	url[i++]= AjxStringUtil.urlComponentEncode(appCtxt.getActiveAccount().name);
	url[i++]= path;
	if(fmt != '') {
		url[i++] = "/?fmt=";
		url[i++] = fmt;
	}
	
	return url.join("");
}

function parse_folders(obj, root_elem) {
	
	var out = [];
	
	var folder_path = obj.getPath(false,false,0,true,true,'');
	var group_url = create_url('json','/'+folder_path);
	
	var folder_content = JSON.parse(httpGet(group_url));
	console.log(folder_content, group_url);
	
	if(root_elem in folder_content) {
		
		for(f=0; f<folder_content[root_elem].length; f++) {
			
			if(root_elem == 'doc') {
				out.push(folder_content[root_elem][f]['id']+'.'+folder_content[root_elem][f]['ver']);
			}
			else {
				out.push(folder_content[root_elem][f]['id']);
			}
		
		}
		
	}
	else {
		return [obj.id];
	}
	return out;
	
}

function parse_groups(group) {
	
	var out = [];
	
	var g_url = create_url('json','');
	g_url = g_url+'&id='+group.id;
	var response = JSON.parse(httpGet(g_url));
	var group_p = response['cn'][0]['m'];
	
	for(g=0; g<group_p.length; g++) {
		
		if(group_p[g]['type'] != 'G') {
		
			var arr_id = group_p[g]['value'].split(':');
			out.push(arr_id[1]);
			
		}
		
	}
	
	return out;
}

function switch_types(obj, ids, fmt, folder_ids, folder_objs) {

	if(obj.type == "CONV") {
		ids = ids.concat(_getMsgIdsFromConv(obj));
	} else if(obj.type == "MSG") {
		ids.push(obj.id);
	} else if(obj.TYPE == "ZmContact" || obj.type == "CONTACT") {
		ids.push(obj.id);
	} else if(obj.TYPE == "ZmAppt" || obj.type == "APPT") {
		ids.push(obj.id);
	} else if(obj.type == "TASK") {
		
		if(obj.isZmFolder == true) {
			ids = ids.concat(parse_folders(obj,'task'));
		}
		else {
			ids.push(obj.id);
		}
		
	} else if(obj.type == "BRIEFCASE_ITEM") {
		
		if('isFolder' in obj) {
			ids = ids.concat(parse_folders(obj.folder,'doc'));
		}
		else {
			ids.push(obj.id+'.'+obj.version);
		}
		
	} else if(obj.type == 'GROUP') {
		ids = ids.concat(parse_groups(obj));
	} else if(obj.type == 'FOLDER') {
		ids = ids.concat(parse_folders(obj,'m'));
		folder_ids = folder_ids.push(obj.id);
		folder_objs = folder_objs.push(obj);
	} else if(obj.type == 'BRIEFCASE') {
		ids = ids.concat(parse_folders(obj,'doc'));
	} else if(obj.type == 'ADDRBOOK') {
		ids = ids.concat(parse_folders(obj,'cn'));
	} else if(obj.type == 'CALENDAR') {
		ids = ids.concat(parse_folders(obj,'appt'));
	} else {
		console.log(appCtxt.getAppController());
		appCtxt.getAppController().setStatusMsg(downloaderInstance.getMessage("EmailDownloaderZimlet_error"),ZmStatusView.LEVEL_CRITICAL);
		return false;
	}
	
	return [ids, fmt, obj.type];

}

function format_url(items) {
	
	var ids = [];
	var fmt = "zip";
	var data = [];
	data[0] = [];
	data[1] = [];
	data[2] = [];
	var folder_ids = [];
	var folder_objs = [];
	
	if(items.length == 1) {
		items = items[0];
	}
	
	console.log(items);
	
	if(items instanceof Array) {
		for(var i =0; i < items.length; i++) {
			
			var obj = items[i].srcObj ?  items[i].srcObj :  items[i];
			data_temp = switch_types(obj, ids, fmt, folder_ids, folder_objs);
			data[0] = data[0].concat(data_temp[0]);
			data[1] = data_temp[1];
			data[2] = data_temp[2];
			
		}
	} else {
		
		var obj = items.srcObj ? items.srcObj : items;
			data = switch_types(obj, ids, fmt, folder_ids, folder_objs);
		
	}
	if(data) {
		
		var url = create_url(data[1],'');
		console.log(data[0]);
		var ids_clear = data[0].filter(function(elem, index, self) {
			return index == self.indexOf(elem);
		})
		
		
		url = url+'&list='+ids_clear.join(",")+"&filename=ZimbraItems";
		console.log(url);
		window.open(url, "_blank");
		
		var del_prop = downloaderInstance.getUserProperty("delete_after_export");
		
		if(del_prop == 1) {
			
			if(data[2] == 'MSG' || data[2] == 'CONV') {
				
				downloaderInstance._displayDelDialog(ids_clear, 'Msg', 'undefined');
				
			} else if(data[2] == 'FOLDER') {
				
				downloaderInstance._displayDelDialog(folder_ids, 'Folder', folder_objs);
			
			}
		
		}
		
	}
}

EmailDownloaderZimlet.prototype.doDrop = function(droppedItem) {
	
	format_url(droppedItem);
	
};

EmailDownloaderZimlet.prototype.initializeToolbar = function(app, toolbar, controller, viewId) {
	
	
	var viewType = appCtxt.getViewTypeFromId(viewId);
	
	// get the index of "View" menu so we can display the button after that
	var buttonIndex = 0;
	var view = appCtxt.getCurrentView();
	
	if (viewType == 'TV' || viewType == 'CNS' || viewType == 'CLD' || viewType == 'TKL' || viewType == 'CLV' || viewType == 'BDLV') {
		
		if(toolbar._items) {
		
			for (var i = 0; i < toolbar._items.length; i++) {
				if (toolbar._items[i].className == 'ZToolbarFiller') {
						buttonIndex = i;
						break;
				}
			}
		
		}
		else {
			//zimbra 8.7. bug
			for (var i = 0; i < toolbar._itemsEl.cells.length; i++) {
				if (toolbar._itemsEl.cells[i].className == 'ZToolbarFiller') {
						buttonIndex = i;
						break;
				}
			}
		
		}
		var bck_button = toolbar.getButton('EXPORT');
		//console.log(bck_button);
		if(!bck_button) {
			
			var buttonParams = {
					text: downloaderInstance.getMessage("EmailDownloaderZimlet_button_label"),
					tooltip: downloaderInstance.getMessage("EmailDownloaderZimlet_button_tooltip"),
					index: buttonIndex,
			};
		
			// creates the button with an id and params containing the button details
			var button = toolbar.createOp("EXPORT", buttonParams);
			button.addSelectionListener(new AjxListener(downloaderInstance, downloaderInstance.exportItems, [controller]));
			
		}
		
			controller.operationsToEnableOnMultiSelection.push('EXPORT');
			toolbar.getButton('EXPORT').setEnabled(false);
			
	}
	
	//console.log(EmailDownloaderZimlet.prototype);
	
};

EmailDownloaderZimlet.prototype.onActionMenuInitialized = function(controller, actionMenu) {
	
	console.log(actionMenu);
	
	viewType = controller._currentViewType;
	if (viewType == 'TV' || viewType == 'CNS' || viewType == 'CLD' || viewType == 'TKL' || viewType == 'BDLV' || viewType == 'CLV') {
		
		actionMenu.createSeparator();
		var mi = actionMenu.createMenuItem("EXPORT", {text: downloaderInstance.getMessage("EmailDownloaderZimlet_button_label"), image: 'emaildownloader-panelIcon'});
		mi.addSelectionListener(new AjxListener(this, this.exportItems, [controller]));
		
	}

}


EmailDownloaderZimlet.prototype.exportItems = function(controller) {
	
	var selected = controller.getSelection();
	format_url(selected);
	
};
