// these are labels for the days of the week
var cal_days_labels = [ 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat','Sun'];
// these are labels for the days of the week (box)
var box_days_labels = [ 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday','Sunday'];
// these are human-readable month name labels, in order
var cal_months_labels = ['January', 'February', 'March', 'April',
	                'May', 'June', 'July', 'August', 'September',
	                'October', 'November', 'December'];
// these are the days of the week for each month, in order
var cal_days_in_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];


var colorCodes= ['#000','#426DA9','#78E3E3','#4C8E6F','#9B6FBD','#CE5858','#CED030','#D580B1','#BBBBBB','#D39E4A'];




var printEventsInstance;

function hexToRgb(hex) {
    // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function(m, r, g, b) {
        return r + r + g + g + b + b;
    });

    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}


function readFile(url)
{
	var reader = new FileReader();
	reader.onload = function (e) {
		var data = this.result;
		//console.log(data);
	}
	reader.readAsDataURL( url );

}


function convertFileToDataURLviaFileReader(url, callback) {
  var xhr = new XMLHttpRequest();
  xhr.responseType = 'blob';
  xhr.onload = function() {
    var reader = new FileReader();
    reader.onloadend = function() {
      callback(reader.result);
    }
    reader.readAsDataURL(xhr.response);
  };
  xhr.open('GET', url);
  xhr.send();
}

function convertImgToBase64(url, callback, outputFormat){
	var img = new Image();
	img.crossOrigin = 'Anonymous';
	img.onload = function(){
		var canvas = document.createElement('CANVAS');
		var ctx = canvas.getContext('2d');
		canvas.height = this.height;
		canvas.width = this.width;
		ctx.drawImage(this,0,0);
		var dataURL = canvas.toDataURL(outputFormat || 'image/png');
		callback(dataURL);
		canvas = null;
	};
	img.onerror= function(){
		callback();
	};
	img.src = url;
	//console.log(img);
}


function printEvents(doc,events)
{
	//setup
	var sl=20;//square left
	var st=160;//squre top
	var sw=280;//square width
	var sh=220;//square height
	var hh=20;//header height
	var tl=100;//text left
	var tt=15;//text height
	var el=25;//event left
	var eh=13;//event height
	var et=35;//event top
	var ew=245;//event width
	var bl=10;//box left
	var bt=27;//box top
	//write events on pdf
	//doc.setTextColor(150);//pick the color from Calendar
	doc.setFontSize(8);
	var stoff=0;//splittedtext offset
	var max_events=14;
	var max_events2=5;
	//first row
	for(i=0;i<3;i++)
	{
		events[i].sort();
		stoff=0;
		for(j=0;j<events[i].length;j++)
		{
			doc.setDrawColor(0);
			var rect_color=hexToRgb(events[i][j][1].substring(1));
			doc.setFillColor(rect_color.r,rect_color.g,rect_color.b);
			doc.rect(sl+bl,st+i*sh+(j+stoff)*eh+bt, 10, 10, 'FD');
			splitText= doc.splitTextToSize(events[i][j][0],ew);
			//console.log("splittext",splitText);
			doc.text(sl+el,st+i*sh+(j+stoff)*eh+et,splitText);
			stoff+=splitText.length-1;
			if(j+stoff==max_events-1)
			{
				doc.text(sl+el,st+i*sh+(j+stoff+1)*eh+et,"+ " + (events[i].length-(j+1))+ " events");
				break;
			}
		}
	}
	//second row
	for(i=0;i<2;i++)
	{
		events[i+3].sort();
		stoff=0;
		for(j=0;j<events[i+3].length;j++)
		{
			doc.setDrawColor(0);
			var rect_color=hexToRgb(events[i+3][j][1].substring(1));
			doc.setFillColor(rect_color.r,rect_color.g,rect_color.b);
			doc.rect(sl+bl+sw,st+i*sh+(j+stoff)*eh+bt, 10, 10, 'FD');
			splitText= doc.splitTextToSize(events[i+3][j][0],ew);
			doc.text(sl+el+sw,st+i*sh+(j+stoff)*eh+et,splitText);
			stoff+=splitText.length-1;
			if(j+stoff==max_events-1)
			{
				doc.text(sl+el+sw,st+i*sh+(j+stoff+1)*eh+et,"+ " + (events[i+3].length-(j+1))+ " events");
				break;
			}
		}
	}
	offset=i*sh;
	for(i=0;i<2;i++)
	{
		events[i+5].sort();
		stoff=0;
		for(j=0;j<events[i+5].length;j++)
		{
			doc.setDrawColor(0);
			var rect_color=hexToRgb(events[i+5][j][1].substring(1));
			doc.setFillColor(rect_color.r,rect_color.g,rect_color.b);
			doc.rect(sl+bl+sw,st+i*sh/2+(j+stoff)*eh+bt+offset, 10, 10, 'FD');
			splitText= doc.splitTextToSize(events[i+5][j][0],ew);
			doc.text(sl+el+sw,st+i*sh/2+(j+stoff)*eh+et+offset,splitText);
			stoff+=splitText.length-1;
			if(j+stoff==max_events2-1)
			{
				doc.text(sl+el+sw,st+i*sh/2+(j+stoff+1)*eh+et+offset,"+ " + (events[i+5].length-(j+1))+ " events");
				break;
			}
		}
	}


	//getlogo
	var logo=printEventsInstance.getUserProperty("logo");
	
	//console.log(logo);
	if(!logo || logo=="" || typeof(logo) == "undefined")
	{
		logo=printEventsInstance.getResource("logo.jpg");
	}
	else
	{
		var URLsplit = logo.split('/');
		var host = URLsplit[0] + "//" + URLsplit[2] + "/";
		logo = logo.replace(host, '');
	}
	//logo=printEventsInstance.getResource("logo.jpg");
	//readFile(logo);
	//convertFileToDataURLviaFileReader(logo,printEventsInstance._printPDF);
	convertImgToBase64(logo,printEventsInstance._printPDF,"image/jpeg");		

}

function printBaseDoc(doc,monday,sunday)
{
	//write interval
	doc.setFontSize(20);
	doc.text(210,140,monday.toLocaleDateString() + " - " + sunday.toLocaleDateString());
	doc.setFontSize(10);

	//setup
	var sl=20;//square left
	var st=160;//squre top
	var sw=280;//square width
	var sh=220;//square height
	var hh=20;//header height
	var tl=100;//text left
	var tt=15;//text height
	var el=10;//event left
	var eh=13;//event height
	var et=35;//event top
	var ew=260;//event width
	cday=monday;
	//first 3 days
	for(i=0;i<3;i++)
	{
		doc.rect(sl,st+i*sh,sw,sh);
		doc.setFillColor(128);
		doc.rect(sl,st+i*sh,sw,hh,"F");
		doc.text(sl+tl,st+tt+i*sh,box_days_labels[(cday.getDay()+6)%7] + " " + cday.toLocaleDateString());
		cday.setDate(cday.getDate()+1);
	}
	//last 2 days
	for(i=0;i<2;i++)
	{
		doc.rect(sl+sw,st+i*sh,sw,sh);
		doc.setFillColor(128);
		doc.rect(sl+sw,st+i*sh,sw,hh,"F");
		doc.text(sl+sw+tl,st+tt+i*sh,box_days_labels[(cday.getDay()+6)%7] + " " + cday.toLocaleDateString());
		cday.setDate(cday.getDate()+1);
	}
	//last 2 days
	var offset=i*sh;
	for(i=0;i<2;i++)
	{
		doc.rect(sl+sw,st+i*sh/2+offset,sw,sh/2);
		doc.setFillColor(128);
		doc.rect(sl+sw,st+i*sh/2+offset,sw,hh,"F");
		doc.text(sl+sw+tl,st+tt+i*sh/2+offset,box_days_labels[(cday.getDay()+6)%7] + " " + cday.toLocaleDateString());
		cday.setDate(cday.getDate()+1);
	}
}





function printMiniCals(doc,today,start_date)
{
	var trigger=-1;
	doc.setFontSize(8);
	//setup
	var month;
	var year;
	var fdm;
	var co=10;//calendars offset
	var st=20;//square top
	var sl=130;//square left
	var sh=85;//square height
	var sw=105;//square width
	var tt=10;//text top
	var tl=28;//text left
	var hh=15;//header height
	var rs=10;//row size
	var cs=15;//col size
	var dmo=3;//days micro offset
	//calendar 1
	month = (today.getMonth()+11)%12;//start from previous
	year  = today.getFullYear();
	fdm=(new Date(year + "-" + (month+1) + "-01").getDay()+6)%7;//used to calculate first day of the month
	//console.log(fdm);
	var monthName = cal_months_labels[month];
	var days=cal_days_in_month[month];
	doc.rect(sl, st, sw, sh); // main square 
	doc.setFillColor(192);
	doc.rect(sl, st, sw, hh,"FD"); // header square  
	doc.text(sl+tl, st+tt, monthName + " " + year);
	//print rows
	for(r=1;r<=6;r++)
	{
		doc.line(sl,st+hh+r*rs,sl+sw,st+hh+r*rs);	
	}
	//print cols and day header
	doc.setFontSize(6);
	for(c=1;c<=7;c++)
	{
		doc.line(sl+c*cs,st+hh,sl+c*cs,st+sh);
		
		doc.text(sl+(c-1)*cs+1,st+hh+rs-1,cal_days_labels[c-1]);
	}
	doc.setFontSize(8);
	//print days
	
	for(d=0;d<days;d++)
	{
		if(trigger>=0 || start_date.getMonth()==month && start_date.getDate()==d+1)
		{
			//start trigger week
			doc.setTextColor(255,0,0);
			trigger++;	
		}
		doc.text(dmo+sl+((d+fdm)%7)*cs,st+hh+(Math.floor((d+fdm)/7)+2)*rs-1,pad(d+1));
		if(trigger==6)
		{
			doc.setTextColor(0);
			trigger=-1;
		}
	}
	//must reset the color
	doc.setTextColor(0);


	//calendar 2
	year=year+Math.floor((month+1)/12);
	month=++month%12;
	fdm=(new Date(year + "-" + (month+1) + "-01").getDay()+6)%7;
	//console.log(fdm);
	monthName = cal_months_labels[month];
	days=cal_days_in_month[month];
	sl=sl+sw+co;
	doc.rect(sl, st, sw, sh); // main square
	doc.setFillColor(128);
	doc.rect(sl, st, sw, hh,"FD"); // header square 
	doc.text(sl+tl, st+tt, monthName + " " + year);
	
	//print rows
	for(r=1;r<=6;r++)
	{
		doc.line(sl,st+hh+r*rs,sl+sw,st+hh+r*rs);	
	}
	//print cols and day header
	doc.setFontSize(6);
	for(c=1;c<=7;c++)
	{
		doc.line(sl+c*cs,st+hh,sl+c*cs,st+sh);	
		doc.text(sl+(c-1)*cs+1,st+hh+rs-1,cal_days_labels[c-1]);
	}
	doc.setFontSize(8);
	//print days
	
	for(d=0;d<days;d++)
	{
		if(trigger>=0 || start_date.getMonth()==month && start_date.getDate()==d+1)
		{
			//start trigger week
			doc.setTextColor(255,0,0);
			trigger++;	
		}
		doc.text(dmo+sl+((d+fdm)%7)*cs,st+hh+(Math.floor((d+fdm)/7)+2)*rs-1,pad(d+1));
		if(trigger==6)
		{
			doc.setTextColor(0);
			trigger=-1;
		}
	}

	doc.setTextColor(0);
	//calendar 3
	year=year+Math.floor((month+1)/12);
	month=++month%12;
	fdm=(new Date(year + "-" + (month+1) + "-01").getDay()+6)%7;
	//console.log(fdm);
	sl=sl+sw+co;
	monthName = cal_months_labels[month];
	days=cal_days_in_month[month];
	doc.rect(sl, st, sw, sh); // main square 
	doc.setFillColor(192);
	doc.rect(sl, st, sw, hh,"FD"); // header square 
	doc.text(sl+tl, st+tt, monthName + " " + year);
	//print rows
	for(r=1;r<=6;r++)
	{
		doc.line(sl,st+hh+r*rs,sl+sw,st+hh+r*rs);	
	}
	//print cols and day header
	doc.setFontSize(6);
	for(c=1;c<=7;c++)
	{
		doc.line(sl+c*cs,st+hh,sl+c*cs,st+sh);	
		doc.text(sl+(c-1)*cs+1,st+hh+rs-1,cal_days_labels[c-1]);
	}
	doc.setFontSize(8);
	//print days
	
	for(d=0;d<days;d++)
	{
		if(trigger>=0 || start_date.getMonth()==month && start_date.getDate()==d+1)
		{
			//start trigger week
			doc.setTextColor(255,0,0);
			trigger++;	
		}
		doc.text(dmo+sl+((d+fdm)%7)*cs,st+hh+(Math.floor((d+fdm)/7)+2)*rs-1,pad(d+1));
		if(trigger==6)
		{
			doc.setTextColor(0);
			trigger=-1;
		}
	}
	

}
function pad(d) {
    return (d < 10) ? '0' + d.toString() : d.toString();
}

function getMonday(d) {
  d = new Date(d);
  var day = d.getDay(),
      diff = d.getDate() - day + (day == 0 ? -6:1); // adjust when day is sunday
  return new Date(d.setDate(diff));
}

function getSunday(d) {
  d = new Date(d);
  var day = d.getDay(),
      diff = d.getDate() - day + (day == 0 ? -6:1) + 6; // adjust when day is sunday
  return new Date(d.setDate(diff));
}

it_wordpower_printevents_HandlerObject = function() {
};



var dialog_id;
it_wordpower_printevents_HandlerObject.prototype = new ZmZimletBase;
it_wordpower_printevents_HandlerObject.prototype.constructor = it_wordpower_printevents_HandlerObject;
it_wordpower_printevents_HandlerObject.prototype.init= function() {
	//alert("Test");
	dialog_id="printEvents";
	printEventsInstance = appCtxt._zimletMgr.getZimletByName('it_wordpower_printevents').handlerObject;
};



it_wordpower_printevents_HandlerObject.prototype.initializeToolbar= function(app,toolbar,controller,viewId) {
	var viewType = appCtxt.getViewTypeFromId(viewId);
	//console.log(viewType);
	if (viewType == "CLWW" || viewType == "CLD") {	
		//Create button
		
		if (toolbar.getButton('WEEKLY_PRINT'))
	     {
			return;
		}	
		var buttonIndex = 0;

		var buttonParams = {
		        text    : "Weekly print",
		        tooltip: "Weekly appointment print",
		        index: buttonIndex, // position of the button
		        image: "Print" // icon
		};

		// creates the button with an id and params containing the button details
		var button = toolbar.createOp("WEEKLY_PRINT", buttonParams);
		button.addSelectionListener(new AjxListener(this, this._print, [controller]));

		
	}
};


var doc;
it_wordpower_printevents_HandlerObject.prototype._toPDF=function()
{
	var html_string='';
	var sel=document.getElementById("selected_calendar");
	//var calendar_folder=sel.options[sel.selectedIndex].text;
	
	var selected_date=this._selDate.getValue();
	if(!selected_date)
	{
		alert(ZmMsg.errorDate);
		return;
	}
	//console.log(selected_date);
	var monday=getMonday(selected_date);
	monday.setHours(0,0,0,0);
	var sunday=getSunday(selected_date);
	sunday.setHours(23,59,59,999);
	//console.log(monday);
	//console.log(sunday); 

	// PDF
	doc = new jsPDF('p','pt','a4',true);

	printBaseDoc(doc,new Date(monday.getTime()),new Date(sunday.getTime()));
	printMiniCals(doc,selected_date,monday);
	
	
	var calendars=document.getElementsByClassName("calendar_checkbox");
	var events=new Array();
	events[0]=new Array();
	events[1]=new Array();
	events[2]=new Array();
	events[3]=new Array();
	events[4]=new Array();
	events[5]=new Array();
	events[6]=new Array();
	for(cal=0;cal<calendars.length;cal++)
	{
		//console.log(calendars[cal]);
		if(calendars[cal].checked)
		{
			var calendar_folder=calendars[cal].value;
			var calColor=calendars[cal].getAttribute("calColor");
			var oReq = new XMLHttpRequest();
			var username=printEventsInstance.getUsername();
			oReq.open("GET", "/home/"+ username + calendar_folder+"?fmt=json&start="+monday.getTime()+"&end="+sunday.getTime(), false);
			oReq.onerror = function ()
			{
				//Ignore error	
			}
			oReq.onload = function (oEvent) {
				try
				{
					var arrayBuffer = JSON.parse(oReq.response);
					//console.log(arrayBuffer);
					var appt=arrayBuffer["appt"];
					if(appt && typeof(appt) != 'undefined')
					{
						
						//read events
						for(i=0;i<appt.length;i++)
						{
							start_date=new Date(appt[i]["inv"][0]["comp"][0]["s"][0]["u"]);
							start_time=pad(start_date.getHours())+":"+pad(start_date.getMinutes());
							end_date=new Date(appt[i]["inv"][0]["comp"][0]["e"][0]["u"]);
							end_time=pad(end_date.getHours())+":"+pad(end_date.getMinutes());
	
							var date_diff=end_date-start_date;
							if(end_date.getDay()!=start_date.getDay())
							{
								event_string=start_time+" (" + start_date.toLocaleDateString() + ") - "+end_time +" (" + end_date.toLocaleDateString() + ") " +appt[i]["inv"][0]["comp"][0]["name"];
							}
							else
							{
								event_string=start_time+" - "+end_time + " " +appt[i]["inv"][0]["comp"][0]["name"];
							}
							var day=start_date.getDay();
							day=(day+6)%7;
							events[day].push(new Array(event_string,calColor));
						}
						//console.log("Events at " + cal);
						//console.log(events);
						
				
					}
				}
				catch(ex)
				{
					//console.log(ex);	
				}

			};
			oReq.send(null);




		}
	}
	
	if(events[0].length==0 && events[1].length==0 && events[2].length==0 && events[3].length==0 && events[4].length==0 && events[5].length==0 && events[6].length==0)
	{
		alert(ZmMsg.exportEmptyName);
	}
	else
	{
		printEvents(doc,events);
	}
	
}


it_wordpower_printevents_HandlerObject.prototype._print=function(controller) {
	


	//var shell = new DwtShell("MainShell", true, null, null, true);
	//shell.setVirtual();
	
	
	printEventsInstance._dialog = new DwtDialog( { title:ZmMsg.printCalendar, parent:printEventsInstance.getShell(), standardButtons:[DwtDialog.CANCEL_BUTTON,DwtDialog.OK_BUTTON], disposeOnPopDown:true } );
	


	

/*	var soapDoc = AjxSoapDoc.create("GetFolderRequest", "urn:zimbraMail");
	soapDoc.getMethod().setAttribute("view","appointment");
	soapDoc.getMethod().setAttribute("visible","1");

	var params = {
			soapDoc: soapDoc,
			asyncMode: false,
			//callback: (new AjxCallback(this, this._sendEncrypted)),
			//errorCallback: (new AjxCallback(this, this._))
			};

	

	var result = appCtxt.getAppController().sendRequest(params);*/
	var ccal = appCtxt.getOverviewController().getTreeController(ZmOrganizer.CALENDAR);
	
	var html = "";
	//var response = result["GetFolderResponse"]["folder"][0];
	var response = ccal.getDataTree()["root"];		
	var calendars=[];
	var index=0;
	console.log(response);
	function getCalendars2(cnode,parent_path,deep)
	{
		
		var absPathFolder=parent_path + "/" + (cnode["_systemName"]?cnode["_systemName"]:cnode["name"]);
		if(cnode["type"]=="CALENDAR")
		{
			calendars[index]=[];
			calendars[index]["name"]=cnode["name"];
			calendars[index]["folder"]=absPathFolder;
			calendars[index]["color"]=cnode["color"];
			calendars[index]["rgb"]=cnode["rgb"];
			index++;
			
		}
		if(cnode._systemName!="Trash" && cnode.children._array && cnode.children._array.length>0)
		{
			
			for(var i=0;i<cnode.children._array.length;i++)
			{
				//root folder
				if(cnode.id=="1")
				{
					getCalendars2(cnode.children._array[i],"",1);
				}
				else
				{
					getCalendars2(cnode.children._array[i],absPathFolder,deep+1);
				}
			}	
		}
		
		
	};
	/*function getCalendars(cnode)
	{
		if(cnode["view"]=="appointment")
		{
			calendars[index]=[];
			calendars[index]["name"]=cnode["name"];
			calendars[index]["folder"]=cnode["absFolderPath"];
			calendars[index]["color"]=cnode["color"];
			calendars[index]["rgb"]=cnode["rgb"];
			index++;
		}
		if(cnode["folder"])
		{
			for(i=0;i<cnode["folder"].length;i++)
			{
				getCalendars(cnode["folder"][i]);		
			}	
		}
		if(cnode["link"])
		{
			for(i=0;i<cnode["link"].length;i++)
			{
				getCalendars(cnode["link"][i]);		
			}	
		}
	};*/
	//response=getCalendars(response);
	//console.log(response);
	response=getCalendars2(response,"",0);
	
	
	
	
	
	

	var opts = "";
	
	
	for(i=0;i<calendars.length;i++) 
	{
		opts = opts + '<input class="calendar_checkbox" calColor="'+(calendars[i]["rgb"]?calendars[i]["rgb"]:(calendars[i]["color"]?colorCodes[calendars[i]["color"]]:colorCodes[1]))+'" type="checkbox" id="'+calendars[i]["name"]+'" value="'+calendars[i]["folder"]+'" checked>'+calendars[i]["name"]+'<br />';
	
	}
//<strong>'+ZmMsg.calendars+'</strong>
	var selCalendars = '<div id="selected_calendars">'+opts+'</div>';
	//printEventsInstance._calendar = ZmCalendar.create( { parent:this._dialog, className:'ZmDateFieldInput', posStyle:Dwt.DISPLAY_BLOCK, workingDays:[DwtCalendar.WED,DwtCalendar.TUE],hidePrevNextMo:false, readOnly:false, showWeekNumber:true } );
	//printEventsInstance._calendar=ZmCalendar.create();
	//printEventsInstance._calendar = new  DwtCalendar( { parent:printEventsInstance._dialog, showWeekNumber:true, posStyle:Dwt.DISPLAY_BLOCK });
	
	
	html= AjxTemplate.expand("calendar.Calendar#PrintDialog", {id:dialog_id});
	printEventsInstance._dialog.setContent(html);
	printEventsInstance._selDate = new ZmDateInput(printEventsInstance._dialog, dialog_id + "_selDate", dialog_id + "_selDateContainer");
	printEventsInstance._selDate.setValue(new Date());
	printEventsInstance._todayButton=new DwtButton({parent:printEventsInstance._dialog,parentElement:dialog_id + "_todayButtonContainer"});
	printEventsInstance._todayButton.setText(ZmMsg.today);
	printEventsInstance._todayButton.addSelectionListener(new AjxListener(printEventsInstance, printEventsInstance._setDateToToday));

	
	

	//this._dateRangeTo = new ZmDateInput(printEventsInstance._dialog, dialog_id + "_dateRangeTo", dialog_id + "_dateRangeToContainer");
	document.getElementById(dialog_id+"_calTreeContainer").innerHTML=selCalendars;
	document.getElementById(dialog_id+"_printOptionsContainer").children[0].children[0].children[1].innerHTML="";
	document.getElementById(dialog_id+"_printOptionsContainer").children[0].children[0].children[0].children[0].innerHTML="";


	var separatordiv=document.getElementById(dialog_id+"_printOptionsContainer").children[1];
	
	separatordiv.setAttribute("class","");
	document.getElementById(dialog_id+"_printOptionsContainer").children[2].innerHTML='';
	//var radio_range=document.getElementById(dialog_id+"_dateRangeRadio");
	//radio_range.parentNode.removeChild(radio_range);
	
	
	



	printEventsInstance._dialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(printEventsInstance, printEventsInstance._toPDF));
	//console.log(printEventsInstance);
	printEventsInstance._dialog.popup();


};

it_wordpower_printevents_HandlerObject.prototype._setDateToToday = 
function() {
	var t=new Date();
	this._selDate.setValue(t);
};

it_wordpower_printevents_HandlerObject.prototype._printPDF = 
function(base64logo) {
	//console.log(base64logo);
	if(base64logo && typeof(base64logo) != "undefined")
	{
		doc.addImage(base64logo,10,10,100,27);
	}
	doc.output("dataurlnewwindow");
	printEventsInstance._dialog.popdown();
};

/*it_wordpower_printevents_HandlerObject.prototype._showSetupPopup = 
function() {
	this._setupDialog=new DwtDialog( { title:ZmMsg.printCalendar, parent:this.getShell(), standardButtons:[DwtDialog.CANCEL_BUTTON,DwtDialog.OK_BUTTON], disposeOnPopDown:true } );
	this._setupDialog.setContent('<input type="file" id="logo_uploader" />');
	this._setupDialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._uploadLogo));
	this._setupDialog.popup();
};

it_wordpower_printevents_HandlerObject.prototype._alert = 
function() {
	alert("OK");
}

it_wordpower_printevents_HandlerObject.prototype._uploadLogo = 
function() {
	var zimlet=this;
	var file=document.getElementById("logo_uploader");
	var formData=new FormData();
	formData.append("upload", file.files[0]);
	console.log(file.files[0]);
	var reader=new FileReader();
	reader.onload= function(event)
	{
		var dataUrl=event.target.result;
		console.log(dataUrl);
		zimlet.setUserProperty("logo",dataUrl,true);
	}
	reader.readAsDataURL(file.files[0]);
	
};






it_wordpower_printevents_HandlerObject.prototype.menuItemSelected = 
function(itemId) {
	switch (itemId) {
		case "printSetup":
			this._showSetupPopup();
			break;
	}
};
*/





/************** PREFERENCES DIALOG **********************/
/**
 * Called when the zimlet is double-clicked.
 */
it_wordpower_printevents_HandlerObject.prototype.doubleClicked = function() {
	this._displayPrefDialog();
};



it_wordpower_printevents_HandlerObject.prototype._displayPrefDialog =function() {
	if(printEventsInstance.prefDlg)
	{
		printEventsInstance.prefDlg.popup();
		return;	
	}
	printEventsInstance.pView = new DwtComposite(printEventsInstance.getShell());
	printEventsInstance.pView.getHtmlElement().style.overflow = "auto";
	var logo=printEventsInstance.getUserProperty("logo");
	var html='<table><tr><td>Briefcase link</td><td><input id="logo" type="text" value="'+logo+'" /></td></tr></table>';
	printEventsInstance.pView.getHtmlElement().innerHTML = html;
	
	printEventsInstance.prefDlg = printEventsInstance._createDialog({title:"Logo", view:printEventsInstance.pView, standardButtons:[DwtDialog.OK_BUTTON, DwtDialog.CANCEL_BUTTON]});
	printEventsInstance.prefDlg.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(printEventsInstance, printEventsInstance._prefOKBtnListener));
	printEventsInstance.prefDlg.popup();
};

it_wordpower_printevents_HandlerObject.prototype._prefOKBtnListener =function() {

	var logo_path=document.getElementById("logo").value;
	printEventsInstance.setUserProperty("logo", logo_path, true);

	printEventsInstance.prefDlg.popdown();
};
/************** END DIALOG **********************/

