var getUrlBase	= 'http://cgi.sfu.ca/~hillman/zimbrarest.cgi/';
var postUrlBase = 'http://cgi.sfu.ca/~hillman/zimbrarest.cgi/';
var myUrlBase = 'http://cgi.sfu.ca/~hillman/motd/';

var isupPath	= 'isup';
var months		= ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sept','Oct','Nov','Dec'];

function toggleEditor(elementId) {
	if (!tinyMCE.get(elementId))
		tinyMCE.execCommand('mceAddControl', false, elementId);
	else
		tinyMCE.execCommand('mceRemoveControl', false, elementId);
}

// generateId -- generates a message ID using timestampe in ms
function generateId() {
	var ID = new Date().getTime();
	return ID;
};

// isup -- check that the service is available
function isup() {
	$.ajax({
	  type: "GET",
	  async: false,
	  url: getUrlBase + isupPath,
	  success: function(data){
	    status = data;
		if (status == "OK") { status = true; } else { status = false; }
	  }
	});
	return status;
}

// whoami -- get the REMOTE_USER string
function whoami() {
	computingId = '';
	url = document.location.href.substring(0,location.href.lastIndexOf('/')+1) + "whoami.php?"+generateId();
	//console.info(url);
	$.ajax({
	  type: "GET",
	  async: false,
	  url: url,
	  success: function(data){
	    computingId = data;
	  },
//	  error: function(){
//		alert('You do not appear to be logged in to CAS. Click OK to reload the page and reauthenticate.');
//		// window.location.reload();
//	}
	});
	
	return computingId;
}

function getCkidToken() {
	ckidToken = '';
	// Ckid is SFU-specific, so just return null
	return ckidToken;

}


// fetchMessages -- retreives all messages and parses into table form
function fetchMessages(type) {

	if ( type == 'tip' ) {
		$.getJSON(getUrlBase+'motd/tips/all.js?sfu_token=' + getCkidToken() , function(json) {
			$.each(json,function(i,item) {
				var qs			= new Querystring(item);
				var messageId 		= qs.get("messageId");
				var messageTitle	= unescape(decodeURIComponent(qs.get('messageTitle')));
				var messageStatus	= qs.get('messageStatus')=='active'?'Enabled':'Disabled';
				var messageBody		= unescape(decodeURIComponent(qs.get('messageBody')));
				var messageAuthor	= qs.get('messageAuthor');
				var messageDateInt 	= parseInt(messageId);
				var messageDateObj	= new Date(messageDateInt);
				var messageDate		= messageDateObj.getFullYear() + '-' + months[messageDateObj.getMonth()] + '-' + messageDateObj.getDate();
				messageStatus == 'Enabled' ? textColor='black' : textColor='silver';
				var messageTableHtml = [
					'<tr class="messageSummary" id="summary_'+messageId+'" style="color:'+textColor+'">',
					'	<td>'+messageTitle+'</td><td>'+messageAuthor+'</td>',
					'	<td>'+messageDate+'</td><td>'+messageStatus+'</td>',
					'	<td class="buttonCell"><img class="actionButton" src="../_img/edit.png" onclick="editMessage(\'tip\','+messageId+')"/><img class="actionButton" src="../_img/delete.png" onclick="deleteMessage(\'tip\','+messageId+')"/></td>',
					'</tr>'
				].join("");
				
				$('#messagesTableBody').append(messageTableHtml);
			});
		});	
	} else if ( type == 'pa' ) {
		$.getJSON(getUrlBase+'motd/pa/all.js?sfu_token=' + getCkidToken(), function(json) {	
			$.each(json,function(i,item) {
				var qs	        		= new Querystring(item);
				var messageId 			= qs.get("messageId");
				var messageTitle		= unescape(decodeURIComponent(qs.get('messageTitle')));
				var messageBody			= unescape(decodeURIComponent(qs.get('messageBody')));
				var messageAuthor		= qs.get('messageAuthor');
				
				var messageStartTimeInt = qs.get('messageStartTime');
				var messageStartTimeObj	= new Date(parseInt(messageStartTimeInt));
				var messageStartHours	= messageStartTimeObj.getHours();
				var messageStartHours	= messageStartHours<10?'0'+messageStartHours:messageStartHours;
				var messageStartMinutes	= messageStartTimeObj.getMinutes();
				var messageStartMinutes	= messageStartMinutes<10?'0'+messageStartMinutes:messageStartMinutes;
				var messageStartTime	= messageStartTimeObj.getFullYear() + '-' + months[messageStartTimeObj.getMonth()] + '-' + messageStartTimeObj.getDate() + ' ' + messageStartHours +':'+ messageStartMinutes;
				
				var messageEndTimeInt	= parseInt(qs.get('messageEndTime'));
				var messageEndTimeObj	= new Date(messageEndTimeInt);
				var messageEndHours		= messageEndTimeObj.getHours();
				var messageEndHours		= messageEndHours<10?'0'+messageEndHours:messageEndHours;
				var messageEndMinutes	= messageEndTimeObj.getMinutes();
				var messageEndMinutes	= messageEndMinutes<10?'0'+messageEndMinutes:messageEndMinutes;
				var messageEndTime		= messageEndTimeObj.getFullYear() + '-' + months[messageEndTimeObj.getMonth()] + '-' + messageEndTimeObj.getDate() + ' ' + messageEndHours + ':' + messageEndMinutes;
				
				var messageStatus		= qs.get('messageStatus');
				var messageType			= qs.get('messageType');
				if ( messageType == 'alert' ) {
					var messageTypeStyle = 'messageType_alert';
				} else if ( messageType == "notification" ) {
					var messageTypeStyle = 'messageType_notification';
				}
				
				messageStatus == 'active' ? textColor='black' : textColor='silver';
				
				var messageTableHtml 	= [
					'<tr class="messageSummary" id="summary_'+messageId+'" style="color:'+textColor+'">',
					'	<td class="'+messageTypeStyle+'">&nbsp;</td>',  // messageTypeIcon
					'	<td>'+messageTitle+'</td>',
					'	<td>'+messageAuthor+'</td>',
					'	<td>'+messageStatus+'</td>',
					'	<td>'+messageStartTime+'</td><td>'+messageEndTime+'</td>',
					'	<td class="buttonCell"><img class="actionButton" src="../_img/edit.png" onclick="editMessage(\'pa\','+messageId+')"/><img class="actionButton" src="../_img/delete.png" onclick="deleteMessage(\'pa\','+messageId+')"/></td>',
					'</tr>'
				].join("");
				$('#messagesTableBody').append(messageTableHtml);
			});
		});	

		
		
	}
	
	
	$('#messagesTableBody').fadeOut('fast').empty();
	$('#messagesTableBody').fadeIn('fast');

	
}

// fetchMessage -- retreives a specific message
function fetchMessage(type,id) {
	if ( type == 'tip' ) {
		var url = getUrlBase + 'motd/tips/' + id + '.txt?sfu_token=' + getCkidToken();
	} else if ( type == 'pa' ) {
		var url = getUrlBase + 'motd/pa/' + id + '.txt?sfu_token=' + getCkidToken();
	}
	$.ajax({
		type: "GET",
		async: false,
		url: url,
		dataType: 'text',
		success: function(data){
			theMessage = data;
			if (theMessage == "") {
				theMessage = "nomessage";
		}
	  }
	});
	return theMessage;
}

// editMessage -- fetches & parses the specified message, sets the edit form values and displays the form row
function editMessage(type,id) {
	editFormHtml = buildFormHtml(type,'edit',id);
	toggleTableAndEditForm();
	$("#editMessageForm").html(editFormHtml);
	$(".dateField").datepicker({ 
		dateFormat: "M dd yy",
		showOn: "both",
		showAnim: "fadeIn",
	    buttonImage: "../_img/calendar_empty.png", 
	    buttonImageOnly: true 
	}).attr("readonly", "readonly");
	toggleEditor('body_'+id);
}

function newMessageForm(type) {
	id = generateId();
	newMessageFormHtml = buildFormHtml(type,'new',id);
	toggleTableAndEditForm();
	$("#editMessageForm").html(newMessageFormHtml);
	// $('#startDate').datepicker();
	$(".dateField").datepicker({ 
		dateFormat: "M dd yy",
		showAnim: "fadeIn",
		showOn: "both", 
	    buttonImage: "../_img/calendar_empty.png", 
	    buttonImageOnly: true 
	}).attr("readonly", "readonly");
	toggleEditor('body_'+id);
}

function hourDropdown(id,elementId,defaultVal) {
	var hourDropdownHtml = '';
	if ( !defaultVal ) { defaultVal = ''; }
	defaultVal = defaultVal<10?'0'+defaultVal:defaultVal;
	hourDropdownHtml += '<span style="margin-left:20px;margin-right:10px">Time</span><select name="'+elementId+'" id="'+elementId+'_'+id+'">\n';
	hourDropdownHtml += '<option value=""></option>';
	for ( i=0; i<24; i++ ) {
		i = i<10?'0'+i:i;
		if ( defaultVal == i ) {
			hourDropdownHtml += '<option selected="selected" value="'+i+'">'+i+'</option>\n';
		} else {
			hourDropdownHtml += '<option value="'+i+'">'+i+'</option>\n';
		}
	}
	hourDropdownHtml += '</select>';
	return hourDropdownHtml;
}

function minuteDropdown(id,elementId,defaultVal) {
	var minuteDropdownHtml = '';
	if ( !defaultVal ) { defaultVal = ''; }
	defaultVal = defaultVal<10?'0'+defaultVal:defaultVal;
	minuteDropdownHtml += '<select "name="'+elementId+'" id="'+elementId+'_'+id+'">\n';
	minuteDropdownHtml += '<option value=""></option>';
	for ( i=0; i<60; i++ ) {
		i = i<10?'0'+i:i;
		if ( defaultVal == i ) {
			minuteDropdownHtml += '<option selected="selected" value="'+i+'">'+i+'</option>\n';
		} else {
			minuteDropdownHtml += '<option value="'+i+'">'+i+'</option>\n';
		}
	}
	minuteDropdownHtml += '</select>';
	return minuteDropdownHtml;
}


function buildFormHtml(type,action,id) {

	// type: tip,pa
	// action: new, edit
	// id: (message id)
	
	// edit: parse the raw message querystring into component variables
	if ( action == "edit" ) {
		var rawMessage 			= fetchMessage(type,id);	
		var qs					= new Querystring(rawMessage);
		var messageId	 		= qs.get("messageId");
		var messageStatus		= qs.get('messageStatus');
		var messageTitle		= unescape(decodeURIComponent(qs.get('messageTitle')));
		var messageBody			= unescape(decodeURIComponent(qs.get('messageBody')));
		var messageAuthor		= qs.get('messageAuthor');
		if ( type == "pa" ) {
			var messageStartTime	= new Date(parseInt(qs.get('messageStartTime')));
			var messageStartDate	= months[messageStartTime.getMonth()] + ' ' + messageStartTime.getDate() + ' ' +  messageStartTime.getFullYear();
			var messageStartHour	= messageStartTime.getHours();
			var messageStartMinutes	= messageStartTime.getMinutes();
		
			var messageEndTime		= new Date(parseInt(qs.get('messageEndTime')));
			var messageEndDate		= months[messageEndTime.getMonth()] + ' ' + messageEndTime.getDate() + ' ' + messageEndTime.getFullYear();
			var messageEndHour		= messageEndTime.getHours();
			var messageEndMinutes	= messageEndTime.getMinutes();
			
			var messageType			= qs.get('messageType');
					
			if ( trim(messageType ) == "alert" ) {
				var messageTypeFrag = '<option value="alert" selected="selected">Alert</option><option value="notification">Notification</option>';
			} else if ( trim(messageType ) == "notification" ) {
				var messageTypeFrag = '<option value="alert">Alert</option><option value="notification" selected="selected">Notification</option>';
			}

		}
		if ( trim(messageStatus) == 'active' ) {
			var messageStatusFrag = '<option value="active" selected="selected">Enabled</option><option value="inactive">Disabled</option>';
		} else if ( trim(messageStatus) == 'inactive' ) { 
			var messageStatusFrag = '<option value="active">Enabled</option><option value="inactive" selected="selected">Disabled</option>';
		}
		
		
	} else if ( action == "new" ) {
		var messageAuthor 		= whoami();
		var messageId			= id;
		var messageStatusFrag 	= '<option value="active">Enabled</option><option value="inactive" selected="selected">Disabled</option>';
		var messageTypeFrag		= '<option value="" selected="selected"></option><option value="alert">Alert</option><option value="notification">Notification</option>';
		var messageTitle		= '';
		var messageBody			= '';
		var messageStartDate	= '';
		var messageEndDate		= '';
	}
	
	// build the form html
	var editFormHtml = '';
	editFormHtml +=			'	<form id="messageForm_'+messageId+'">';
	editFormHtml +=			'	<input type="hidden" value="'+messageId+'" name="messageId"></input>';
	editFormHtml +=			'	<input type="hidden" value="'+messageAuthor+'" name="messageAuthor" id="author_'+messageId+'"></input>';
	
	// if ( type == "pa" ) {
	// 	editFormHtml += 	'	<input type="hidden" value="" name="messageLastUpdatedTime" id="lastUpdated_'+messageId+'"></input>';
	// }
	
	editFormHtml +=			'	<div id="titleDiv">';
	editFormHtml +=			'		<div class="fieldLabel">Title</div>';
	editFormHtml +=			'		<p><label for="messageTitle">Title</label><input class="messageTitleField" type="text" name="messageTitle" value="'+messageTitle+'" id="title_'+messageId+'" maxlength="40" /></p>';
	editFormHtml +=			'	</div>';
	editFormHtml +=			'	<div id="bodyDiv">';
	editFormHtml +=			'		<div class="fieldLabel">Body</div>';
	editFormHtml +=			'		<p><label for="messageBody">Body</label><textarea class="messageBodyField" name="messageBody" id="body_'+messageId+'" style="width:92%" rows="20">'+unescape(decodeURIComponent((messageBody)))+'</textarea></p>';
	editFormHtml +=			'		<p style="font-size:.75em; margin-top:5px" onclick="toggleEditor(\'body_'+messageId+'\')">Toggle Editor</p>';
	editFormHtml +=			'	</div>';

	if ( type == "pa" ) {
		editFormHtml +=		'	<div id="typeDiv">';
		editFormHtml +=		'		<div class="fieldLabel">Message Type</div>';
		editFormHtml +=		'		<span style=\'display: block;font: .8em "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, sans-serif;color: gray;padding-bottom:5px\'>Note: Alert messages will display above notification messages.</span>',
		editFormHtml +=		'		<p><label for="messageType">Message Type</label><select name="messageType" id="type_'+messageId+'">';
		editFormHtml +=					messageTypeFrag;
		editFormHtml +=		'		</select></p>';
		editFormHtml +=		'	</div>';

		editFormHtml +=		'	<div id="timeRangeDiv">';
		editFormHtml +=		'		<div class="fieldLabel">Display Message Between</div>';
		editFormHtml +=		'		<div style="margin-bottom:5px"><p><label for="startDate" class="showLabel">Start Date</label><input class="dateField" type="text" size="10" value="'+messageStartDate+'" name="startDate" id="startDate"/>';		

		if ( action == "edit" ) {
			editFormHtml +=		'		'+hourDropdown(id,'startTimeHour',messageStartHour)+'&nbsp; : &nbsp;'+minuteDropdown(id,'startTimeMinute',messageStartMinutes)+'</p></div>';			
		} else {
			editFormHtml +=		'		'+hourDropdown(id,'startTimeHour')+'&nbsp; : &nbsp;'+minuteDropdown(id,'startTimeMinute')+'</p></div>';
		}		
		editFormHtml +=		'		<div style="margin-bottom:5px"><p><label for="endDate" class="showLabel">End Date</label><input class="dateField" type="text" size="10" value="'+messageEndDate+'" name="endDate" id="endDate"/>';
		
		if ( action == "edit" ) {
			editFormHtml +=		'		'+hourDropdown(id,'endTimeHour',messageEndHour)+'&nbsp; : &nbsp;'+minuteDropdown(id,'endTimeMinute',messageEndMinutes)+'</p></div>';
		} else {
			editFormHtml +=		'		'+hourDropdown(id,'endTimeHour')+'&nbsp; : &nbsp;'+minuteDropdown(id,'endTimeMinute')+'</p></div>';
		}
		editFormHtml +=		'	</div>';
	}

	editFormHtml +=		'	<div id="statusDiv">';
	editFormHtml +=		'		<div class="fieldLabel">Status</div>';
	editFormHtml +=		'		<span style=\'display: block;font: .8em "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, sans-serif;color: gray;padding-bottom:5px;width:89%\'>Note: setting a PA Message to <em>Inactive</em> will prevent the message from being displayed, even if the current time is within the start and end times.</span>',
	editFormHtml +=		'		<p><label for="messageStatus">Status</label><select name="messageStatus" id="status_'+messageId+'">';
	editFormHtml +=					messageStatusFrag;
	editFormHtml +=		'		</select></p>';
	editFormHtml +=		'	</div>';


	editFormHtml +=			'	<div class="formActionButtons">';
	editFormHtml +=			'		<span class="saveButton" onclick="postMessage(\''+type+'\',\''+messageId+'\')">&nbsp;</span>';
	editFormHtml +=			'		<span class="cancelButton" onclick="cancelEditForm(\''+messageId+'\')">&nbsp;</span>';
	editFormHtml +=			'	</div>';
	editFormHtml +=			'	</form>';

	
	return editFormHtml;
}

function postMessage(type,id) {

	// get the messageBody contents from tiny_mce
	try {
		$('#body_'+id).val(tinyMCE.activeEditor.save());
	} catch (err) {
		alert(err);
	}
	
	
	if ( type == 'tip' ) {
		var url = postUrlBase + 'motd/tips/' + id + '.js?sfu_token=' + getCkidToken();
		var queryString = [
			'messageId='+id,
			'&messageAuthor=' + $('#author_'+id).val(),
			'&messageStatus=' + $('#status_'+id).val(),
			'&messageTitle=' + escape(encodeURIComponent($('#title_'+id).val())),
			'&messageBody=' + escape(encodeURIComponent($('#body_'+id).val()))
		].join("");	
	} else if ( type == 'pa' ) {
		// var url = myUrlBase+'_util/rest.php?id='+id+'&type=pa';
		url = postUrlBase + 'motd/pa/' + id + '.js?sfu_token=' + getCkidToken();
		
		var startDate 				= new Date($('#startDate').val()).getTime();
		var startHours	 			= $('#startTimeHour_'+id).val()*60*60*1000;
		var startMinutes			= $('#startTimeMinute_'+id).val()*60*1000;
		var messageStartTime 		= startDate+startHours+startMinutes;

		var endDate			 		= new Date($('#endDate').val()).getTime();
		var endHours	 			= $('#endTimeHour_'+id).val()*60*60*1000;
		var endMinutes				= $('#endTimeMinute_'+id).val()*60*1000;
		var messageEndTime			= endDate+endHours+endMinutes;
		
		var messageLastUpdatedTime	= new Date().getTime(); 
		
		var queryString = [
			'messageId='+id,
			'&messageAuthor=' + $('#author_'+id).val(),
			'&messageStatus=' + $('#status_'+id).val(),
			'&messageType=' + $('#type_'+id).val(),
			'&messageLastUpdatedTime=' + messageLastUpdatedTime,
			'&messageStartTime=' + messageStartTime,
			'&messageEndTime=' + messageEndTime,
			'&messageTitle=' + escape(encodeURIComponent($('#title_'+id).val())),
			'&messageBody=' + escape(encodeURIComponent($('#body_'+id).val()))
		].join("");	
		
	}

	// validation
	
	var errorString = '';
	
	if ( $('#title_'+id).val() == "" || $('#body_'+id).val() == "" ) {
		errorString += 'Title and Body are required fields.\n';
	}

	if ( type == 'pa' ) {
		if ( messageEndTime < messageStartTime ) {
			errorString += 'End date is before start date. Temporal paroxes abound!\n';
		}
		if ( $('#type_'+id).val() == "" ) {
			errorString += 'Message type is a required field';
		}
	}

	if ( errorString ) {
		alert('The following errors were found in your input. Please correct and try again.\n\n'+errorString);
		return false;
	}
	
	// var typeStr = (type == 'tip' ? 'tips' : type);
	
	try { console.info( queryString ); } catch (err) {}
	theResult = $.ajax({
			type: "POST", 
			url: url,
			contentType: "application/json; charset=utf-8",
			data: queryString,
			success: function(data){
				theResult=data;
				try { console.info( data ); } catch (err) {}
				if ( theResult != "OK" ) {
					alert("An error occured and your message could not be saved. Please try again.");
				} else {
					try { toggleEditor('body_'+id); } catch(err) { console.log('oh shit');}
					$('#editMessageForm').empty();
					fetchMessages(type);
					toggleTableAndEditForm();
				}
			}
		});
}

function deleteMessage(type,id) {
	
	// confirm deletion
	// TODO: Make this prettier than a standard confirm dialog
	var confirmation = confirm("Are you sure you want to delete this message?");
	if (confirmation) {
		if ( type == 'tip' ) {
			var url = getUrlBase +'motd/tips/' + id + '.js?rest_op=delete&sfu_token=' + getCkidToken();
		} else if ( type == 'pa' ) {
			var url = getUrlBase +'motd/pa/' + id + '.js?rest_op=delete&sfu_token=' + getCkidToken();
		}
		try { console.info( url ); } catch (err) {}
		var http = new XMLHttpRequest();
		http.open("GET", url, false);
		http.send(null);
		fetchMessages(type);
	}
}

function deleteAll(type) {
	var confirmation = confirm("Delete ALL messages currently not supported");
//	if ( confirmation ) {
//		if ( type == 'tip' ) {
//			var url = myUrlBase +'tips/?rest_op=delete&sfu_token=' + getCkidToken();;
//		} else if ( type == 'pa' ) {
//			var url = myUrlBase +'pa/?rest_op=delete&sfu_token=' + getCkidToken();;
//		}
//		var xmlhttp = new XMLHttpRequest();
//		xmlhttp.open("DELETE", url, false);
//		xmlhttp.send(null);
//		fetchMessages(type);
//	}
}

function cancelEditForm(id) {

	// TODO: confirm cancelation on dirty fields?
	try { toggleEditor('body_'+id); } catch(err) {}
	$('#editMessageForm').empty();
	toggleTableAndEditForm();
}

function toggleTableAndEditForm() {
	$('#editMessageForm').slideToggle();
	$('#messageTable').slideToggle();

}

/**
*
*  Javascript trim, ltrim, rtrim
*  http://www.webtoolkit.info/
*
*
**/

function trim(str, chars) {
    return ltrim(rtrim(str, chars), chars);
}

function ltrim(str, chars) {
    chars = chars || "\\s";
    return str.replace(new RegExp("^[" + chars + "]+", "g"), "");
}

function rtrim(str, chars) {
    chars = chars || "\\s";
    return str.replace(new RegExp("[" + chars + "]+$", "g"), "");
}




$(document).ready(function() {
	// var username = whoami();
});
