//////////////////////////////////////////////////////////////
//  ca_sfu_icat_motd zimlet -- tips, pa messages
//  @author Graham Ballantyne (grahamb@sfu.ca)
//////////////////////////////////////////////////////////////

function ca_sfu_icat_motd() { }

ca_sfu_icat_motd.prototype = new ZmZimletBase();
ca_sfu_icat_motd.prototype.constructor = ca_sfu_icat_motd;

ca_sfu_icat_motd.host               = 'http://cgi.sfu.ca/~hillman/zimbrarest.cgi';   // Path to your REST server, you should probably change it
ca_sfu_icat_motd.username           = appCtxt.get(ZmSetting.USERNAME).substr(0, appCtxt.get(ZmSetting.USERNAME).indexOf('@'));
ca_sfu_icat_motd.restRoot           = ZmZimletBase.PROXY + ca_sfu_icat_motd.host + '/motd/';
ca_sfu_icat_motd.prefUrl            = ZmZimletBase.PROXY + ca_sfu_icat_motd.host + '/datastore/motd/' + ca_sfu_icat_motd.username + '/showtip.txt';
ca_sfu_icat_motd.lastSeenUrl        = ZmZimletBase.PROXY + ca_sfu_icat_motd.host + '/datastore/motd/' + ca_sfu_icat_motd.username + '/lastseen.txt';
ca_sfu_icat_motd.isUpUrl            = ZmZimletBase.PROXY + ca_sfu_icat_motd.host + '/isup';
ca_sfu_icat_motd.appPrefsUrl        = ZmZimletBase.PROXY + ca_sfu_icat_motd.host + '/datastore/motd/global.js';
ca_sfu_icat_motd.currentMessageId   = '';

// defaults, will be overridden in getPrefs, if they exist on the server
ca_sfu_icat_motd.motdIsEnabled = "true";
ca_sfu_icat_motd.paDialogHeight = 400;
ca_sfu_icat_motd.paDialogWidth = 600;
ca_sfu_icat_motd.paMessageDisplayLimit = 5;
ca_sfu_icat_motd.paPollingInterval = 900000; // milliseconds
ca_sfu_icat_motd.tipDialogHeight = 400;
ca_sfu_icat_motd.tipDialogWidth = 600

// make an object to hold the number of times each PA message has been seen by the user in this session
ca_sfu_icat_motd.paMessageViewedCount = {};

ca_sfu_icat_motd.prototype.init = function () {

        try { console.info('[ZIMLET] Loading ca_sfu_icat_motd'); } catch (err) {}
        // die if the rest server is not responding
        if (this.isUp().substr(0, 2) !== "OK") {
            try { console.info('[ZIMLET] ca_sfu_icat_motd: Could not communite with REST server - stopping'); } catch (err) {}
            return false;
        }
        
        // get application preferences
        this.getPrefs();

        if (ca_sfu_icat_motd.motdIsEnabled === "false") {
            try { console.info('[ZIMLET] ca_sfu_icat_motd has been disabled - stopping'); } catch (err) {}
            return false;
        }

        // bind a click-handler to the "don't show at login" checkbox
        $("#showTip").live("click", function () {
            ca_sfu_icat_motd.prototype.toggleTipPref();
        });

        // define the timer
        this.paPollForMessageAction = new AjxTimedAction(this, this.paPollForMessage);

        // check for pending PA messages
        // if any found, display; else, check tipPref & lastSeen and if good, show a tip
        this.paMessageResult = this.getPaMsg();
        if (this.paMessageResult !== false) {
            this.showMessage('pa', this.paMessageResult);
        } else {
            if ((this.getTipPref() !== "false")  && (this.timeoutHasElapsed() === "true")) {
                this.showMessage('tip', this.getRandomTip(), true);
            } else {
                // start the timer
                AjxTimedAction.scheduleAction(this.paPollForMessageAction, paPollingInterval);
            }
        }
};

ca_sfu_icat_motd.prototype.singleClicked = function () {
    // die if the rest server is not responding or if the zimlet has been disabled
    if (this.isUp().substr(0, 2) !== "OK" || ca_sfu_icat_motd.motdIsEnabled === "false") {
        return false;
    }
    this.showMessage('tip', this.getRandomTip());
};

ca_sfu_icat_motd.prototype.doubleClicked = function () {
    this.singleClicked();
};

ca_sfu_icat_motd.prototype.isUp = function (data) {
    var isUp = AjxRpc.invoke(null, ca_sfu_icat_motd.isUpUrl, null, null, true, 5000).text;
    return isUp;
};

ca_sfu_icat_motd.prototype.getPrefs = function (data) {
    $.ajax({
        type: "GET",
        url: ca_sfu_icat_motd.appPrefsUrl,
        dataType: "json",
        async: false,
        success: function (data) {
            ca_sfu_icat_motd.motdIsEnabled = data.motdIsEnabled;
            ca_sfu_icat_motd.paDialogHeight = data.paDialogHeight;
            ca_sfu_icat_motd.paDialogWidth = data.paDialogWidth;
            ca_sfu_icat_motd.paMessageDisplayLimit = data.paMessageDisplayLimit;
            ca_sfu_icat_motd.paPollingInterval = data.paPollingInterval;
            ca_sfu_icat_motd.tipDialogHeight = data.tipDialogHeight;
            ca_sfu_icat_motd.tipDialogWidth = data.tipDialogWidth;
        }
    });
};

ca_sfu_icat_motd.prototype.nextTipButtonHandler = function () {
    var rawMessage = this.getNextTip(ca_sfu_icat_motd.currentMessageId),
        qs = new Querystring(rawMessage),
        messageTitle = unescape(decodeURIComponent(qs.get('messageTitle'))),
        messageBody  = unescape(decodeURIComponent(qs.get('messageBody')));
    ca_sfu_icat_motd.currentMessageId = unescape(decodeURIComponent(qs.get('messageId')));
    $(".messageTitle").html(messageTitle);
    $(".messageBody").html(messageBody);
};

ca_sfu_icat_motd.prototype.closeButtonHandler = function () {
    this.dialog.popdown();
    this.dialog.dispose();
    AjxTimedAction.scheduleAction(this.paPollForMessageAction, ca_sfu_icat_motd.paPollingInterval);
};

ca_sfu_icat_motd.prototype.getTipPref = function () {
    var tipPref = AjxRpc.invoke(null, ca_sfu_icat_motd.prefUrl, null, null, true, 5000).text;
    tipPref = tipPref === '' ? 'true' : tipPref;
    return tipPref;
};

ca_sfu_icat_motd.prototype.timeoutHasElapsed = function () {
    var lastSeen = AjxRpc.invoke(null, ca_sfu_icat_motd.lastSeenUrl, null, null, true, 5000).text,
        now = new Date().getTime(),
        oneDay = 1000 * 60 * 60 * 24,
        elapsed = ((now - lastSeen) / oneDay),
        hasElapsed;
    if (elapsed > 1) {
        hasElapsed = "true";
    }
    return hasElapsed;
};

ca_sfu_icat_motd.prototype.setLastSeenTime = function () {
    var lastSeenTs = new Date().getTime();
    AjxRpc.invoke(lastSeenTs, ca_sfu_icat_motd.lastSeenUrl, null, null, false, 5000);
};

ca_sfu_icat_motd.prototype.getRandomTip = function () {
    ie_cachebuster = new Date().getTime();  // generate a timestamp so that we can append it to the GET request to work around IE's HTTP GET caching behaviour
    var rawTip = AjxRpc.invoke(null, ca_sfu_icat_motd.restRoot + 'tips/random?' + ie_cachebuster, null, null, true, 5000).text;
    return rawTip;
};

ca_sfu_icat_motd.prototype.getNextTip = function (currentMessageId) {
    ie_cachebuster = new Date().getTime();  // generate a timestamp so that we can append it to the GET request to work around IE's HTTP GET caching behaviour
    var rawTip = AjxRpc.invoke(null, ca_sfu_icat_motd.restRoot + 'tips/' + currentMessageId + '/next?' + ie_cachebuster, null, null, true, 5000).text;
    return rawTip;
};

ca_sfu_icat_motd.prototype.toggleTipPref = function () {
    var currentPref = this.getTipPref(),
        theResponse;
        
    if (currentPref === "true") {
        theResponse = AjxRpc.invoke("false", ca_sfu_icat_motd.prefUrl, null, null, false, 5000);
    } else {
        theResponse = AjxRpc.invoke("true", ca_sfu_icat_motd.prefUrl, null, null, false, 5000);
    }
};

ca_sfu_icat_motd.prototype.getPaMsg = function () {
    var paMessages,
        ie_cachebuster = new Date().getTime(),  // generate a timestamp so that we can append it to the GET request to work around IE's HTTP GET caching behaviour
        url = ca_sfu_icat_motd.restRoot + 'pa/current.js?' + ie_cachebuster;
    $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            async: false,
            success: function (data) {               
                if (data.length > 0) {
                    paMessages = data;
                } else {
                    paMessages = false;
                }
            }
        });
    return paMessages;
};

ca_sfu_icat_motd.prototype.paPollForMessage = function (data) {
    this.paMessageResult = this.getPaMsg();
    if (this.paMessageResult !== false) {
        this.showMessage('pa', this.paMessageResult);
    }  else {
        AjxTimedAction.scheduleAction(this.paPollForMessageAction, ca_sfu_icat_motd.paPollingInterval);
    }
};

ca_sfu_icat_motd.prototype.showMessage = function (type, data, atStartup) {
    
    AjxTimedAction.cancelAction(this.paPollForMessageAction._id);

    var width  = type === 'tip' ? ca_sfu_icat_motd.tipDialogWidth  : ca_sfu_icat_motd.paDialogWidth,
        height = type === 'tip' ? ca_sfu_icat_motd.tipDialogHeight : ca_sfu_icat_motd.paDialogHeight,
        el, messageDialogBox, tipPrefCheckBox, qs, html, paMsgArray, countForMessage, numTimesLeftToShow, numTimesLeftToShowStr, messageTitle, messageBody, messageLastUpdatedTime;
    
    var view = new DwtComposite(this.getShell());
    view.setSize(width, height);
    el = view.getHtmlElement();
    messageDialogBox = document.createElement('div');
    el.appendChild(messageDialogBox);

    // build the content for the dialog
    if (type === "tip") {
        // get the current tip display pref for the checkbox
        if (this.getTipPref() === 'true') {
            tipPrefCheckBox = 'checked';
        } else {
            tipPrefCheckBox = '';
        }

        // parse the querystring and append data to our div
        qs = new Querystring(data);
        if (data === "") {
            return false;
        } else {
            if (atStartup) {
                this.setLastSeenTime();
            }
        }
        messageTitle = unescape(decodeURIComponent(qs.get('messageTitle')));
        messageBody  = unescape(decodeURIComponent(qs.get('messageBody')));
        ca_sfu_icat_motd.currentMessageId    = unescape(decodeURIComponent(qs.get('messageId')));

        html = [
            '<div class="messageTitle">' + messageTitle + '</div>',
            '<div class="messageBody">' + messageBody + '</div>',
            '<div class="messagePref" style="padding-top:5px"><input type="checkbox" id="showTip" name="showTip" checked="' + tipPrefCheckBox + '" /><label for="showTip">Show Tip of the Day at login (once every 24 hours)</label></div>'
        ].join('');
        messageDialogBox.innerHTML = html;

        $('.messageBody').css('height', height - 35);

        // set dialog options (title, button labels, button handlers)
        this.dialog = this._createDialog({title : "SFU Connect - Tips &amp; Tricks", view : view});
        this.dialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this.nextTipButtonHandler));
        this.dialog.setButtonListener(DwtDialog.CANCEL_BUTTON, new AjxListener(this, this.closeButtonHandler));
        this.dialog.getButton(DwtDialog.OK_BUTTON).setText("Show Another");
        this.dialog.getButton(DwtDialog.CANCEL_BUTTON).setText("Close");
        this.dialog.popup();

    } else if (type === 'pa') {
        
        // append a new div with overflow:auto to create a scrolling area
        messageDialogBox.innerHTML = '<div class="paMessageContainer"></div>';

        // split alert and notification messages into separate arrays
        paMsgArray = [ [], [] ];
        // paMsgArray.push(new Array());
        // paMsgArray.push(new Array());
        $.each(data, function (i, item) {
            qs = new Querystring(item);
            messageType = qs.get('messageType');
            if (messageType === 'alert') {
                paMsgArray[0].push(item);
            } else if (messageType === 'notification') {
                paMsgArray[1].push(item);
            }
        });

        $.each(paMsgArray, function (i, item) {
            $.each(item, function (m, msg) {
                qs = new Querystring(msg);
                messageId = qs.get('messageId');
                    
                if (!ca_sfu_icat_motd.paMessageViewedCount[messageId]) {
                    ca_sfu_icat_motd.paMessageViewedCount[messageId] = 1;
                } else {
                    ca_sfu_icat_motd.paMessageViewedCount[messageId]++;
                }

                if (ca_sfu_icat_motd.paMessageDisplayLimit > 0) {
                    countForMessage = ca_sfu_icat_motd.paMessageViewedCount[messageId];
                    numTimesLeftToShow = (ca_sfu_icat_motd.paMessageDisplayLimit - ca_sfu_icat_motd.paMessageViewedCount[messageId]);

                    if (numTimesLeftToShow === 0) {
                        numTimesLeftToShowStr = "This message will not be shown again in this session";
                    } else if (numTimesLeftToShow === 1) {
                        numTimesLeftToShowStr = "This message will be shown " + numTimesLeftToShow + " more time in this session";
                    } else {
                        numTimesLeftToShowStr = "This message will be shown " + numTimesLeftToShow + " more times in this session";
                    }

                    messageTitle            = unescape(decodeURIComponent(qs.get('messageTitle')));
                    messageBody             = unescape(decodeURIComponent(qs.get('messageBody')));
                    messageLastUpdatedTime  = new Date(parseInt(qs.get('messageLastUpdatedTime'), 10));

                    if (0 <= numTimesLeftToShow || ca_sfu_icat_motd.paMessageDisplayLimit < numTimesLeftToShow) {
                        $('.paMessageContainer').append('<div class="paMessageTitle">' + messageTitle + '</div>');
                        $('.paMessageContainer').append('<div class="paMessageNumTimesLeftToShowStr">Last updated: ' + messageLastUpdatedTime + '&nbsp;&nbsp;&bull;&nbsp;&nbsp;' + numTimesLeftToShowStr + '</div>');
                        $('.paMessageContainer').append('<div class="paMessageBody">' + messageBody + '</p></div>');
                    }

                } else {
                    $('.paMessageContainer').append('<div class="paMessageTitle">' + messageTitle + '</div>');
                    $('.paMessageContainer').append('<div class="paMessageNumTimesLeftToShowStr">Last updated: ' + messageLastUpdatedTime + '</div>');
                    $('.paMessageContainer').append('<div class="paMessageBody">' + messageBody + '</p></div>');
                }

            });


        });

        if ($('.paMessageContainer').css('height', height - 35).html()) {
            // set dialog options (title, button labels, button handlers)
            this.dialog = this._createDialog({title: "SFU Connect - Notices &amp; Alerts", view : view});
            this.dialog.getButton(DwtDialog.OK_BUTTON).setText("Close");
            this.dialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this.closeButtonHandler));
            this.dialog.setButtonVisible(DwtDialog.CANCEL_BUTTON, false);
            this.dialog.popup();
        } else {
            AjxTimedAction.scheduleAction(this.paPollForMessageAction, ca_sfu_icat_motd.paPollingInterval);
        }
    }
};
