/**
 * ***** BEGIN LICENSE BLOCK *****
 * Weather in Japan Zimlet
 * Copyright (C) 2013 MIRAIT Information Systems Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ***** END LICENSE BLOCK *****
 * @author MIRAIT Information Systems Co.,Ltd.
 */


function jp_miraitsystems_weather_handlerObject() {
}
jp_miraitsystems_weather_handlerObject.prototype = new ZmZimletBase();
jp_miraitsystems_weather_handlerObject.prototype.constructor = jp_miraitsystems_weather_handlerObject;

jp_miraitsystems_weather_handlerObject.pos = null;

jp_miraitsystems_weather_handlerObject.prototype.init =
function() {
	this.degrees = this.getMessage("degrees");
	this.using_geo_info = this.getMessage("using_geo_info");
	this.zimletname = this.getMessage("label");
	this.failToGetLocationiData = this.getMessage("fail_to_get_location_data");
	this.defaultCity = ["tokyo", "130010"]; //Tokyo
	this.cityList =[
		["tokyo", "\u6771\u4eac", this.getMessage("Tokyo"), 130010],
		["osaka", "\u5927\u962a", this.getMessage("Osaka"), 270000],
		["niigata", "\u65b0\u6f5f", this.getMessage("Niigata"), 150010]
	];

	this._feed = "http://weather.livedoor.com/forecast/webservice/json/v1?city=";
	this._city = this.getUserProperty("city");
	var appId = "YOUR_APPLICATION_ID";
	this._dist = 3;
	this._yahoo_api = "http://search.olp.yahooapis.jp/OpenLocalPlatform/V1/localSearch?results=1&output=xml&appid=" + appId;
	if(!this._city){
		this._city = this.defaultCity[1];
		this.setUserProperty("city", this._city, true);
	}
	this.use_location = this.getUserProperty("use_location");
	// the type of this.use_location is String.
	if(this.use_location == "true"){
		this.use_location = true;
	}
	else{
		this.use_location = false;
	}

	if(this.use_location){
		this.getLocation();
	}

};

jp_miraitsystems_weather_handlerObject.prototype.getLocation =
function(){
	if(window.navigator.geolocation){
		window.navigator.geolocation.getCurrentPosition(function(_pos){jp_miraitsystems_weather_handlerObject.pos = _pos;},function(error){});
	}
};

jp_miraitsystems_weather_handlerObject.prototype._invoke =
function(postCallback) {
	this.isInvokeDone = true;
	var response;
	if(this.use_location){
		if(jp_miraitsystems_weather_handlerObject.pos != null){
			// jp_miraitsystems_weather_handlerObject.pos may be null because it takes time to get position using window.navigator.geolocation.getCurrentPosition.
			var googleApiUrl = ZmZimletBase.PROXY + AjxStringUtil.urlComponentEncode(this._yahoo_api + "&lat=" +  jp_miraitsystems_weather_handlerObject.pos.coords.latitude + "&lon=" + jp_miraitsystems_weather_handlerObject.pos.coords.longitude + "&dist=" + this._dist);
			AjxRpc.invoke(null, googleApiUrl, null, new AjxCallback(this, this._getCityHandler, postCallback), true, 5000);
		}
		else{
			this._showErrorTooltip();
			this._getWeather(this._city, postCallback);
		}
	}
	else{
		this._getWeather(this._city, postCallback);
	}
};

jp_miraitsystems_weather_handlerObject.prototype._getWeather =
function(city, postCallback){
	var feedUrl = ZmZimletBase.PROXY + AjxStringUtil.urlComponentEncode(this._feed + city);
	AjxRpc.invoke(null, feedUrl, null, new AjxCallback(this, this._responseHandler, postCallback), true, 5000);
};

jp_miraitsystems_weather_handlerObject.prototype._showErrorTooltip =
function(){
	var param = {
		msg:this.failToGetLocationiData,
		level: ZmStatusView.LEVEL_WARNING
	};
	this.displayStatusMessage(param);
};


jp_miraitsystems_weather_handlerObject.prototype._getCityHandler =
function(postCallback, response){
	var target_city = this._city;
	var success = false;
	if(response && response.xml){
		var address = response.xml.documentElement.getElementsByTagName("Feature")[0].getElementsByTagName("Property")[0].getElementsByTagName("Address")[0].textContent;
		var city_str = this.getCityString(address);
		if(city_str){
			target_city = this.getCityCode(city_str);
			success = true;
		}
	}
	// notify failure and use selected city or default(Tokyo)
	if(!success || target_city < 0){
		this._showErrorTooltip();
		target_city = this._city;
	}
	this._getWeather(target_city, postCallback);
};

jp_miraitsystems_weather_handlerObject.prototype.getCityString =
function(str){
	var i;
	for(i = 0; i < this.cityList.length; i++){
		if(str.match(this.cityList[i][1])){
			return this.cityList[i][0];
		}
	}
	return null; // unknown city
};
		


jp_miraitsystems_weather_handlerObject.prototype.getCityCode =
function(str){
	var code;
	if(str){
		str = str.toLowerCase();
	}
	for(var i = 0; i < this.cityList.length; i++){
		if(str == this.cityList[i][0]){
			return this.cityList[i][3];
		}
	}
	return -1; // unknown city
}



jp_miraitsystems_weather_handlerObject.prototype._responseHandler =
function(postCallback, response) {
	var item = "";
	try {
		item = JSON.parse(response.text);
	} catch(e) {//there was some expn getting feed
		this._showErrorMsg(e);
		return;
	}
	this.titleDescArray = new Array();
	this._currentFeedIndex = 0;
	var counter = 0;
	for (var i = 0; i < 1; i++) {
		try {
			var city = item.location.city;
			var date1 = item.forecasts[0].date;
			var weather1 = item.forecasts[0].telop;
			var temperature1 = item.forecasts[0].temperature.max && item.forecasts[0].temperature.max.celsius;
			var icon1 = item.forecasts[0].image.url;
			// Tomorrow
			var date2 = item.forecasts[1].date;
			var weather2 = item.forecasts[1].telop;
			var temperature2 = item.forecasts[1].temperature.max && item.forecasts[1].temperature.max.celsius;
			var icon2 = item.forecasts[1].image.url;
/*
//API was changed...
			// Day after tomorrow
			var date3 = item.forecasts[2].date;
			var weather3 = item.forecasts[2].telop;
			var temperature3 = item.forecasts[2].temperature.max && item.forecasts[2].temperature.max.celsius;
			var icon3 = item.forecasts[2].image.url;
*/
			var copyright = item.copyright.title;
			this.titleDescArray[counter] =
				{city:city, date1:date1, weather1:weather1, icon1:icon1, temperature1:temperature1,
					date2:date2, weather2:weather2, icon2:icon2, temperature2:temperature2,
//					date3:date3, weather3:weather3, icon3:icon3, temperature3:temperature3,
					copyright:copyright}; 
			counter++;
		}catch(e) {//print some exception
			this._showErrorMsg(e);
			return;
		}
	}
   if(postCallback)
	   postCallback.run(this);
};

jp_miraitsystems_weather_handlerObject.prototype._showErrorMsg =
function(msg) {
	var msgDialog = appCtxt.getMsgDialog();
	msgDialog.reset();
	msgDialog.setMessage(msg, DwtMessageDialog.CRITICAL_STYLE);
	msgDialog.popup();
};


jp_miraitsystems_weather_handlerObject.prototype.doubleClicked =
function() {
	if(this.isInvokeDone != true){
		var postCallback = new AjxCallback(this, this._displayWeatherResultsDialog);
		this._invoke(postCallback);
	}
	else{
		this._displayWeatherResultsDialog();
	}
};

jp_miraitsystems_weather_handlerObject.prototype.singleClicked =
function() {
	var postCallback = null;
	if(this._visible) {//if weather is visible.. clear timeout, and then swap it
		this._showWeatherInMiniCal();
		return;
	}
	if(this.isInvokeDone != true){
		postCallback = new AjxCallback(this, this._showWeatherInMiniCal);
		this._invoke(postCallback);
	}
	else{
		this._showWeatherInMiniCal();
	}
};

jp_miraitsystems_weather_handlerObject.prototype.menuItemSelected =
function(itemId) {
	switch(itemId){
		case "jp_miraitsystems_weather_geoinfo":
			this._displayPrefDialog();
			break;
		case "jp_miraitsystems_weather_refresh":
			this.isInvokeDone = false;
			if(this.use_location){
				this.getLocation();
			}
			break;
	}
};


jp_miraitsystems_weather_handlerObject.prototype._displayWeatherResultsDialog =
function() {
	if (this.weatherDlg) {
		this._parentView.getHtmlElement().innerHTML = this._constructDialogView();
		this.weatherDlg.popup();
		return;
	}
	this._parentView = new DwtComposite(this.getShell());
	this._parentView.setSize("400", "160");
	this._parentView.getHtmlElement().style.overflow = "auto";
	this._parentView.getHtmlElement().innerHTML = this._constructDialogView();
	this.weatherDlg = this._createDialog({title:this.zimletname, view:this._parentView, standardButtons : [DwtDialog.OK_BUTTON]});
	this.weatherDlg.popup();
};

jp_miraitsystems_weather_handlerObject.prototype._constructDialogView =
function() {
	var html = new Array();
	var i = 0;
	for(var j=0;j<this.titleDescArray.length; j++) {
		var val = this.titleDescArray[j];
		html[i++] = "<div class='jp_miraitsystems_weather_HdrDiv'>";
		html[i++] = "<TABLE  cellpadding=5>";
		html[i++] = "<TR>";
		html[i++] = "<TD>";
		html[i++] =  val.city;
		html[i++] = "</TD>";
		html[i++] = "</TR>";
		html[i++] = "</TABLE>";
		html[i++] = "</div>";
		html[i++] = "<div class='jp_miraitsystems_weather_sectionDiv'>";
		html[i++] = "<TABLE  cellpadding=5>";
		html[i++] = "<TR>";
		html[i++] = "<TD>";
		if(val.temperature1){
			html[i++] =  val.date1 + "  " + val.weather1 +  "  " +  val.temperature1 + " " + this.degrees + "  <img src='" + val.icon1 + "'>";
		}
		else{
			html[i++] =  val.date1 + "  " + val.weather1 + "  <img src='" + val.icon1 + "'>";
		}
		html[i++] = "</TD>";
		html[i++] = "</TR>";
		html[i++] = "<TR>";
		html[i++] = "<TD>";
		if(val.temperature2){
			html[i++] =  val.date2 + "  " + val.weather2 +  "  " +  val.temperature2 + " " + this.degrees + "  <img src='" + val.icon2 + "'>";
		}
		else{
			html[i++] =  val.date2 + "  " + val.weather2 + "  <img src='" + val.icon2 + "'>";
		}
		html[i++] = "</TD>";
		html[i++] = "</TR>";
		html[i++] = "</TR>";
/*
// API was changed...
		html[i++] = "<TR>";
		html[i++] = "<TD>";
		if(val.temperature3){
			html[i++] =  val.date3 + "  " + val.weather3 + "  " +  val.temperature3 + " " + this.degrees  +  "  <img src='" + val.icon3 + "'>";
		}
		else{
			html[i++] =  val.date3 + "  " + val.weather3 + "  <img src='" + val.icon3 + "'>";
		}
		html[i++] = "</TD>";
		html[i++] = "</TR>";
*/
		html[i++] = "<TR>";
		html[i++] = "<TD>";
		html[i++] =  val.copyright;
		html[i++] = "</TD>";
		html[i++] = "</TR>";
		html[i++] = "</TABLE>";
		html[i++] = "</div>";		
	}
	return html.join("");
};


jp_miraitsystems_weather_handlerObject.prototype._showWeatherInMiniCal = function() {
	this._visible = !this._visible;
	if(!this._miniCal) {
		var calController = AjxDispatcher.run("GetCalController");
		this._miniCal = calController ? calController.getMiniCalendar().getHtmlElement() : null;
	}
	if (this._visible) {
		this._newDiv = document.getElementById("customInMiniCal_DIV");
		if (!this._newDiv) {
			this._newDiv = document.createElement("div");
			this._newDiv.id = "customInMiniCal_DIV";
			this._newDiv.style.zIndex = 900;
			this._newDiv.style.width = 163;
			this._newDiv.style.backgroundColor = "white";
			document.getElementById("skin_container_tree_footer").appendChild(this._newDiv);
		}
		this._miniCal.style.visibility = "hidden";
		this._showMinicalView();
	}
	else {
		this._miniCal.style.visibility = "visible";
	}
};

jp_miraitsystems_weather_handlerObject.prototype._showMinicalView =
function() {
	if(this._currentFeedIndex ==this.titleDescArray.length) {
		this._currentFeedIndex =0;//reset
	}
	var html = new Array();
	var i = 0;
	var val = this.titleDescArray[this._currentFeedIndex];
	html[i++] = "<div>";
	html[i++] = "<TABLE  cellpadding=5>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	html[i++] =  val.city;
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	if(val.temperature1){
		html[i++] =  val.date1 + " " + val.weather1 + " " +  val.temperature1 + " " + this.degrees + " <img src='" + val.icon1 + "'>";
	}
	else{
		html[i++] =  val.date1 + " " + val.weather1 + " <img src='" + val.icon1 + "'>";
	}
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	html[i++] =  val.copyright;
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "</div>";	
	this._newDiv.innerHTML = html.join("");
	this._currentFeedIndex++;
};


jp_miraitsystems_weather_handlerObject.prototype._displayPrefDialog =
function() {
	if (this.pbDialog) {
		document.getElementById("jp_miraitsystems_weather_geoinfo_usage").checked = this.use_location;
		for(var i = 0; i < this.cityList.length; i++){
			var element = document.getElementById("jp_miraitsystems_weather_radio_" + this.cityList[i][0]);
			if(this._city == this.cityList[i][3]){
				element.checked = true;
			}
			else{
				element.checked = false;
			}
		}
		this.pbDialog.popup();
		return;
	}
	this.pView = new DwtComposite(this.getShell());
	this.pView.setSize("130", "100"); // set width and height
	this.pView.getHtmlElement().innerHTML = this._createPreferenceView();
	this.pbDialog = new ZmDialog({title:"Zimlet Preferences", view:this.pView, parent:this.getShell(), standardButtons:[DwtDialog.OK_BUTTON]});
	this.pbDialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._okBtnListner));
	this.pbDialog.popup();
};


jp_miraitsystems_weather_handlerObject.prototype._createPreferenceView =
function() {
	var html = new Array();
	var i = 0;
	var cityId = {};
	var j;
	for(j = 0; j < this.cityList.length; j++){
		cityId[this.cityList[j][0]] = this.cityList[j][3] == this._city ? "checked" : "";
	}
	var checkStatus = this.use_location ? "checked" : "";

	html[i++] = "<DIV>";
	html[i++] = "<input id='jp_miraitsystems_weather_geoinfo_usage'  type='checkbox' value='use_geo_info'" + checkStatus + ">" + this.using_geo_info ;
	html[i++] = "</DIV>";
	html[i++] = "<DIV>";
	for(j = 0; j < this.cityList.length; j++){
		var id = "jp_miraitsystems_weather_radio_" + this.cityList[j][0];
		var value = this.cityList[j][0];
		var label = this.cityList[j][2];
		html[i++] = "<input id='" + id + "' name='jp_miraitsystems_weather_geoinfo' type='radio' value='" + value + "' " + cityId[value] + "/>" + label + "</br>";
	}
	html[i++] = "</DIV>";
	return html.join("");
};


jp_miraitsystems_weather_handlerObject.prototype._okBtnListner =
function() {
	var value = document.getElementById("jp_miraitsystems_weather_geoinfo_usage").checked;
	// get checked city from radio buttons
	var city_info = document.getElementsByName("jp_miraitsystems_weather_geoinfo");
	var city = "";
	var i;
	for (i = 0; i < city_info.length; i++){
		if (city_info[i].checked){
			city = city_info[i].value;
		}
	}
	var code = this.getCityCode(city);

	if(this.use_location == value && this._city == code){
		this.pbDialog.popdown();
		return;
	}

	this.use_location = value;
	this._city = code;
	this.setUserProperty("use_location", value.toString());
	this.setUserProperty("city", code, true);
	if(this.use_location){
		this.getLocation();
	}
	this.isInvokeDone = false;
	this.pbDialog.popdown();
};
