/**
 * ***** BEGIN LICENSE BLOCK *****
 * Address Check Zimlet
 * Copyright (C) 2013 MIRAIT Information Systems Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ***** END LICENSE BLOCK *****
 * @author MIRAIT Information Systems Co.,Ltd.
 */


function jp_miraitsystems_addresscheck_HandlerObject() {
}

jp_miraitsystems_addresscheck_HandlerObject.prototype = new ZmZimletBase();
jp_miraitsystems_addresscheck_HandlerObject.prototype.constructor = jp_miraitsystems_addresscheck_HandlerObject;

jp_miraitsystems_addresscheck_HandlerObject.prototype.init =
function() {
	this.dialog_message = this.getMessage("DomainAlert_dialog_message");
	this.multi_domain_message = this.getMessage("multiple_domain");
	this.addressbook_message = this.getMessage("non_registered_email");
	this.scanning_message = this.getMessage("scanning_addressbook");
	this.scanning_done_message = this.getMessage("scanning_addressbook_done");
	this.scan_not_finished_message = this.getMessage("scan_not_finished");
	this.scan_skipped_message = this.getMessage("scan_skipped");
	this._scanningAddressbookDone = false;
	this.zimletName = "jp_miraitsystems_addresscheck";
};


jp_miraitsystems_addresscheck_HandlerObject.prototype.initializeToolbar =
function(app, toolbar, controller, viewId) {
	if(viewId.match(/COMPOSE/)) {
		this.getAllContacts();
	}
};


/**
 * @param {ZmMailMsg} mail 		the mail object
 * @param {array} boolAndErrorMsgArray	an array of hash objects
 */
jp_miraitsystems_addresscheck_HandlerObject.prototype.emailErrorCheck =
function(mail, boolAndErrorMsgArray) {
	if(!this._contactList){
		var errParams = {
			hasError:true,
			errorMsg: this.dialog_message + "<br>" + this.scan_skipped_message,
			zimletName:jp_miraitsystems_addresscheck_HandlerObject.ZIMLET_NAME
		};
		return boolAndErrorMsgArray.push(errParams);
	}

	var emails = this.getEmails(mail);
	var unique_domain = this.getDomains(emails);
	var non_registered_emails = this.checkAddressbook(emails);

	if(unique_domain.length == 1 && non_registered_emails.length == 0){
		return null;
	}

	var html;
	var i;
	var domain_list = "";
	if(unique_domain.length > 1){
		html = new Array();
		for(i = 0; i < unique_domain.length; i++){
			html[i] = "<br>" + AjxStringUtil.htmlEncode(unique_domain[i]);
		}
		domain_list = "<br><br>" + this.multi_domain_message + html.join("");
	}

	var non_registered_list = "";
	if(non_registered_emails.length > 0){
		var not_finished_message = "";
		if(!this._scanningAddressbookDone){
			not_finished_message = this.scan_not_finished_message;
		}
		html = new Array();
		for(i = 0; i < non_registered_emails.length; i++){
			html[i] = "<br>" + AjxStringUtil.htmlEncode(non_registered_emails[i]);
		}
		non_registered_list = "<br><br>" + this.addressbook_message + not_finished_message + html.join("");
	}

	// On Compose Windows, a warning dialog is shown when user is sending a message with no subject.
	// When closing the dialog, OkCancelDialog is set invisible(i.e. setVisible(false) is called) on some browsers.
	// See ZmComposeView.prototype._popDownAlertAndSendMsg
	// Under the condition, a dialog by this zimlet cannot be shown and all buttons keeps their status disabled.
	// i.e. User cannot do anything after that.
	// To avoid that, this zimlet set the dialog visible as follows.
	if(AjxEnv.isNav && appCtxt.isChildWindow){
		appCtxt.getOkCancelMsgDialog().setVisible(true);
	}


	var errParams = {
			hasError:true,
			errorMsg: this.dialog_message + domain_list + non_registered_list,
			zimletName:this.zimletName
	};

	return boolAndErrorMsgArray.push(errParams);
};

jp_miraitsystems_addresscheck_HandlerObject.prototype.getEmails =
function(mail) {
	var emails = new Array();
	var _addr = new Array();
	_addr[0] = mail.getAddresses("TO").getArray();
	_addr[1] = mail.getAddresses("CC").getArray();
	_addr[2] = mail.getAddresses("BCC").getArray();
	for(var i = 0; i < 3; i++){
		for(var j = 0; j < _addr[i].length; j++){
			if(_addr[i][j].getAddress()){
				emails.push(_addr[i][j].getAddress());
			}
		}
	}
	return emails;
};

jp_miraitsystems_addresscheck_HandlerObject.prototype.getDomains =
function(emails) {
	var unique_domain = new Array();
	var hash = {};
	for(var i = 0; i < emails.length; i++){
		var domain = emails[i].match(/.*@(.*)/);
		if(domain && !(domain[1] in hash)){
			hash[domain[1]] = true;
			unique_domain.push(domain[1]);
		}
	}
	return unique_domain;
};

jp_miraitsystems_addresscheck_HandlerObject.prototype.checkAddressbook =
function(emails) {
	var non_registered_emails = new Array();
	for(var i = 0; i < emails.length; i++){
		var contact = this._contactList.getContactByEmail(emails[i]);
		if(!contact){
			non_registered_emails.push(emails[i]);
		}
	}		
	return non_registered_emails;
};


//see http://wiki.zimbra.com/wiki/Zimlet_cookbook_based_on_JavaScript_API#AddressBook

jp_miraitsystems_addresscheck_HandlerObject.prototype.getAllContacts =
function(mail) {
	var  postCallback = new AjxCallback(this, this._markFinish);
	this.loadAllContacts(postCallback);

};

jp_miraitsystems_addresscheck_HandlerObject.prototype.loadAllContacts = function(postCallback) {
	this.__oldNumContacts = 0;
	this._noOpLoopCnt = 0;
	this._totalWaitCnt = 0;

	if(this._contactsAreLoaded) {//2nd time onwards..
		if(postCallback) {
			postCallback.run(this);
			return;
		}
	}

	var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
	appCtxt.getAppController().setStatusMsg(this.scanning_message, ZmStatusView.LEVEL_INFO, null, transitions);
	this._contactsAreLoaded = false;
	this._waitForContactToLoadAndProcess(postCallback);
	this._contactsAreLoaded = true;
};

jp_miraitsystems_addresscheck_HandlerObject.prototype._waitForContactToLoadAndProcess = function(postCallback) {
	this._contactList = AjxDispatcher.run("GetContacts");
	if (!this._contactList)
		return;

	this.__currNumContacts = this._contactList.getArray().length;
	if (this._totalWaitCnt < 2 || this._noOpLoopCnt < 3) {//minimum 2 cycles post currentCnt==oldCnt
		if (this.__oldNumContacts == this.__currNumContact) {
			this._noOpLoopCnt++;
		}
		this._totalWaitCnt++;
		this.__oldNumContacts = this.__currNumContact;
		setTimeout(AjxCallback.simpleClosure(this._waitForContactToLoadAndProcess, this, postCallback), 5000);
	} else {//process..
		if(postCallback) {
			postCallback.run(this);
		}
	}
};

jp_miraitsystems_addresscheck_HandlerObject.prototype._markFinish =
function(){
	this._scanningAddressbookDone = true;
	var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
	appCtxt.getAppController().setStatusMsg(this.scanning_done_message, ZmStatusView.LEVEL_INFO, null, transitions);

};

