/*************************************************************************
 * 
 *  Weemo Video Chat Zimlet Version 4.0.867
 *  [2013] Weemo Inc.
 *  All Rights Reserved.
 *  
 *  Updated:  October 1, 2013
 * 
 *  NOTICE:
 *
 *  Weemo hereby grants permission to use, copy, modify, and distribute 
 *  this software and its documentation, with or without modification, 
 *  for any purpose and without fee or royalty provided that you include 
 *  the licenses notice included in the Weemo Video Driver download modal.
 *
 */

// You must obtain a Web Application Identifier (API Key) from Weemo and enter it here to activate the zimlet
var webAppId = "";

// You must enter your Zimbra domain name in this variable to activate this zimlet
var domainZimbraName = "";


weemo = null;
modal = null;
var sipOkNOk = false;
function com_weemo_email_handlerObject() {

    

    var script = document.createElement("SCRIPT");
    script.src = 'https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js';
    script.type = 'text/javascript';
    document.getElementsByTagName("head")[0].appendChild(script);

    // Poll for jQuery to come into existance
    var checkReady = function(callback) {
        if (window.jQuery) {
            callback(jQuery);
        }
        else {
            window.setTimeout(function() { checkReady(callback); }, 100);
        }
    };
    
    var isIpad = function() {
    	if( navigator.userAgent.match(/iPad/i)) return true;
    	else return false;
    };

    // Start polling...
    checkReady(function($) {
        if(webAppId != '' && domainZimbraName != ''){

        $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon ImgWeemoPanelItemIconNotConnected");
        var Modal = function(downloadUrl) {
        var self = this;

        this.options = {
            height : "210",
            width : "350",
            downloadUrl: downloadUrl,
            top: "center",
            left: "center"
        };

    var overlay= function() {
    var el = $('<div class="weemo_overlay"></div><div class="weemo_modal_box"></div>');
        $(el).appendTo('body');
    };

    var defaultStyles = function() {
        var winW = 0, winH = 0;
        if (document.body && document.body.offsetWidth) {
         winW = document.body.offsetWidth;
         winH = document.body.offsetHeight;
        }
        if (document.compatMode=='CSS1Compat' &&
            document.documentElement &&
            document.documentElement.offsetWidth ) {
         winW = document.documentElement.offsetWidth;
         winH = document.documentElement.offsetHeight;
        }
        if (window.innerWidth && window.innerHeight) {
         winW = window.innerWidth;
         winH = window.innerHeight;
        }

        var pageHeight = winH;
        var pageWidth = winW;

        if(self.options.top == "center") {
            self.options.top = (pageHeight / 2) - (self.options.height/2);
        }

        if(self.options.left == "center") {
            self.options.left = (pageWidth / 2) - (self.options.width/2);
        }

        $('.weemo_overlay').css({
            'position':'absolute',
            'top':'0',
            'left':'0',
            'background-color':'#EEEEEE',
            'height':pageHeight,
            'width':pageWidth,
            'z-index':'1049',
            'filter':'alpha(opacity = 50)',
            '-ms-filter':'alpha(opacity = 50)',
            'opacity': '0.5'
        });

        $('.weemo_modal_box').css({
            'background-clip': 'padding-box',
            'background-color': '#FFFFFF',
            'border-width': '1px',
            'border-color': '#8E8E8E #777777 #777777 #8E8E8E',
            'border-style': 'solid',
            'border-radius': '4px',
            'box-shadow': '5px 5px 25px grey',
            'outline': 'medium none',
            'z-index': '1050',
            'position':'absolute',
            'left':self.options.left,
            'top':self.options.top,
            'display':'none',
            'height': 'auto',
            'width': self.options.width + 'px'
        });
        $('.weemo_modal_header_title').css({
            'font-size' :'12px',
            'text-align':'left',
            'margin':'0',
            'padding': '5px 10px 7px'
        });
        $('.weemo_modal_header').css({
            'border-bottom': '1px solid #EEEEEE',
            'border-top-right-radius': '4px',
            'border-top-left-radius': '4px',
            'padding': '5px 10px;',
            'color': '#333333',
            'font-family': '\"Helvetica Neue\",Helvetica,Arial,sans-serif',
            'background':'#C5C5C5',
            'font-size':'14px'
        });
        $('.weemo_inner_modal_box').css({
            'padding': '15px',
            'position': 'relative',
            'background-color':'#F2F2F2',
            'color': '#333333',
            'font-family': '\"Helvetica Neue\",Helvetica,Arial,sans-serif',
            'font-size': '14px',
            'line-height': '20px',
            'text-align': 'left'
        });
        $('.weemo_inner_modal_box p').css({
            'font-size': '14px'
        });
        $('.weemo_download_button').css({
            'text-align':'center'
        });
        $('.weemo_download_button_link').css({
            '-moz-border-bottom-colors': 'none',
            '-moz-border-left-colors': 'none',
            '-moz-border-right-colors': 'none',
            '-moz-border-top-colors': 'none',
            'background-color': '#F5F5F5',
            'background-image': 'linear-gradient(to bottom, #FFFFFF, #E6E6E6)',
            'background-repeat': 'repeat-x',
            'border-color': 'rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.1) #B3B3B3',
            'border-image': 'none',
            'border-radius': '4px 4px 4px 4px',
            'border-style': 'solid',
            'border-width': '1px',
            'box-shadow': '0 1px 3px rgba(50, 50, 50, 0.75)',
            'color': '#333333',
            'cursor': 'pointer',
            'display': 'inline-block',
            'font-size': '14px',
            'line-height': '20px',
            'margin-bottom': '0',
            'padding': '4px 12px',
            'text-align': 'center',
            'text-shadow': '0 1px 1px rgba(255, 255, 255, 0.75)',
            'vertical-align': 'middle',
            'text-decoration': 'none'
        });
        $('.weemo_footer').css({
            'background-color': '#F5F5F5',
            'border-radius': '0 0 6px 6px',
            'border-top': '1px solid #DDDDDD',
            'box-shadow': '0 1px 0 #FFFFFF inset',
            'margin-bottom': '0',
            'padding': '14px 15px 30px',
            'text-align': 'center',
            'height':'15px'
        });
        $('.btnClose').css({
            'margin-left':'20px'
        });
    };

    var weemo_box = function() {
            var box = $('<div class="weemo_modal_header"><h3 class="weemo_modal_header_title">Video Driver Download</h3></div><div class="weemo_inner_modal_box"><p>Please click to download and install to enable Video Chat in Zimbra.</p><br/><div style="text-align:center;""><div class="weemo_download_button"><a class="weemo_download_button_link btnDownload" href="'+ self.options.downloadUrl+'" target="_blank">Download</a><a href="#" class="weemo_download_button_link btnClose">Cancel</a></div></div></div><div class="weemo_footer">This software contains open source libraries, a complete list of these and their associated licenses are available <a target="_blank" href="http://weemo.com/licenses">here</a>.</div>');
            $(box).appendTo('.weemo_modal_box');
            $('.weemo_modal_close, .btnClose').click(function(){
               $('.weemo_modal_box').fadeOut().remove();
                $('.weemo_overlay').fadeOut().remove();
            });
        };

        this.show = function() {
            overlay();
            weemo_box();
            defaultStyles();
            $('.weemo_modal_box').fadeIn(500);
        };

        this.close = function() {
            $('.weemo_modal_box').fadeOut().remove();
            $('.weemo_overlay').fadeOut().remove();
        };
    };
    
    var urlToWeemo = "https://download.weemo.com/js/webappid/"+webAppId;
    $.getScript(urlToWeemo, function() {
	    if(typeof(com_zimbra_email_handlerObject) !== "undefined"){
	        alert('In order to use the Weemo Video Chat Zimlet, the "Email" Zimlet must be disabled. Please contact your administrator.');
	    }
	    
	    var name = com_weemo_email_handlerObject.prototype.getUsername();
        var displayName = appCtxt.getActiveAccount().getDisplayName();
        while (name.length<6) {
            name += name;
        }
        
    	weemo = new Weemo(webAppId, name, 'internal', '', '0', displayName);
    	modal = new Modal();

        weemo.onConnectionHandler = function(message, code) {
        	switch(message) {
        	case 'connectedWeemoDriver':
            $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon ImgWeemoPanelItemIconProcess");
             if (jQuery.contains(document.documentElement, $('#ziBanner')[0])) {
                    $("#ziBanner").slideUp(750);
                }
        	    weemo.authenticate();
        	    break;
          	case 'sipOk':
              	sipOkNOk = true;
               
                $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon ImgWeemoPanelItemIconConnected");
                EmailTooltipZimlet.prototype.setContentDownloadPopUp();
                break;
            case 'sipNok':
            case 'diconnectedCloud':
            case 'verifiedUserNok':
            case 'unauthenticated':
            case 'disconnectedWeemoDriver':
            case 'error':
            case'kicked':
          		sipOkNOk = false;
                $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon ImgWeemoPanelItemIconNotConnected");
                EmailTooltipZimlet.prototype.setContentDownloadPopUp();
                break;
            case 'initializationIncomplete':
                var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
                appCtxt.getAppController().setStatusMsg("You need to be connected in order to perform this action", ZmStatusView.LEVEL_WARNING, null, transitions);
                break;
            case 'unsupportedOS':
                sipOkNOk = false;
                $(".ImgWeemoPanelItemIcon").closest("td").next(".DwtTreeItem-Text").css({'color':'#CCC'});
                $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon weemoUnactivated");
                EmailTooltipZimlet.prototype.singleClicked = function() {};
                break;
            case "weemoAuthApiError":
                if(jQuery.contains(document.documentElement, $('.weemo_overlay')[0]))   $(".weemo_overlay").remove();
                if(jQuery.contains(document.documentElement, $('.weemo_modal_box')[0])) $(".weemo_modal_box").remove();
                sipOkNOk = false;
                modal.show();
                EmailTooltipZimlet.prototype.setContentDownloadPopUp(true,code);
                EmailTooltipZimlet.prototype.singleClicked = function() {};
                break;
            case 'loggedasotherdevice':
            case 'loggedasotheruser':
                weemo.authenticate(1);
                break;
            }
        };

        weemo.onGetHandler = function(name, obj) {
          	switch(name) {
        		case 'status':
        	    	if(obj.value == 1){
        				$(".videoChatPeerButton").removeClass('cannotCall');
                        $(".weemoConnectedIcon").addClass('buttonConnectedVCard');	
        	    	} else if(obj.value == 0){
                        $(".videoChatPeerButton").removeAttr("onclick");
                        $(".weemoConnectedIcon").addClass('buttonNotConnectedVCard');
                    }
        	    break;
        	}
        };

        weemo.onWeemoDriverNotStarted = function(downloadUrl) {
        	sipOkNOk = false;
        	
        	if(jQuery.contains(document.documentElement, $('.weemo_overlay')[0]))	$(".weemo_overlay").remove();
        	if(jQuery.contains(document.documentElement, $('.weemo_modal_box')[0]))	$(".weemo_modal_box").remove();

            modal = new Modal(downloadUrl);
            modal.show();
            $(".btnDownload").click(function(){
                modal.close();
                $("body").prepend('<div id="ziBanner"><div class="bannerContent"><div id="divToCloseBanner" style="float:right;position: relative;right: -54px;border: 1px solid grey;border-radius: 4px;padding: 3px;cursor: pointer;margin-top: 24px;">X</div><p>1. Wait a few seconds for the Weemo Driver download to complete</p><p>2. Open the Weemo Driver Installer and follow the simple installation steps</p><div></div></div></div>');
                $("#ziBanner").slideDown(750);
                $("#divToCloseBanner").on("click", function(){
                     $("#ziBanner").slideUp(750);
                });
            });
        }; 

        if(!isIpad()) {
        	weemo.initialize();
        }

        $(".ZAppTab").on("click",function(){
            EmailTooltipZimlet.prototype.setIconZimletWeemo();
        });

        $("#logOff_title").on("click",function(){
            if(!isIpad()) {
                weemo.reset();
            }
        });

    });
} else {
    $(".ImgWeemoPanelItemIcon").closest("td").next(".DwtTreeItem-Text").css({'color':'#CCC'});
    $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon weemoUnactivated");
    alert("Weemo Video Zimlet is not activated");
}

});



	this.isPrimaryEmailTooltip = true;

	// support for showing address objects in the msg header as bubbles
	this._isBubble = {};
	this._bubbleClassName = "addrBubble";
	this._bubbleParams = {};
	this._internalId = Dwt.getNextId();
	DwtControl.ALL_BY_ID[this._internalId] = this;
}

com_weemo_email_handlerObject.prototype = new ZmZimletBase();
com_weemo_email_handlerObject.prototype.constructor = com_weemo_email_handlerObject;

var EmailTooltipZimlet = com_weemo_email_handlerObject;


// static content
EmailTooltipZimlet.IM_NEW_IM = "im new im";
EmailTooltipZimlet.IM_NEW_BUDDY = "im new buddy";
EmailTooltipZimlet.NEW_FILTER = "__new__";
EmailTooltipZimlet.MAILTO_RE = /^mailto:[\x27\x22]?([^@?&\x22\x27]+@[^@?&]+\.[^@?&\x22\x27]+)[\x27\x22]?/;
EmailTooltipZimlet.tooltipWidth = 280;
//EmailTooltipZimlet.tooltipHeight = 150;

EmailTooltipZimlet.prototype.init =
function() {

	if (appCtxt.get(ZmSetting.CONTACTS_ENABLED)) {
		AjxDispatcher.require(["ContactsCore", "Contacts"]);
		if (appCtxt.get(ZmSetting.IM_ENABLED)) {
			this._presenceCache = [];
		}
	}
	this._prefDialog = new EmailToolTipPrefDialog(this);

	this._subscriberZimlets = [];
    this._presenceProvider = null; // For the subscriber zimlet that can provide presence info. Only one presence provider
	this._preLoadImgs();
	this._convModeCount = 0;
    this._presenceCache = []; // Cache for holding presence information
   
        
       

};

com_weemo_email_handlerObject.prototype.doDrop =
function(obj) {
    if(obj.length){
        var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
        appCtxt.getAppController().setStatusMsg("Please drag and drop only one contact on the Weemo Zimlet", ZmStatusView.LEVEL_WARNING, null, transitions);
    } else {
        var type = obj.TYPE;
        if (type != null) {
            switch(type) {
            case "ZmContact":
                    var contact = obj;
                    var email = contact.email;
                    var fn = contact.firstName;
                    var ln = contact.lastName;
                    var displayNameToCall = fn+" "+ln;
                    var jsonObj, request, soapDoc;
                if(contact.email.split('@')[1] == domainZimbraName){
                    jsonObj = {GetAccountInfoRequest:{_jsns:"urn:zimbraAccount"}};
                    request = jsonObj.GetAccountInfoRequest;
                    request.name = email;
                    request.type = "account";
                    request.account = {_content: email, by: "name"};
                    request.offset = 0;
                    request.limit = 3;
                    var callback = new AjxCallback(this, this._handleSOAPResponseJSONToDragAndDrop(displayNameToCall));
                    appCtxt.getAppController().sendRequest({jsonObj:jsonObj,asyncMode:true,callback:callback, noBusyOverlay:true});
                } else {             
                    var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
                    appCtxt.getAppController().setStatusMsg("Sorry, you can not call this contact", ZmStatusView.LEVEL_WARNING, null, transitions);
                }
                break;
             case "ZmConv":
             case "ZmMailMsg":
             case "ZmAppt":
             case "ZmTask":
             case "ZmBriefcaseItem":
             var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
            appCtxt.getAppController().setStatusMsg("Sorry, you can only drag and drop only contact on the Weemo Zimlet", ZmStatusView.LEVEL_WARNING, null, transitions);
                /*var msg = obj.srcObj;
                var fromAddresses = msg.getAddresses(AjxEmailAddress.FROM); 
                if (fromAddresses) {
                    EmailTooltipZimlet.prototype.getListAddresses(fromAddresses);
                }
                var toAddresses = msg.getAddresses(AjxEmailAddress.TO);
                 if (toAddresses) {
                    EmailTooltipZimlet.prototype.getListAddresses(toAddresses);
                }
                var ccAddresses = msg.getAddresses(AjxEmailAddress.CC);
                 if (ccAddresses) {
                    EmailTooltipZimlet.prototype.getListAddresses(ccAddresses);
                }*/
                break;
            }
        }
    }
};

EmailTooltipZimlet.prototype._handleSOAPResponseJSONToDragAndDrop =
function(displayNameToCall) {
return function(result){
        if (result.isException()) {
        // do something with exception
        var exception = result.getException();      
        return;
    }
    // do something with response (in JSON format)
    var response = result.getResponse().GetAccountInfoResponse;
     EmailTooltipZimlet.prototype.callWeemo(response.name ,"internal",displayNameToCall);
    }
};
/**
 * This method is called when the panel item is double-clicked.
 *
 */
EmailTooltipZimlet.prototype.doubleClicked =
function() {
	this.singleClicked();
};

/**
 * This method is called when the panel item is single-clicked.
 *
 */
EmailTooltipZimlet.prototype.singleClicked =
function() {
		modal.show();
		EmailTooltipZimlet.prototype.setContentDownloadPopUp();
};

EmailTooltipZimlet.prototype._getRoster =
function() {
	if (!this._roster && appCtxt.get(ZmSetting.IM_ENABLED) &&
		!(!appCtxt.get(ZmSetting.IM_PREF_AUTO_LOGIN) &&
		  !appCtxt.getApp(ZmApp.IM).hasRoster())) // If not AUTO_LOGIN enabled, don't LOGIN
	{
		this._roster = AjxDispatcher.run("GetRoster");
		var list = this._roster.getRosterItemList();
		list.addChangeListener(new AjxListener(this, this._rosterChangeListener));
	}
	return this._roster;
};

EmailTooltipZimlet.prototype._rosterChangeListener =
function(ev) {
	if (ev.event != ZmEvent.E_MODIFY) { return; }

	var fields = ev.getDetail("fields");
	var doPresence = ZmRosterItem.F_PRESENCE in fields;
	if (doPresence) {
		var buddies = ev.getItems();
		var hash = {};
		for (var i = buddies.length; --i >= 0;) {
			var b = buddies[i];
			hash[b.getAddress()] = b;
		}
		var cache = this._presenceCache;
		for (var i = cache.length; --i >= 0;) {
			var el = cache[i];
			var b = hash[el.im_addr];
			if (b) {
				// try to update presence state
				var img = document.getElementById(el.img_id);
				if (img && b.getPresence().getShow() == ZmRosterPresence.SHOW_ONLINE) {
					AjxImg.setImage(img, b.getPresence().getIcon(true), true);
				} else {
					// no longer visible, remove from cache?
					// cache.splice(i, 1);
					// better not: will fail if we collapse/expand headers
				}
			}
		}
	}
};

EmailTooltipZimlet.prototype.onConvStart =
function() {
    if (this._convModeCount == 0) {
        this._clearBubbles();
    }
    this._convModeCount++;
};

EmailTooltipZimlet.prototype.onConvEnd =
function() {
    this._convModeCount--;
};

EmailTooltipZimlet.prototype.onFindMsgObjects =
function() {
    if (this._convModeCount == 0) {
        this._clearBubbles();
    }
};



EmailTooltipZimlet.prototype._clearBubbles =
function() {
    DBG.println(AjxDebug.DBG3, "EmailTooltipZimlet._clearBubbles");
    if (appCtxt.get(ZmSetting.USE_ADDR_BUBBLES)) {
		// TODO: dispose old bubbles
		this._bubbleList = new ZmAddressBubbleList();
		this._bubbleList.addSelectionListener(new AjxListener(this, this._bubbleSelectionListener));
		this._bubbleList.addActionListener(new AjxListener(this, this._bubbleActionListener));
		this._bubbleParams = {};
	}
}

// create bubble for address in header
EmailTooltipZimlet.prototype.generateSpan =
function(html, idx, obj, spanId, context, options) {
    DBG.println(AjxDebug.DBG3, "EmailTooltipZimlet.generateSpan");
	options = options || {};
	if (options.addrBubbles) {
		this._isBubble[spanId] = true;
		var canExpand = obj.isGroup && obj.canExpand && appCtxt.get("EXPAND_DL_ENABLED");
		if (canExpand && !this._aclv) {
			// create a ZmAutocompleteListView to handle DL expansion; it's never shown
			var aclvParams = {
				dataClass:		appCtxt.getAutocompleter(),
				matchValue:		ZmAutocomplete.AC_VALUE_FULL,
				options:		{addrBubbles:true, massDLComplete:true},
				selectionCallback:	this._dlAddrSelected.bind(this),
				contextId:		this.name
			};
			this._aclv = new ZmAutocompleteListView(aclvParams);
		}

		// We'll be creating controls (bubbles) later, so we provide the tooltip now and let the control manage
		// it instead of the zimlet framework.
		var bubbleParams = {
			parent:		appCtxt.getShell(),
			parentId:	this._internalId,
			addrObj:	obj,
			id:			spanId,
			canExpand:	canExpand,
			email:		this._getAddress(obj),
			separator:	AjxEmailAddress.SEPARATOR
		};
		ZmAddressInputField.BUBBLE_OBJ_ID[spanId] = this._internalId;	// pretend to be a ZmAddressInputField
		this._bubbleParams[spanId] = bubbleParams;
        DBG.println(AjxDebug.DBG3, "  create span = " + spanId + ", email = " + bubbleParams.email);

		// placeholder SPAN
		html[idx++] = "<span id='" + spanId + "'>";
		html[idx++] = "</span>";
		return idx;
	} else {
		return ZmObjectHandler.prototype.generateSpan.apply(this, arguments);
	}
};

EmailTooltipZimlet.prototype.onMsgView =
function() {
	this._createBubbles();
};

// Called from conversation view - used there instead of onMsgView because onMsgView is a
// commonly implemented call whose use would invoke numerous Zimlets that are inappropriate
// for a conversation view.
EmailTooltipZimlet.prototype.onConvView =
function() {
	this._createBubbles();
};

EmailTooltipZimlet.prototype._createBubbles =
function() {
	DBG.println(AjxDebug.DBG3, "EmailTooltipZimlet._createBubble");
	for (var id in this._bubbleParams) {
		// make sure SPAN was actually added to DOM (may have been ignored by template, for example)
		if (!document.getElementById(id)) {
			continue;
		}
		var bubbleParams = this._bubbleParams[id];
		var bubble = new ZmAddressBubble(bubbleParams);
		bubble.replaceElement(id);
		if (this._bubbleList) {
			this._bubbleList.add(bubble);
		}
		DBG.println(AjxDebug.DBG3, "  span = " + id + ", email = " + bubbleParams.email);
	}
}

EmailTooltipZimlet.prototype._bubbleSelectionListener =
function(ev) {

	var bubble = ev.item;
	if (bubble && ev.detail === DwtEvent.ONDBLCLICK) {
		this._composeListener(ev, bubble.address);
	}
};

EmailTooltipZimlet.prototype._bubbleActionListener =
function(ev) {

	var bubble = ev.item;
	var menu = this.getActionMenu(bubble.addrObj);
	if (menu) {
		this._actionBubble = bubble;
		menu.popup(0, ev.docX, ev.docY);
	}
};

EmailTooltipZimlet.prototype._menuPopdownListener =
function() {

	if (!appCtxt.get(ZmSetting.USE_ADDR_BUBBLES)) { return; }
	
	if (this._actionBubble) {
		this._actionBubble.setClassName(this._bubbleClassName);
	}
	
	// use a timer since popdown happens before listeners are called; alternatively, we could put the
	// code below at the end of every menu action listener
	AjxTimedAction.scheduleAction(new AjxTimedAction(this,
		function() {
			this._actionBubble = null;
			if (this._bubbleList) {
				this._bubbleList.clearRightSelection();
			}
		}), 10);
};

EmailTooltipZimlet.prototype.getClassName =
function(obj, context, spanId) {
    return (this._isBubble[spanId]) ? this._bubbleClassName :
				   					  ZmObjectHandler.prototype.getClassName.apply(this, arguments);
};

EmailTooltipZimlet.prototype.getHoveredClassName =
function(obj, context, spanId) {
	return (this._isBubble[spanId]) ? this._bubbleClassName :
				   					  ZmObjectHandler.prototype.getHoveredClassName.apply(this, arguments);
};

EmailTooltipZimlet.prototype.getActiveClassName =
function(obj, context, spanId) {
	return (this._isBubble[spanId]) ? this._bubbleClassName :
				   					  ZmObjectHandler.prototype.getActiveClassName.apply(this, arguments);
};

EmailTooltipZimlet.prototype._getHtmlContent =
function(html, idx, obj, context, spanId, options) {
	if (obj instanceof AjxEmailAddress) {
		var context = window.parentAppCtxt || window.appCtxt;
		var contactsApp = context.getApp(ZmApp.CONTACTS);
		var contact = contactsApp && contactsApp.getContactByEmail(obj.address); // contact in cache?
		var buddy = this._getBuddy(contact, obj.address);
		if (contactsApp && !contact && contact !== null) {
			// search for contact
			var respCallback = new AjxCallback(this, this._handleResponseGetContact, [html, idx, obj, spanId, options]);
			contactsApp.getContactByEmail(obj.address, respCallback);
		}
		// return content for what we have now (may get updated after search)
		return this._updateHtmlContent(html, idx, obj, contact, buddy, spanId, options);
	} else {
		html[idx++] = AjxStringUtil.htmlEncode(obj);
		return idx;
	}
};

/**
 * Returns content for this object's <span> element based on a contact and/or buddy.
 * If given a spanId, it will instead replace the content of the <span>, for example,
 * with the results of a search.
 */
EmailTooltipZimlet.prototype._updateHtmlContent =
function(html, idx, obj, contact, buddy, spanId, options) {

	var content;
	var pres = buddy && buddy.getPresence();
	if (pres && pres.getShow() == ZmRosterPresence.SHOW_ONLINE) {
		var pres_id = Dwt.getNextId();

		content = [
			AjxStringUtil.htmlEncode(buddy.getDisplayName()),
			AjxImg.getImageHtml(pres.getIcon(true), "display:inline; padding-left:13px", "id=" + pres_id)
		].join("");

		var params = {
			contact : contact,
			buddy   : buddy,
			im_addr : buddy.getAddress(),
			img_id  : pres_id
		};
		this._presenceCache.push(params);

		if (this._presenceCache.length > 50) {
			// 50 should be enough.. maybe should be even smaller?
			this._presenceCache.splice(0, 1);
		}

		this._getRoster();
	} else {
		content = AjxStringUtil.htmlEncode(obj.toString(options && options.shortAddress));
	}

	var span = spanId && document.getElementById(spanId);
	if (span) {
		span.innerHTML = content;
	} else {
		html[idx++] = content;
		return idx;
	}
};

EmailTooltipZimlet.prototype._handleResponseGetContact =
function(html, idx, obj, spanId, options, contact) {
	if (contact) {
		var buddy = this._getBuddy(contact, obj.address);
		this._updateHtmlContent(html, idx, obj, contact, buddy, spanId, options);
	}
};

EmailTooltipZimlet.prototype._getBuddy =
function(contact, address) {

	if (appCtxt.isChildWindow) { return; }

	var buddy;
	if (appCtxt.get(ZmSetting.IM_ENABLED) && !(!appCtxt.get(ZmSetting.IM_PREF_AUTO_LOGIN) &&
		!appCtxt.getApp(ZmApp.IM).hasRoster())) {	// If not AUTO_LOGIN enabled, don't LOGIN

		buddy = contact && contact.getBuddy();
		if (!buddy) {
			buddy = AjxDispatcher.run("GetRoster").getRosterItem(address);
		}
	}
	return buddy;
};

EmailTooltipZimlet.prototype.hoverOut =
function(object, context, span, spanId) {
	if(!this.tooltip) {	return;	}
	if (spanId && this._bubbleParams[spanId]) {
        return;
    }

	this._hoverOver =  false;
	this.tooltip._poppedUp = false;//makes the tooltip sticky
	setTimeout(AjxCallback.simpleClosure(this.popDownIfMouseNotOnSlide, this), 700);
	//override to ignore hoverout. 
};

EmailTooltipZimlet.prototype.popDownIfMouseNotOnSlide =
function() {
	if(this._hoverOver) {
		return;
	} else if(this.slideShow && this.slideShow.isMouseOverTooltip) {
		return;
	} else if(this.tooltip) {
		this.tooltip._poppedUp = true;//makes the tooltip non-sticky
		this.tooltip.popdown();
	}
};

EmailTooltipZimlet.prototype.popdown =
function() {
	this._hoverOver =  false;
	
	if(this.tooltip) {
		this.tooltip._poppedUp = true;
		this.tooltip.popdown();
	}
};

EmailTooltipZimlet.prototype.addSubscriberZimlet =
function(subscriberZimlet, isPrimary, cbObject) {
    //debugger;
	this._subscriberZimlets.push(subscriberZimlet);	
	if(isPrimary) {
		this.primarySubscriberZimlet = subscriberZimlet;
	}

    // Presence provider set up - only one presence provider assumed

    if (cbObject && cbObject.presenceCallback && !this._presenceProvider){
        this._presenceProvider = cbObject.presenceCallback;
    }
};

// This is called by the zimlet framework.
EmailTooltipZimlet.prototype.hoverOver =
function(object, context, x, y, span) {
	var shell = DwtShell.getShell(window);
	var tooltip = shell.getToolTip();
	tooltip.setContent('<div id="zimletTooltipDiv"/>', true);
	this.x = x;
	this.y = y;
	if (!this.toolTipPoppedUp(span, object, context, document.getElementById("zimletTooltipDiv"))) {
		tooltip.popup(x, y, true, new AjxCallback(this, this.hoverOut, object, context, span));
	}
};

EmailTooltipZimlet.prototype.toolTipPoppedUp =
function(spanElement, contentObjText, matchContext, canvas) {
	var tooltip = appCtxt.getToolTipMgr().getToolTip(ZmToolTipMgr.PERSON, {address:contentObjText});
	if (tooltip) {
		// for some reason canvas is not the live element, need to fetch it from DOM here
		var tooltipDiv = document.getElementById("zimletTooltipDiv");
		if (tooltipDiv) {
			tooltipDiv.innerHTML = tooltip;
		}
		return false;
	}
	return true;
};

// This is called from the core tooltip manager.
EmailTooltipZimlet.prototype.onHoverOverEmailInList =
function(object, ev, noRightClick) {
	if (!object || !object.address) {
		return false;
	}
	var x = ev ? ev.docX : this.x;
	var y = ev ? ev.docY : this.y;
	this.noRightClick = noRightClick;
	return this.handleHover(object, null, x, y);
};

// return true if we have handled the hover
EmailTooltipZimlet.prototype.handleHover =
function(object, context, x, y, span, spanId) {
EmailTooltipZimlet.prototype.getStatusWeemo(object.address);
	if (spanId && this._bubbleParams[spanId]) { return false; }

	this._hoverOver = true;
	this._initializeProps(object, context, x, y, span);
	appCtxt.notifyZimlets("onEmailHoverOver", [this], {waitUntilLoaded:true});
	if (this.primarySubscriberZimlet) {
		this.primarySubscriberZimlet.showTooltip();
		return true;
	}

    this._unknownPersonSlide = new UnknownPersonSlide();
    this._unknownPersonSlide.onEmailHoverOver(this);
    this._unknownPersonSlide.showTooltip();
    return true;
};

EmailTooltipZimlet.prototype._initializeProps =
function(object, context, x, y, span) {
	if (!this.seriesAnimation) {
		this.seriesAnimation = new SeriesAnimation();
	}
	this.seriesAnimation.reset();
	var shell = DwtShell.getShell(window);
	var tooltip = shell.getToolTip();
	tooltip.setContent("<div id=\"zimletTooltipDiv\"></div>", true);
	this.x = x;
	this.y = y;
	this.tooltip = tooltip;
	//this is used by mail/conv list
    Dwt.setHandler(tooltip._div, DwtEvent.ONMOUSEOUT, AjxCallback.simpleClosure(this.hoverOut, this));

	var addr = (object instanceof AjxEmailAddress) ? object.address : object;
	var isMailTo = this.isMailToLink(addr);
	if (isMailTo) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}
	this.emailAddress = addr;
	this.fullName = (object instanceof AjxEmailAddress) ? object.name : "";
	this.canvas =   document.getElementById("zimletTooltipDiv");
	this.slideShow = new EmailToolTipSlideShow(this, this.canvas);
	this.contextMenu = this.getActionMenu(object, span, context, false);

};

EmailTooltipZimlet.prototype._preLoadImgs =
function() {
	this._busyImg = new Image();
	this._busyImg.src = this.getResource("img/EmailZimlet_busy.gif");
	this._unknownPersonImg = new Image();
	this._unknownPersonImg.src = this.getResource("img/UnknownPerson_dataNotFound.jpg");
};
EmailTooltipZimlet.prototype.showBusyImg =
function(timeoutCallback, xOffset, yOffset) {
	var top = yOffset ? this.y + yOffset : this.y;
	var left = xOffset ? this.x + xOffset : this.x;

	this._busyImg.style.top = top;
	this._busyImg.style.left = left;
	this._busyImg.style.display = "block";
	this._busyImg.style.position = "absolute";
	this._busyImg.style.zIndex = "500";
	this._busyImgTimer = setTimeout(AjxCallback.simpleClosure(this._handleNoImg, this, timeoutCallback), 4000);//hide busyImg after 4 secs
};

EmailTooltipZimlet.prototype.showLoadingAtId =
function(timeoutCallback, id) {
	var div = document.getElementById(id);
	div.innerHTML = ["<br/><br/><label style='color:gray'>", ZmMsg.loading, "</label>"].join("");
	this._busyImgTimer = setTimeout(AjxCallback.simpleClosure(this._handleNoImgAtId, this, timeoutCallback, id), 4000);//hide busyImg after 4 secs
};

EmailTooltipZimlet.prototype._handleNoImgAtId =
function(timeoutCallback, id) {
	clearTimeout(this._busyImgTimer);
	if (timeoutCallback) {
		timeoutCallback.run();
	}
};


EmailTooltipZimlet.prototype._handleNoImg =
function(timeoutCallback) {
	clearTimeout(this._busyImgTimer);
	this._busyImg.style.zIndex = "100";
	this._busyImg.style.display = "none";
	if (timeoutCallback) {
		timeoutCallback.run();
	}
};

EmailTooltipZimlet.prototype.hideBusyImg =
function() {
	clearTimeout(this._busyImgTimer);
	this._busyImg.style.zIndex = "100";
	this._busyImg.style.display = "none";
};



EmailTooltipZimlet.prototype.createFilterMenu =
function(actionMenu) {
	if (this._filterMenu) { return; }

	this._newFilterMenuItem = actionMenu.getOp("ADDTOFILTER");
	this._filterMenu = new ZmPopupMenu(actionMenu);
	this._newFilterMenuItem.setMenu(this._filterMenu);

	this._rules = AjxDispatcher.run("GetFilterRules");
	this._rules.addChangeListener(new AjxListener(this, this._rulesChangeListener));
	this._resetFilterMenu();
};

EmailTooltipZimlet.prototype.createSearchMenu =
function(actionMenu) {
	if (this._searchMenu) { return; }

    var list = [ZmOperation.SEARCH, ZmOperation.SEARCH_TO];
    var overrides = {};
    overrides[ZmOperation.SEARCH] = {textKey:"findEmailFromRecipient"};
    overrides[ZmOperation.SEARCH_TO] = {textKey:"findEmailToRecipient"};

    this._searchMenu = new ZmActionMenu({parent:actionMenu, menuItems:list, overrides:overrides});
    var searchOp = actionMenu.getOp("SEARCHEMAILS");
    searchOp.setMenu(this._searchMenu);
};

EmailTooltipZimlet.prototype._resetFilterMenu =
function() {
	var filterItems = this._filterMenu.getItems();
	while (filterItems.length > 0) {
		this._filterMenu.removeChild(filterItems[0]);
	}
	this._rules.loadRules(false, new AjxCallback(this, this._populateFiltersMenu));
};

EmailTooltipZimlet.prototype._populateFiltersMenu =
function(results){
	var filters = results.getResponse();
	var menu = this._filterMenu;

	var miNew = new DwtMenuItem({parent:menu});
	miNew.setText(this.getMessage("newFilter"));
	miNew.setImage("Plus");
	miNew.setData(Dwt.KEY_OBJECT, EmailTooltipZimlet.NEW_FILTER);
	miNew.addSelectionListener(new AjxListener(this, this._filterItemSelectionListener));

	if (filters.size()) {
		menu.createSeparator();
	}

	for (var i = 0; i < filters.size(); i++) {
		this._addFilter(menu, filters.get(i));
	}
};

EmailTooltipZimlet.prototype._rulesChangeListener =
function(ev){
	if (ev.type != ZmEvent.S_FILTER) { return; }

	if (!ev.handled) {
		this._resetFilterMenu();
		ev.handled = true;
	}
};

EmailTooltipZimlet.prototype._filterItemSelectionListener =
function(ev){
	var filterMenuItem = ev.item;
	var editMode = true;

	var rule = filterMenuItem.getData(Dwt.KEY_OBJECT);

	if (rule == EmailTooltipZimlet.NEW_FILTER) {
		editMode = false;
		rule = new ZmFilterRule();
		rule.addAction(ZmFilterRule.A_KEEP);
	}
	else {
		rule = this._rules.getRuleByName(rule.name) || rule;
	}

	var addr = this._getAddress(this._actionObject);
	if (AjxUtil.isString(addr) && this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}
	var subjMod = ZmFilterRule.C_ADDRESS_VALUE[ZmFilterRule.C_FROM];
	rule.addCondition(ZmFilterRule.TEST_ADDRESS, ZmFilterRule.OP_IS, addr, subjMod);

	appCtxt.getFilterRuleDialog().popup(rule, editMode);
};

EmailTooltipZimlet.prototype._addFilter =
function(menu, rule, index) {
	var mi = new DwtMenuItem({parent:menu, index:index});
	mi.setText(AjxStringUtil.clipByLength(rule.name, 20));
	mi.setData(Dwt.KEY_OBJECT, rule);
	mi.addSelectionListener(new AjxListener(this, this._filterItemSelectionListener));
};

EmailTooltipZimlet.prototype.getActionMenu =
function(obj, span, context) {
	// call base class first to get the action menu
	var actionMenu = ZmZimletBase.prototype.getActionMenu.call(this, obj, span, context);
	var isDetachWindow = appCtxt.isChildWindow;

	if (!isDetachWindow && appCtxt.get(ZmSetting.FILTERS_ENABLED) && actionMenu.getOp("ADDTOFILTER") ) {
		this.createFilterMenu(actionMenu);
	}

    if (!isDetachWindow && appCtxt.get(ZmSetting.SEARCH_ENABLED) && actionMenu.getOp("SEARCHEMAILS")) {
        this.createSearchMenu(actionMenu);
	}
	var addr = this._getAddress(obj);
	if (this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}

	if (!(appCtxt.get(ZmSetting.CONTACTS_ENABLED) || appCtxt.isOffline)) {
		// make sure to remove adding new contact menu item if contacts are disabled
		if (actionMenu.getOp("NEWCONTACT")) {
			actionMenu.removeOp("NEWCONTACT");
		}
	}

	var imItem = actionMenu.getOp("NEWIM");
	if (imItem) {
		if (isDetachWindow || !appCtxt.get(ZmSetting.IM_ENABLED)) {
			actionMenu.removeOp("NEWIM");
		} else {
			var addrObj = obj instanceof AjxEmailAddress ? obj : new AjxEmailAddress(obj);
			ZmImApp.updateImMenuItemByAddress(imItem, addrObj);
		}
	}

	if (actionMenu.getOp("SEARCHEMAILS") && (isDetachWindow || !appCtxt.get(ZmSetting.SEARCH_ENABLED))) {
		ZmOperation.removeOperation(actionMenu, "SEARCHEMAILS", actionMenu._menuItems);
	}
    else{
        if (obj && obj.type) {
            if (actionMenu.getOp("SEARCHEMAILS")){
                 if (obj.type == "FROM"){
                    ZmOperation.setOperation(this._searchMenu, ZmOperation.SEARCH, ZmOperation.SEARCH, ZmMsg.findEmailFromSender);
                    ZmOperation.setOperation(this._searchMenu, ZmOperation.SEARCH_TO, ZmOperation.SEARCH_TO, ZmMsg.findEmailToSender);
                 } else{
                    ZmOperation.setOperation(this._searchMenu, ZmOperation.SEARCH, ZmOperation.SEARCH, ZmMsg.findEmailFromRecipient);
                    ZmOperation.setOperation(this._searchMenu, ZmOperation.SEARCH_TO, ZmOperation.SEARCH_TO, ZmMsg.findEmailToRecipient);
                 }
                 this._searchMenu.addSelectionListener("SEARCH", new AjxListener(this, this.menuItemSelected,["SEARCH",obj]));
                 this._searchMenu.addSelectionListener("SEARCH_TO", new AjxListener(this, this.menuItemSelected,["SEARCH_TO", obj]));
            }
        }
    }

	if (actionMenu.getOp("ADDTOFILTER") && (isDetachWindow || !appCtxt.get(ZmSetting.FILTERS_ENABLED))) {
		ZmOperation.removeOperation(actionMenu, "ADDTOFILTER", actionMenu._menuItems);
	}

	var contactsApp = appCtxt.getApp(ZmApp.CONTACTS);
	var contact = contactsApp && contactsApp.getContactByEmail(addr);
	var newContactAction = actionMenu.getOp("NEWCONTACT");
	if (newContactAction) {
		newContactAction.setVisible(true);
	}
	if (contact) {
		// contact for this address was found in the cache
		if (contact.isDistributionList() && newContactAction) {
			//do not allow editing a DL in this way (if user is owner, they can edit via the DL folder/toolbar)
			// And most likley this is a regular user that is not the owner anyway. So let's keep it simple
			newContactAction.setVisible(false);
		}
		ZmOperation.setOperation(actionMenu, "NEWCONTACT", ZmOperation.EDIT_CONTACT);
	} else {
		// contact not found, do a search
		if (contactsApp && !contact && contact !== null) {
            if (actionMenu.getOp("NEWCONTACT")) {
			    actionMenu.getOp("NEWCONTACT").setText(ZmMsg.loading);
            }
			var respCallback = new AjxCallback(this, this._handleResponseGetContact1, [actionMenu]);
			contactsApp.getContactByEmail(addr, respCallback);
		} else {
			ZmOperation.setOperation(actionMenu, "NEWCONTACT", ZmOperation.NEW_CONTACT, ZmMsg.AB_ADD_CONTACT);
		}
	}
	
	if (!actionMenu.isListenerRegistered(DwtEvent.POPDOWN)) {
		actionMenu.addPopdownListener(new AjxListener(this, this._menuPopdownListener));
	}
	
	return actionMenu;
};

EmailTooltipZimlet.prototype._handleResponseGetContact1 =
function(actionMenu, contact) {
	var newOp = contact ? ZmOperation.EDIT_CONTACT : ZmOperation.NEW_CONTACT;
	var newText = contact ? null : ZmMsg.AB_ADD_CONTACT;
	ZmOperation.setOperation(actionMenu, "NEWCONTACT", newOp, newText);
};

EmailTooltipZimlet.prototype.isMailToLink =
function (str){
	return (!!(str.search(/mailto/i) != -1));
};

EmailTooltipZimlet.prototype.parseMailToLink =
function(str){
	var parts = {};
	var match = str.match(/\bsubject=([^&]+)/i);
	parts.subject = match ? decodeURIComponent(match[1]) : null;

	match = str.match(/\bto\:([^&]+)/);
	if (!match) {
		match = str.match(/\bmailto\:([^\?]+)/i);
	}
	parts.to = match ? decodeURIComponent(match[1]) : null;

	match = str.match(/\bbody=([^&]+)/i);
	parts.body = match ? decodeURIComponent(match[1]) : null;

	return parts;
};

EmailTooltipZimlet.prototype.clicked =
function(spanElement, contentObjText, matchContext, ev) {

	var spanId = spanElement && spanElement.id;
	if (spanId && this._bubbleParams[spanId]) { return; }

	if (this.tooltip) {
		this.tooltip.popdown();
	}

	this._actionObject = contentObjText;
	this._composeListener(ev, this._getAddress(contentObjText));
};

EmailTooltipZimlet.prototype.menuItemSelected =
function(itemId, item, ev) {
	switch (itemId) {
		case "SEARCH":			this._searchListener();		break;
        case "SEARCH_TO":        this._searchToListener();   break;
		case "SEARCHBUILDER":	this._browseListener();		break;
		case "NEWEMAIL":		this._composeListener(ev);	break;
		case "VIDEOCHAT":		this._videoChatMenuAction();	break;
		case "JOINCONFERENCECHAT":		this._joinVideoChatMenuAction();	break;
		case "CREATECONFERENCECHAT":	this._createVideoChatMenuAction();	break;
		case "NEWIM":			this._newImListener(ev);	break;
		case "NEWCONTACT":		this._contactListener(true);	break;
		case "ADDTOFILTER":		this._filterListener();		break;
		case "GOTOURL":			this._goToUrlListener();	break;
        case "HOSTCONF":         EmailTooltipZimlet.prototype.callWeemo("","host",""); break;
        case "SETTINGS":         EmailTooltipZimlet.prototype.singleClicked();
	}
};

EmailTooltipZimlet.prototype._getYahooHint =
function() {
	var html = [];
	var idx = 0;
	html[idx++] = "<center><table border=0><tr><td valign=top><div class='ImgWebSearch'></div></td><td>";
	html[idx++] = ZmMsg.leftClickYahoohint;
	html[idx++] = "<div class='TooltipHint'>";
	html[idx++] = ZmMsg.rightClickHint;
	html[idx++] = "</div></td></tr></table></center>";
	return html.join("");
};

EmailTooltipZimlet.prototype._getAddress =
function(obj) {
	return obj.isAjxEmailAddress ? obj.address : obj;
};

EmailTooltipZimlet.prototype._contactListener =
function(isDirty) {
	this.popdown();
	var loadCallback = new AjxCallback(this, this._handleLoadContact, [isDirty]);
	AjxDispatcher.require(["ContactsCore", "Contacts"], false, loadCallback, null, true);
};

EmailTooltipZimlet.prototype._newImListener =
function(ev) {
	ZmImApp.getImMenuItemListener().handleEvent(ev);
};

EmailTooltipZimlet.prototype._getActionedContact =
function(create) {
	// actionObject can be a ZmContact, a String, or a generic Object (phew!)
	var contact;
	var addr = this._actionObject;
	if (this._actionObject) {
		if (this._actionObject.toString() == "ZmContact") {
			contact = this._actionObject;
		} else if (AjxUtil.isString(this._actionObject)) {
			addr = this._getAddress(this._actionObject);
			if (this.isMailToLink(addr)) {
				addr = (this.parseMailToLink(addr)).to || addr;
			}
			contact = AjxDispatcher.run("GetContacts").getContactByEmail(addr);
		} else {
			contact = AjxDispatcher.run("GetContacts").getContactByEmail(this._actionObject.address);
		}
	}
	if (contact == null && create) {
		contact = new ZmContact(null);
		contact.initFromEmail(addr);
	}
	return contact;
};

EmailTooltipZimlet.prototype._handleLoadContact =
function(isDirty) {
	var contact = this._getActionedContact(true);

	if (window.parentAppCtxt) {
		var capp = window.parentAppCtxt.getApp(ZmApp.CONTACTS);
		capp.getContactController().show(contact, isDirty);
	} else {
		AjxDispatcher.run("GetContactController").show(contact, isDirty);
	}
};

EmailTooltipZimlet.prototype._createVideoChatMenuAction=
function(){
	weemo.createCall(com_weemo_email_handlerObject.prototype.getUsername(),'host',weemo.getDisplayName());
};

EmailTooltipZimlet.prototype._joinVideoChatMenuAction =
function(addr){
	/*var obj = this._actionObject;
	addr = addr ? this._getAddress(addr) : (obj ? this._getAddress(obj) : "");

	var currentEmail = com_weemo_email_handlerObject.prototype.getUsername();

	if(currentEmail == addr){
		var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
		appCtxt.getAppController().setStatusMsg("You cannot call yourself", ZmStatusView.LEVEL_WARNING, null, transitions);
		return false;
	}

	nameToCall = addr.toLowerCase().split('@')[0];
	if(addr.split('@')[1] == domainZimbraName){
		weemo.createCall(nameToCall,'attendee',nameToCall);
	}else{
		var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
		appCtxt.getAppController().setStatusMsg("This contact is not a Zimbra member. You cannot make this call", ZmStatusView.LEVEL_WARNING, null, transitions);
	}*/
};

EmailTooltipZimlet.prototype._videoChatMenuAction =
function(addr){
	var obj = this._actionObject;
	addr = addr ? this._getAddress(addr) : (obj ? this._getAddress(obj) : "");

	var currentEmail = com_weemo_email_handlerObject.prototype.getUsername();
	if(currentEmail == addr){
		var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
		appCtxt.getAppController().setStatusMsg("You cannot call yourself", ZmStatusView.LEVEL_WARNING, null, transitions);
		return false;
	}

	nameToCall = addr.toLowerCase().split('@')[0];
	if(addr.split('@')[1] == domainZimbraName){
		weemo.createCall(nameToCall,'internal',nameToCall);
	}else{
		var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
		appCtxt.getAppController().setStatusMsg("This contact is not a Zimbra member. You cannot make this call", ZmStatusView.LEVEL_WARNING, null, transitions);
	}
};


EmailTooltipZimlet.prototype._composeListener =
function(ev, addr) {

	this.popdown();

	var obj = this._actionObject;
	addr = addr ? this._getAddress(addr) : (obj ? this._getAddress(obj) : "");

	var params = {};
	var inNewWindow = (!appCtxt.get(ZmSetting.NEW_WINDOW_COMPOSE) && ev && ev.shiftKey) ||
					  (appCtxt.get(ZmSetting.NEW_WINDOW_COMPOSE) && ev && !ev.shiftKey);

	if (this.isMailToLink(addr)) {
		var mailToParams = this.parseMailToLink(addr);
		params.toOverride = mailToParams.to;
		params.subjOverride = mailToParams.subject;
		params.extraBodyText = mailToParams.body;
		addr = mailToParams.to || addr;
	}

	params.action = ZmOperation.NEW_MESSAGE;
	params.inNewWindow = inNewWindow;
	if (!params.toOverride) {
		params.toOverride = addr + AjxEmailAddress.SEPARATOR;
	}
	if (obj && obj.isAjxEmailAddress && obj.address == addr) {
		params.toOverride = obj;
	}

	AjxDispatcher.run("Compose", params );
};

EmailTooltipZimlet.prototype._browseListener =
function() {
	var addr = this._getAddress(this._actionObject);
	if (this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}
	appCtxt.getSearchController().fromBrowse(addr);
};

EmailTooltipZimlet.prototype._searchListener =
function() {
	var addr = this._getAddress(this._actionObject);
	if (this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}
	appCtxt.getSearchController().fromSearch(this._getAddress(addr));
};

EmailTooltipZimlet.prototype._searchToListener =
function() {
	var addr = this._getAddress(this._actionObject);
	if (this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}
	appCtxt.getSearchController().toSearch(this._getAddress(addr));
};

EmailTooltipZimlet.prototype._filterListener =
function() {
	var loadCallback = new AjxCallback(this, this._handleLoadFilter);
	AjxDispatcher.require(["PreferencesCore", "Preferences"], false, loadCallback, null, true);
};

EmailTooltipZimlet.prototype._handleLoadFilter =
function() {
	appCtxt.getAppViewMgr().popView(true, ZmId.VIEW_LOADING);	// pop "Loading..." page
	var rule = new ZmFilterRule();

	var addr = this._getAddress(this._actionObject);
	if (AjxUtil.isString(addr) && this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}
	var subjMod = ZmFilterRule.C_ADDRESS_VALUE[ZmFilterRule.C_FROM];
	rule.addCondition(ZmFilterRule.TEST_ADDRESS, ZmFilterRule.OP_IS, addr, subjMod);
	rule.addAction(ZmFilterRule.A_KEEP);

	appCtxt.getFilterRuleDialog().popup(rule);
};

EmailTooltipZimlet.prototype._goToUrlListener =
function() {
	var addr  = this._getAddress(this._actionObject);
	if (AjxUtil.isString(addr) && this.isMailToLink(addr)) {
		addr = (this.parseMailToLink(addr)).to || addr;
	}

	var parts = addr.split("@");
	if (parts.length) {
		var domain = parts[parts.length - 1];
		var pieces = domain.split(".");
		this._actionUrl = "http://" + ((pieces.length <= 2) ? 'www.' + domain : domain);
	}

	if (this._actionUrl) {
		window.open(this._actionUrl, "_blank");
	} else {
		this.displayStatusMessage(ZmMsg.errorCreateUrl);
	}
};

// To call a phone by clicking on it in the contact card

EmailTooltipZimlet.prototype._phoneListener =
    function(phone) {
        if (!phone) return;
        appCtxt.notifyZimlets("onPhoneClicked", [phone], {waitUntilLoaded:true});
    };

EmailTooltipZimlet.prototype._imListener =
    function(imURI) {
        if (!imURI) return;
    };
/**
 * Helper function
 */
EmailTooltipZimlet.prototype.animateOpacity =
function(id, opacStart, opacEnd, millisec) {
	// create a starting point
	this.changeOpac(opacStart, document.getElementById(id).style);

	//speed for each frame
	var speed = Math.round(millisec / 100);
	var timer = 0;
	var styleObj = document.getElementById(id).style;

	// determine the direction for the blending, if start and end are the same nothing happens
	if (opacStart > opacEnd) {
		for (i = opacStart; i >= opacEnd; i--) {
			setTimeout(AjxCallback.simpleClosure(this.changeOpac, this, i, styleObj), (timer * speed));
			timer++;
		}
	} else if (opacStart < opacEnd) {
		for (i = opacStart; i <= opacEnd; i++)
		{
			setTimeout(AjxCallback.simpleClosure(this.changeOpac, this, i, styleObj), (timer * speed));
			timer++;
		}
	}
};

/**
 * Change the opacity for different browsers
 */
EmailTooltipZimlet.prototype.changeOpac =
function(opacity, styleObj) {
	styleObj.opacity = (opacity / 100);
	styleObj.MozOpacity = (opacity / 100);
	styleObj.KhtmlOpacity = (opacity / 100);
	styleObj.zoom = 1;
	styleObj.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=" + opacity + ")";
};

EmailTooltipZimlet.prototype.openCenteredWindow =
function (url) {
	this.popdown();
	var width = 800;
	var height = 600;
	var left = parseInt((screen.availWidth / 2) - (width / 2));
	var top = parseInt((screen.availHeight / 2) - (height / 2));
	var windowFeatures = "width=" + width + ",height=" + height + ",status,resizable,left=" + left + ",top=" + top + "screenX=" + left + ",screenY=" + top;
	var win = window.open(url, "subWind", windowFeatures);
	if (!win) {
		this._showWarningMsg(ZmMsg.popupBlocker);
	}
};

/**
 * Expands the distribution list address of the bubble with the given ID.
 *
 * @param {string}	bubbleId	ID of bubble
 * @param {string}	email		address to expand
 */
EmailTooltipZimlet.prototype.expandBubble = function(bubbleId, email) {

	var bubble = document.getElementById(bubbleId);
	if (bubble) {
		var loc = Dwt.getLocation(bubble);
		loc.y += Dwt.getSize(bubble).y + 2;
		this._aclv.expandDL({email:email, loc:loc});
	}
};
// handle click on an address (or "Select All") in popup DL expansion list
EmailTooltipZimlet.prototype._dlAddrSelected =
function(match, ev) {
	this._composeListener(ev, match);
};
EmailTooltipZimlet.prototype.callWeemo = function(testparam,type,displayNameToCall) {
	if(this.isIpad()) {
		try {
			var uidToCall = testparam;
	        while (uidToCall.length<6)
	            {
	                uidToCall += uidToCall;
	            }
	        var token = weemo.getToken();
			//window.open('weemosdk://token='+token+'&contact='+uidToCall+'&type='+type);
			window.location = 'weemosdk://token='+token+'&contact='+uidToCall+'&type='+type;
		}
		catch(err)
		  {
		   console.log('error');
		   console.log(err);
		  }
		
	} else {
		if(type == "internal" || type == "attendee"){
			var uidToCall = testparam;
	        while (uidToCall.length<6)
	            {
	                uidToCall += uidToCall;
	            }
	
			if(testparam.split('@')[1] == domainZimbraName){
				weemo.createCall(uidToCall,type,displayNameToCall);	
			}else{
				var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.PAUSE,  ZmToast.FADE_OUT ];
				appCtxt.getAppController().setStatusMsg("This contact is not a Zimbra member. You cannot make this call", ZmStatusView.LEVEL_WARNING, null, transitions);
			}
		} else if(type == "host"){
			modal.close();
			weemo.createCall(com_weemo_email_handlerObject.prototype.getUsername(),type,weemo.getDisplayName());
		}
	}
	
};
EmailTooltipZimlet.prototype.getStatusWeemo =
function(email) {
    if(email.split('@')[1] == domainZimbraName){
        
        var jsonObj, request, soapDoc;
        jsonObj = {GetAccountInfoRequest:{_jsns:"urn:zimbraAccount"}};
        request = jsonObj.GetAccountInfoRequest;
        request.name = email;
        request.type = "account";
        request.account = {_content: email, by: "name"};
        request.offset = 0;
        request.limit = 3;
        var callback = new AjxCallback(this, this._handleSOAPResponseJSON);
        appCtxt.getAppController().sendRequest({jsonObj:jsonObj,asyncMode:true,callback:callback, noBusyOverlay:true});
    }
};

EmailTooltipZimlet.prototype._handleSOAPResponseJSON = 
function(result){
    if (result.isException()) {
        // do something with exception
        var exception = result.getException();      

        return;
    }
    
    // do something with response (in JSON format)
    var response = result.getResponse().GetAccountInfoResponse;

    var uid = response.name;
        while (uid.length<6) {
            uid += uid;
        }    
        weemo.getStatus(uid);   
};

EmailTooltipZimlet.prototype._handleSOAPErrorResponseJSON =
function(ex) {
    var errorMsg = ex.getErrorMsg(); // the error message
    var dump = ex.dump(); // the complete error dump
};

EmailTooltipZimlet.prototype.getDomaineAddressName =function() {
	return domainZimbraName;
};
EmailTooltipZimlet.prototype.getSipOkNok =function() {
	return sipOkNOk;
};
EmailTooltipZimlet.prototype.setIconZimletWeemo =function(authError) {
    if (sipOkNOk){
        $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon ImgWeemoPanelItemIconConnected");
        $(".ImgWeemoPanelItemIcon").closest("td").next(".DwtTreeItem-Text").css({'color':'#000'});
    } else if (authError){
        $(".ImgWeemoPanelItemIcon").closest("td").next(".DwtTreeItem-Text").css({'color':'#CCC'});
        $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon weemoUnactivated");
    } else{
        $(".ImgWeemoPanelItemIcon").removeClass().addClass("ImgWeemoPanelItemIcon ImgWeemoPanelItemIconNotConnected");
        $(".ImgWeemoPanelItemIcon").closest("td").next(".DwtTreeItem-Text").css({'color':'#000'});
    } 
};
EmailTooltipZimlet.prototype.setContentDownloadPopUp = function(authError,code) {
    EmailTooltipZimlet.prototype.setIconZimletWeemo(authError);
    if(sipOkNOk){
        $(".weemo_inner_modal_box").html("<div style=\"margin: 20px 20px 20px 45px; cursor: pointer; text-align: center;\" >"+
        "<div class=\"buttonConnected\" disabled=\"disabled\" style=\"padding: 5px 10px;text-align: center;cursor: not-allowed; width: 163px;border: 1px solid #CCCCCC; border-radius: 3px 3px 3px 3px;\">You are connected</div>"+
        "<div class=\"ZToolbarButtonBorder\" style=\"padding: 5px 10px; width: 163px; margin-top: 20px;\" onclick=\"EmailTooltipZimlet.prototype.callWeemo('"+name+"','host')\">"+
        "Join My Group Video</div></div>");
    } else if (authError){
        $(".weemo_inner_modal_box").html("<div style=\"margin-left: 42px;\"><b>An Error Occurred:</b><br />"+
           code+"<br /><br />Try to refresh the page. If the problem persists, contact your Zimbra administrator for assistance.</div>");
    }else {
         $(".weemo_inner_modal_box").html("<div style=\"margin-left: 42px;\"><button class=\"buttonNotConnected\" disabled=\"disabled\" style=\"padding: 5px 10px;text-align: center;width: 185px;cursor: not-allowed;margin-bottom: 10px;border: 1px solid #CCCCCC; border-radius: 3px 3px 3px 3px;\">You are not connected</button><br />"+
        "<button class=\"ZToolbarButtonBorder\" disabled=\"disabled\" style=\"padding: 5px 10px;width: 185px;text-align: center;cursor: not-allowed;margin-bottom: 10px;\">"+
        "Join My Group Video</button><br /><a class=\"weemo_download_button_link btnDownload\" href=\"https://download.weemo.com/poc.php?urlreferer="+webAppId
        +"\" target=\"_blank\"><button class=\"ZToolbarButtonBorder\" style=\" color: #333333;padding: 5px 10px;text-align: center;width: 185px;\">Download Weemo Driver</button></a></div>");
    }
    
    $(".weemo_modal_header_title").text("Weemo Video Chat Zimlet");
    $(".weemo_footer").html('<a style="color: #333333; padding: 5px 10px;" href="#" class="weemo_download_button_link btnClose ZToolbarButtonBorder">Cancel</a>');
    $('.weemo_modal_box').css({'width':'300px'});
    
    $('.weemo_modal_close, .btnClose').click(function(){
        $('.weemo_modal_box').fadeOut().remove();
        $('.weemo_overlay').fadeOut().remove();
    });
};

EmailTooltipZimlet.prototype.isIpad = function() {
	if( navigator.userAgent.match(/iPad/i)) return true;
	else return false;
};

