EmailToolTipSlideShow.mainDivId = "EmailZimlet_slidesMainDiv";
EmailToolTipSlideShow.navDivId = "EmailZimlet_slidesNavDiv";
EmailToolTipSlideShow.navTableRowId = "EmailZimlet_slidesNavTableRow";

function EmailToolTipSlideShow(zimlet, canvas) {
	this.slidesIconAndSlideMap = [];
	this.numberOfSlides = 0;
	this.emailZimlet = zimlet;
	this.canvas = canvas;
	this._createFrame(canvas);
	this.mainDiv = document.getElementById(EmailToolTipSlideShow.mainDivId);
	this.navDiv = document.getElementById(EmailToolTipSlideShow.navDivId);
	this.navTableRow = document.getElementById(EmailToolTipSlideShow.navTableRowId);
	this.currentSelectCellId = null;
	this.currentSlideId = null;
	this.navDiv.onclick = AjxCallback.simpleClosure(this._handleClick, this);
	canvas.onmouseover =  AjxCallback.simpleClosure(this.handleMouseOver, this);
	canvas.onmouseout = AjxCallback.simpleClosure(this.handleMouseOut, this);
	//set height and width to make it work in IE
	this.mainDiv.style.width = EmailTooltipZimlet.tooltipWidth + "px";
	this.navDiv.style.width = EmailTooltipZimlet.tooltipWidth + "px";
};

EmailToolTipSlideShow.prototype._createFrame =
function(canvas) {
	canvas.innerHTML = ["<div id='", EmailToolTipSlideShow.mainDivId,"'></div>",
						"<div id='", EmailToolTipSlideShow.navDivId, "'>",
						"<div class='horizsep'></div>",
						"<table width=100%><tr id='",EmailToolTipSlideShow.navTableRowId,"'>",
						"</tr></table></div>"].join("");
};

EmailToolTipSlideShow.prototype._handleClick =
function(e) {
	if (!e){
		var e = window.event;
	}
	var targ;
	if (e.target) {
		targ = e.target;
	} else if (e.srcElement) {
		targ = e.srcElement;
	}
	if (targ.nodeType == 3) {
		targ = targ.parentNode;
	}
	if(targ.id) {
		if(this.slidesIconAndSlideMap[targ.id]){
			this.slidesIconAndSlideMap[targ.id].select();
		}
	}
};

EmailToolTipSlideShow.prototype.addSlide =
function(slide, index) {
	slide.slideShow = this;
	if(!index) {
		index = this.numberOfSlides;
	}
	this.slidesIconAndSlideMap[slide.iconDivId] = slide;
	var div  =  document.createElement("div");
	div.id = slide.id;
	div.style.display = "none";
	this.mainDiv.appendChild(div);
	div.innerHTML = slide.html;

	this._insertSlideIcon(slide);
	this.numberOfSlides++;
};

EmailToolTipSlideShow.prototype._insertSlideIcon =
function(slide) {
	var iconName = slide.iconName;
	var iconDivId = slide.iconDivId;
	var selectCellId = slide.selectCellId;
	var name = slide.name;
	var iconCell = this.navTableRow.insertCell(0);
	this._insertIconHtml(iconCell, selectCellId, name, iconDivId, iconName);
};

EmailToolTipSlideShow.prototype._insertIconHtml =
function(iconCell, selectCellId, name, iconDivId, iconName) {
	iconCell.align="center";
	iconCell.id = selectCellId;

	iconCell.innerHTML = ["<div title='",name,"' id='",iconDivId,"' class='Img", iconName, "' style='cursor:pointer;'></div>"].join("");
};

EmailToolTipSlideShow.prototype.handleMouseOver =
function() {
	this.isMouseOverTooltip = true;
};

EmailToolTipSlideShow.prototype.handleMouseOut =
function() {
	this.isMouseOverTooltip = false;
	this.emailZimlet.hoverOut();

};
