/* #vim: set expandtab tabstop=4 shiftwidth=4 autoindent smartindent mouse=a hlsearch: */
/*jslint browser: true, nomen: true, white: true */
/*global ca_greenrope_contacts, ZmZimletBase, appCtxt, ZmOrganizer, GR_Connection, AjxListener, AjxDispatcher, AjxCallback, ZmItem, DwtComposite, ZmAttachTabView, Dwt, DwtTabViewPage, AjxTemplate, ZmApp, ZmContact, ZmMsg, ZmStatusView, ZmFolder, ZmStatusView, AjxMessageFormat, ZmEvent, ZmList, DwtTabView, AjxUtil, EmailToolTipSlide, DwtControl, ZmSetting, ZmPreferencesPage, ZmPref, DwtInputField, ZmCalendar, ZmCsfeException, ZmEditContactView, AjxXmlDoc, ZmAddressBubble, EmailTooltipZimlet, ZmObjectHandler, EmailToolTipSlideShow, SeriesAnimation, DwtShell, DwtEvent, AjxEmailAddress */

function ca_greenrope_contacts() {
	'use strict';
}

ca_greenrope_contacts.prototype = new ZmZimletBase();
ca_greenrope_contacts.prototype.constructor = ca_greenrope_contacts;

ca_greenrope_contacts.prototype.init = function () {
	'use strict';
    var i, j, oc = appCtxt.getOverviewController(),
        tc = oc.getTreeController(ZmOrganizer.ADDRBOOK),
        dt = tc.getDataTree(), token, login;
	ca_greenrope_contacts.app = this;
    this.accountsWithAccess = [];
    this.groups = [];
    this.grConnection   = new GR_Connection();
    this._zimletContext = appCtxt.getZimletMgr().getZimletByName("ca_greenrope");
    token = this.getUserProperty("GreenRope_AuthToken");
    login = this.getUserProperty("GreenRope_AuthLogin");
    appCtxt.set("GR_LOGIN", login);
    this.grConnection.authToken = token || '';
    this.grConnection.login = login || '';
    dt.addChangeListener(new AjxListener(this, this._newAddrBookListener));
    this._zimbraApp();
    AjxDispatcher.setPackageLoadFunction("Preferences", new AjxCallback(this, this._prefsApp));
    AjxDispatcher.setPackageLoadFunction("ContactsCore", new AjxCallback(this, this._abookApp));
    this.greenRopeAppName = this.createApp("GreenRope", "GreenRopeZimletIcon", "GreenRope");
    if (token && token !== '') {
        AjxDispatcher.setPackageLoadFunction("CalendarCore", new AjxCallback(this, this.getAccountsWithAccess));
    }
    if (EmailToolTipSlideShow) {
        EmailTooltipZimlet.prototype.popDownIfMouseNotOnSlide = function () {
            if (this._hoverOver) {
                //console.log("_hoverOver is true")
                return;
            }
            if (this.slideShow && this.slideShow.isMouseOverTooltip) {
                //console.log("isMouseOverTooltip is true");
                return;
            }
            if (this.tooltip) {
                //console.log("Popping down tooltip");
                this.tooltip._poppedUp = true; //makes the tooltip non-sticky
                this.tooltip.popdown();
            }
        };
        EmailToolTipSlideShow.prototype.handleMouseOut = function (evt) {
            if (!ca_greenrope_contacts.app.isDescendant(ca_greenrope_contacts.app._tooltipTabView._elRef, evt.toElement) && !ca_greenrope_contacts.app.isDescendant(evt.fromElement, evt.toElement)) {
                this.isMouseOverTooltip = false;
                this.emailZimlet.hoverOut();
            }
        };
        EmailTooltipZimlet.prototype._initializeProps = function(object, context, x, y, span) {
            var shell, tooltip, addr, isMailTo;
            if (!this.seriesAnimation) {
                this.seriesAnimation = new SeriesAnimation();
            }
            this.seriesAnimation.reset();
            shell = DwtShell.getShell(window);
            tooltip = shell.getToolTip();
            tooltip.setContent("<div id=\"zimletTooltipDiv\"></div>", true);

            //Here is where we are setting the tooltip offset
            this.x = x - 50;
            this.y = y - 10;
            this.tooltip = tooltip;
            //this is used by mail/conv list
            Dwt.setHandler(tooltip._div, DwtEvent.ONMOUSEOUT, AjxCallback.simpleClosure(this.hoverOut, this));

            addr = (object instanceof AjxEmailAddress) ? object.address : object;
            isMailTo = this.isMailToLink(addr);
            if (isMailTo) {
                addr = (this.parseMailToLink(addr)).to || addr;
            }
            this.emailAddress = addr;
            this.fullName = (object instanceof AjxEmailAddress) ? object.name : "";
            this.canvas =   document.getElementById("zimletTooltipDiv");
            this.slideShow = new EmailToolTipSlideShow(this, this.canvas);
            this.contextMenu = this.getActionMenu(object, span, context, false);
            ca_greenrope_contacts.app.clearPopdown();
            this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 1500);
        };
    }
};
/**
  * Panel item was clicked.
  *
  */
ca_greenrope_contacts.prototype.singleClicked = function () {
	'use strict';
    appCtxt.getAppController().activateApp(this.greenRopeAppName);
};

/**
  * Calls singleClicked when doubleClicked on panel item.
  *
  */
ca_greenrope_contacts.prototype.doubleClicked = function () {
	'use strict';
    this.singleClicked();
};

ca_greenrope_contacts.prototype.appLaunch = function (appName, activate) {
	'use strict';
    if (appName === this.greenRopeAppName) {
        this.greenRopeApp = appCtxt.getApp(appName);
        this.greenRopeApp.setContent( "<iframe src=\"http://www.greenrope.com/zimbra.html\" width=\"100%\" height=\"100%\" frameborder=\"0\"></iframe>" );
    }
};
ca_greenrope_contacts.prototype.getAuthKey = function () {
	'use strict';
    if ((typeof this.authkey) === "string") {
        return this.authkey;
    }

};
ca_greenrope_contacts.prototype.getContactGRId = function (contact) {
	'use strict';
    var gr_id;
    if (!contact || contact.type !== ZmItem.CONTACT) {
        return null;
    }
    gr_id = parseInt(contact.getAttr('Greenropeid'), 10);
    if (!gr_id || gr_id < 1) {
        gr_id = parseInt(contact.getAttr('greenropeid'), 10);
    }
    if (!gr_id || gr_id < 1) {
        return null;
    }
    return gr_id;
};
ca_greenrope_contacts.prototype.getContactGRAccId = function (contact) {
	'use strict';
    var gr_acc_id;
    if (!contact || contact.type !== ZmItem.CONTACT) {
        return null;
    }
    gr_acc_id = parseInt(contact.getAttr('GRAccountid'), 10);
    if (!gr_acc_id || gr_acc_id < 1) {
        gr_acc_id = parseInt(contact.getAttr('Graccountid'), 10);
    }
    if (!gr_acc_id || gr_acc_id < 1) {
        gr_acc_id = parseInt(contact.getAttr('graccountid'), 10);
    }
    if (!gr_acc_id || gr_acc_id < 1) {
        return null;
    }

    return gr_acc_id;
};

ca_greenrope_contacts.prototype.onContactView = function (contact, elid) {
	'use strict';
    var detailsBox = document.getElementById(elid + "_details"),
        greenropeidBox = document.getElementById(elid + "_Greenropeid"),
        greenropeidBox2 = document.getElementById(elid + "_greenropeid"),
        graccountidBox = document.getElementById(elid + "_GRAccountid"),
        currentViewChildren,
        contactView,
        gr_id = 0, 
        gr_acc_id = 0, 
        newel, 
        grcontact, 
        i;
    // Remove element that is not needed.
    if (greenropeidBox) {
        greenropeidBox.parentNode.style.display = "none";
    }
    if (greenropeidBox2) {
        greenropeidBox2.parentNode.style.display = "none";
    }
    if (graccountidBox) {
        graccountidBox.parentNode.style.display = "none";
    }
    gr_id = ca_greenrope_contacts.app.getContactGRId(contact);
    gr_acc_id = ca_greenrope_contacts.app.getContactGRAccId(contact);
    // If this is a greenrope contact
    //create an element to put CRM Data into
    if (!gr_id) { return; }
    currentViewChildren = appCtxt.getCurrentView().getChildren();
    for(i = 0; i < currentViewChildren.length; i += 1)
    {
        if (currentViewChildren[i] && currentViewChildren[i] instanceof DwtComposite && currentViewChildren[i].getVisible())
        {
            contactView = appCtxt.getCurrentView().getChildren()[i];
        }
    }
    if (!contactView) { return; }
    this._contactTabView = (typeof ZmAttachTabView !== "undefined") ? new ZmAttachTabView(contactView, null, Dwt.STATIC_STYLE) : new DwtTabView({parent:contactView, posStyle:Dwt.STATIC_STYLE});
    this._CRMActivitiesPage = new DwtTabViewPage(this._contactTabView);
    this._CRMEmailsPage = new DwtTabViewPage(this._contactTabView);
    this._CRMWebsitesPage = new DwtTabViewPage(this._contactTabView);
    this._contactTabView.GRContact = contact;
    this._contactTabView.GRId = gr_id;
    this._contactTabView.GRAccId = gr_acc_id;

    this._contactTabView.addStateChangeListener(new AjxListener(this, this.contactTabStateChangeListener));

    this._contactTabKeys = {};
    this._contactTabKeys.activities = this._contactTabView.addTab("CRM Activities", this._CRMActivitiesPage);
    this._contactTabKeys.emails = this._contactTabView.addTab("CRM Emails", this._CRMEmailsPage);
    this._contactTabKeys.websites = this._contactTabView.addTab("CRM Website Visits", this._CRMWebsitesPage);
    this._CRMActivitiesPage.setContent("    Loading GreenRope CRM Activity data...");
    this._CRMEmailsPage.setContent("    Loading GreenRope CRM E-Mail data...");
    this._CRMWebsitesPage.setContent("    Loading GreenRope CRM Website Visit data...");
    this._CRMActivitiesPage.setScrollStyle(Dwt.SCROLL);
    this._CRMEmailsPage.setScrollStyle(Dwt.SCROLL);
    this._CRMWebsitesPage.setScrollStyle(Dwt.SCROLL);

};
ca_greenrope_contacts.prototype.contactTabStateChangeListener = function (evt) {
	'use strict';
    var req = "", 
        el, 
        fc, 
        container = this._contactTabView.parent,
        newY = container.getH(), 
        i;
    for(i = 0; i < container._elRef.childNodes.length; i += 1)
    {
        if (container._elRef.childNodes[i].tagName.toString().toLowerCase() === "table")
        {
            newY -= container._elRef.childNodes[i].offsetHeight;
        }
    }
    newY -= this._contactTabView.getTabBar().getH();
    if ( this._contactTabView.GRAccId > 0)
    {
        req += " account_id=\"" + parseInt(this._contactTabView.GRAccId, 10) + "\"";
    }
    if ( this._contactTabView.GRId > 0)
    {
        req += " contact_id=\"" + parseInt(this._contactTabView.GRId, 10) + "\"";
    }
    switch(evt.item.getCurrentTab())
    {
        case 1: // CRM Activities
            el = this._CRMActivitiesPage.getHtmlElement();
            this._CRMActivitiesPage.setSize("100%", newY + "px");
            //create a request to get the CRM Data to put into the element.
            this.grConnection.sendRawRequest("<GetCRMActivitiesRequest" + req + "></GetCRMActivitiesRequest>", new AjxCallback(this, this._updateContactViewActivities, {contact:this._contactTabView.GRContact, el:el}));
            break;
        case 2: // CRM Emails
            el = this._CRMEmailsPage.getHtmlElement();
            this._CRMEmailsPage.setSize("100%", newY + "px");
            this.grConnection.sendRawRequest("<GetCRMActivitiesEmailsRequest" + req + "></GetCRMActivitiesEmailsRequest>", new AjxCallback(this, this._updateContactViewEmails, {contact:this._contactTabView.GRContact, el:el}));
            break;
        case 3: // CRM Website Visits
            el = this._CRMWebsitesPage.getHtmlElement();
            this._CRMWebsitesPage.setSize("100%", newY + "px");
            this.grConnection.sendRawRequest("<GetCRMActivitiesWebsiteVisitsRequest" + req + "></GetCRMActivitiesWebsiteVisitsRequest>", new AjxCallback(this, this._updateContactViewWebsites, {contact:this._contactTabView.GRContact, el:el}));
            break;
        default: // Error
    }
        return true;
};
ca_greenrope_contacts.prototype.onMsgView = function (msg, b, msgview)
{
	'use strict';
    var doc = msgview._ifw.getDocument(),
        style = doc.createElement('style');
    style.type = 'text/css';
    style.innerHTML = '.greenRopeAddr { background-color: #C8FF9B; border-radius: 5px; padding: 2px; }';
    doc.getElementsByTagName('head')[0].appendChild(style);

};

ca_greenrope_contacts.prototype._updateContactViewActivities = function (data, res) {
	'use strict';
    var crmactivities = [], 
        tthtml, 
        i, 
        resp, 
        el, 
        fc, 
        temp;
    if (res.status === "OK")
    {
        el = this._CRMActivitiesPage.getHtmlElement();
        fc = el.firstChild;
        while (fc)
        {
            el.removeChild(fc);
            fc = el.firstChild;
        }
        resp = this.parseXML(res.RAWResponse[0]._content);
        if (!resp || (resp.ErrorCode && parseInt(resp.ErrorCode.toString(),10) > 0) || (!resp.CRMActivities || !resp.CRMActivities.CRMActivity))
        {
            tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#ActivitiesFrame", {crmactivities: [], response: {status:"Error", message:"No Entries Found."}});
            data.el.innerHTML = tthtml;
            return false;
        }
        crmactivities = this.is_array(resp.CRMActivities.CRMActivity) ? resp.CRMActivities.CRMActivity : [resp.CRMActivities.CRMActivity];
        for(i = 0; i < crmactivities.length / 2; i += 1)
        {
            temp = crmactivities[i];
            crmactivities[i] = crmactivities[crmactivities.length - i - 1];
            crmactivities[crmactivities.length - i - 1] = temp;
        }
    }
    tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#ActivitiesFrame", {crmactivities: crmactivities, response: res});
    data.el.innerHTML = tthtml;
};
ca_greenrope_contacts.prototype._updateContactViewEmails = function (data, res) {
	'use strict';
    var crmactivities = [], 
        tthtml, 
        i, 
        resp, 
        el, 
        fc, 
        temp;
    if (res.status === "OK")
    {
        el = this._CRMEmailsPage.getHtmlElement();
        fc = el.firstChild;
        while (fc)
        {
            el.removeChild(fc);
            fc = el.firstChild;
        }
        resp = this.parseXML(res.RAWResponse[0]._content);
        if (!resp || (resp.ErrorCode && parseInt(resp.ErrorCode.toString(),10) > 0) || (!resp.SentEmails || !resp.SentEmails.SentEmail))
        {
            tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#EmailsFrame", {crmactivities: [], response: {status:"Error", message:"No Entries Found."}});
            data.el.innerHTML = tthtml;
            return false;
        }
        crmactivities = this.is_array(resp.SentEmails.SentEmail) ? resp.SentEmails.SentEmail : [resp.SentEmails.SentEmail];
        for(i = 0; i < crmactivities.length / 2; i += 1)
        {
            temp = crmactivities[i];
            crmactivities[i] = crmactivities[crmactivities.length - i - 1];
            crmactivities[crmactivities.length - i - 1] = temp;
        }
    }
    tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#EmailsFrame", {crmactivities: crmactivities, response: res});
    data.el.innerHTML = tthtml;
};
ca_greenrope_contacts.prototype._updateContactViewWebsites = function (data, res) {
	'use strict';
    var crmactivities = [], 
        tthtml, 
        i, 
        resp, 
        el, 
        fc, 
        temp;
    if (res.status === "OK")
    {
        el = this._CRMWebsitesPage.getHtmlElement();
        fc = el.firstChild;
        while (fc)
        {
            el.removeChild(fc);
            fc = el.firstChild;
        }
        resp = this.parseXML(res.RAWResponse[0]._content);
        if (!resp || (resp.ErrorCode && parseInt(resp.ErrorCode.toString(),10) > 0) || (!resp.WebsiteVisits || !resp.WebsiteVisits.WebsiteVisit))
        {
            tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#WebsitesFrame", {crmactivities: [], response: {status:"Error", message:"No Entries Found."}});
            data.el.innerHTML = tthtml;
            return false;
        }
        crmactivities = this.is_array(resp.WebsiteVisits.WebsiteVisit) ? resp.WebsiteVisits.WebsiteVisit : [resp.WebsiteVisits.WebsiteVisit];
        for(i = 0; i < crmactivities.length / 2; i += 1)
        {
            temp = crmactivities[i];
            crmactivities[i] = crmactivities[crmactivities.length - i - 1];
            crmactivities[crmactivities.length - i - 1] = temp;
        }
    }
    tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#WebsitesFrame", {crmactivities: crmactivities, response: res});
    data.el.innerHTML = tthtml;
};

ca_greenrope_contacts.prototype.getGroup = function (group_id) {
	'use strict';
    var i = this.groups.length;
    while (i) {
    	i-=1;
        if (parseInt(this.groups[i].id, 10) === parseInt(group_id, 10)) {
            return this.groups[i];
        }
    }
    return false;
};
ca_greenrope_contacts.prototype.getGroupByName = function (group_name) {
	'use strict';
    var i = this.groups.length;
    while (i) {
    	i-=1;
        if (this.groups[i].name === group_name) {
            return this.groups[i];
        }
    }
    return false;
};

ca_greenrope_contacts.prototype.isGreenRope = function (addr) {
	'use strict';
    var contactsApp = appCtxt.getApp(ZmApp.CONTACTS),
        contact = contactsApp.getContactByEmail(addr);
    if (ca_greenrope_contacts.app.getContactGRId(contact) > 0)
    {
        return true;
    }
    return false;
};

ca_greenrope_contacts.prototype.getAccountsWithAccess = function () {
	'use strict';
    var contains = function (a, obj) {
                    var i = a.length;
                    while (i) {
                    	i-=1;
                        if (a[i] === obj) {
                            return true;
                        }
                    }
                    return false;
    };
    this.grConnection.sendRawRequest('<GetAccountsWithAccessRequest></GetAccountsWithAccessRequest>',
        new AjxCallback(this, function (res)
        {
            var i, 
            j, 
            account_id, 
            result, 
            accounts;
            if (res.status === "OK")
            {
                result = this.parseXML(res.RAWResponse[0]._content);
                if (!result || !result.Accounts || !result.Accounts.Account) { return; }
                accounts = (this.is_array(result.Accounts.Account)) ? result.Accounts.Account : [result.Accounts.Account];
                this.accountsWithAccessCount = 0;
                this.accountsWithAccess = [];
                for (i = 0; i < accounts.length; i += 1) {
                    account_id = parseInt(accounts[i].AccountNumber.toString(),10);
                    if (!this.accountsWithAccess[account_id])
                    {
                        this.accountsWithAccess[account_id] = {};
                        this.accountsWithAccessCount += 1;
                    }
                    this.accountsWithAccess[account_id].account_id = account_id;
                    if (!this.accountsWithAccess[account_id].groups)
                    {
                        this.accountsWithAccess[account_id].groups = [];
                    }
                    if (accounts[i].Groups && accounts[i].Groups.Group)
                    {
                        for(j = 0; j < accounts[i].Groups.Group.length; j += 1)
                        {
                            this.accountsWithAccess[account_id].groups.push({
                                group_id: parseInt(accounts[i].Groups.Group[j].GroupID.toString(),10),
                                group_name: parseInt(accounts[i].Groups.Group[j].GroupName.toString(),10)
                            });
                        }
                    }
                }
                this.getGroups();
            }
        })
    );
};
ca_greenrope_contacts.prototype.getGroups = function () {
	'use strict';
    var a, 
        cond, 
        cb = new AjxCallback(this, function (res)
            {
                var grpArray, selected_groups;
                grpArray = (this.is_array(res.Groups.Group)) ? res.Groups.Group : [res.Groups.Group];

                this.groups = this.groups.concat(grpArray);

            }),
        accountsWithAccessCounter = this.accountsWithAccessCount,
        accWithAccessCb = new AjxCallback(this, function (res) {
                    var selected_groups, 
                    i, 
                    result = this.parseXML(res.RAWResponse[0]._content), 
                    contains = function (a, obj) {
                        var i = a.length;
                        while (i) {
                            i-=1;
                            if (a[i] === obj) {
                                return true;
                            }
                        }
                        return false;
                    };
                    if (result.Result && result.Result.toString() === "Success")
                    {
                        cb.run(result);
                    }
                    accountsWithAccessCounter -= 1;
                    if (accountsWithAccessCounter<=0)
                    {
                        selected_groups = String(this.getUserProperty("GreenRope_SyncGroups"));
                        selected_groups = selected_groups.split(",");
                        for(i = 0; i< this.groups.length ; i += 1)
                        {
                            this.groups[i].selected = contains(selected_groups, this.groups[i].AccountNumber.toString() + "_" + this.groups[i].Group_id.toString());
                            this.groups[i].id = parseInt(this.groups[i].Group_id.toString(), 10);
                            this.groups[i].account_id = parseInt(this.groups[i].AccountNumber.toString(), 10);
                            this.groups[i].name = this.groups[i].Name.toString();
                            this.groups[i].type = this.groups[i].Group_type.toString();
                        }
                        this.updateGroups();
                    }
                });
    this.groups = [];
    for (a in this.accountsWithAccess) {
        if (this.accountsWithAccess.hasOwnProperty(a)) {
            if (this.accountsWithAccess[a].account_id === 0)
            {
                cond = '';
            }
            else
            {
                cond = ' account_id="' +this.accountsWithAccess[a].account_id + '"';
                //{account_id: this.accountsWithAccess[a]};
            }
            this.grConnection.sendRawRequest('<GetGroupsRequest'+cond+'></GetGroupsRequest>', accWithAccessCb);
        }
    }
};
ca_greenrope_contacts.prototype.getContacts = function (account_id, group_id) {
	'use strict';
    var sExp, 
        group_name = "Invalid GR Folder", i;
    if (group_id)
    {
        sExp = {account_id: account_id, group_id: group_id};
    }
    for (i = 0; i < this.groups.length; i += 1)
    {
        if (this.groups[i].id === group_id && this.groups[i].account_id === account_id) {
            group_name = this.groups[i].name;
        }
    }
    this.getContactsRunner.push([account_id, group_id]);
    this.grConnection.syncContacts(
        {id: group_id, name: group_name, accountId: account_id},
        new AjxCallback(this,
            function (res) {
                this.getContactsRunner.pop();
                if (this.getContactsRunner.length <= 0)
                {
                    this.updateContactApp();
                }
                return;
            }
        )
    );

};

ca_greenrope_contacts.prototype.updateGroups = function () {
	'use strict';
    var i, 
        oc = appCtxt.getOverviewController(),
        tc = oc.getTreeController(ZmOrganizer.ADDRBOOK),
        dt = tc.getDataTree(),
        folders = dt.getByType(ZmOrganizer.ADDRBOOK),
        found = null;
        this.getContactsRunner = [];
    for (i = 0; i < this.groups.length; i += 1)
    {
        if (this.groups[i].name === appCtxt.get("GR_ALLCONTACT_SYNC"))
        {
            this.groups[i].folder = dt.getByName("Contacts");
            this.getContacts(this.groups[i].account_id, this.groups[i].id);
        }
        else
        {
            found = dt.getByName(this.groups[i].name);
            if (found === null && this.groups[i].selected)
            {
                tc._doCreate({type:"folder", name:this.groups[i].name});
            }
            else
            {
                this.groups[i].folder = found;
            }
            if (this.groups[i].selected)
            {
                this.getContacts(this.groups[i].account_id, this.groups[i].id);
                this.updateCal(this.groups[i].account_id, this.groups[i].id);
            }
        }
    }
};

ca_greenrope_contacts.prototype.updateContactApp = function () {
	'use strict';
    var greenrope = this;
    /**
     * Updates contact attributes.
     *
     * @param {Hash}    attr        a set of attributes and new values
     * @param {AjxCallback} callback    the callback
     */
    ZmContact.prototype.modify = function (attr, callback) {
        if (this.list.isGal) { return; }

        // change force to 0 and put up dialog if we get a MODIFY_CONFLICT fault?
        var jsonObj = {ModifyContactRequest:{_jsns:"urn:zimbraMail", replace:"0", force:"1"}},
            cn = jsonObj.ModifyContactRequest.cn = {id:this.id}, 
            continueRequest = false, 
            name, 
            contact = {}, 
            i, 
            fields, 
            field, 
            value, 
            respCallback, 
            fullName;
        cn.a = [];

        for (name in attr) {
            if (attr.hasOwnProperty(name)) {
                if (name !== ZmContact.F_folderId) {
                    this._addRequestAttr(cn, name, (attr[name] && attr[name].value) || attr[name]);
                    continueRequest = true;
                }
            }
        }

        // bug: 45026
        if (attr.hasOwnProperty(ZmContact.F_firstName) || attr.hasOwnProperty(ZmContact.F_lastName) || attr.hasOwnProperty(ZmContact.F_company) || attr.hasOwnProperty(ZmContact.X_fileAs)) {
            fields = [ZmContact.F_firstName, ZmContact.F_lastName, ZmContact.F_company, ZmContact.X_fileAs];
            for (i = 0; i < fields.length; i += 1) {
                field = fields[i];
                value = attr[field];
                contact[field] = value !== null ? value : this.getAttr(field);
            }
            fullName = ZmContact.computeFileAs(contact);
            this._addRequestAttr(cn, ZmContact.X_fullName, fullName);
        }
        greenrope._modifyGR(attr);
        if (continueRequest) {
            respCallback = new AjxCallback(this, this._handleResponseModify, [attr, callback, false]);
            appCtxt.getAppController().sendRequest({jsonObj:jsonObj, asyncMode:true, callback:respCallback});
        } else {
            if (attr[ZmContact.F_folderId]) {
                this._setFolder(attr[ZmContact.F_folderId]);
            }
        }
    };
    /**
     * @private
     */
    ZmContact.prototype._handleResponseModify =
    function (attr, callback, notify, result) {
        var resp, 
        cn, 
        id, 
        detail;
        if (typeof notify !== 'boolean')
        {
            result = notify;
            notify = true;
        }

        resp = result.getResponse().ModifyContactResponse;
        cn = resp ? resp.cn[0] : null;
        id = cn ? cn.id : null;

        if (id && id === this.id) {
            if (notify) { appCtxt.setStatusMsg(this.isGroup() ? ZmMsg.groupSaved : ZmMsg.contactSaved); }
            // was this contact moved to another folder?
            if (attr[ZmContact.F_folderId] && this.folderId !== attr[ZmContact.F_folderId]) {
                this._setFolder(attr[ZmContact.F_folderId]);
            }
        } else {
            detail = ZmMsg.errorTryAgain + "\n" + ZmMsg.errorContact;
            appCtxt.getAppController().setStatusMsg(ZmMsg.errorModifyContact, ZmStatusView.LEVEL_CRITICAL, detail);
        }
        // NOTE: we no longer process callbacks here since notification handling
        //       takes care of everything
    };


    /*
    * Creates a contact from the given set of attributes. Used to create contacts on
    * the fly (rather than by loading them). This method is called by a list's <code>create()</code>
    * method.
    * <p>
    * If this is a GAL contact, we assume it is being added to the contact list.</p>
    *
    * @param {Hash} attr            the attribute/value pairs for this contact
    * @param {ZmBatchCommand}   batchCmd    the batch command that contains this request
    */
    ZmContact.prototype.create = function (attr, batchCmd, grGen) {

        var jsonObj = {CreateContactRequest:{_jsns:"urn:zimbraMail"}},
            request = jsonObj.CreateContactRequest,
            cn = request.cn = {},
            folderId = attr[ZmContact.F_folderId] || ZmFolder.ID_CONTACTS,
            folder = appCtxt.getById(folderId), 
            name, 
            respCallback;

        if (folder && folder.isRemote()) {
            folderId = folder.getRemoteId();
        }
        cn.l = folderId;
        cn.a = [];

        for (name in attr) {
            if (attr.hasOwnProperty(name))
            {
                if (name !== ZmContact.F_folderId &&
                    name !== "objectClass" &&
                    name !== "zimbraId" &&
                    name !== "createTimeStamp" &&
                    name !== "modifyTimeStamp") {

                    this._addRequestAttr(cn, name, attr[name]);
                }
            }
        }

        respCallback = new AjxCallback(this, this._handleResponseCreate, [attr, batchCmd !== null, false]);
        if (!grGen)
        {
            greenrope._createGR(attr);
        }

        if (batchCmd) {
            batchCmd.addRequestParams(jsonObj, respCallback);
        } else {
            appCtxt.getAppController().sendRequest({jsonObj:jsonObj, asyncMode:true, callback:respCallback});
        }
    };
    /**
     * @private
     */
    ZmContact.prototype._handleResponseCreate = function (attr, isBatchMode, notify, result) {
        // dont bother processing creates when in batch mode (just let create
        // notifications handle them)
        var resp, 
            id, 
            msg, 
            detail, 
            a, 
            cn;
        if (isBatchMode) { return; }
        if (typeof notify !== 'boolean') {
            result = notify;
            notify = true;
        }

        resp = result.getResponse().CreateContactResponse;
        cn = resp ? resp.cn[0] : null;
        id = cn ? cn.id : null;
        if (id) {
            this._fileAs = null;
            this._fullName = null;
            this.id = id;
            this.modified = cn.md;
            this.folderId = cn.l || ZmOrganizer.ID_ADDRBOOK;
            for (a in attr) {
                if (attr.hasOwnProperty(a)) {
                    if (!(attr[a] === undefined || attr[a] === '')) {
                        this.setAttr(a, attr[a]);
                    }
                }
            }
            msg = this.isGroup() ? ZmMsg.groupCreated : ZmMsg.contactCreated;
            if (notify) { appCtxt.getAppController().setStatusMsg(msg); }
        } else {
            msg = this.isGroup() ? ZmMsg.errorCreateGroup : ZmMsg.errorCreateContact;
            detail = ZmMsg.errorTryAgain + "\n" + ZmMsg.errorContact;
            appCtxt.getAppController().setStatusMsg(msg, ZmStatusView.LEVEL_CRITICAL, detail);
        }
    };
    /**
     * @private
     */
    ZmContact.prototype._setFolder = function (newFolderId) {
        var folder = appCtxt.getById(this.folderId),
            fId = folder ? folder.nId : null,
            newFolder, 
            jsonObj, 
            respCallback, 
            accountName;
        if (fId === newFolderId) { return; }
        // moving out of a share or into one is handled differently (create then hard delete)
        newFolder = appCtxt.getById(newFolderId);
        if (this.isShared() || (newFolder && newFolder.link)) {
            if (this.list) {
                this.list.moveItems({items:[this], folder:newFolder});
            }
        } else {
            jsonObj = {ContactActionRequest:{_jsns:"urn:zimbraMail"}};
            jsonObj.ContactActionRequest.action = {id:this.id, op:"move", l:newFolderId};
            respCallback = new AjxCallback(this, this._handleResponseMove, [newFolderId]);
            accountName = appCtxt.multiAccounts && appCtxt.accountList.mainAccount.name;
            appCtxt.getAppController().sendRequest({jsonObj:jsonObj, asyncMode:true, callback:respCallback, accountName:accountName});
        }
    };
    /**
     * @private
     */
    ZmContact.prototype._handleResponseMove = function (newFolderId, resp) {
        var newFolder = newFolderId && appCtxt.getById(newFolderId),
            count = 1;
        if (newFolder)
        {
            appCtxt.setStatusMsg(AjxMessageFormat.format(ZmMsg.actionMove, [count, AjxMessageFormat.format(ZmMsg[ZmItem.COUNT_KEY[ZmItem.CONTACT]], count), newFolder.name]));
        }
        this._notify(ZmEvent.E_MODIFY, resp);
    };
    /**
     * Deletes one or more items from the list. Normally, deleting an item just
     * moves it to the Trash (soft delete). However, if it's already in the Trash,
     * it will be removed from the data store (hard delete).
     *
     * @param {Hash}    params      a hash of parameters
     * @param   {Array} params.items            list of items to delete
     * @param   {Boolean}   params.hardDelete   <code>true</code> to force physical removal of items
     * @param   {Object}    params.attrs            additional attrs for SOAP command
     * @param   {window}    params.childWin     the child window this action is happening in
     * @param   {AjxCallback}   params.finalCallback    the callback to run after all items have been processed
     * @param   {int}   params.count            the starting count for number of items processed
     */
    ZmList.prototype.deleteItems = function () {
        var items, toMove, toDelete, item, folderId, folder, gr_id, gr_acc_id, accounts, i, param;
        param = Dwt.getParams(arguments, ["items", "hardDelete", "attrs", "childWin"]);

        items = param.items = AjxUtil.toArray(param.items);

        // figure out which items should be moved to Trash, and which should actually be deleted
        toMove = [];
        toDelete = [];
        if (items[0] && items[0] instanceof ZmItem) {
            for (i = 0; i < items.length; i += 1) {
                item = items[i];
                folderId = item.getFolderId();
                folder = appCtxt.getById(folderId);
                if (item.type === ZmItem.CONTACT)
                {
                    gr_id = ca_greenrope_contacts.app.getContactGRId(item);
                    if (gr_id > 0)
                    {
                        greenrope._deleteGR(item, folderId);
                    }
                }
                if (param.hardDelete || (folder && folder.isHardDelete())) {
                    toDelete.push(item);
                } else {
                    toMove.push(item);
                }
            }
        } else {
            toMove = items;
        }

        param.callback = param.childWin && new AjxCallback(this._handleDeleteNewWindowResponse, param.childWin);

        // soft delete - items moved to Trash
        if (toMove.length) {
            if (appCtxt.multiAccounts) {
                accounts = this._filterItemsByAccount(toMove);
                if (!param.callback) {
                    param.callback = new AjxCallback(this, this._deleteAccountItems, [accounts, param]);
                }
                this._deleteAccountItems(accounts, param);
            }
            else {
                param.items = toMove;
                param.folder = appCtxt.getById(ZmFolder.ID_TRASH);
                this.moveItems(param);
            }
        }

        // hard delete - items actually deleted from data store
        if (toDelete.length) {
            param.items = toDelete;
            param.action = "delete";
            param.actionText = ZmMsg.actionDelete;
            this._itemAction(param);
        }
    };
};
ca_greenrope_contacts.prototype._deleteGR = function (item, folderId) {
	'use strict';
    var i, j, folder, itemGRid = ca_greenrope_contacts.app.getContactGRId(item),
        itemGRAccID = ca_greenrope_contacts.app.getContactGRAccId(item),
        emptyfunc = function (res) {};
    folderId = parseInt(folderId, 10);
    if (itemGRid > 0)
    {
        if (folderId === ZmOrganizer.ID_ADDRBOOK)
        {
            // check if folder is currently being synced
            for(j = 0; j < this.groups.length; j += 1)
            {
                if (parseInt(this.groups[j].folder.id, 10) === folderId && this.groups[j].selected)
                {
                    // delete it
                    this.grConnection.deleteContact(itemGRid, emptyfunc, {account_id:itemGRAccID});
                    return;
                }
            }

        }
        else
        {
            //find grfolderid and remove it
            for(j = 0; j < this.groups.length; j += 1)
            {
                if (parseInt(this.groups[j].folder.id, 10) === folderId && this.groups[j].selected)
                {
                    this.grConnection.removeContactsFromGroup(this.groups[j].id, [itemGRid], emptyfunc, {account_id:itemGRAccID});
                    return;
                }
            }
        }

    }
};
ca_greenrope_contacts.prototype._createGR = function (attrs) {
	'use strict';
    var con = {};
    con.email = attrs[ZmContact.F_email];
    con.phone = attrs[ZmContact.F_companyPhone];
    con.firstName = attrs[ZmContact.F_firstName];
    con.lastName = attrs[ZmContact.F_lastName];
    con.title = attrs[ZmContact.F_namePrefix];
    con.company = attrs[ZmContact.F_company];
    con.address1 = attrs[ZmContact.F_workStreet];
    con.address2 = attrs[ZmContact.F_workStreet + "2"];
    con.city = attrs[ZmContact.F_workCity];
    con.state = attrs[ZmContact.F_workState];
    con.zip = attrs[ZmContact.F_workPostalCode];
    con.country = attrs[ZmContact.F_workCountry];
    con.mobile = attrs[ZmContact.F_mobilePhone];
    con.fax = attrs[ZmContact.F_workFax];
    con.webSite = attrs[ZmContact.F_workURL];
    this.grConnection.addContact(con,
        new AjxCallback(this, function (attr, res)
        {
            var j, cId, folderId = parseInt(attr.folderId, 10),
                emptyfunc = function (resp) {};
            if (res.ContactID && res.ContactID[0] && res.ContactID[0]._content)
            {
                cId = parseInt(res.ContactID[0]._content, 10);
                for(j = 0; j < this.groups.length; j += 1)
                {
                    if (parseInt(this.groups[j].folder.id, 10) === parseInt(folderId, 10))
                    {
                        this.grConnection.addContactsToGroup(this.groups[j].id, [cId], emptyfunc);
                        return;
                    }
                }

            }
        }, [attrs]));
};
ca_greenrope_contacts.prototype._modifyGR = function (attrs) {
	'use strict';
    var i, newkey, change = false, key, newContact = [];
    if (parseInt(attrs.greenropeid, 10) < 1)
    {
        return;
    }
    if (parseInt(attrs.greenropeid, 10) > 0)
    {
        for(key in attrs)
        {
            if (attrs.hasOwnProperty(key))
            {
                if (key !== 'greenropeid' && key !== 'folderId')
                {
                    newkey = (key === 'namePrefix') ? 'title' : key;
                    newkey = (key === 'companyPhone') ? 'phone' : newkey;
                    newkey = (key === 'workPhone') ? 'phone' : newkey;
                    newkey = (key === 'homePhone') ? 'phone' : newkey;
                    newkey = (key === 'mobilePhone') ? 'mobile' : newkey;
                    newkey = (key === 'workFax') ? 'fax' : newkey;
                    newkey = (key === 'homeFax') ? 'fax' : newkey;
                    newkey = (key === 'URL') ? 'webSite' : newkey;
                    newkey = (key === 'workURL') ? 'webSite' : newkey;
                    newkey = (key === 'workStreet') ? 'address1' : newkey;
                    newkey = (key === 'workStreet2') ? 'address2' : newkey;
                    newkey = (key === 'workCity') ? 'city' : newkey;
                    newkey = (key === 'workState') ? 'state' : newkey;
                    newkey = (key === 'workCountry') ? 'country' : newkey;
                    newkey = (key === 'workPostalCode') ? 'zip' : newkey;
                    newkey = (key === 'homeURL') ? 'webSite' : newkey;
                    newkey = (key === 'homeStreet') ? 'address1' : newkey;
                    newkey = (key === 'homeStreet2') ? 'address2' : newkey;
                    newkey = (key === 'homeCity') ? 'city' : newkey;
                    newkey = (key === 'homeState') ? 'state' : newkey;
                    newkey = (key === 'homeCountry') ? 'country' : newkey;
                    newkey = (key === 'homePostalCode') ? 'zip' : newkey;
                    newContact[newkey] = attrs[key];
                }
            }
        }
        if (change)
        {
            this.grConnection.saveContact(newContact, function (res) {});
        }

    }
};
ca_greenrope_contacts.prototype._moveFolderGR = function (contact) {
	'use strict';
    //debugger;
};

ca_greenrope_contacts.prototype._newAddrBookListener = function (evt) {
	'use strict';
    var i, 
        found, 
        folder;
    if (evt.event === "CREATE" && evt.type === ZmOrganizer.ADDRBOOK)
    {
        folder = evt.getDetail("organizers").pop();
        for (i in this.groups)
        {
            if (this.groups.hasOwnProperty(i))
            {
                if (this.groups[i] && this.groups[i].name === folder.name)
                {
                    this.groups[i].folder = folder;
                }
            }
        }

    }
};
ca_greenrope_contacts.prototype._addSlide = function (contact) {
	'use strict';
    var selectCallback =  new AjxCallback(this, this._handleSlideSelect),
    gr_id = ca_greenrope_contacts.app.getContactGRId(contact),
    gr_acc_id = ca_greenrope_contacts.app.getContactGRAccId(contact);

    this._slide = new EmailToolTipSlide(this._getTooltipBGHtml(), true, "GreenRopeZimletIcon", selectCallback, "GreenRope");
    this.emailZimlet.slideShow.addSlide(this._slide);
    this._slide.setCanvasElement(document.getElementById("greenRopeZimlet_MainDiv"));

    this.clearPopdown();

    this._tooltipTabView = (typeof ZmAttachTabView !== "undefined") ? new ZmAttachTabView(appCtxt.getShell(), null, Dwt.STATIC_STYLE) : new DwtTabView({parent:appCtxt.getShell(), posStyle:Dwt.STATIC_STYLE});
    this._tooltipTabView.reparentHtmlElement(this._slide.canvasElement);

    this._tooltipCRMActivitiesPage = new DwtTabViewPage(this._tooltipTabView);
    this._tooltipCRMEmailsPage = new DwtTabViewPage(this._tooltipTabView);
    this._tooltipCRMWebsitesPage = new DwtTabViewPage(this._tooltipTabView);
    this._tooltipTabView.GRContact = contact;
    this._tooltipTabView.GRId = gr_id;
    this._tooltipTabView.GRAccId = gr_acc_id;
 
    this._tooltipTabView.addStateChangeListener(new AjxListener(this, this.tooltipTabStateChangeListener));

    this._tooltipTabKeys = {};
    this._tooltipTabKeys.activities = this._tooltipTabView.addTab("Activities", this._tooltipCRMActivitiesPage);
    this._tooltipTabKeys.emails = this._tooltipTabView.addTab("Emails", this._tooltipCRMEmailsPage);
    this._tooltipTabKeys.websites = this._tooltipTabView.addTab("Web Visits", this._tooltipCRMWebsitesPage);
    this._tooltipCRMActivitiesPage.setContent("    Loading GreenRope CRM Activity data...");
    this._tooltipCRMEmailsPage.setContent("    Loading GreenRope CRM E-Mail data...");
    this._tooltipCRMWebsitesPage.setContent("    Loading GreenRope CRM Website Visit data...");
    this._tooltipCRMActivitiesPage.setScrollStyle(Dwt.SCROLL);
    this._tooltipCRMEmailsPage.setScrollStyle(Dwt.SCROLL);
    this._tooltipCRMWebsitesPage.setScrollStyle(Dwt.SCROLL);
    this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);

};
ca_greenrope_contacts.prototype.isDescendant = function (par, child) {
    'use strict';
     var node = child.parentNode;
     while (node !== null) {
         if (node === par) {
             return true;
         }
         node = node.parentNode;
     }
     return false;
};

//Clears the popdown from the hover over tooltip
ca_greenrope_contacts.prototype.clearPopdown = function () {
	'use strict';
    if (this._saveHideTimeout) {
        clearTimeout(this._saveHideTimeout);
    }
    if (this.emailZimlet && this.emailZimlet.tooltip) {
        this.emailZimlet.tooltip.setSticky(true);
    }
    if (!this._saveHide)
    {
        this._saveHide = appCtxt._shell.getToolTip().popdown; //DwtControl.hideToolTip;
    }
    appCtxt._shell.getToolTip().popdown = function () {};
};
ca_greenrope_contacts.prototype.restorePopdown = function () {
	'use strict';
    if (this.emailZimlet && this.emailZimlet.tooltip) {
        this.emailZimlet.tooltip.setSticky(false);
    }
    appCtxt._shell.getToolTip().popdown = this._saveHide;
};



ca_greenrope_contacts.prototype.tooltipTabStateChangeListener = function (evt) {
	'use strict';
    var req = "", 
        el, 
        fc, 
        i;
    if ( this._tooltipTabView.GRAccId > 0)
    {
        req += " account_id=\"" + parseInt(this._tooltipTabView.GRAccId, 10) + "\"";
    }
    if ( this._tooltipTabView.GRId > 0)
    {
        req += " contact_id=\"" + parseInt(this._tooltipTabView.GRId, 10) + "\"";
    }
    switch(evt.item.getCurrentTab())
    {
        case 1: // CRM Activities
            el = this._tooltipCRMActivitiesPage.getHtmlElement();
            //create a request to get the CRM Data to put into the element.
            this.clearPopdown();
            try {
                this.grConnection.sendRawRequest("<GetCRMActivitiesRequest" + req + "></GetCRMActivitiesRequest>", new AjxCallback(this, this._updateTooltipViewActivities, {contact:this._tooltipTabView.GRContact, el:el}));
            } catch (e1) {
                this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
            }
            break;
        case 2: // CRM Emails
            el = this._tooltipCRMEmailsPage.getHtmlElement();
            this.clearPopdown();
            try {
                this.grConnection.sendRawRequest("<GetCRMActivitiesEmailsRequest" + req + "></GetCRMActivitiesEmailsRequest>", new AjxCallback(this, this._updateTooltipViewEmails, {contact:this._tooltipTabView.GRContact, el:el}));
            } catch (e2) {
                this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
            }
            break;
        case 3: // CRM Website Visits
            el = this._tooltipCRMWebsitesPage.getHtmlElement();
            this.clearPopdown();
            try {
                this.grConnection.sendRawRequest("<GetCRMActivitiesWebsiteVisitsRequest" + req + "></GetCRMActivitiesWebsiteVisitsRequest>", new AjxCallback(this, this._updateTooltipViewWebsites, {contact:this._tooltipTabView.GRContact, el:el}));
            } catch (e3) {
                this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
            }
            break;
        default: // Error
            this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
    }
        return true;
};
ca_greenrope_contacts.prototype._updateTooltipViewActivities = function (data, res) {
	'use strict';
    var crmactivities = [], 
        tthtml, 
        i, 
        resp, 
        el, 
        fc, 
        temp,
        newW = this.emailZimlet.slideShow.mainDiv.clientWidth,
        newH; // 26 is the default tab height.
    if (res.status === "OK")
    {
        el = this._tooltipCRMActivitiesPage.getHtmlElement();
        fc = el.firstChild;
        while (fc)
        {
            el.removeChild(fc);
            fc = el.firstChild;
        }
        resp = this.parseXML(res.RAWResponse[0]._content);
        if (!resp || (resp.ErrorCode && parseInt(resp.ErrorCode.toString(),10) > 0) || (!resp.CRMActivities || !resp.CRMActivities.CRMActivity))
        {
            tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#ActivitiesFrame", {crmactivities: [], response: {status:"Error", message:"No Entries Found."}});
            data.el.innerHTML = tthtml;
            this._tooltipCRMActivitiesPage.setSize(newW + "px", newH + "px");
            this._slide.select();
            this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
            return false;
        }
        crmactivities = this.is_array(resp.CRMActivities.CRMActivity) ? resp.CRMActivities.CRMActivity : [resp.CRMActivities.CRMActivity];
        for(i = 0; i < crmactivities.length / 2; i += 1)
        {
            temp = crmactivities[i];
            crmactivities[i] = crmactivities[crmactivities.length - i - 1];
            crmactivities[crmactivities.length - i - 1] = temp;
        }
    }
    tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#ActivitiesFrame", {crmactivities: crmactivities, response: res});
    data.el.innerHTML = tthtml;
    this._slide.select();
    newH = this.emailZimlet.slideShow.mainDiv.clientHeight - 26;
    this._tooltipCRMActivitiesPage.setSize(newW + "px", newH + "px");
    this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
};
ca_greenrope_contacts.prototype._updateTooltipViewEmails = function (data, res) {
	'use strict';
    var crmactivities = [], 
        tthtml, 
        i, 
        resp, 
        el, 
        fc, 
        temp,
        newW = this.emailZimlet.slideShow.mainDiv.clientWidth,
        newH; // 26 is the default tab height.
    if (res.status === "OK")
    {
        el = this._tooltipCRMEmailsPage.getHtmlElement();
        fc = el.firstChild;
        while (fc)
        {
            el.removeChild(fc);
            fc = el.firstChild;
        }
        resp = this.parseXML(res.RAWResponse[0]._content);
        if (!resp || (resp.ErrorCode && parseInt(resp.ErrorCode.toString(),10) > 0) || (!resp.SentEmails || !resp.SentEmails.SentEmail))
        {
            tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#EmailsFrame", {crmactivities: [], response: {status:"Error", message:"No Entries Found."}});
            data.el.innerHTML = tthtml;
            this._tooltipCRMEmailsPage.setSize(newW + "px", newH + "px");
            this._slide.select();
            this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
            return false;
        }
        crmactivities = this.is_array(resp.SentEmails.SentEmail) ? resp.SentEmails.SentEmail : [resp.SentEmails.SentEmail];
        for(i = 0; i < crmactivities.length / 2; i += 1)
        {
            temp = crmactivities[i];
            crmactivities[i] = crmactivities[crmactivities.length - i - 1];
            crmactivities[crmactivities.length - i - 1] = temp;
        }
    }
    tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#EmailsFrame", {crmactivities: crmactivities, response: res});
    data.el.innerHTML = tthtml;
    this._slide.select();
    newH = this.emailZimlet.slideShow.mainDiv.clientHeight - 26;
    this._tooltipCRMEmailsPage.setSize(newW + "px", newH + "px");
    this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
};
ca_greenrope_contacts.prototype._updateTooltipViewWebsites = function (data, res) {
	'use strict';
    var crmactivities = [], 
        tthtml, 
        i, 
        resp, 
        el, 
        fc, 
        temp,
        newW = this.emailZimlet.slideShow.mainDiv.clientWidth,
        newH; // 26 is the default tab height.
    if (res.status === "OK")
    {
        el = this._tooltipCRMWebsitesPage.getHtmlElement();
        fc = el.firstChild;
        while (fc)
        {
            el.removeChild(fc);
            fc = el.firstChild;
        }
        resp = this.parseXML(res.RAWResponse[0]._content);
        if (!resp || (resp.ErrorCode && parseInt(resp.ErrorCode.toString(),10) > 0) || (!resp.WebsiteVisits || !resp.WebsiteVisits.WebsiteVisit))
        {
            tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#WebsitesFrame", {crmactivities: [], response: {status:"Error", message:"No Entries Found."}});
            data.el.innerHTML = tthtml;
            this._tooltipCRMWebsitesPage.setSize(newW + "px", newH + "px");
            this._slide.select();
            this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
            return false;
        }
        crmactivities = this.is_array(resp.WebsiteVisits.WebsiteVisit) ? resp.WebsiteVisits.WebsiteVisit : [resp.WebsiteVisits.WebsiteVisit];
        for(i = 0; i < crmactivities.length / 2; i += 1)
        {
            temp = crmactivities[i];
            crmactivities[i] = crmactivities[crmactivities.length - i - 1];
            crmactivities[crmactivities.length - i - 1] = temp;
        }
    }
    tthtml = AjxTemplate.expand("ca_greenrope.templates.ContentView#WebsitesFrame", {crmactivities: crmactivities, response: res});
    data.el.innerHTML = tthtml;
    this._slide.select();
    newH = this.emailZimlet.slideShow.mainDiv.clientHeight - 26;
    this._tooltipCRMWebsitesPage.setSize(newW + "px", newH + "px");
    this._saveHideTimeout = setTimeout(function(){ca_greenrope_contacts.app.restorePopdown();}, 500);
};

ca_greenrope_contacts.prototype._getTooltipBGHtml = function () {
	'use strict';
    return AjxTemplate.expand("ca_greenrope.templates.ToolTip#Loading");
};
ca_greenrope_contacts.prototype._getTooltipContentHtml = function (crmactivities, res) {
	'use strict';
    return AjxTemplate.expand("ca_greenrope.templates.ToolTip#ActivitiesFrame", {crmactivities: crmactivities, response: res});
};

ca_greenrope_contacts.prototype._handleSlideSelect = function () {
	'use strict';
    var el, slideel;
    if (this._slide.loaded) {
        return;
    }
    el = document.getElementById("greenRopeZimlet_MainDiv");
    slideel = document.getElementById(this._slide.id);
    if (el && slideel)
    {
        this._tooltipTabView._pageEl.style.height = "124px";
//        el.style.height = slideel.offsetHeight;
        //var q = this._getDefaultQuery();
        //this._searchLinkedIn(null, null, null, q);
        //this._setSearchFieldValue(q);
        if (this._slide) {
            this._slide.loaded = true;
        }
    }
};
/**
 *  * This method is called by Email Zimlet notifying this Zimlet to add GreenRope slide to the tooltip
 *   */
ca_greenrope_contacts.prototype.onEmailHoverOver = function (emailZimlet) {
	'use strict';
    var contact, 
        i, 
        zmcontact;
        emailZimlet.addSubscriberZimlet(this, false);
        this.emailZimlet = emailZimlet;
        zmcontact = emailZimlet._getActionedContact();
        if (ca_greenrope_contacts.app.getContactGRId(zmcontact) > 0) {
                this._addSlide(zmcontact);
        }
};

//Gets called when the preferences app is loaded.
ca_greenrope_contacts.prototype._prefsApp = function () {
	'use strict';
    var sections, 
        settings = appCtxt.getSettings(), 
        id;
    settings.registerSetting("GR_AUTH_TOKEN",           {name:"zimbraPrefGRAuthToken",  type: ZmSetting.T_COS, dataType: ZmSetting.D_STRING, defaultValue: ""});
    settings.registerSetting("GR_LOGIN",                {name:"zimbraPrefGRLogin",      type: ZmSetting.T_COS, dataType: ZmSetting.D_STRING, defaultValue: appCtxt.getUsername()});
    settings.registerSetting("GR_PASSWORD",             {name:"zimbraPrefGRPassword",   type: ZmSetting.T_COS, dataType: ZmSetting.D_STRING, defaultValue: ""});
    settings.registerSetting("GR_SYNCGROUPS",           {name:"zimbraPrefGRSyncGroups", type: ZmSetting.T_COS, dataType: ZmSetting.D_LIST, defaultValue: []});
    settings.registerSetting("GR_ALLCONTACT_SYNC",      {name:"zimbraPrefGRAllContactSync", type: ZmSetting.T_COS, dataType: ZmSetting.D_STRING, defaultValue: ""});
    appCtxt.set("GR_AUTH_TOKEN", this.getUserProperty("GreenRope_AuthToken"));
    appCtxt.set("GR_LOGIN", this.getUserProperty("GreenRope_AuthLogin"));
    appCtxt.set("GR_ALLCONTACT_SYNC", this.getUserProperty("GreenRope_AllContactSync"));
    sections = {
    GREENROPE: {
        title: "GreenRope",
        icon: "SendReceive",
        templateId: "ca_greenrope.templates.Prefs#GreenRopePrefs",
        priority: 2,
        manageDirty: true,
        prefs: [
            ZmSetting.GR_AUTH_TOKEN,
            ZmSetting.GR_LOGIN,
            ZmSetting.GR_PASSWORD,
            ZmSetting.GR_SYNCGROUPS,
            ZmSetting.GR_ALLCONTACT_SYNC
        ],
        createView: function (parent, section, controller) {
            var zmPage = new ZmPreferencesPage(parent, section, controller);
            zmPage._getTemplateData = function () {
                    var data = {
                            id: this._htmlElId,
                            isEnabled: AjxCallback.simpleClosure(this._isEnabled, this),
                            activeAccount: appCtxt.getActiveAccount()
                    };
                    data.expandField = AjxCallback.simpleClosure(this._expandField, this, data);
                    data.graccounts = ca_greenrope_contacts.app.accountsWithAccess;
                    data.grgroups = ca_greenrope_contacts.app.groups.sort(function (a,b) {
                            var nameA = a.name.toLowerCase(), 
                                nameB = b.name.toLowerCase();
                             if (nameA < nameB) //sort string ascending
                             { return -1; }
                             if (nameA > nameB)
                             { return 1; }
                             return 0; //default return value (no sorting)
                        });
                    return data;
            };
            zmPage.getPreSaveCallback = function () {
                return new AjxCallback(this, function () {
                    var pos, 
                        i, 
                        retval, 
                        grtoken = ca_greenrope_contacts.app.getUserProperty("GreenRope_AuthToken"),
                        changedSettings = this.parent.getChangedPrefs(),
                        that = this,
                        selected_groups = [],
                        el, loginEl, pwEl, tmpLogin, tmpPw;
                    for(i = 0; i < ca_greenrope_contacts.app.groups.length; i += 1) {
                        el = document.getElementById(this.__internalId + "_GR_SYNCGROUPS_"+ca_greenrope_contacts.app.groups[i].account_id + "_" + ca_greenrope_contacts.app.groups[i].id);
                        if (el && el.checked) {
                            selected_groups.push(ca_greenrope_contacts.app.groups[i].account_id + "_" + ca_greenrope_contacts.app.groups[i].id);
                        }
                    }
					loginEl = document.getElementById(this.__internalId + "_GR_LOGIN");
					tmpLogin = (loginEl && loginEl.value && loginEl.value.length > 0) ? loginEl.value : appCtxt.get("GR_LOGIN");
					pwEl = document.getElementById(this.__internalId + "_GR_PASSWORD");
					tmpPw = (pwEl && pwEl.value && pwEl.value.length > 0) ? pwEl.value : appCtxt.get("GR_PASSWORD");
                    ca_greenrope_contacts.app.setUserProperty("GreenRope_SyncGroups", selected_groups.join(","), true);
                    ca_greenrope_contacts.app.setUserProperty("GreenRope_AllContactSync", appCtxt.get("GR_ALLCONTACT_SYNC"), true);

                    appCtxt.set("GR_AUTH_TOKEN", grtoken);

                    if (tmpLogin.length > 0 && tmpPw.length > 0) {
                        ca_greenrope_contacts.app.grConnection.doLogin(
                            tmpLogin,
                            tmpPw,
                            new AjxCallback(ca_greenrope_contacts.app,
                            function (res) {
                                var settings, token, login;
                                if (res.status === "OK") {
                                    token = (res.authToken && res.authToken[0] && res.authToken[0]._content) ? res.authToken[0]._content : '';
                                    login = (res.login && res.login[0] && res.login[0]._content) ? res.login[0]._content : '';
                                    if (token && token !== '') {
                                        this.grConnection.authToken = token;
                                        this.grConnection.login = login;
                                        this.setUserProperty("GreenRope_AuthToken", token, true);
                                        this.setUserProperty("GreenRope_AuthLogin", login, true);
                                        grtoken = token;
                                        appCtxt.set("GR_AUTH_TOKEN", token);
                                        appCtxt.set("GR_LOGIN", login);
                                        if (appCtxt.get("GR_ALLCONTACT_SYNC").length > 0 && !ca_greenrope_contacts.app.getGroupByName(appCtxt.get("GR_ALLCONTACT_SYNC"))) {
                                            //Create the group to sync to
                                            this.grConnection.addGroup({name: appCtxt.get("GR_ALLCONTACT_SYNC"), type: "Private"},
                                                    new AjxCallback(ca_greenrope_contacts.app, function (res) {
                                                        this.getAccountsWithAccess();
                                                    }));
                                        } else {
                                            ca_greenrope_contacts.app.getAccountsWithAccess();
                                        }
                                    }
                                } else {
                                    appCtxt.setStatusMsg({ msg: "Login Failed: " + res.message, level: ZmStatusView.LEVEL_WARNING});
                                    return false;
                                }
                            })
                        );
                    } else if (grtoken && grtoken.length > 0) {
                        if (appCtxt.get("GR_ALLCONTACT_SYNC").length > 0 && !ca_greenrope_contacts.app.getGroupByName(appCtxt.get("GR_ALLCONTACT_SYNC"))) {
                            //Create the group to sync to
                            ca_greenrope_contacts.app.grConnection.addGroup({name: appCtxt.get("GR_ALLCONTACT_SYNC"), type: "Private"},
                                    new AjxCallback(ca_greenrope_contacts.app, function (res) {
                                        this.getAccountsWithAccess();
                                    }));
                        } else {
                            ca_greenrope_contacts.app.getAccountsWithAccess();
                        }

                    }
                    this._controller._doSave();
                    appCtxt.set("GR_AUTH_TOKEN", grtoken);
                    //this.setVisible(false); // hide until ready
                    this.hasRendered = false;
                    this.showMe();
                    return true;
                });
            };
            return zmPage;
        }
    }
    };
    for (id in sections) {
        if (sections.hasOwnProperty(id)) {
            ZmPref.registerPrefSection(id, sections[id]);
        }
    }
    ZmPref.registerPref("GR_AUTH_TOKEN", {
        displayName:        "Auth Token",
        displayContainer:   ZmPref.TYPE_STATIC
    });
    ZmPref.registerPref("GR_LOGIN", {
        displayName:        "Login",
        displayContainer:   ZmPref.TYPE_INPUT
    });
    ZmPref.registerPref("GR_PASSWORD", {
        displayName:        "Password",
        displayContainer:   ZmPref.TYPE_INPUT,
        type: DwtInputField.PASSWORD
    });
    ZmPref.registerPref("GR_SYNCGROUPS", {
        displayName:        "Sync Groups",
        displayContainer:   ZmPref.TYPE_CUSTOM
    });
    ZmPref.registerPref("GR_ALLCONTACT_SYNC", {
        displayName:        "All Contacts Sync",
        displayContainer:   ZmPref.TYPE_INPUT
    });

};
ca_greenrope_contacts.prototype._calUpdate = function (data, res) {
	'use strict';
    var link = "", i,
        folderTree = appCtxt.getFolderTree(),
        cals = folderTree.getByType(ZmOrganizer.CALENDAR),
        group = this.getGroup(data.group_id),
        cal, folder;
    if (res.status === "OK") {
        link = "webcal://" + res.Link[0]._content;
        i = cals.length;
        while (i) {
            i-=1;
            if (cals[i].name === group.name + " Calendar") {
                cal = cals[i];
                break;
            }
        }
        if (!cal) {
            //create new calendar with the link
            folder = {
                name: group.name + " Calendar",
                url: link
            };
            this.createCal(folder);
        }
    }
};
ca_greenrope_contacts.prototype.createCal = function (params) {
	'use strict';
    var jsonObj, folder, req, type, callback_func, errorCallback_func, callback, errorCallback, value, i;
    jsonObj = {CreateFolderRequest:{_jsns:"urn:zimbraMail"}};
    folder = jsonObj.CreateFolderRequest.folder = {};
    req = {
//          account: null,
            name: params.name,
            f: "#",
            l: 1,
//          view: "appointment"
            type: "CALENDAR",
            url: params.url
    };
    type = req.type;
    callback_func = function (req, ex) {
        var resp = ex.getResponse(),
            folderResp = resp.CreateFolderResponse || {},
            folders = folderResp.folder || {},
            folder = folders[0] || {},
            id = folder.id || false,
            newFolder;
        if (!id) { return false; }
        newFolder = new ZmCalendar(folder);
        appCtxt.cacheSet(id, newFolder);
        appCtxt.getFolderTree().root.notifyCreate(folder);
        params.folderId = id;
        return true;
    };
    errorCallback_func = function (req, ex) {
        var msg;
        if (req.url && (ex.code === ZmCsfeException.SVC_PARSE_ERROR)) {
            msg = AjxMessageFormat.format(ZmMsg.calFeedInvalid, req.url);
            ZmOrganizer._showErrorMsg(msg);
            return true;
        }
        return ZmOrganizer._handleErrorCreate(req, ex);
    };

    callback = new AjxCallback(this, callback_func, req);
    errorCallback = new AjxCallback(null, errorCallback_func, req);

    // set attributes
    req.view = req.view || ZmOrganizer.VIEWS[type] ? ZmOrganizer.VIEWS[type][0] : null;
    for (i in req) {
        if (req.hasOwnProperty(i))
        {
            if (i !== "type" && i !== "errorCallback" && i !== "account") {

                value = req[i];
                if (i === "color") {
                    // no need to save color if missing or default
                    if (!value || (value === ZmOrganizer.DEFAULT_COLOR[type])) {
                        value = null;
                    }
                }
                if (value) {
                    folder[i] = value;
                }
            }
        }
    }

    return appCtxt.getAppController().sendRequest({
            jsonObj: jsonObj,
            asyncMode: true,
            accountName: (req.account && req.account.name),
            callback: callback,
            errorCallback: errorCallback
            });
};
ca_greenrope_contacts.prototype.updateCal = function (account_id, group_id) {
	'use strict';
    this.grConnection.getCalendarICSLink(
            group_id,
            this.getUserProperty("GreenRope_AuthLogin"),
            new AjxCallback(this, this._calUpdate, {account_id: account_id, group_id: group_id})
    );
};
//Gets called when the address book app is loaded.
ca_greenrope_contacts.prototype._abookApp = function () {
	'use strict';
    /**
     * @private
     */
    ZmEditContactView.prototype.__initRowsOther =
    function (nattrs,id,prefixes,onlyvalue,listAttrs) {
        var arr, attributes = {}, attrId, listId, i, j, aname, list, prefix, suffix, anameNormalized;
        arr = this.__initRowsControl.call(this,nattrs,id,prefixes,onlyvalue,listAttrs,true);
        // gather attributes we know about
        for (attrId in ZmEditContactView.ATTRS) {
            if (ZmEditContactView.ATTRS.hasOwnProperty(attrId))
            {
                attributes[ZmEditContactView.ATTRS[attrId]] = true;
            }
        }
        for (listId in ZmEditContactView.LISTS) {
            if (ZmEditContactView.LISTS.hasOwnProperty(listId))
            {
                list = ZmEditContactView.LISTS[listId];
                if (list.attrs)
                {
                    for (i = 0; i < list.attrs.length; i += 1) {
                        attributes[list.attrs[i]] = true;
                    }
                }
            }
        }
        for (i = 0; i < ZmEditContactView.ADDR_PREFIXES.length; i += 1) {
            prefix = ZmEditContactView.ADDR_PREFIXES[i];
            for (j = 0; j < ZmEditContactView.ADDR_SUFFIXES.length; j += 1) {
                suffix = ZmEditContactView.ADDR_SUFFIXES[j];
                attributes[prefix+suffix] = true;
            }
        }

        // add attributes on contact that we don't know about
        for (aname in nattrs) {
            if (nattrs.hasOwnProperty(aname))
            {
                anameNormalized = aname.replace(/\d+$/,"");
                if (!ZmContact.IS_IGNORE[anameNormalized]) {
                    if (!attributes.hasOwnProperty(anameNormalized) && anameNormalized.toLowerCase() !== "greenropeid" && anameNormalized.toLowerCase() !== "graccountid") {
                        arr.push({type:anameNormalized,value:nattrs[aname]});
                        if (!listAttrs[id]) { listAttrs[id] = []; }
                        listAttrs[id].push(aname);
                    }
                }
            }
        }

        this.setValue(id, arr);
    };
};
ca_greenrope_contacts.prototype.parseXML = function (xmlStr) {
	'use strict';
    return AjxXmlDoc.createFromXml(xmlStr).toJSObject();
};
ca_greenrope_contacts.prototype.is_array = function (input) {
	'use strict';
        return (typeof(input) === 'object') && (input instanceof Array);
};
ca_greenrope_contacts.prototype._zimbraApp = function () {
	'use strict';
    ZmAddressBubble.prototype._createHtml = function (params) {

        var el = this.getHtmlElement(),
            addr = params.email || params.address;
        el.innerHTML = ZmAddressBubble.getContent(params);
        if (params.parentId) {
            el._aifId = params.parentId;
        }
        //Check if GreenRope address
        if (ca_greenrope_contacts.app.isGreenRope(addr))
        {
            el.className += " greenRopeAddr";
        }
    };
    EmailTooltipZimlet.prototype.getClassName = function (obj, context, spanId) {
        if (this._isBubble[spanId])
        {
            return this._bubbleClassName;
        }
        if (ca_greenrope_contacts.app.isGreenRope(obj))
        {
            return "Object greenRopeAddr";
        }
        return ZmObjectHandler.prototype.getClassName.apply(this, arguments);
    };
};
//new ca_greenrope_contacts();

