function GR_SoapResponseHandler(con, conCB, userCB)
{
	this.connection = con;
	this.conCB      = conCB;
	this.userCB     = userCB;
}

GR_SoapResponseHandler.prototype.applySoapResponse = function(res)
{
	var e;
	var response = res.getResponse().GRAPIResponse;

	try
	{
		console.log("Get GR Response:");
		console.log( response );
	}
	catch(e)
	{}

	if( this.conCB )
	{
		this.conCB.call(this.connection, response);
	}

	if( this.userCB )
	{
		if(this.userCB instanceof AjxCallback)
		{
			this.userCB.run( response );
		}
		else
		{
			this.userCB( response );
		}
	}
};

function GR_Connection()
{
	this.authToken = '';
	this.login     = '';
	this.saaID     = 0; // Shared Access Acount ID
	this.login = '';
	/*
	this.login     = 'alexz@tcgsi.com';
	this.authToken = '6fc38ead9bfe7eacc151026786764331d6ba717121e532b2e10595392c869e25';
	this.saaID     = 31608;
*/
}

GR_Connection.prototype = new ZmZimletBase();
GR_Connection.prototype.nodeText = function(n, subNodeName)
{
	var sn = n[subNodeName];
	if(! sn)
	{
		return '';
	}
	sn = sn[0];
	if(! sn)
	{
		return '';
	}
	if(! sn._content)
	{
		return '';
	}

	return sn._content;
};

GR_Connection.prototype.soapDoc = function(name, withAuthToken)
{
	var doc = AjxSoapDoc.create(name, 'gr:api');
	if( withAuthToken )
	{
		doc.set('Login',     this.login);
		doc.set('AuthToken', this.authToken);
	}
	if( this.saaID )
	{
		doc.set('SAAID', this.saaID);
	}
	return doc;
};

GR_Connection.prototype.doSoapCall = function(doc, conCB, userCB)
{
	var resHandler = new GR_SoapResponseHandler(this, conCB, userCB);

	var params =
	{
		soapDoc: doc,
		asyncMode: true,
		noBusyOverlay: true,
		callback: new AjxCallback(resHandler, resHandler.applySoapResponse),
		errorCallback: new AjxCallback(this, this.soapResponseError)
	};

	appCtxt.getAppController().sendRequest( params );
};

GR_Connection.prototype.addSearchExpr = function(doc, sExpr)
{
	if(typeof sExpr == 'object')
	{
		var k;
		for(k in sExpr)
		{
			var l = doc.set('Like', sExpr[k]);
			l.setAttribute('key', k);
		}
	}
};

GR_Connection.prototype.isSuccess = function(res)
{
	return (res.status == "OK");
};

GR_Connection.prototype.onGetAuthToken = function(res)
{
	if( this.isSuccess(res) )
	{
		this.login     = res.login[0]._content;
		this.authToken = res.authToken[0]._content;
//		ca_greenrope_contacts.app.getGroups();
	}
};

GR_Connection.prototype.doLogin = function(login, pswd, cb)
{
	var doc = this.soapDoc('GetAuthToken', false);
	doc.set('login', login);
	doc.set('password', pswd);
	this.doSoapCall(doc, this.onGetAuthToken, cb);
};

GR_Connection.prototype.sendRawRequest = function(xml, cb)
{
	var doc = this.soapDoc('RAWRequest', true);
	doc.set('request', xml);
	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.getAccountAccessInfo = function(cb)
{
	var doc = this.soapDoc('GetAccountAccessInfo', true);
	this.doSoapCall(doc, false, cb);
};
GR_Connection.prototype.parseAccountAccessInfo = function(res)
{
	var i, a, gn, go, j, p;
	var aai = new Object();
	aai.accounts = new Array();
	aai.groups   = new Array();

	var accounts = res.Accounts[0].Account;
	for(i=0; i<accounts.length; i++)
	{
		a = accounts[i];
		aai.accounts[aai.accounts.length] = {id: a.id, isOwner: (a.isOwner=='Y')};
	}

	var groups = res.Groups[0].Group;
	for(i=0; i<groups.length; i++)
	{
		gn = groups[i];
		go = {id: gn.id, name: gn.name, permissions: new Object()};

		var permissions = gn.permission;
		for(j=0; j<permissions.length; j++)
		{
			p = permissions[j];
			go.permissions[p.name] = (p.value == 'Y');
		}

		aai.groups[aai.groups.length] = go;
	}

	return aai;
};


GR_Connection.prototype.getContacts = function(cb, sExpr)
{
	var doc = this.soapDoc('GetContacts', true);
	this.addSearchExpr(doc, sExpr);
	this.doSoapCall(doc, false, cb);
};
GR_Connection.prototype.parseContactsResponse = function( res )
{
	var ret = new Array(), i, c, groups, j, g;
	var contacts = res.Contacts[0].Contact;
	for(i=0; i<contacts.length; i++)
	{
		c = contacts[i];
		ret[i] = new GR_Contact()
		idx = i+1;
		ret[i].id        = this.nodeText(c, "ID");
		ret[i].firstName = this.nodeText(c, "FirstName");
		ret[i].lastName  = this.nodeText(c, "LastName");
		ret[i].title     = this.nodeText(c, "Title");
		ret[i].company   = this.nodeText(c, "Company");
		ret[i].address1  = this.nodeText(c, "Address1");
		ret[i].address2  = this.nodeText(c, "Address2");
		ret[i].city      = this.nodeText(c, "City");
		ret[i].state     = this.nodeText(c, "State");
		ret[i].zip       = this.nodeText(c, "Zip");
		ret[i].country   = this.nodeText(c, "Country");
		ret[i].phone     = this.nodeText(c, "Phone");
		ret[i].mobile    = this.nodeText(c, "Mobile");
		ret[i].fax       = this.nodeText(c, "Fax");
		ret[i].webSite   = this.nodeText(c, "WebSite");
		ret[i].email     = this.nodeText(c, "Email");

		groups = c.Groups[0].Group;
		if( groups )
		{
			for(j=0; j<groups.length; j++)
			{
				g = groups[j];
				ret[i].groups[j] =
				{
					id: this.nodeText(g, "ID"),
					type: this.nodeText(g, "Type"),
					name: this.nodeText(g, "Name")
				}
			}
		}
	}

	return ret;
};


GR_Connection.prototype.addContact = function(con, cb)
{
	var doc = this.soapDoc('AddContact', true);

	var conNode = doc.set
	(
		"Contact",
		{
			Email:     con.email,
			FirstName: con.firstName,
			LastName:  con.lastName,
			Title:     con.title,
			Company:   con.company,
			Address1:  con.address1,
			Address2:  con.address2,
			City:      con.city,
			State:     con.state,
			Zip:       con.zip,
			Country:   con.country,
			Phone:     con.phone,
			Mobile:    con.mobile,
			Fax:       con.fax,
			WebSite:   con.webSite
		}
	);

	if(con.groups && con.groups.length>0)
	{
		var grpsNode = doc.set("Groups", "", conNode);
		for(var i=0; i<con.groups.length; i++)
		{
			doc.set("Group", con.groups[i], grpsNode);
		}
	}

	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.saveContact = function(con, cb)
{
	var doc = this.soapDoc('SaveContact', true);

	doc.set
	(
		"Contact",
		{
			ID:        con.id,
			Email:     con.email,
			FirstName: con.firstName,
			LastName:  con.lastName,
			Title:     con.title,
			Company:   con.company,
			Address1:  con.address1,
			Address2:  con.address2,
			City:      con.city,
			State:     con.state,
			Zip:       con.zip,
			Country:   con.country,
			Phone:     con.phone,
			Mobile:    con.mobile,
			Fax:       con.fax,
			WebSite:   con.webSite
		}
	);

	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.deleteContact = function(cid, cb)
{
	var doc = this.soapDoc('DeleteContact', true);
	doc.set("ContactID", cid);
	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.getGroups = function(cb)
{
	var doc = this.soapDoc('GetGroups', true);
	this.doSoapCall(doc, false, cb);
};
GR_Connection.prototype.parseGroupsResponse = function( res )
{
	var ret = new Array(), i, g;
	var groups = res.Groups[0].Group;
	for(i=0; i<groups.length; i++)
	{
		g = groups[i];
		ret[ret.length] = 
		{
			idx: i+1,
			id: this.nodeText(g, "ID"),
			type: this.nodeText(g, "Type"),
			name: this.nodeText(g, "Name")
		}
	}
	return ret;
};

GR_Connection.prototype.addGroup = function(grp, cb)
{
	var doc = this.soapDoc('AddGroup', true);

	doc.set
	(
		"Group",
		{
			Type: grp.type,
			Name: grp.name
		}
	);

	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.setGroupInfo = function(doc, gInfo)
{
	if(typeof gInfo.id != 'undefined')
	{
		doc.set("GroupID", gInfo.id);
	}
	if(typeof gInfo.name != 'undefined')
	{
		doc.set("GroupName", gInfo.name);
	}
};

GR_Connection.prototype.addRemoveContactsGroup = function(requestName, gInfo, cIdOrCids, cb)
{
	var doc = this.soapDoc(requestName, true);
	var cIds, i;

	if(cIdOrCids instanceof Array)
	{
		cIds = cIdOrCids;
	}
	else
	{
		cIds = [cIdOrCids];
	}

	this.setGroupInfo(doc, gInfo);

	var contacts = doc.set("Contacts");
	for(i=0; i<cIds.length; i++)
	{
		doc.set("ContactID", cIds[i], contacts);
	}

	this.doSoapCall(doc, false, cb);

};

GR_Connection.prototype.addContactsToGroup = function(gInfo, cIdOrCids, cb)
{
	this.addRemoveContactsGroup('AddContactsToGroup', gInfo, cIdOrCids, cb);
};
GR_Connection.prototype.removeContactsFromGroup = function(gInfo, cIdOrCids, cb)
{
	this.addRemoveContactsGroup('RemoveContactsFromGroup', gInfo, cIdOrCids, cb);
};

GR_Connection.prototype.deleteGroup = function(gInfo, cb)
{
	var doc = this.soapDoc('DeleteGroup', true);
	this.setGroupInfo(doc, gInfo);
	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.addCRMActivity = function(crm, cb)
{
	var doc = this.soapDoc('AddCRMActivity', true);

	doc.set('ContactID',       crm.contactId);
	doc.set('DoneByContactID', crm.doneByContactId);
	doc.set('GroupID',         crm.groupId);
	doc.set('Date',            crm.date);
	doc.set('Due',             crm.due);
	doc.set('Activity',        crm.activity);
	doc.set('Notes',           crm.notes);

	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.getCRMActivities = function(cb, sExpr)
{
	var doc = this.soapDoc('GetCRMActivities', true);
	this.addSearchExpr(doc, sExpr);
	this.doSoapCall(doc, false, cb);
};
GR_Connection.prototype.parseCRMActivities = function( res )
{
	var crms = new Array(), i, crm;
	var xmlCRMs = res.CRMActivities[0].CRMActivity;
	if( xmlCRMs )
	{
		for(i=0; i<xmlCRMs.length; i++)
		{
			crm = xmlCRMs[i];
			crms[i] = new GR_CRMActivity();

			crms[i].id               = this.nodeText(crm, "ID");
			crms[i].contactId        = this.nodeText(crm, "ContactID");
			crms[i].contactFirstName = this.nodeText(crm, "ContactFirstName");
			crms[i].contactLastName  = this.nodeText(crm, "ContactLastName");
			crms[i].doneByContactId  = this.nodeText(crm, "DoneByContactID");
			crms[i].groupId          = this.nodeText(crm, "GroupID");
			crms[i].groupName        = this.nodeText(crm, "GroupName");
			crms[i].date             = this.nodeText(crm, "Date");
			crms[i].due              = this.nodeText(crm, "Due");
			crms[i].activity         = this.nodeText(crm, "Activity");
			crms[i].notes            = this.nodeText(crm, "Notes");
		}
	}
	return crms;
};
GR_Connection.prototype.deleteCRMActivity = function(aid, cb)
{
	var doc = this.soapDoc('DeleteCRMActivity', true);
	doc.set('CRMActivityID', aid);
	this.doSoapCall(doc, false, cb);
};

GR_Connection.prototype.getCalendarICSLink = function(groupId, email, cb)
{
	var doc = this.soapDoc('GetCalendarIcsLink', true);
	doc.set('GroupID', groupId);
	doc.set('Email',   email);
	this.doSoapCall(doc, false, cb);
};


GR_Connection.prototype.uploadMedia = function(media, cb)
{
	var doc = this.soapDoc('UploadMedia', true);

	doc.set('GUID',        media.guid);
	doc.set('Type',        media.type);
	doc.set('Folder',      media.folder);
	doc.set('Description', media.description);

	this.doSoapCall(doc, false, cb);
}

GR_Connection.prototype.syncContacts = function(info, cb)
{
	var doc = this.soapDoc('SyncContacts', true);
	this.setGroupInfo(doc, info);
	if((! this.saaID) && (info.accountId))
	{
		doc.set('SAAID', info.accountId);
	}

	this.doSoapCall(doc, false, cb);
}
