/*
 * Decompiled with CFR 0.152.
 */
package com.gr.zimbra;

import com.gr.Logger;
import com.gr.api.Connection;
import com.gr.api.Contact;
import com.gr.api.GRAPIException;
import com.gr.api.Group;
import com.gr.api.ObjectKey;
import com.gr.api.SearchObject;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class GRDocumentHandler
extends DocumentHandler {
    protected Map<String, Object> m_context;

    public Element createOK(ZimbraSoapContext zimbraSoapContext) {
        Element element = zimbraSoapContext.createElement(QName.get((String)"GRAPIResponse", (Namespace)Namespace.get((String)"gr:api")));
        element.addAttribute("status", "OK");
        return element;
    }

    public Element createError(ZimbraSoapContext zimbraSoapContext, GRAPIException gRAPIException) {
        Element element = zimbraSoapContext.createElement(QName.get((String)"GRAPIResponse", (Namespace)Namespace.get((String)"gr:api")));
        element.addAttribute("status", "ERROR");
        element.addAttribute("code", gRAPIException.code());
        element.addAttribute("message", gRAPIException.text());
        return element;
    }

    public Connection grConnection(Element element) throws ServiceException {
        Connection connection = new Connection(element.getElement("Login").getText(), element.getElement("AuthToken").getText());
        Element element2 = element.getOptionalElement("SAAID");
        if (null != element2) {
            connection.setSAAID(element2.getText());
        }
        return connection;
    }

    public Contact getContact(Element element) throws ServiceException {
        Element element2 = element.getOptionalElement("ID");
        Contact contact = new Contact();
        if (null != element2) {
            contact.setId(element2.getText());
        }
        contact.setEmail(element.getElement("Email").getText());
        contact.setFirstName(element.getElement("FirstName").getText());
        contact.setLastName(element.getElement("LastName").getText());
        contact.setTitle(element.getElement("Title").getText());
        contact.setCompany(element.getElement("Company").getText());
        contact.setAddress1(element.getElement("Address1").getText());
        contact.setAddress2(element.getElement("Address2").getText());
        contact.setCity(element.getElement("City").getText());
        contact.setState(element.getElement("State").getText());
        contact.setZip(element.getElement("Zip").getText());
        contact.setCountry(element.getElement("Country").getText());
        contact.setPhone(element.getElement("Phone").getText());
        contact.setMobile(element.getElement("Mobile").getText());
        contact.setFax(element.getElement("Fax").getText());
        contact.setWebSite(element.getElement("WebSite").getText());
        Element element3 = element.getOptionalElement("Groups");
        if (null != element3) {
            for (Element element4 : element3.listElements("Group")) {
                contact.groups().addWithName(element4.getText());
            }
        }
        return contact;
    }

    public Group getGroup(Element element) throws ServiceException {
        Element element2 = element.getOptionalElement("ID");
        Group group = new Group();
        if (null != element2) {
            group.setId(element2.getText());
        }
        group.setType(element.getElement("Type").getText());
        group.setName(element.getElement("Name").getText());
        return group;
    }

    public SearchObject getSearchObject(Element element) throws ServiceException {
        SearchObject searchObject = new SearchObject();
        for (Element element2 : element.listElements("Like")) {
            searchObject.put(element2.getAttribute("key"), element2.getText());
        }
        return searchObject;
    }

    public ObjectKey getGroupKey(Element element) throws ServiceException {
        ObjectKey objectKey = new ObjectKey();
        Element element2 = element.getOptionalElement("GroupName");
        if (null != element2) {
            objectKey.name = element2.getText();
        }
        if (null != (element2 = element.getOptionalElement("GroupID"))) {
            objectKey.id = element2.getText();
        }
        return objectKey;
    }

    public abstract Element grHandle(Element var1, ZimbraSoapContext var2) throws GRAPIException, ServiceException;

    public Element handle(Element element, Map<String, Object> map) throws ServiceException {
        Element element2 = null;
        this.m_context = map;
        ZimbraSoapContext zimbraSoapContext = GRDocumentHandler.getZimbraSoapContext(this.m_context);
        try {
            Logger.debug("Got SOAP Request: " + element.toString());
            element2 = this.grHandle(element, zimbraSoapContext);
        }
        catch (GRAPIException gRAPIException) {
            if (gRAPIException.isSystem()) {
                throw ServiceException.FAILURE((String)"Can't process GreenRope SOAP call", (Throwable)gRAPIException.src());
            }
            element2 = this.createError(zimbraSoapContext, gRAPIException);
        }
        Logger.debug("Send SOAP Response: " + element2.toString());
        this.m_context = null;
        return element2;
    }
}

