/*
 * Decompiled with CFR 0.152.
 */
package com.gr.api;

import com.gr.Logger;
import com.gr.api.AccountAccessInfo;
import com.gr.api.CRMActivities;
import com.gr.api.CRMActivity;
import com.gr.api.Contact;
import com.gr.api.ContactList;
import com.gr.api.GRAPIException;
import com.gr.api.Group;
import com.gr.api.GroupList;
import com.gr.api.IDList;
import com.gr.api.ObjectKey;
import com.gr.api.SearchObject;
import com.gr.lib;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class Connection {
    protected String m_authToken;
    protected String m_login;
    protected String m_saaID;
    protected String m_forseResponse;

    public Connection() {
        this.m_authToken = "";
        this.m_login = "";
        this.m_saaID = null;
        this.m_forseResponse = "";
    }

    public Connection(String string, String string2) {
        this.m_authToken = string2;
        this.m_login = string;
        this.m_saaID = null;
        this.m_forseResponse = "";
    }

    public String authToken() {
        return this.m_authToken;
    }

    public String login() {
        return this.m_login;
    }

    public void setSAAID(String string) {
        this.m_saaID = string;
    }

    public String saaID() {
        return this.m_saaID;
    }

    public String sendPost(String string, TreeMap<String, String> treeMap) throws Exception {
        String string2;
        String string3 = "";
        String string4 = "";
        for (Map.Entry<String, String> object2 : treeMap.entrySet()) {
            if (string3.length() > 0) {
                string3 = string3 + "&";
            }
            string3 = string3 + URLEncoder.encode(object2.getKey(), "UTF-8");
            string3 = string3 + "=";
            string3 = string3 + URLEncoder.encode(object2.getValue(), "UTF-8");
        }
        Logger.debug("Send POST to '" + string + "': " + string3);
        URLConnection uRLConnection = new URL(string).openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(string3);
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            string4 = string4 + string2;
        }
        Logger.debug("Got Response: " + string4);
        if (this.m_forseResponse.length() > 0) {
            string4 = this.m_forseResponse;
            Logger.debug("Forse Response: " + string4);
        }
        return string4;
    }

    public void verifyResponse(Element element) throws GRAPIException {
        String string = lib.xmlChildText(element, "Result");
        if (!string.equals("Success")) {
            GRAPIException.raise(lib.xmlChildText(element, "ErrorCode"), lib.xmlChildText(element, "ErrorText"));
        }
    }

    public String sendRawRequest(String string) throws GRAPIException {
        String string2 = "";
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Logger.debug("Request XML: " + string);
        treeMap.put("email", this.m_login);
        treeMap.put("auth_token", this.m_authToken);
        treeMap.put("xml", string);
        try {
            string2 = this.sendPost("http://app.greenrope.com/xml.pl", treeMap);
        }
        catch (Exception exception) {
            Logger.error("Can't send request to GR API: " + exception, exception);
            GRAPIException.raise(exception);
        }
        return string2;
    }

    public Element sendRequest(String string, boolean bl) throws GRAPIException {
        Element element = null;
        try {
            element = lib.parseXML(this.sendRawRequest(string)).getDocumentElement();
            if (bl) {
                this.verifyResponse(element);
            }
        }
        catch (GRAPIException gRAPIException) {
            throw gRAPIException;
        }
        catch (Exception exception) {
            Logger.error("Can't get auth token: " + exception, exception);
            GRAPIException.raise(exception);
        }
        return element;
    }

    public String getAuthToken(String string, String string2) throws GRAPIException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("email", string);
        treeMap.put("password", string2);
        treeMap.put("xml", "<GetAuthTokenRequest></GetAuthTokenRequest>");
        try {
            Element element = lib.parseXML(this.sendPost("http://app.greenrope.com/xml.pl", treeMap)).getDocumentElement();
            this.verifyResponse(element);
            this.m_authToken = lib.xmlChildText(element, "Token");
        }
        catch (GRAPIException gRAPIException) {
            throw gRAPIException;
        }
        catch (Exception exception) {
            Logger.error("Can't get auth token: " + exception, exception);
            GRAPIException.raise(exception);
        }
        this.m_login = string;
        return this.m_authToken;
    }

    public String appendSearchExpr(String string, SearchObject searchObject) {
        if (null != searchObject) {
            for (String string2 : searchObject.keySet()) {
                string = string + " " + lib.xmlAttr(string2, (String)searchObject.get(string2));
            }
        }
        return string;
    }

    public String xmlGroupKey(ObjectKey objectKey) {
        if (null != objectKey.id) {
            return lib.xmlAttr("group_id", objectKey.id);
        }
        if (null != objectKey.name) {
            return lib.xmlAttr("group_name", objectKey.name);
        }
        return null;
    }

    public AccountAccessInfo getAccountAccessInfo() throws GRAPIException {
        AccountAccessInfo accountAccessInfo = new AccountAccessInfo();
        Element element = this.sendRequest("<GetAccountsWithAccessRequest></GetAccountsWithAccessRequest>", false);
        accountAccessInfo.load(element);
        return accountAccessInfo;
    }

    public ContactList getContacts(SearchObject searchObject) throws GRAPIException {
        ContactList contactList = new ContactList();
        String string = "<GetContactsRequest";
        if (null != this.m_saaID) {
            string = string + lib.xmlAttr(" account_id", this.m_saaID);
        }
        string = this.appendSearchExpr(string, searchObject);
        string = string + "></GetContactsRequest>";
        Element element = this.sendRequest(string, true);
        contactList.tryLoad(lib.xmlChild(element, "Contacts"));
        return contactList;
    }

    public void addContact(Contact contact) throws GRAPIException {
        String string = "<AddContactsRequest>";
        string = string + "<Contacts>";
        string = string + "<Contact";
        if (null != this.m_saaID) {
            string = string + lib.xmlAttr(" account_id", this.m_saaID);
        }
        string = string + ">";
        string = string + contact.getFieldsAsXML();
        string = string + "</Contact>";
        string = string + "</Contacts>";
        string = string + "</AddContactsRequest>";
        Element element = this.sendRequest(string, true);
        contact.setId(lib.xmlChildText(element, "Contact_id"));
    }

    public void saveContact(Contact contact) throws GRAPIException {
        String string = "<EditContactsRequest>";
        string = string + "<Contacts>";
        string = string + "<Contact contact_id=\"" + contact.id() + "\">";
        string = string + contact.getFieldsAsXML();
        string = string + "</Contact>";
        string = string + "</Contacts>";
        string = string + "</EditContactsRequest>";
        this.sendRequest(string, true);
    }

    public void deleteContact(String string) throws GRAPIException {
        String string2 = "<DeleteContactsRequest><Contacts><Contact";
        if (null != this.m_saaID) {
            string2 = string2 + lib.xmlAttr(" account_id", this.m_saaID);
        }
        string2 = string2 + lib.xmlAttr(" contact_id", string);
        string2 = string2 + "/></Contacts></DeleteContactsRequest>";
        this.sendRequest(string2, true);
    }

    public GroupList getGroups() throws GRAPIException {
        GroupList groupList = new GroupList();
        String string = "<GetGroupsRequest";
        if (null != this.m_saaID) {
            string = string + lib.xmlAttr(" account_id", this.m_saaID);
        }
        string = string + "></GetGroupsRequest>";
        Element element = this.sendRequest(string, true);
        groupList.tryLoad(lib.xmlChild(element, "Groups"));
        return groupList;
    }

    public void addGroup(Group group) throws GRAPIException {
        String string = "<CreateGroupRequest>";
        string = string + group.getFieldsAsXML();
        string = string + "</CreateGroupRequest>";
        this.sendRequest(string, true);
    }

    public void addContactsToGroup(ObjectKey objectKey, IDList iDList) throws GRAPIException {
        String string = "<AddContactsToGroupRequest " + this.xmlGroupKey(objectKey) + ">";
        string = string + "<Contacts>";
        for (String string2 : iDList) {
            string = string + "<Contact contact_id=\"" + string2 + "\" />";
        }
        string = string + "</Contacts>";
        string = string + "</AddContactsToGroupRequest>";
        this.sendRequest(string, true);
    }

    public void removeContactsFromGroup(ObjectKey objectKey, IDList iDList) throws GRAPIException {
        String string = "<DeleteContactsFromGroupRequest " + this.xmlGroupKey(objectKey) + ">";
        string = string + "<Contacts>";
        for (String string2 : iDList) {
            string = string + "<Contact contact_id=\"" + string2 + "\" />";
        }
        string = string + "</Contacts>";
        string = string + "</DeleteContactsFromGroupRequest>";
        this.sendRequest(string, true);
    }

    public void deleteGroup(ObjectKey objectKey) throws GRAPIException {
        String string = "<DeleteGroupsRequest><Groups>";
        string = string + "<Group " + this.xmlGroupKey(objectKey) + " />";
        string = string + "</Groups></DeleteGroupsRequest>";
        this.sendRequest(string, true);
    }

    public void addCRMActivity(CRMActivity cRMActivity) throws GRAPIException {
        String string = "<AddCRMActivitiesRequest>";
        string = string + "<CRMActivities>";
        string = string + "<CRMActivity>";
        string = string + cRMActivity.getFieldsAsXML();
        string = string + "</CRMActivity>";
        string = string + "</CRMActivities>";
        string = string + "</AddCRMActivitiesRequest>";
        Element element = this.sendRequest(string, true);
        cRMActivity.setId(lib.xmlChildText(element, "Activity_id"));
    }

    public CRMActivities getCRMActivities(SearchObject searchObject) throws GRAPIException {
        CRMActivities cRMActivities = new CRMActivities();
        String string = "<GetCRMActivitiesRequest";
        string = this.appendSearchExpr(string, searchObject);
        string = string + "></GetCRMActivitiesRequest>";
        Element element = this.sendRequest(string, true);
        cRMActivities.tryLoad(lib.xmlChild(element, "CRMActivities"));
        return cRMActivities;
    }

    public void deleteCRMActivity(String string) throws GRAPIException {
        this.sendRequest("<DeleteCRMActivitiesRequest><CRMActivities><CRMActivity activity_id=\"" + string + "\" /></CRMActivities></DeleteCRMActivitiesRequest>", true);
    }

    public String getCalendarIcsLink(String string, String string2) throws GRAPIException {
        String string3 = "<GetCalendarIcsLinkRequest";
        string3 = string3 + lib.xmlAttr(" group_id", string);
        string3 = string3 + lib.xmlAttr(" user_email", string2);
        string3 = string3 + "></GetCalendarIcsLinkRequest>";
        Element element = this.sendRequest(string3, true);
        return lib.xmlChildText(element, "IcsURL").trim();
    }

    public void uploadMedia(String string, String string2, String string3, String string4, String string5) throws GRAPIException {
        String string6 = "<UploadMediaRequest>";
        string6 = string6 + lib.node("Type", string);
        string6 = string6 + lib.node("MediaFolder", string2);
        string6 = string6 + lib.node("Filename", string3);
        string6 = string6 + lib.node("Content", string4);
        string6 = string6 + lib.node("Description", string5);
        string6 = string6 + "</UploadMediaRequest>";
        this.sendRequest(string6, true);
    }
}

