AnyMeetingAPI = function() {};
AnyMeetingAPI.prototype.constructor = AnyMeetingAPI;
AnyMeetingAPI.prototype.CurrentUserID = "";
AnyMeetingAPI.prototype.CurrentEventKey = "";
AnyMeetingAPI.prototype.PresentationSessionID = "";
AnyMeetingAPI.prototype.LastResponseContent = "";
AnyMeetingAPI.prototype.ShowAlerts = true;

/*
Description: Generic callback method. Saves response content as last response content
 */
AnyMeetingAPI.prototype.GenericCallback = function(methodName,data)
{
	var response = anyMeetingRequestHelper.ParseResponse(data,AnyMeetingAPI.prototype.ErrorCallback);
	anyMeetingAPI.LastResponseContent = anyMeetingRequestHelper.GetResponseContent(response,methodName);
	alert(anyMeetingAPI.LastResponseContent);
};

/*
Description: Generic error callback method. Saves error message as last response content
 */
AnyMeetingAPI.prototype.ErrorCallback = function(error)
{
	AnyMeetingAPI.LastResponseContent = error;
};

/*
Description: Simple function to establish connectivity with the web server. Returns: "Hello %UserName% (%ResellerID%)"
 */
AnyMeetingAPI.prototype.HelloWorld = function(callbackMethod)
{
	// TODO get seller Id 
	var callback = AnyMeetingAPI.prototype.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1]); };

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("HelloWorld", new Array(), new Array());

	var methodName = "HelloWorld";
	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),{"Content-Type":"text/xml", "Cache-Control":"no-cache"}, new AjxCallback(this, callback, [methodName]),true);
};

AnyMeetingAPI.prototype.ValidateAccount = function(email, password, callbackMethod, callbackContext)
{	
	var callback = AnyMeetingAPI.prototype.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1],arguments[2]); };

	var methodName = "ValidateEmailAndPassword";

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall(methodName, new Array("UserEmail", "UserPassword"), new Array(email, password));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),{"Content-Type":"text/xml", "Cache-Control":"no-cache"}, new AjxCallback(this, callback, [methodName,callbackContext]),true);
};

/*
Description: Returns a Boolean value representing whether or not that email is already in the system. If it already exists, it cannot be used for a new account.
 */
AnyMeetingAPI.prototype.CheckEmailExists = function(emailAddress,callbackMethod)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1]); };

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("CheckEmailExists", new Array("EmailAddress"), new Array(emailAddress));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName]),true);
};

AnyMeetingAPI.prototype.GetUserXML = function(userId, callbackMethod, callbackParams)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0], arguments[1]); };

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("GetUserXML", new Array("UserID"), new Array(userId));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [callbackParams]),true);
};

/*
Description: Create a meeting based on EventKey and session and starts the session to enable connecting
*/
AnyMeetingAPI.prototype.CreatePresentationSessionWithTitleAndMode = function(userID,meetingTitle,mode,callbackMethod,additionalParams)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1],arguments[2]); };
		
  var methodName = "CreatePresentationSessionWithTitleAndMode";

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("CreatePresentationSessionWithTitleAndMode", new Array("UserID","Title","Mode"), new Array(userID,meetingTitle,mode));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName,additionalParams]),true);
};

/*
Description: Get the active meeting
*/
AnyMeetingAPI.prototype.GetActivePresentationSession = function(userID, callbackMethod, additionalParams)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1],arguments[2]); };
		
	var methodName = "GetActivePresentationSession";

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("GetActivePresentationSession", new Array("UserID"), new Array(userID));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName,additionalParams]),true);
};

/*
Description: End meeting
*/
AnyMeetingAPI.prototype.EndPresentationSession = function(userID,presentationSessionID,callbackMethod,additionalParams)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1],arguments[2]); };
		
  var methodName = "EndPresentationSession";

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("EndPresentationSession", new Array("UserID","PresentationSessionID"), new Array(userID,presentationSessionID));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName,additionalParams]),true);
};

/*
Description: Returns a Boolean value representing whether or not that email is logged in to an active meeting correlating to the provided EventKey.
 */
AnyMeetingAPI.prototype.CheckIsLoggedIn = function(eventKey,email,callbackMethod)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1]); };

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("CheckIsLoggedIn", new Array("EventKey","Email"), new Array(eventKey,email));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName]),true);
};

/*
Description: Creates a customer account with the provided information. System returns a string which is the newly created UserID. This should be stored for all future calls regarding this user 
 */
AnyMeetingAPI.prototype.CreateUserAccount = function(firstName, lastName, userEmail, meetingURL, userPassword, callbackMethod)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1]); };

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("CreateAnyMeetingUserAccount", new Array("FirstName","LastName", "UserEmail","MeetingURL","Password"), new Array(firstName, lastName,userEmail,meetingURL, userPassword));
	
	var methodName = "CreateAnyMeetingUserAccount";

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName]),true);
};

AnyMeetingAPI.prototype.UpdatePresentation = function(userId, eventKey, title, topic, password, active, callbackMethod)
{
/*
  var callback = AnyMeetingAPI.GenericCallback;
  
  if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1]); };
		
	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("UpdatePresentation", new Array("UserID","EventKey", "PresentationTitle","PresentationTopic","PresentationPassword","Active"), new Array(userId, eventKey, title, topic, password, active));
	
	var methodName = "UpdatePresentation";

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName]),true);
	*/
	callbackMethod();
};

/*
Description: Gets the path to the actual online presentation. The RoleID determines if the attendee will be logged in as a Presenter or an Audience Member.
NOTE: The URL returned will only be valid for 15 minutes, after which it will expire. It's recommended that the URL is requested on an as needed basis.
RoleID:
1 - Presenter
2 - Audience Member
 */

AnyMeetingAPI.prototype.GetEnterPresentationURL = function(userId,eventKey,roleId,callbackMethod)
{
	var callback = AnyMeetingAPI.GenericCallback;

	if(callbackMethod != undefined)
		callback = function(){ Busy(false); callbackMethod(arguments[0],arguments[1]); };
		
  var methodName = "GetEnterPresentationURL";

	var bodyContent = anyMeetingRequestHelper.GetBodyMethodCall("GetEnterPresentationURL", new Array("UserID","EventKey","RoleID"), new Array(userId,eventKey,roleId));

	var request = anyMeetingRequestHelper.NewAnyMeetingRequest(bodyContent);
	Busy(true);
	var result = AjxRpc.invoke(null, anyMeetingRequestHelper.GetAnyMeetingServiceURL(true, request),anyMeetingRequestHelper.GetResponseContentType(), new AjxCallback(this, callback, [methodName]),true);
};
