
AnyMeetingZimlet.prototype.doDrop = function(obj) 
{
	var type = obj.TYPE;
	switch(type) {
		case "ZmAppt":
			this.AppointmentDropped(obj, true);
			break;
		case "ZmContact":
			this.ContactDropped(obj);
			break;
		case "ZmConv":
		case "ZmMailMsg":
			this.MailDropped(obj);
			break;
	}

};

AnyMeetingZimlet.prototype.ContactDropped = function(objContact) 
{
	if (!(objContact instanceof Array)) {
		objContact = [objContact];
	}
	var emails = [];
	for (var i = 0; i < objContact.length; i++) {
		var contact = objContact[i];
		var email = contact.email ? contact.email : (contact.email2 ? contact.email2 : (contact.email3 ? contact.email3 : ""));
		if (email != "" && email != undefined && email != "undefined") {
			emails.push(email);
		}
	}
	this.DisplayStartMeetingDialog(emails.join(";"));
};

AnyMeetingZimlet.prototype.MailDropped = function(objMail) 
{
	var emails = [];	
	if(!(objMail instanceof Array)) {
		objMail = [objMail];
	}
	
	for (var i = 0; i < objMail.length; i++)
	{
		this.srcMsgObj = objMail[i].srcObj;
		if (this.srcMsgObj.type == "CONV") {
			this.srcMsgObj = this.srcMsgObj.getFirstHotMsg();
		}
		var currentEmails = this.srcMsgObj.getEmails().getArray();
		for (var j = 0; j < currentEmails.length; j++)
			if (!ArrayContainsItem(emails, currentEmails[j]))
				emails.push(currentEmails[j]);
	}
	this.DisplayStartMeetingDialog(emails.join(";"));
};

AnyMeetingZimlet.prototype.AppointmentDropped = function(obj, retryGetAttendees) 
{
  Busy(true);
	var attendees = obj.srcObj.getAttendees(ZmCalBaseItem.PERSON);
	var emails = [];
	for (var i = 0; i < attendees.length; i++) {
		emails.push(attendees[i].getEmail());
	}
	
	if (attendees.length == 0 && retryGetAttendees)
	{
    ZimletBackup = this;
    setTimeout(function() { ZimletBackup.AppointmentDropped(obj, false); Busy(false); }, 1500);
  }
  else
  {
    Busy(false);
    this.DisplayStartMeetingDialog(emails.join(";"));
  }
};