var AnyMeetingZimletCopy;
var AnyMeetingAppointmentCollection;

AnyMeetingZimlet.prototype.CurrentFilter = "";

AnyMeetingZimlet.prototype.ShowJoinMeetingDialog = function(filter)
{	
	this.CurrentFilter = filter;
	zimletObject = this;
	
	if(anyMeetingAPI.CurrentEventKey == undefined || anyMeetingAPI.CurrentEventKey == '')
	{
		this.DisplayManageAccountDialog(this.JoinMeetingUserAuthenticated,this.CurrentFilter);
	}
	else 
	{
		if (this.JoinMeetingDialog) 
		{
			this.JoinMeetingDialog.popup();
			document.getElementById("divFiltersSection").innerHTML = this.GetDropDownHtmlString(filter);
			document.getElementById("divMeetingsTable").innerHTML = this.GetAppointmentsHtmlString(filter);
			AnyMeetingZimletCopy = this;
			return;
		}

		this.pView = new DwtComposite(this.getShell());
		this.pView.setSize(745, 400);
		this.pView.getHtmlElement().style.overflow = "auto";
		this.pView.getHtmlElement().innerHTML = AjxTemplate.expand("com_anymeeting_zimlet.Templates.JoinMeeting#JoinMeeting");

		this.JoinMeetingDialog = new ZmDialog({title:"Join an Existing AnyMeeting", view:this.pView, parent:this.getShell(), standardButtons: [DwtDialog.CANCEL_BUTTON]});

		this.JoinMeetingDialog.setButtonListener(DwtDialog.CANCEL_BUTTON, new AjxListener(this, this.CancelJoinMeetingListener));

		this.JoinMeetingDialog.popup();

		document.getElementById("divFiltersSection").innerHTML = this.GetDropDownHtmlString(filter);
		document.getElementById("divMeetingsTable").innerHTML = this.GetAppointmentsHtmlString(filter);
		AnyMeetingZimletCopy = this;
	}
};

AnyMeetingZimlet.prototype.JoinMeetingUserAuthenticated = function(data)
{	
  if(data[data.length-1]=='save')
    data[0].DisplayJoinMeeting(data[1]);
};

AnyMeetingZimlet.prototype.CancelJoinMeetingListener = function()
{
	ClosePopup(this.JoinMeetingDialog);
};

AnyMeetingZimlet.prototype.GetAnyMeetingAppointments = function(filter)
{
	//TODO get all the appointments from the calendar that match the received filter.
	// 			obs: see selectFilterMeetings drop down in JoinMeeting.template for the possible values.
	//TODO with the resulted appointments, build an array of Appointment objects and return it.

	this._startDate = new Date();
	this._startDate.setHours(0, 0, 0, 0);
	var startTime = this._startDate.getTime();
	var endTime = startTime; //this._startDate.getTime() + AjxDateUtil.MSEC_PER_DAY;
	var result;

	switch (filter)
	{
	case "1":
		endTime = this._startDate.getTime() + AjxDateUtil.MSEC_PER_DAY * 400; //Zimbra cannot handle more than 400 days.
		break;
	case "2":
		endTime = this._startDate.getTime() + AjxDateUtil.MSEC_PER_DAY;
		break;
	case "3":
		startTime = this._startDate.getTime() + AjxDateUtil.MSEC_PER_DAY;
		endTime = this._startDate.getTime() + 2 * AjxDateUtil.MSEC_PER_DAY;
		break;
	case "4":
		endTime = this._startDate.getTime() + 7 * AjxDateUtil.MSEC_PER_DAY;
		break;
	default:
		break;
	}

	try 
	{
		var params = {start:startTime, end:endTime, fanoutAllDay:true};
		this._calController = AjxDispatcher.run("GetCalController");
		result = this._calController.getApptSummaries(params);
	} 
	catch (ex) 
	{
		DBG.println(ex);
		return new AjxVector();
	}

	var appointments = new Array();
  
  var apptCount = 0;
  
	for (var index = 0; index < result._array.length; index ++)
	{
    if(result._array[index].location.indexOf("http://www.anymeeting.com/") != 0)
      continue;
    
    var clone = ZmAppt.quickClone(result._array[index]);
    
    //"host"
		if(clone.organizer == undefined || clone.organizer == '')
      clone.organizer = "[Local appointment]";

    //meetingName
    if (clone.name.length > 90)
      clone.name = TrimString(clone.name, 90);
		
		//startTime
		//clone.startDate;
		
		//id
		//clone.id;

		//URL
		//clone.location;

    appointments[apptCount++] = clone;
	}

	return appointments;
};

AnyMeetingZimlet.prototype.GetAppointmentsHtmlString = function(filter)
{
	var appointments = this.GetAnyMeetingAppointments(filter);
	AnyMeetingAppointmentCollection = appointments;
	var result = "";

	if (appointments == null || appointments.length == 0)
		return "<b style='margin-left:12px;'>There are no upcoming appointments.</b>";

	for (var i = 0; i < appointments.length; i++ )
	{
		var isLastElement = false;
		if (i == appointments.length-1)
			isLastElement = true;
		result += this.GetMeetingRowHtmlString(appointments[i], isLastElement);
	}

	return result;
};

AnyMeetingZimlet.prototype.GetMeetingRowHtmlString = function(appointment, isLastElement)
{
	CurrentURL = appointment.location;
	var startJoinLink = "Join";
	if("http://www.anymeeting.com/" + anyMeetingAPI.CurrentEventKey == CurrentURL)
		startJoinLink = "Start";
	
	var appointmentDate = appointment.startDate._toString();
	var hourIndex = appointmentDate.indexOf(':') - 2;
	var oldHour = appointmentDate.slice(hourIndex, hourIndex + 8);
	var newHour = Date.parse(oldHour).toString("h:mm tt");
  appointmentDate = appointmentDate.replace(oldHour, newHour);

	var result = "";
		
	result += "<table style='table-layout: fixed;'><tr><td style='width: 104px;' class='headerLabel'><div style='width: 92px; margin-left:12px;'>"
	result += appointment.organizer;
	result += "</div></td><td style='width: 245px;' class='headerLabel'><div style='width: 243px;'>";
  result += appointment.name;
  result += "</div></td><td style='width: 245px;' class='headerLabel'><div style='width: 243px;'>";
  result += appointmentDate;
  result += "</div></td><td style='width: 104px;' class='headerLabel'><div style='width: 102px;'>";
  result += "<a href='#' onclick='return StartOrJoinMeeting(\"";
  result += appointment.id;
	result += "\");'>";
	result += startJoinLink;
	result += "</a></div>";
	result += "</td></tr></table><div class='thinerBottomBorder'></div>";
	if (!isLastElement)
		result += "<br />";
	
	return result;	
};

AnyMeetingZimlet.prototype.GetDropDownHtmlString = function(filter)
{
	var result = "";

	result += "<b>Show meetings: &nbsp;</b>";
	result += "<select id='selectFilterMeetings' onchange='GetFilteredMeetings();' style='margin-left:10px;'>";
	if (filter == 1)
		result += "<option value='1' selected='selected'>From now on</option>";
	else
		result += "<option value='1'>From now on</option>";
	if (filter == 2)
		result += "<option value='2' selected='selected'>Today</option>";
	else
		result += "<option value='2'>Today</option>";
	if (filter == 3)
		result += "<option value='3' selected='selected'>Tomorrow</option>";
	else
		result += "<option value='3'>Tomorrow</option>";
	if (filter == 4)
		result += "<option value='4' selected='selected'>Next 7 days</option>";
	else
		result += "<option value='4'>Next 7 days</option>";
	result += "</select>";

	return result;
};

var CurrentURL;
var MeetingTitle;

function StartOrJoinMeeting(id)
{	
	for(var index=0; index< AnyMeetingAppointmentCollection.length; index ++)
		if(AnyMeetingAppointmentCollection[index].id == id)
		{
			CurrentURL = AnyMeetingAppointmentCollection[index].location;
			MeetingTitle = AnyMeetingAppointmentCollection[index].name;

			if("http://www.anymeeting.com/" + anyMeetingAPI.CurrentEventKey == CurrentURL)
			{
			anyMeetingAPI.UpdatePresentation(anyMeetingAPI.CurrentUserID, anyMeetingAPI.CurrentEventKey, MeetingTitle, MeetingTitle, "", true, function(){
			zimletObject.CreatePresentationWithSpecificURL(AnyMeetingAppointmentCollection[index])
			});
			}
			else
			{
				window.open(CurrentURL);
			}
			
			break;
		}
};

AnyMeetingZimlet.prototype.CreatePresentationWithSpecificURL = function(appt)
{
	if (zimletObject == undefined || zimletObject == null)
		zimletObject = this;
		
	anyMeetingAPI.CreatePresentationSessionWithTitleAndMode(anyMeetingAPI.CurrentUserID, appt.name, 1, zimletObject.PresentationCreated,{URL:CurrentURL, appt: appt});
};

GetFilteredMeetings = function()
{
	var filter = document.getElementById("selectFilterMeetings").value;
	ClosePopup(AnyMeetingZimletCopy.JoinMeetingDialog);
	AnyMeetingZimletCopy.ShowJoinMeetingDialog(filter);
};
