AnyMeetingRequestHelper = function() { };
AnyMeetingRequestHelper.prototype.constructor = AnyMeetingRequestHelper;

AnyMeetingRequestHelper.prototype.NewAnyMeetingRequest = function(bodyContent)
{
	return ["<soap:Body>", bodyContent, "</soap:Body>", 
	        "</soap:Envelope>"].join("");
};

function Busy(isbusy)
{
  if(isbusy)
  {
    $('body').prepend("<div id='busyOverlay' style='position:absolute;width:100%;height:100%;z-index:999999;cursor:wait;'></div>");
  }
  else
  {
    $("#busyOverlay").remove();
  }
}

AnyMeetingRequestHelper.prototype.GetBodyMethodCall = function(methodName, parameterNames, parameterValues)
{
	var builder = "";

	for(index=0; index<parameterNames.length; index ++)
	{
		builder += "<" + parameterNames[index] + ">";
		builder += parameterValues[index];
		builder += "</" + parameterNames[index] + ">"; 
	}

	return ["<", methodName, " xmlns=\"http://instantpresenter.com/ws/api/\">", builder, "</", 
	        methodName, ">" ].join("");
};

AnyMeetingRequestHelper.prototype.GetAnyMeetingServiceURL = function(isLive, request)
{	
	if (UseProxy == true)
	{
		var extParams = [new Date().getTime(), "&live=true&body", "=", AjxStringUtil.urlComponentEncode(request)].join("");
		var extServerUrl = [SERVICE_URL, "?", extParams].join("");

		var encodedExtServerUrl = AjxStringUtil.urlComponentEncode(extServerUrl);
		var proxyServletUrl = [ZmZimletBase.PROXY, encodedExtServerUrl].join("");
	
		return proxyServletUrl;
	}
	else
	{	
		var params = [new Date().getTime(), "&live=true&body", "=", request].join("");
		var serviceURL = [SERVICE_URL, "?", params].join("");
	
		return serviceURL;
	}
};

AnyMeetingRequestHelper.prototype.GetUri = function(url){
 return ZmZimletBase.PROXY + AjxStringUtil.urlComponentEncode(url);
};

AnyMeetingRequestHelper.prototype.GetResponseContentType = function()
{
  return {"Content-Type":"text/xml", "Cache-Control":"no-cache"};
};

AnyMeetingRequestHelper.prototype.ParseResponse = function(response,errorCallback) {
	var jsonDoc = null;
	try {
		var xmlDoc = null;
		if (response.xml && response.xml.childNodes.length > 0) {
			xmlDoc = new AjxXmlDoc.createFromDom(response.xml);
		} else {
			xmlDoc = new AjxXmlDoc.createFromXml(response.text.replace(/^\s+|\s+$/g,""));
		}
		jsonDoc = xmlDoc.toJSObject(true, false);
	} catch(ex) {
		errorCallback();
		return null;
	}
	
	if (response.text && response.text.length > 5 && response.text.substring(0, 6).toLowerCase() == "<html>") {
		jsonDoc = null;
		errorCallback();
	}

	return jsonDoc;
};

AnyMeetingRequestHelper.prototype.ValidateResponse = function(response,errorCallback) {
	var isValid = true;

	if (!response || !response.header || !response.header.response || !response.header.response.result || response.header.response.result != "SUCCESS") 
	{
		isValid = false;
	}

	if (!isValid) {
		var error = response.header.response.reason;
    errorCallback(error);
	}

	return isValid;
};

AnyMeetingRequestHelper.prototype.GetResponseBody = function(response){
  return response.Body;
};

AnyMeetingRequestHelper.prototype.GetResponseContent = function(response,method){
  return this.GetResponseBody(response)[method+"Response"][method+"Result"];
	//return this.GetResponseBody(response);
};

AnyMeetingRequestHelper.prototype.GetResultsFromResponse = function(response,keyArray){
  var resultArray = new Array();
  try
  {
  var responseBody = AnyMeetingRequestHelper.GetResponseBody(response);
  for(index=0;index<keyArray.length;index++)
   resultArray[index] = responseBody[keyArray[index]].toString();
  }
  catch(ex)
  {
   //
  }
  return resultArray;
};
