AnyMeetingZimlet.prototype.ManageAccountDialogCloseCallback = null;
AnyMeetingZimlet.prototype.Params = null;
var ZimletBackup = null;

AnyMeetingZimlet.prototype.ManageAccountDialog = null;

AnyMeetingZimlet.prototype.CloseAction = 'none';

AnyMeetingZimlet.prototype.DisplayManageAccountDialog = function(callback,params) 
{
  this.Params = params;
  this.ManageAccountDialogCloseCallback = callback;

	if (this.ManageAccountDialog) 
	{
    ClearErrors();
    ClearFields();
		this.ManageAccountDialog.popup();
		return;
	}

	this.pView = new DwtComposite(this.getShell());
	this.pView.setSize(360, 210);
	this.pView.getHtmlElement().style.overflow = "auto";
	this.pView.getHtmlElement().innerHTML = AjxTemplate.expand(this.IsZCS8() == true ? "com_anymeeting_zimlet.Templates.ManageAccountFix#ManageAccountFix" : "com_anymeeting_zimlet.Templates.ManageAccount#ManageAccount");

	this.ManageAccountDialog = new ZmDialog({title:"Manage Account", view:this.pView, parent:this.getShell(), standardButtons:[DwtDialog.CANCEL_BUTTON]});

	this.ManageAccountDialog.setButtonListener(DwtDialog.CANCEL_BUTTON, new AjxListener(this, this.CancelManageAccountlListener));
	
	var buttonLogIn = new DwtButton({parent:this.getShell()});
	buttonLogIn.setText("Log In");
	buttonLogIn.addSelectionListener(new AjxListener(this, this.SaveManageAccountListener));
	document.getElementById("divButtonLogIn").appendChild(buttonLogIn.getHtmlElement());
	
  var buttonRegister = new DwtButton({parent:this.getShell()});
	buttonRegister.setText("Register");
	buttonRegister.addSelectionListener(new AjxListener(this, this.LinkRegisterListener));
	document.getElementById("divButtonRegister").appendChild(buttonRegister.getHtmlElement());

	$("[name='manageAccount_password']").bind('keydown',{ zimlet : this },function(e){
      if(e.which == 13 || e.keyCode == 13)
        e.data.zimlet.SaveManageAccountListener();
	});
	
	this.SetManageAccountDialogTabGroup();
	
	this.ManageAccountDialog.popup();
	document.getElementById("manageAccount_username").focus();
};

function ClearErrors()
{
  $("[name$='_star']").css('display','none');
  $("[name^='manageAccount_']:not([name$='_star'])").css('width','155px');
};

function ValidateField(elemid)
{
  var elem = $("[name='"+elemid+"']");
  if(elem != null && (elem.val() == "" || elem.val() == null || elem.val() == undefined))
  {
    var star = $("[name='"+elemid+"_star']");
    if(star!=null)
    {
      star.css('display','inline-block');
      elem.css('width','150px');
    }
    return false;
  }
  return true;
};

AnyMeetingZimlet.prototype.SetManageAccountDialogTabGroup = function()
{
	this.ManageAccountDialog._tabGroup.removeAllMembers();
	
	var tabGroup = new DwtTabGroup();
	
	tabGroup.addMember(document.getElementsByName("manageAccount_username")[0]);
	tabGroup.addMember(document.getElementsByName("manageAccount_password")[0]);
	var childrenList = this._dwtShell._children._array;
	var position = childrenList.length;
	tabGroup.addMember(this._dwtShell._children._array[position-2]);
	tabGroup.addMember(this._dwtShell._children._array[position-1]);
	tabGroup.addMember(this.ManageAccountDialog._button[1]);
	
	this.ManageAccountDialog._tabGroup.addMember(tabGroup);
};

AnyMeetingZimlet.prototype.DisplayCreateAccountDialog = function(reshowData) 
{
	if (this.CreateAccountDialog) 
	{
		this.CreateAccountDialog.popup();
		ClearCreateAccountErrors();
		ClearErrors();
		if (!reshowData)
      ClearCreateAccountFields();
		return;
	}

	var isZCS8 = this.IsZCS8();

	this.pView = new DwtComposite(this.getShell());
	this.pView.setSize(isZCS8 == true ? 550 : 500, 250);
	this.pView.getHtmlElement().style.overflow = "auto";
	this.pView.getHtmlElement().innerHTML = AjxTemplate.expand(isZCS8 == true ? "com_anymeeting_zimlet.Templates.CreateAccountFix#CreateAccountFix" : "com_anymeeting_zimlet.Templates.CreateAccount#CreateAccount");

	var SaveButtonId = Dwt.getNextId();
	var CancelButtonId = Dwt.getNextId();
	SaveButton = new DwtDialog_ButtonDescriptor(SaveButtonId, "Save", DwtDialog.ALIGN_RIGHT);
	CancelButton = new DwtDialog_ButtonDescriptor(CancelButtonId, "Cancel", DwtDialog.ALIGN_RIGHT);

	this.CreateAccountDialog = new ZmDialog({title:"Create Account", view:this.pView, parent:this.getShell(), standardButtons: [DwtDialog.NO_BUTTONS], extraButtons: [SaveButton, CancelButton]});

	var linkTermsOfService = document.getElementById("linkTermsOfService");

	linkTermsOfService.onclick = AjxCallback.simpleClosure(this.LinkTermsOfServiceListener, this);
	this.CreateAccountDialog.setButtonListener(SaveButtonId, new AjxListener(this, this.CreateAccountListener));
	this.CreateAccountDialog.setButtonListener(CancelButtonId, new AjxListener(this, this.CancelCreateAccountlListener));

	this.SetCreateAccountDialogTabGroup(SaveButtonId, CancelButtonId);
	
	this.CreateAccountDialog.popup();
	this.AddCustomTooltips();
};

AnyMeetingZimlet.prototype.AddCustomTooltips = function()
{
	$('.customToolTip').tipTip({
		maxWidth: "300px",
		defaultPosition: "right"
	});
	
	var imageSource = this.getResource("/Images/ImageError.png");
	
	$('img[id^="imageError"]').attr('src', imageSource);
};

AnyMeetingZimlet.prototype.SetCreateAccountDialogTabGroup = function(saveButtonId, cancelButtonId)
{
	this.CreateAccountDialog._tabGroup.removeAllMembers();
	
	var tabGroup = new DwtTabGroup();
	
	tabGroup.addMember(document.getElementById("createAccount_FirstName"));
	tabGroup.addMember(document.getElementById("createAccount_LastName"));
	tabGroup.addMember(document.getElementById("createAccount_Email"));
	tabGroup.addMember(document.getElementById("createAccount_ConfirmEmail"));
	tabGroup.addMember(document.getElementById("createAccount_Password"));
	tabGroup.addMember(document.getElementById("createAccount_Address"));
	tabGroup.addMember(document.getElementById("createAccount_checkboxAgree"));
	
	tabGroup.addMember(this.CreateAccountDialog._button[saveButtonId]);
	tabGroup.addMember(this.CreateAccountDialog._button[cancelButtonId]);
	
	this.CreateAccountDialog._tabGroup.addMember(tabGroup);
};

AnyMeetingZimlet.prototype.SaveManageAccountListener = function() 
{
  var valid = true;

  valid = ValidateField('manageAccount_password') && valid;
  valid = ValidateField('manageAccount_username') && valid;
  
  if(valid && anyMeetingAPI.ShowAlerts == true)
  {
    anyMeetingAPI.ShowAlerts = false;
    ClearErrors();
    anyMeetingAPI.ValidateAccount(this.GetCurrentUsername(), this.GetCurrentPassword(), this.OnValidateCallback, this);
  }
};

AnyMeetingZimlet.prototype.OnValidateCallback = function(methodName, context, data)
{
  anyMeetingAPI.ShowAlerts = true;
	var response = anyMeetingRequestHelper.ParseResponse(data, context.ErrorCallback);
	anyMeetingAPI.LastResponseContent = anyMeetingRequestHelper.GetResponseContent(response,methodName);

	if(response.Body.ValidateEmailAndPasswordResponse.ValidateEmailAndPasswordResult == "0")
	{
		context.ShowNotificationDialog("critical", "The username or password is incorrect. If you don't have an AnyMeeting account please register.", function() { ClosePopup(context.NotificationDialog, null, null); }, null, null, null);
	}
	else
	{
    context.CloseAction = 'save'; 
    var params = [ context, context.Params , context.CloseAction] ;
    context.Params = null;
    
		anyMeetingAPI.CurrentUserID = response.Body.ValidateEmailAndPasswordResponse.ValidateEmailAndPasswordResult.toString();
		anyMeetingAPI.GetUserXML(anyMeetingAPI.CurrentUserID, SetupAnyMeetingSettings, params);
	}
};

function SetupAnyMeetingSettings(params, eventKey)
{
  var context = params[0];
  //response.Body.ValidateEmailAndPasswordResponse.ValidateEmailAndPasswordResult
  var doc = anyMeetingRequestHelper.ParseResponse(eventKey,null);
  anyMeetingAPI.CurrentEventKey = doc.Body.GetUserXMLResponse.GetUserXMLResult.toString().split('MeetingWebAddress="')[1].split('"')[0] + "1";
  
  context.ShowNotificationDialog("info", "You have successfully logged in with your AnyMeeting credentials.", function() { CloseLoggedInNotification(params); }, null, null, null);
 };
 
function CloseLoggedInNotification(params)
{
  params[0].CloseNotificationDialog();
  ClosePopup(params[0].ManageAccountDialog,params[0].ManageAccountDialogCloseCallback, params);
};

AnyMeetingZimlet.prototype.CancelManageAccountlListener = function()
{
  this.CloseAction = 'cancel';
  var params = [ this.Params , this.CloseAction];
  this.Params = null;
  ClosePopup(this.ManageAccountDialog,this.ManageAccountDialogCloseCallback,params);
};

function ClearFields()
{
  $('#manageAccount_username').val("");
  $('#manageAccount_password').val("");
};

AnyMeetingZimlet.prototype.CreateAccountListener = function() 
{		
	ClearCreateAccountErrors();
		
	if (ValidateCreateAccountFields())
	{
		AnyMeetingZimlet.prototype.ManageAccountDialog = this.ManageAccountDialog;
		AnyMeetingZimlet.prototype.CreateAccountDialog = this.CreateAccountDialog;
		AnyMeetingZimlet.prototype.CloseAction = this.CloseAction;
		AnyMeetingZimlet.prototype.ManageAccountDialogCloseCallback = this.ManageAccountDialogCloseCallback;
		AnyMeetingZimlet.prototype.Params = this.Params;
		
		ZimletBackup = this;
		anyMeetingAPI.CreateUserAccount(this.GetRegisterFirstName(), this.GetRegisterLastName(), this.GetRegisterEmail(), this.GetRegisterMeetingURL(), this.GetRegisterPassword(), this.OnCreateAccountCallback);
		//TODO call register method with the required parameters (use the getters below)
		// define a callback method to handle the response 
		// depending on the response, it could either be an error which could be displayed as a validation message (e.g. the email exists, the URL exists)

	    this.CloseAction = 'create';
	    var params = [null, this.Params];
	    this.Params = null;
		ClosePopup(this.CreateAccountDialog,this.ManageAccountDialogCloseCallback,params);
		this.ShowWaitingMessage();
	}
};

AnyMeetingZimlet.prototype.ShowWaitingMessage = function()
{
	var imageSource = this.getResource("/Images/Loading.gif");
	var body = "<table border='0' cellpadding='2' cellspacing='0' width='100%'><tbody><tr><td colspan='2'> </td></tr><tr><td colspan='2'> </td></tr><tr><td colspan='2'> Please wait... </td><td colspan='2'> </td></tr><tr><td colspan='2'> <br /> </td></tr><tr><td colspan='2'> <br /> </td></tr><tr><td colspan='2'><img src='" + imageSource + "' style='width: 75px; height: 75px; margin-left: 110px;' /> </td></tr></tbody></table>";
	
	if (this.WaitingDialog) 
	{
		this.WaitingDialog.popup();
		return;
	}

	this.pView = new DwtComposite(this.getShell());
	this.pView.setSize(300, 200);
	this.pView.getHtmlElement().style.overflow = "auto";
	this.pView.getHtmlElement().innerHTML = body;
	
	this.WaitingDialog = new ZmDialog({title:"Registering Your New Account", view:this.pView, parent:this.getShell(), standardButtons: [DwtDialog.NO_BUTTONS]});
	this.WaitingDialog.popup();
	AnyMeetingZimlet.prototype.WaitingDialog = this.WaitingDialog;
};

AnyMeetingZimlet.prototype.OnCreateAccountCallback = function(methodName, data)
{
	ClosePopup(AnyMeetingZimlet.prototype.WaitingDialog);
	
	var response = anyMeetingRequestHelper.ParseResponse(data, AnyMeetingAPI.prototype.ErrorCallback);
	
	// data.success will be true even if there is an error on anymeeting service (because it is called from our java service which
	// will return success = true and the error message) so we should check for the faultcode in the received response to see if we have any errors.
	
	if (response.Body.Fault != undefined && response.Body.Fault != null)
		{
			var errorMessage = ZimletBackup.GetAccountCreationError(response.Body.Fault.faultstring);
			ZimletBackup.ShowNotificationDialog("critical", errorMessage, ZimletBackup.CloseCreateAccountNotification, null, null, null);
		}
	else
	{
		anyMeetingAPI.LastResponseContent = anyMeetingRequestHelper.GetResponseContent(response,methodName);
		
		var textManageAccountUsername = document.getElementsByName("manageAccount_username")[0];
		var textManageAccountPassword = document.getElementsByName("manageAccount_password")[0];
		
		var textCreateAccountEmail = document.getElementById("createAccount_Email");
		var textCreateAccountPassword = document.getElementById("createAccount_Password");
		
		textManageAccountUsername.value = textCreateAccountEmail.value;
		textManageAccountPassword.value = textCreateAccountPassword.value;
		
		if (AnyMeetingZimlet.prototype.ManageAccountDialog != null)
			ClosePopup(AnyMeetingZimlet.prototype.ManageAccountDialog);
		AnyMeetingZimlet.prototype.SaveManageAccountListener();
	}
};

AnyMeetingZimlet.prototype.CloseCreateAccountNotification = function()
{
  ClosePopup(this.NotificationDialog, null, null);
  AnyMeetingZimlet.prototype.DisplayCreateAccountDialog(true);
};

AnyMeetingZimlet.prototype.GetAccountCreationError = function(data)
{
	var errorContent = data.__msh_content;	
	if (errorContent == null)
		return;
	
	var error = errorContent.split("---> ");
	if (error[1] == null)
		return "Invalid request";
	
	var errorMessage = error[1].split(".")[0];
	if (errorMessage == null)
		errorMessage = "The server could not process your request.\nPlease revise your account details and try again.";
	
	if (errorMessage == "E-mail is not unique")
    errorMessage = "An AnyMeeting account with this email already exists.";
    
  return errorMessage;
};

AnyMeetingZimlet.prototype.CancelCreateAccountlListener = function()
{
  this.CloseAction = 'cancel_register';
  var params = [ this.Params , this.CloseAction] ;
	ClearCreateAccountErrors();
	ClosePopup(this.CreateAccountDialog,this.ManageAccountDialogCloseCallback,params);
};

AnyMeetingZimlet.prototype.LinkRegisterListener = function()
{
	this.DisplayCreateAccountDialog(false);
};

AnyMeetingZimlet.prototype.LinkTermsOfServiceListener = function()
{
	window.open("http://www.anymeeting.com/AccountManager/messages/AnyMeetingTermsOfService.htm");
};

function validateEmail(email) { 
    var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
} 

function ValidateCreateAccountFields()
{
	var result = true;
	var firstName = document.getElementById("createAccount_FirstName");
	if (firstName == null || firstName.value == null || firstName.value.length == 0)
	{
		$('#imageErrorFirstName').show();
		result = false;
	}
	var lastName = document.getElementById("createAccount_LastName");
	if (lastName == null || lastName.value == null || lastName.value.length == 0)
	{
		$('#imageErrorLastName').show();
		result = false;
	}
	var email = document.getElementById("createAccount_Email");
	if (email == null || email.value == null || email.value.length == 0 || !validateEmail(email.value))
	{
		$('#imageErrorEmail').show();
		result = false;
	}
	var confirmEmail = document.getElementById("createAccount_ConfirmEmail");
	if (confirmEmail == null || confirmEmail.value == null || confirmEmail.value.length == 0)
	{
		$('#imageErrorConfirmEmail').show();		
		result = false;
	}
	if (email != null && email.value != null && confirmEmail != null && confirmEmail.value != null && confirmEmail.value != email.value)
		{
			$('#imageErrorConfirmEmail').show();
			result = false;
		}
	var password = document.getElementById("createAccount_Password");
	if (password == null || password.value == null || password.value.length == 0)
	{
		$('#imageErrorPassword').show();
		result = false;
	}
	var address = document.getElementById("createAccount_Address");
	if (address == null || address.value == null || address.value.length == 0)
	{
		$('#imageErrorAddress').show();
		result = false;
	}
	//var hearSource = document.getElementById("createAccount_HowDidYouHear");
	//if (hearSource == null || hearSource.value == null || hearSource.value.length == 0)
	//{
	//	ShowErrorLabel("labelErrorSelectSource");
	//	result = false;
	//}
	var agree = document.getElementById("createAccount_checkboxAgree");
	if (agree == null || agree.checked == null || agree.checked == false)
	{
		$('#imageErrorAgree').show();
		result = false;
	}	
	
	// todo validate email and email confirmation fields

	return result;
};

function ClearCreateAccountErrors()
{	
	$('img[id^="imageError"]').hide();
};

function ClearCreateAccountFields()
{
  $('input[id^="createAccount"]').val("");
  $('#createAccount_checkboxAgree').attr('checked', false);
}

AnyMeetingZimlet.prototype.GetCurrentUsername = function()
{
	var usernameField = document.getElementsByName("manageAccount_username")[0];

	if(usernameField != undefined)
		return usernameField.value;
};

AnyMeetingZimlet.prototype.GetCurrentPassword = function()
{
	var passwordField = document.getElementsByName("manageAccount_password")[0];

	if(passwordField != undefined)
		return passwordField.value;
};

AnyMeetingZimlet.prototype.SetCurrentUsername = function(value)
{
	var usernameField = document.getElementsByName("manageAccount_username")[0];
	
	if (usernameField != undefined)
		usernameField.value = value;
};

AnyMeetingZimlet.prototype.SetCurrentPassword = function(value)
{
	var passwordField = document.getElementsByName("manageAccount_password")[0];
	
	if (passwordField!= undefined)
		passwordField.value = value;
};

AnyMeetingZimlet.prototype.GetRegisterFirstName = function()
{
	return document.getElementById("createAccount_FirstName").value;
};

AnyMeetingZimlet.prototype.GetRegisterLastName = function()
{
	return document.getElementById("createAccount_LastName").value;
};

AnyMeetingZimlet.prototype.GetRegisterEmail = function()
{
	return document.getElementById("createAccount_Email").value;
};

AnyMeetingZimlet.prototype.GetRegisterMeetingURL = function()
{
	return document.getElementById("createAccount_Address").value; 
};

AnyMeetingZimlet.prototype.GetRegisterPassword = function()
{
	return document.getElementById("createAccount_Password").value;
};




