/**
 * Zimlet handler class
 */
function com_proofpoint_encryptionHandlerObject() {
}

com_proofpoint_encryptionHandlerObject.PP_SENDENC_OP = "PP_SENDENC";

com_proofpoint_encryptionHandlerObject.prototype = new ZmZimletBase();
com_proofpoint_encryptionHandlerObject.prototype.constructor =
    com_proofpoint_encryptionHandlerObject;

com_proofpoint_encryptionHandlerObject.prototype.init =
    function() {
      ZmMailMsg.requestHeaders[this.getConfig("headerName")]=
                               this.getConfig("headerName");
      //We don't belong in hear but this is the best we can do to see if
      //compose windows have been created before we have been loaded.
      //If compose windows do exist this will load our menu option.
      var controllers=appCtxt.getApp(ZmApp.MAIL).
                            _sessionController[ZmId.VIEW_COMPOSE];
      if (controllers) {
        for (var id in controllers) {
            if (controllers[id]._toolbar) {
                this._loadmenu(controllers[id]._toolbar,controllers[id]);
            }
        }
      }
    };

/**
 * This method gets called by the Zimlet framework when a toolbar is created.
 *
 * @param {ZmApp} app
 * @param {ZmButtonToolBar} toolbar
 * @param {ZmController} controller
 * @param {String} viewId
 * 
 */
com_proofpoint_encryptionHandlerObject.prototype.initializeToolbar =
    function(app, toolbar, controller, viewId) {
        if (viewId.indexOf("COMPOSE") >= 0 ) {
            this._loadmenu(toolbar,controller);
        }
    };

com_proofpoint_encryptionHandlerObject.prototype._loadmenu =
    function(toolbar,controller) {
        var op = toolbar.getOp(ZmOperation.COMPOSE_OPTIONS);
        if (op) {
            var menu = op.getMenu();
            if (menu) {
                var mi = menu.getMenuItem(
                    com_proofpoint_encryptionHandlerObject.PP_SENDENC_OP);
                if (!mi) {
                    mi = menu.createMenuItem(
                      com_proofpoint_encryptionHandlerObject.PP_SENDENC_OP,
                      {image: "Padlock",
                       text : com_proofpoint_encryption.sendEncrypted,
                       style: DwtMenuItem.CHECK_STYLE});
                    mi.addSelectionListener(new AjxListener(this,
                       this._handleEncryptMenuClick, controller, mi));
                }
                var msg=controller.getMsg();
                if (msg && msg.attrs &&
                    msg.attrs[this.getConfig("headerName")] == 
                              this.getConfig("headerValue")) {
                  mi.setChecked(true);
                  appCtxt.getCurrentView().__com_pp_encrypt_doEncrypt =
                     true; //restore previous setting.
                } else {
                  mi.setChecked(false);
                  appCtxt.getCurrentView().__com_pp_encrypt_doEncrypt =
                     false; //reset
                }
            }
        }
    };

/**
 * Set some unique variable on the current compose view to "true" so that
 * addCustomMimeHeaders function knows that it needs to add custom header as
 * we are dealing with multiple compose-tabs.
 *
 * @param {ZmComposeController} controller
 * @param {Event}	ev
 */
com_proofpoint_encryptionHandlerObject.prototype._handleEncryptMenuClick =
        function(controller, ev) {
            if(!ev)  {
                ev = window.event;
            }
            if(ev && ev.item && ev.item.getChecked)  {
                // set some unique variable ("__com_pp_encrypt_doEncrypt") on
                // ZmComposeView since we need to deal with multiple
                // compose-tabs.
                appCtxt.getCurrentView().__com_pp_encrypt_doEncrypt =
                    ev.item.getChecked();
            }
        };

/**
 * Called by the framework just before sending email.
 * @param {array} customMimeHeaders An array of custom-header objects.
 *     Each item in the array MUST be an object that has "name" and "_content"
 *     properties.
 *     This onle works from 7.1.3
 */
com_proofpoint_encryptionHandlerObject.prototype.addCustomMimeHeaders =
function(customMimeHeaders) {
	//check if the compose view has __com_pp_encrypt_doEncrypt set to
        // true (is true when user selects encrypt menu)
	if(appCtxt.getCurrentView().__com_pp_encrypt_doEncrypt) {
		customMimeHeaders.push({
                              name    :this.getConfig("headerName"),
                              _content:this.getConfig("headerValue")});
	}
	appCtxt.getCurrentView().__com_pp_encrypt_doEncrypt = false; //reset
    };
