/*
 * ***** BEGIN LICENSE BLOCK *****
 * Onepoint Consulting Ltd
 * Copyright (C) 2011 Onepoint Consulting Ltd.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * 
 * ***** END LICENSE BLOCK *****
 */

SSLPostDialog = function(shell, className, parent) {
    className = className || "SSLPostDialog";
    this._zimlet = parent;
    var title = "SSLPost Zimlet";
    DwtDialog.call(this, {parent:shell, className:className, title:title, standardButtons: DwtDialog.OK_BUTTON});
    try {
        this.getHtmlElement().style.display = "auto"; // This does not work on IE.
    }
    catch(e) {
        
    }
    this.getHtmlElement().style.width="500px";
    this.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._okSelected));
    this._createInfoHtml();
};

SSLPostDialog.prototype = new DwtDialog;
SSLPostDialog.prototype.constructor = SSLPostDialog;

/**
 * The support email address.
 */
var supportEmailAddress = 'sup\
port' + '@sslpo\
st.com'

/**
 * The official Zimlet name.
 */
var sslPostZimletName = "SSLPost BE"

/**
 * The singleton instance which is currently displayed.
 */
var sSLPostDialogInstance = null;

/**
 * Displays the information about this Zimlet.
 */
SSLPostDialog.prototype._createInfoHtml = function() {

    sSLPostDialogInstance = this;
    var table = document.createElement("TABLE");
    table.border = 0;
    table.cellPadding = 0;
    table.cellSpacing = 4;

    row = table.insertRow(-1);
    cell = row.insertCell(-1);
    cell.innerHTML = '<h2>' + sslPostZimletName + ' Zimlet</h2>\
        <img src="/service/zimlet/com_sslpost_securemail/images/sslpost_icon_64.png" class="sslPostLeftFloat" />\
        <p id="sslPostMainDesc" class="sslPostjustifiedText">SSLPost is a web centric PKI solution, which allows senders and recipients to securely exchange sensitive data without\
        the need to purchase certificates or manage the exchange of public keys. SSLPost technology is protected by Worldwide patents\
        and  is leading the way in the secure electronic document transfer market. \
        <br />For more information on SSLPost please visit <a href="http://www.sslpost.com" target="_blank">http://www.sslpost.com</a>.</p>\
\
        <p class="sslPostjustifiedText">SSLPost BE Zimlet must be used in conjunction with SSLPost Boundary Encryption. Please contact \
        <a href="Secure Mail" onclick="sSLPostDialogInstance.sendEmailWithPrefInfo(); return false;">' + supportEmailAddress + '</a> for more details.</p>';

    var element = this._getContentDiv();
    element.appendChild(table);
};

/**
 * Opens a new message window in a new window for the user to write to the 
 * sslpost support email address.
 */
SSLPostDialog.prototype.sendEmailWithPrefInfo = function() {
    
    var action = ZmOperation.NEW_MESSAGE;
    var msg = new ZmMailMsg();
    var toOverride = supportEmailAddress;

    var subjOverride = "SSLPost Support Request";
    // Change the default settings
    var settings = appCtxt.getSettings();
    
    var textDefault = appCtxt.get(ZmSetting.COMPOSE_AS_FORMAT) == ZmSetting.COMPOSE_TEXT;
    if (textDefault) { // switch to HTML
        appCtxt.set(ZmSetting.COMPOSE_AS_FORMAT, ZmSetting.COMPOSE_HTML);
    }
    var extraBodyText = "";
    AjxDispatcher.run("Compose", 
        {
            action: action,
            inNewWindow: true,
            msg: msg,
            toOverride: toOverride, 
            subjOverride: subjOverride,
            extraBodyText: extraBodyText
        }
    );
    if (textDefault) { // switch back to text
        appCtxt.set(ZmSetting.COMPOSE_AS_FORMAT, ZmSetting.COMPOSE_TEXT);
    }
};

/**
 * Displays the SSLPost dialogue.
 */
SSLPostDialog.prototype.popup = function(name, callback) {
    
    this.setTitle(sslPostZimletName + " Zimlet Information");

    // enable buttons
    this.setButtonEnabled(DwtDialog.OK_BUTTON, true);
    
    // show
    DwtDialog.prototype.popup.call(this);
};

/**
 * Closes the dialogue.
 */
SSLPostDialog.prototype.popdown = 
function() {
    ZmDialog.prototype.popdown.call(this);
};

/**
 * Closes the dialogue.
 */
SSLPostDialog.prototype._okSelected =
function(){
    this.popdown();
};

