/*
 * ***** BEGIN LICENSE BLOCK *****
 * Onepoint Consulting Ltd
 * Copyright (C) 2011 Onepoint Consulting Ltd.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * 
 * ***** END LICENSE BLOCK *****
 */

/**
 * Constructor.
 *
 * @author Gil Fernandes (Onepoint)
 */
function Com_Sslpost_SecureMail() {
}

Com_Sslpost_SecureMail.prototype = new ZmZimletBase();
Com_Sslpost_SecureMail.prototype.constructor = Com_Sslpost_SecureMail;

/**
 * Simplify handler object
 */
var SecureMailZimlet = Com_Sslpost_SecureMail;

/**
 * The compose controller reference
 */
SecureMailZimlet.zmComposeController = null;

/**
 * The compose controller view reference
 */
SecureMailZimlet.zmComposeView = null;

/**
 * Used to do the insertion of the secure token.
 */
SecureMailZimlet.bodyRegex = /(\<\/body)/i;

/**
 * The plain secure token.
 */
SecureMailZimlet.secureTokenPlain = "x-sslpost-encrypt: true";

/**
 * The HTML secure token.
 */
SecureMailZimlet.secureTokenHtml = "x-sslpost-encrypt: true";

/**
 * Delay before sending the email to the user.
 */
SecureMailZimlet.sendDelay = 1000;

/**
 * Initializes zimlet
 */
SecureMailZimlet.prototype.init =
function() {};

/**
 * Shows preferences dialog when user double-clicks on panel item
 */
SecureMailZimlet.prototype.doubleClicked = function() {
    this.singleClicked();
};

/**
 * Called when an item is selected.
 */
SecureMailZimlet.prototype.menuItemSelected = function(itemId) {
    this.singleClicked();
};

/**
 * Shows preferences dialog when user single-clicks on panel item.
 */
SecureMailZimlet.prototype.singleClicked = function() {
    this._showPrefs();
};

/**
 * Pops up the dialogue with a description of what this Zimlet does.
 */
SecureMailZimlet.prototype._showPrefs =
    function() {
        if(!this._prefsDialog) {
            this._prefsDialog = new SSLPostDialog(appCtxt._shell, null, this);
        }
        this._prefsDialog.popup();
    };

/**
 * Adds the secure send button to the initialized toolbar.
 */
SecureMailZimlet.prototype.initializeToolbar =
    function(app, toolbar, controller, viewId) {

        SecureMailZimlet.zmComposeController = controller;
        SecureMailZimlet.zmComposeView = controller._composeView;
        //for compose view since 6.x supports multiple compose tabs(and has dynamic ids) that look like 123_COMPOSE_DWT123
        if(viewId.indexOf("COMPOSE")  >=0){
            //get the index of View menu so we can display it after that.
            var buttonIndex = 1;
            var lastItem = toolbar.opList[toolbar.opList.length - 1];
            switch(lastItem) {
                case "DETACH_COMPOSE":
                    SecureMailZimlet.sendDelay = 1000;
                    break;
                case "COMPOSE_OPTIONS":
                    SecureMailZimlet.sendDelay = 4000;
                    break;
            }
            //create params obj with button details
            var buttonArgs = {
                text: this.getMessage("SecureMailZimlet_buttonLabel") ? this.getMessage("SecureMailZimlet_buttonLabel") : "Send Secure Mail",
                tooltip: this.getMessage("SecureMailZimlet_buttonTooltip"),
                index: buttonIndex, //position of the button
                image: "securemail-panelIcon" //icon
            };

            //toolbar.createOp api creates the button with some id and  params containing button details.
            var button = toolbar.createOp("SECURE_SEND_MAIL_BUTTON", buttonArgs);
            button.addSelectionListener(new AjxListener(this, this._sendSecureEmail, controller));
        }
    };

/**
 * Removes the secure token in case of failure.
 */
SecureMailZimlet._removeSecureToken = function() {
    var bodyContent = SecureMailZimlet.zmComposeView._htmlEditor.getContent();
    bodyContent = bodyContent.replace(SecureMailZimlet.secureTokenPlain, "");
    SecureMailZimlet.zmComposeView._htmlEditor.setContent(bodyContent);
}
    
/**
 * Handles an error when the message could not be sent.
 */
SecureMailZimlet.prototype.onSendMsgFailure = 
    function() {
        SecureMailZimlet._removeSecureToken();
    };

/**
 * Tries to send the save the email in case the save token is not there. 
 */
SecureMailZimlet.sendSafeWithToken = function(counter) {
    
    if(counter == 5) {
        var msgDialog = appCtxt.getMsgDialog();
        msgDialog.setMessage(this.getMessage("SecureMailZimlet_sendMsgFail"), DwtMessageDialog.CRITICAL_STYLE);
        return;
    }
    var bodyContent = SecureMailZimlet.zmComposeView._htmlEditor.getContent()
    if(bodyContent.indexOf(SecureMailZimlet.secureTokenPlain) > -1) {
        setTimeout("SecureMailZimlet.zmComposeController._send()", SecureMailZimlet.sendDelay);
    }
    else { // If the secure token has not been inserted try again in two seconds.
        setTimeout("SecureMailZimlet.sendSafeWithToken(" + (++counter) + ")", 2000);
    }
}

/**
 * Sends the secured email after having inserted the secure token
 * into the email text.
 */
SecureMailZimlet.prototype._sendSecureEmail =
    function(controller) {
        if(SecureMailZimlet.zmComposeController && SecureMailZimlet.zmComposeView) {
            SecureMailZimlet._removeSecureToken(); // Ensure that the token is only once in the text.
            var bodyContent = SecureMailZimlet.zmComposeView._htmlEditor.getContent()
            var res = bodyContent.search(SecureMailZimlet.bodyRegex);
            if(res > -1) { // HTML version. This inserts a hidden comment.
                bodyContent = bodyContent.replace(SecureMailZimlet.bodyRegex, SecureMailZimlet.secureTokenHtml + RegExp.$1)
            }
            else { // Text version
                bodyContent += '\n' + SecureMailZimlet.secureTokenPlain
            }
            SecureMailZimlet.zmComposeView._htmlEditor.setContent(bodyContent);
            SecureMailZimlet.sendSafeWithToken(0);
        }
    };

    
