/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010 Zimbra, Inc.
 *
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Zimlet to get shortened URL of documents in Briefcase
 *
 * @author whasic hwei@zimbra.com
 */


function com_zimbra_briefcaseshorturl_HandlerObject() {}
com_zimbra_briefcaseshorturl_HandlerObject.prototype = new ZmZimletBase();
com_zimbra_briefcaseshorturl_HandlerObject.prototype.constructor = com_zimbra_briefcaseshorturl_HandlerObject;

/**
 * Simplify handler object
 *
 */
var BriefcaseShortURLZimlet = com_zimbra_briefcaseshorturl_HandlerObject;

/**
 * Initializes the zimlet.
 *
 */
BriefcaseShortURLZimlet.prototype.init = function() {
	this.metaData = appCtxt.getActiveAccount().metaData;
	
};

BriefcaseShortURLZimlet.API_selected_index=1;
BriefcaseShortURLZimlet.API_selected_value="bit.ly";

BriefcaseShortURLZimlet.prototype.menuItemSelected =
function(itemId) {
	switch (itemId) {
	case "API_T_CN":
		this._select_API_t_cn();
		break;
	case "API_S8_HK":
		this._select_API_s8_hk();
		break;
	case "API_BIT_LY":
		this._select_API_bit_ly();
		break;
	default:
		// do nothing
		break;
	}
};

BriefcaseShortURLZimlet.prototype._select_t_cn = 
function() {
	BriefcaseShortURLZimlet.API_selected_index=0;
	BriefcaseShortURLZimlet.API_selected_value="t.cn";
};

BriefcaseShortURLZimlet.prototype._select_API_s8_hk = 
function() {
	BriefcaseShortURLZimlet.API_selected_index=2;
	BriefcaseShortURLZimlet.API_selected_value="s8.hk";
};

BriefcaseShortURLZimlet.prototype._select_API_bit_ly = 
function() {
	BriefcaseShortURLZimlet.API_selected_index=1;
	BriefcaseShortURLZimlet.API_selected_value="bit.ly";
};

BriefcaseShortURLZimlet.prototype._displayShortURLConfigDlg =
function() {
	if (this.BSUConfigDialog) { //if zimlet dialog already exists...
		this.BSUConfigDialog.popup(); //simply popup the dialog
		return;
	}
	var sDialogTitle = this.getMessage("Config_Dialog_Title");
	this.confDialogView = new DwtComposite(this.getShell()); //creates an empty div as a child of main shell div
	this.confDialogView.setSize("250", "100"); // set width and height
	this.confDialogView.getHtmlElement().style.overflow = "auto"; // adds scrollbar
	this.confDialogView.getHtmlElement().innerHTML = this._createDialogView(); // insert html to the dialogbox
	this.BSUConfigDialog = new ZmDialog({title:sDialogTitle, view:this.confDialogView, parent:this.getShell(), standardButtons:[DwtDialog.OK_BUTTON]});
	this.BSUConfigDialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._ConfDialogOKBtnListener)); 
	this.BSUConfigDialog.popup(); //show the dialog
};
BriefcaseShortURLZimlet.prototype._createDialogView =
	function() {
		var html = new Array();
		var i = 0;
		html[i++] = "<input ";
		html[i++] = "type='radio' name='BSU_API' value='t.cn'/ >";
		html[i++] = "Get shortened url via http://t.cn";
		html[i++] = "<br />";
		html[i++] = "<input ";
		html[i++] = "type='radio' name='BSU_API' value='bit.ly'/ checked=true>";
		html[i++] = "Get shortened url via http://bit.ly";
		html[i++] = "<br />";
		html[i++] = "<input ";
		html[i++] = "type='radio' name='BSU_API' value='s8.hk'/>";
		html[i++] = "Get shortened url via http://s8.hk";
		html[i++] = "<br />";
		return html.join("");
	};
	
BriefcaseShortURLZimlet.prototype._ConfDialogOKBtnListener =
function() {
		this.BSUConfigDialog.popdown();
		var BSU_API_radio=document.getElementsByName("BSU_API");
		for(i=0;i<BSU_API_radio.length;i++)
		{
			if(BSU_API_radio[i].checked==true)
			{
				BriefcaseShortURLZimlet.API_selected_index=i;
				BriefcaseShortURLZimlet.API_selected_value=BSU_API_radio[i].value;
			}
		}
	};
/**
 * Adds button to Briefcase toolbar.
 *
 */
BriefcaseShortURLZimlet.prototype.initializeToolbar = function(app, toolbar, controller, viewId) {
	if (viewId.indexOf("BDLV") >= 0) {
		this._initBriefcaseShortURLToolbar(toolbar, controller);
	}
	
};
/**
 * Initiates briefcase toolbar.
 *
 * @param {ZmToolbar} toolbar	 the Zimbra toolbar
 * @param {ZmCalController} controller  the Zimbra calendar controller
 */
BriefcaseShortURLZimlet.prototype._initBriefcaseShortURLToolbar = function(toolbar, controller) {
	if (!toolbar.getButton("Short URL")) {
		ZmMsg.sforceAdd = this.getMessage("BriefcaseShortURLZimlet_SendShortURL_Button_Text");
		for (var i = 0; i < toolbar.opList.length; i++) {
			if (toolbar.opList[i] == "COMPOSE_FORMAT" || toolbar.opList[i] == "VIEW_MENU") {
				buttonIndex = i + 1;
				break;
			}
		}
		var btn = toolbar.createOp("Short URL", {image:"ShortURL-panelIcon", text:ZmMsg.sforceAdd, tooltip:this.getMessage("BriefcaseShortURLZimlet_SendShortURL_Button_Tooltip"), index:buttonIndex});
		//var buttonIndex = 0;
		toolbar.addOp("Short URL");
		var menu = new ZmPopupMenu(btn); //create menu
		//button.setMenu(menu);//add menu to button
		//button.noMenuBar = true;
		this._composerCtrl = controller;
		this._composerCtrl.BriefcaseShortURLZimlet = this;
		btn.addSelectionListener(new AjxListener(this._composerCtrl, this._sendShortURLHandler));
		btn.setMenu(new AjxCallback(this, this._setupSUConfigMenuItems, [toolbar,menu,btn]));
	}
};

BriefcaseShortURLZimlet.prototype._setupSUConfigMenuItems =
function(toolbar,menu,button) {
	ZmMsg.sforceAdd = this.getMessage("BriefcaseShortURLZimlet_SendShortURL_Button_Text");
	button.setMenu(menu);
	id_preference="Short URL Preference";
	var params_preference = {
		image: "SU_API_Preference-panelIcon",
		text: "Preference"
		};
	var mi_preference = menu.createMenuItem(id_preference, params_preference);
	mi_preference.addSelectionListener(new AjxListener(this, this._displayShortURLConfigDlg));
	return menu;
}; 


BriefcaseShortURLZimlet.prototype._sendShortURLHandler = function(event) {
	BriefcaseShortURLZimlet.count=0;
	BriefcaseShortURLZimlet.view = this._listView[this._currentView];
	BriefcaseShortURLZimlet.items = BriefcaseShortURLZimlet.view.getSelection();
	BriefcaseShortURLZimlet.items = AjxUtil.toArray(BriefcaseShortURLZimlet.items);
	BriefcaseShortURLZimlet.names = [];
	BriefcaseShortURLZimlet.urls = [];
	BriefcaseShortURLZimlet.inNewWindow = this._app._inNewWindow(event);
	BriefcaseShortURLZimlet.briefcase=[];
	BriefcaseShortURLZimlet.shares=[];
	BriefcaseShortURLZimlet.noprompt = false;
	BriefcaseShortURLZimlet.count=new Object(BriefcaseShortURLZimlet.items.length);
	for (var i = 0; i < BriefcaseShortURLZimlet.items.length; i++) {
		var item = BriefcaseShortURLZimlet.items[i];
		var url = item.getRestUrl();
		if (appCtxt.isOffline) {
			var remoteUri = appCtxt.get(ZmSetting.OFFLINE_REMOTE_SERVER_URI);
			url = remoteUri + url.substring((url.indexOf("/",7)));
		}
		var BSU_API_radio=document.getElementsByName("BSU_API");
		/*BriefcaseShortURLZimlet.API_selected_value="";
		for(var j=0;j<BSU_API_radio.length;j++)
		{
			if(BSU_API_radio[j].checked==true)
			{
				BriefcaseShortURLZimlet.API_selected_index=j;
				BriefcaseShortURLZimlet.API_selected_value=BSU_API_radio[j].value;
			}
		}*/
		var result="";
		var extServer="";
		var extServerParams="";
		if(BriefcaseShortURLZimlet.API_selected_value=="s8.hk")
		{
			extServer= "http://s8.hk/api/s";
			extServerParams=["u","=",url].join("");
		}
		if(BriefcaseShortURLZimlet.API_selected_value=="bit.ly")
		{
			extServer= "http://api.bitly.com/v3/shorten";
			extServerParams=["login=zimbratest&apiKey=R_65cc18d1ea8cd0916d6c8d467c10bb74&longUrl","=",url,"&format=txt"].join("");
		}
		if(BriefcaseShortURLZimlet.API_selected_value=="t.cn")
		{
			extServer= "http://api.t.sina.com.cn/short_url/shorten.json";
			extServerParams=["source=3764235931&url_long","=",url].join("");
		}
		var extServerUrl = [extServer, "?", extServerParams].join("");
		var encodedExtServerUrl = AjxStringUtil.urlComponentEncode(extServerUrl);
		var proxyServletUrl = [ZmZimletBase.PROXY, encodedExtServerUrl].join("");
		AjxRpc.invoke(null, proxyServletUrl, null, new AjxCallback(this,BriefcaseShortURLZimlet.prototype._httpCallBack), true);
		BriefcaseShortURLZimlet.names.push(item.name);
		if (BriefcaseShortURLZimlet.noprompt) { continue; }
		BriefcaseShortURLZimlet.briefcase = appCtxt.getById(item.folderId);
		BriefcaseShortURLZimlet.shares = BriefcaseShortURLZimlet.briefcase && BriefcaseShortURLZimlet.briefcase.shares;
		if (BriefcaseShortURLZimlet.shares) {
			for (var j = 0; j < BriefcaseShortURLZimlet.shares.length; j++) {
				BriefcaseShortURLZimlet.noprompt = BriefcaseShortURLZimlet.noprompt || BriefcaseShortURLZimlet.shares[j].grantee.type == ZmShare.TYPE_PUBLIC;
			}
		}
	}
}; 

BriefcaseShortURLZimlet.prototype._sendFileListener2 =
function(names, urls, inNewWindow) {
    var action = ZmOperation.NEW_MESSAGE;
    var msg = new ZmMailMsg();
    var toOverride = null;
    var subjOverride = new AjxListFormat().format(names);
    var htmlCompose = appCtxt.get(ZmSetting.COMPOSE_AS_FORMAT) == ZmSetting.COMPOSE_HTML;
    var extraBodyText = urls.join(htmlCompose ? "<br>" : "\n");
    AjxDispatcher.run("Compose", {action: action, inNewWindow: inNewWindow, msg: msg,
                                  toOverride: toOverride, subjOverride: subjOverride,
                                  extraBodyText: extraBodyText});
};
BriefcaseShortURLZimlet.prototype._httpCallBack=function(response) {
	BriefcaseShortURLZimlet.count--;
	if (response.success == false) {
		appCtxt.getAppController().setStatusMsg("Error: " + response.text, ZmStatusView.LEVEL_WARNING);
		BriefcaseShortURLZimlet.urls.push('Can not get shortened url, please try another API provider.');
	}
	else
	{
		if(BriefcaseShortURLZimlet.API_selected_value=="t.cn")
		{
			var myobj=JSON.parse(response.text);
			BriefcaseShortURLZimlet.urls.push(myobj[0].url_short);
		}
		else
		{
			BriefcaseShortURLZimlet.urls.push(response.text);
		}
	}
	if(BriefcaseShortURLZimlet.count==0)
	{
		if (!BriefcaseShortURLZimlet.shares || !BriefcaseShortURLZimlet.noprompt) {
				var args = [BriefcaseShortURLZimlet.names, BriefcaseShortURLZimlet.urls, BriefcaseShortURLZimlet.inNewWindow];
				var callback = new AjxCallback(this, BriefcaseShortURLZimlet.prototype._sendFileListener2, args);
				var dialog = appCtxt.getConfirmationDialog();
				dialog.popup(ZmMsg.errorPermissionRequired, callback);
		} 
		else 
		{
			BriefcaseShortURLZimlet.prototype._sendFileListener2(BriefcaseShortURLZimlet.names, BriefcaseShortURLZimlet.urls);
		}
	}
	return;
};

















