/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010 Zimbra, Inc.
 *
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */
/**
 * Zimlet to Check package delivery information via Kuidi100
 *
 * @author whasic hwei@zimbra.com
 */
 
function ZmtrackcnZimlet() {
}

ZmtrackcnZimlet.prototype = new ZmZimletBase();
ZmtrackcnZimlet.prototype.constructor = ZmtrackcnZimlet;

ZmtrackcnZimlet.trackCompanyCode=[];
ZmtrackcnZimlet.trackCompanyName=[];


ZmtrackcnZimlet.prototype.match =
function(line, startIndex) {
	this._setRegExps();
	if (this._regexps.length == 0) {
		return;
	}

	var a = this._regexps;
	var ret = null;
	for (var i = 0; i < a.length; ++i) {
		var re = a[i];
		re.lastIndex = startIndex;
		var m = re.exec(line);
		if (m && m[0] != "") {
			if (!ret || m.index < ret.index) {
				ret = m;
				ret.matchLength = m[0].length;
				return ret;
			}
		}
	}
	return ret;
};

ZmtrackcnZimlet.prototype._setRegExps =
function() {
	if(this._regexps) {
		return this._regexps;
	}
	var regexSegment,re;
	var i=0;
	re="("+this.getMessage("Company0.Regex")+")";
	ZmtrackcnZimlet.trackCompanyName[0]=this.getMessage("Company0.Name");
	ZmtrackcnZimlet.trackCompanyCode[0]=this.getMessage("Company0.Code");
	for (i = 1; regexSegment = this.getMessage("Company"+i+".Regex"); i++) 
	{
		if (regexSegment.indexOf("###")!=-1) break;
		re=re+"|("+regexSegment+")";
		ZmtrackcnZimlet.trackCompanyName[i]=this.getMessage("Company"+i+".Name");
		ZmtrackcnZimlet.trackCompanyCode[i]=this.getMessage("Company"+i+".Code");
	}
	this._regexps = new Array();
	this._regexps.push(new RegExp(re, "ig"));
};


ZmtrackcnZimlet.prototype.clicked =
function(spanElem, contentObj, matchContext, canvas) {
	url=this._getQueryUrl(contentObj,true);
	canvas = window.open(url);
};

ZmtrackcnZimlet.time=0;
ZmtrackcnZimlet.prototype.toolTipPoppedUp =
function(spanElement, addrs, context, canvas) {
		ZmtrackcnZimlet.time
		AjxRpc.invoke(null, this._getQueryUrl(addrs,false), null, new AjxCallback(this,this._httpExternalGetCallback), false,10000);	
		var div=null;
		canvas.innerHTML="<h1>Querying</h1>";
};

/**
  * Kuaidi100 open API offers two kind of calling method.
  * The calling method of "chaxun" returns all the status of the track package from 
  * get the package to deliver it.
  * When users clicked the automatic underlined logistics tracking number. A new 
  * window or tab will appear and display the result. 
  * The calling method of "apione" returns the last status of the track package
  * When users put his mouse on the underlined logistics tracking number. A poped-up
  * will display the result.
 **/
ZmtrackcnZimlet.prototype._getQueryUrl =
function(myaddrs,isOpen) {
	var CompanyCode=null;
	var s1=myaddrs.split("\uFF1A");
	var s2=myaddrs.split("\u662F");
	if (s1.length==2) splitResult=s1;
	if (s2.length==2) splitResult=s2;
	var CompanyName=splitResult[0];
	var trackNumber=splitResult[1];
	var i;
	for(i=0;i<ZmtrackcnZimlet.trackCompanyName.length;i++)
	{
		if(CompanyName.indexOf(ZmtrackcnZimlet.trackCompanyName[i])!=-1)
		{
			CompanyCode=ZmtrackcnZimlet.trackCompanyCode[i];
			break;
		}
	}
	/**
	 * This code segment returns the complete url to call for the whole status of the 
	 * package by the calling method of "chaxun"
	 **/
	if(isOpen)
	{
		var extServer = "http://api.kuaidi100.com/chaxun";
		var extServerParams1 = ["com", "=", CompanyCode].join("");
		var extServerParams2 = ["nu", "=", trackNumber].join("");
		var extServerUrl = [extServer, "?", extServerParams1,"&",extServerParams2].join("");
		url=extServerUrl;
	}
	/**
	 * This code segment returns the complete url to call for the whole status of the 
	 * package by the calling method of "apione"
	 **/
	else
	{
		var extServer = "http://api.kuaidi100.com/apione";
		var extServerParams1 = ["com", "=", AjxStringUtil.urlComponentEncode(CompanyCode)].join("");
		var extServerParams2 = ["nu", "=", AjxStringUtil.urlComponentEncode(trackNumber)].join("");
		var extServerParams3 = ["show", "=", AjxStringUtil.urlComponentEncode("0")].join("");
		var extServerUrl = [extServer, "?", extServerParams1,"&",extServerParams2,"&",extServerParams3].join("");
		var encodedExtServerUrl = AjxStringUtil.urlComponentEncode(extServerUrl);
		var proxyServletUrl = [ZmZimletBase.PROXY, encodedExtServerUrl].join(""); 
		url=proxyServletUrl;
	}
	return url;
};
ZmtrackcnZimlet.prototype._httpExternalGetCallback =
function(response) {
	var jsonObj=null;
	if (response.success == false) {
		appCtxt.getAppController().setStatusMsg("Error: " + response.text, ZmStatusView.LEVEL_WARNING);
		return;
	}
	else if(response.status == AjxRpcRequest.TIMEOUT)
	{
		var div=document.getElementById("zimletTooltipDiv");
		div.innerHTML="<H1>Query Timeout</H1>";
	}
	jsonObj=JSON.parse(response.text);
	var div=document.getElementById("zimletTooltipDiv");
	div.innerHTML=[
			'<table><tr><td>\u65F6\u95F4</td><td>\u5FEB\u9012\u8DDF\u8E2A</td></tr>',
			'<tr><td>',
			jsonObj.data[0].time,
			'</td><td>',
			jsonObj.data[0].context,
			'</td></tr></table>'
		].join("");
};



