/****************************************************************************
 **
 ** Copyright (C) 2011 Irontec SL. All rights reserved.
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 3.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
/***
 * zspamRunner
 * 
 */
function zspamRunner(parent){
	this.parent = parent;
};

/***
 * zspamRunner.prototype._doPOST
 *
 * This function sends JSON petitions to a local JSP (redirect.jsp)
 * which actually sends the final messages to SugarCRM
 * This JSP acts as a proxy for all petitions from zSugar. The reason
 * for this is that, in some cases we want some task done in server
 * side (that's the JSP) and other in the client side (that's this
 * JavaScript code) 
 * 
 * @param url           @Deprecated
 * @param params        JSON structure
 * @param callback      Callback Function after async Ajax call
 */
zspamRunner.prototype._exec = function (params, callback) {
        var arr = [];
	var hdrs = [];

	/* Convert parameters */
        for (var i = 0; i < params.length; i++) {
		arr.push(AjxStringUtil.urlComponentEncode(params[i][0]) + "=" + AjxStringUtil.urlComponentEncode(params[i][1]));
	}

	/* Set HTTP Rquest Headers */
	hdrs["Content-type"] = "application/x-www-form-urlencoded";

	/* Get JSP URL */
	var jspUrl = this.parent.getResource("runner.jsp");

	/* Set async by default */
	AjxRpc.invoke(arr.join("&"), jspUrl, hdrs, new AjxCallback(this, this._postop, callback), false);
}

zspamRunner.prototype._postop = function (callback, response) {
	try {
		/* Parse JSP response */
		var json_response = eval("("+response.text + ")");
		/* Do the proper callback */
		if (callback) callback.call(this.parent, json_response);
	} catch(e) {
		// Show error in Zimbra
		this.parent.showError(e.name);
	}
}

//---------------------------------------------------------------------
// Basic Zimlet Functions
//---------------------------------------------------------------------
zspamRunner.prototype.checkInstalled = function (callback){
	var params = [["Action", "check_installed"]];
	this._exec(params, callback, true);

}

//---------------------------------------------------------------------
// Razor Network Functions
//---------------------------------------------------------------------
zspamRunner.prototype.razorRegister = function(user, pass, callback){
	var params = [	["Action", "razor_register"],
		      	["User", user],
		      	["Pass", pass]];
	this._exec(params, callback);
}

zspamRunner.prototype.razorReport = function(user, msg, callback){
	var mailurl = this._getMailUrl(msg);
	var params = [	["Action", "razor_report"],
		    	["User", user ],
			["MailData", mailurl ]];
	this._exec(params, callback);	
}

zspamRunner.prototype.razorRevoke = function(user, msg, callback){
	var mailurl = this._getMailUrl(msg);
	var params = [	["Action", "razor_revoke"],
			["User", user ],
			["MailData", mailurl]];
	this._exec(params, callback);
}

//---------------------------------------------------------------------
// Pyzor Network Functions
//---------------------------------------------------------------------
zspamRunner.prototype.pyzorReport = function(msg, callback) {
	var mailurl = this._getMailUrl(msg);
	var params = [	["Action", "pyzor_report"],
			["MailData", mailurl]];
	this._exec(params, callback);
}

zspamRunner.prototype.pyzorRevoke = function(msg, callback) {
	var mailurl = this._getMailUrl(msg);
	var params = [	["Action", "pyzor_revoke"],
			["MailData", mailurl]];
	this._exec(params, callback);
}

//---------------------------------------------------------------------
// DCC Network Functions
//---------------------------------------------------------------------
zspamRunner.prototype.dccReport = function(msg, callback) {
	var mailurl = this._getMailUrl(msg);
	var params = [	["Action", "dcc_report"],
			["MailData", mailurl]];
	this._exec(params, callback);
}

//---------------------------------------------------------------------
// SpamCop Network Functions
//---------------------------------------------------------------------
zspamRunner.prototype.spamcopReport = function(msg, callback) {
	var params = [	["Action", "spamcop_report"] ];
	this._exec(params, callback);
}


//---------------------------------------------------------------------
// Auxiliary Functions
//---------------------------------------------------------------------
zspamRunner.prototype._escapeJSON = function(s){
	if( s==null ) return null;
	var sb = [];
	for(var i=0; i< s.length ;i++){
		var ch = s.charAt(i);
		switch(ch){
			case '"': 	sb.push("\\\""); break;
			case '\\': 	sb.push("\\\\"); break;
			case '\b':	sb.push("\\b");  break;
			case '\f':	sb.push("\\f");	 break;
			case '\n':	sb.push("\\n");  break;
			case '\r':	sb.push("\\r");  break;
			case '\t':	sb.push("\\t");  break;
			case '/':	sb.push("\\/"); break;
			default:	sb.push(ch);
		}
	}
	return sb.join("");
}

zspamRunner.prototype._getBodyContent = function(msg){
        var body = msg.getTextPart();
        if (!body) body = "";
        if (msg.getBodyPart(ZmMimeTable.TEXT_HTML)) {
                var div = document.createElement("div");
                div.innerHTML = msg.getBodyPart(ZmMimeTable.TEXT_HTML).content;
                body = AjxStringUtil.convertHtml2Text(div);
        }
        return body;
}

zspamRunner.prototype._getMailUrl = function (msg){
	var port = Number(location.port);
        var proto = location.protocol;
        var baseURL =
        [       location.protocol,
                '//',
                location.hostname,
                (
                 (port && ((proto == ZmSetting.PROTO_HTTP && port != ZmSetting.HTTP_DEFAULT_PORT)
                || (proto == ZmSetting.PROTO_HTTPS && port != ZmSetting.HTTPS_DEFAULT_PORT)))?
                        ":"+port:''),
                "/service/home/~/"
        ].join("");

        // Fix for Desktop versions
        var msgId = msg.id;
        if (msgId.indexOf(":") != -1 )
            msgId = msgId.split(":")[1];

	return baseURL + "?id=" + msgId;
}
