/****************************************************************************
 **
 ** Copyright (C) 2011 Irontec SL. All rights reserved.
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 3.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/
/***
 * com_irontec_zspamH
 * 
 * This object works as handler for the zSpam Zimlet
 * Interaction with zimlet is divided into:
 *  - A Panel Icon where Messages or Conversations can be droped. It also
 *    has a context menu when right clicked, and options panel when single/double clicked.
 *  - A Toolbar Button. It works as dropping a Msg/Conv into the Panel Icon.
 *  - A Context Menu Button.  It works as dropping a Msg/Conv into the Panel Icon.
 *  
 * This zimlet is used to mark an email as Spam in multiple known Spam networks. 
 * Some of these networks require a login that can be configured in Zimlet Configuration Panel
 * Some of these networks can revoke a spam marked email
 * This zimle only INVOKES reporting tools for that networks, so if you want any of them
 * to work, you MUST install binaries that do the work.
 * Execution of this tools is done using runner.js and runner.jsp
 *  
 */
function com_irontec_zspamH() 
{
	this._appName = "zSpam";
	this._appVersion = "1.0-beta1";
	this._appDesc = "Report mails as spam in CNETs";

	this._initializated = false;
}
com_irontec_zspamH.prototype = new ZmZimletBase();
com_irontec_zspamH.prototype.constructor = com_irontec_zspamH;
com_irontec_zspamH.prototype.singleClicked = function() { this.doubleClicked(); } 
com_irontec_zspamH.prototype.doubleClicked = function() { this._displayConfigDialog(); }

/***
 * com_irontec_zspamH.prototype.menuItemSelected
 * 
 * This function works as wrapper for the Selected item in the Context
 * menu of the Zimlets Panel Icon
 * 
 * @param itemId	Selected item in the context menu of the panel zimlet
 */
com_irontec_zspamH.prototype.menuItemSelected = function(itemId)
{
	// Detect which Option in the Context Menu has been choosen
	switch (itemId) {
		/*** Show About Box ***/
		case "ISPAM_ABOUT":
			var _view = new DwtComposite(this.getShell()); 	// Creates an empty div as a child of main shell div
			_view.setSize("350", "230"); 					// Set width and height
			_view.getHtmlElement().innerHTML = this.getMessage("zspam_aboutText");
			var _dialog = new ZmDialog({title:this.getMessage("zspam_about"), 
				view:_view, parent:this.getShell(), standardButtons:[DwtDialog.OK_BUTTON]});
			_dialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, function() {_dialog.popdown();}));
			_dialog.popup();
			break;
			
		/*** Show Preferences Box ***/
		case "ISPAM_PREFERENCES":
                        this._displayConfigDialog();
			break;
	}
}

/***
 * com_irontec_zspamH.prototype.initializeToolbar
 * 
 * This function works as hook for adding or editing main toolbar icons
 * 
 * It adds the zSpam button at the end of the bar, just after the 
 * View Icon. When this button is clicked, it will callback private
 * _addSpamMsg function.
 * 
 */
com_irontec_zspamH.prototype.initializeToolbar = function(app, toolbar, controller, viewId)
{
	// Get the index of "Spam" menu so we can display the button after that
	var buttonIndex = 0;
	for (var i = 0; i < toolbar.opList.length; i++){
		if (this.getUserProperty("noSpamOverride") != "true" ){
			if (toolbar.opList[i] == ZmOperation.SPAM ){
				toolbar.removeOp(toolbar.opList[i]);
	        	    	buttonIndex = i;
		            	break;
		        }
		}else{
                	if (toolbar.opList[i] == ZmOperation.VIEW_MENU) {
	                    buttonIndex = i + 1;
	                    break;
        	        }
		}
	}
	
	if (buttonIndex != 0 ){
	        // Configure Toolbar button
	        var buttonParams = {
	            text: this.getMessage("zspam_addSpam"),
	            tooltip: this.getMessage("zspam_addSpam_tooltip"),
	            index: buttonIndex,
	            image: "ISPAM-panelIcon",
		    enabled: false
	        };
	
		// Creates the button with an id and params containing the button details
	        this.spamButton = toolbar.createOp("SEND_SPAM_TOOLBAR", buttonParams);
	        this.spamButton.addSelectionListener(new AjxListener(this, this._addSpamMsg,controller));   
		this.spamButton.setToolTipContent(ZmMsg.junkTooltip);
		this.spamButton.setText(ZmMsg.junk);
	}
}


/***
 * com_irontec_zspamH.prototype.init
 * 
 * Init the Zimlet.
 * 
 * It adds the zSpam button at the end of context menu, just after the 
 * View Icon. When this button is clicked, it will callback private
 * _addSpamMsg function. 
 */
com_irontec_zspamH.prototype.init = function() 
{
	var controller = appCtxt.getCurrentController();
	this._shell = this.getShell();
	this._runner = new zspamRunner(this);

	/* If a context menu is available */
	if (controller.getActionMenu){
		var menu = controller.getActionMenu();
		
		// Find the Last Menu Position
		var buttonIndex = 0;
		for (var i = 0; i < menu.opList.length; i++) 
		    if (menu.opList[i] == ZmOperation.CREATE_TASK) {
		            buttonIndex = i + 1;
		            break;
		    }
			buttonIndex = menu.opList.length +1 ;

		    // Add a new button
		    var menuParams = {
		        text: this.getMessage("zspam_bn_addSpam"),
		        tooltip: this.getMessage("zspam_bn_addSpam_tooltip"),
		        index: buttonIndex,
		        image: "ISPAM-panelIcon"
		};
		
		// When this button is clicked execute callback
		var mi = menu.createMenuItem("SEND_SPAM_MENU", menuParams);
		mi.addSelectionListener(new AjxListener(this, this._addSugarMsg,controller));
	}

	// Check installed software
	this._runner.checkInstalled(this._setInstalledTools);
}

/***
 * com_irontec_zspamH.prototype._addSpamMsg
 *
 * Callback function for Toolbar and Context Menu Item
 *
 * This function works as wrapper for the non-panel icons. It just
 * get the Message info and calls _displayMSGDialog, as it will occur
 * when some Msg/Conv is droped into the Zimlet Panel Icon
 * 
 */
com_irontec_zspamH.prototype._addSpamMsg = function(controller)
{
	var msg = controller._listView[controller._currentView].getSelection()[0];
	if (msg){
		this.doDrop(msg);
	}
}

com_irontec_zspamH.prototype._setInstalledTools = function(installed)
{
	/* Set what tools are installed */
	this._razorInstalled = installed.razor;
	this._pyzorInstalled = installed.pyzor;
	this._dccInstalled = installed.dcc;
	this._spamcopInstalled = installed.spamcop;
	
	/* Mark initialization done */
	this._initializated = true;
}

com_irontec_zspamH.prototype._checkCNETs = function() {
	
	if (this.getUserProperty("razorEnabled") == true ||
            this.getUserProperty("razorEnabled") == "true" ||
            this.getUserProperty("pyzorEnabled") == true ||
            this.getUserProperty("pyzorEnabled") == "true" ||
            this.getUserProperty("dccEnabled") == true ||
            this.getUserProperty("dccEnabled") == "true" )
            return 0;


	return 1;
}

com_irontec_zspamH.prototype._isSpam = function (msg) {


	/* Check if we are in the Spam Folder */
	var controller = appCtxt.getCurrentController();
	if(controller._getSearchFolderId() == ZmFolder.ID_SPAM)
		return 1;

        /* Check Mark as zSpam Tag */
        var tagName = this.getUserProperty("tagSpam");
        if ( tagName != undefined && tagName != "" ){
                // Get Requested tag
                var tagObj = appCtxt.getActiveAccount().trees.TAG.getByName(tagName);

                // If Tag exists and message is tagged with this tag
                if (tagObj && msg.tagHash[tagObj.id] !== undefined){
                        return 1;
                }

        }

	return 0;
}

/***
 * com_irontec_zspamH.prototype.doDrop
 *
 * Callback function for Zimlet Panel Icon 
 *
 * This function works as wrapper for the panel icons. It just
 * get the Message info and calls _displayMSGDialog.
 * 
 */
com_irontec_zspamH.prototype.doDrop = function(obj) {
	var msgs = [];
	var msgs_reported = [];
	var msgs_revoked  = [];
	var conv_reported_cnt = 0;
	var conv_revoked_cnt = 0;
	var msgs_reported_cnt = 0;
	var msgs_revoked_cnt = 0;

	/* Check CNETS */
	if (this._checkCNETs() == 1){
		this.showWarning(this.getMessage("zspam_nocnets_report"));
		return;
	}

	/* Check if we have multiple drops */
	if (obj instanceof Array )
		msgs = obj;		
	else
		msgs.push(obj);
	
	for (var i=0; i < msgs.length; i++){
		var msg = (msgs[i].srcObj == undefined )?msgs[i]:msgs[i].srcObj;

		if (!this._isSpam(msg)){
			(msg instanceof ZmConv) ? conv_reported_cnt++ : msgs_reported_cnt++;
			msgs_reported.push(msg);
			this.tag(msg);
			this._reportMessage(msg);
		} else {
			(msg instanceof ZmConv) ? conv_revoked_cnt++ : msgs_revoked_cnt++; 
			msgs_revoked.push(msg);
			this.untag(msg);
			this._revokeMessage(msg);
	    	}
	}

	/* Show finish dialog */
	if (conv_reported_cnt > 0 ) {
		var cnt = conv_reported_cnt + " " + ((conv_reported_cnt == 1 )?this.getMessage("zspam_conversation"):this.getMessage("zspam_conversations"));
		this.showMessage(cnt+" "+this.getMessage("zspam_reportedspam"));
	}
	if (msgs_reported_cnt > 0 ){
                var cnt = msgs_reported_cnt + " " + ((msgs_reported_cnt == 1 )?this.getMessage("zspam_message"):this.getMessage("zspam_messages"));
                this.showMessage(cnt+" "+this.getMessage("zspam_reportedspam"));
	}
	if (conv_revoked_cnt > 0){
                var cnt = conv_revoked_cnt + " " + ((conv_revoked_cnt == 1 )?this.getMessage("zspam_conversation"):this.getMessage("zspam_conversations"));
                this.showMessage(cnt+" "+this.getMessage("zspam_revokedspam"));
	}
        if (msgs_revoked_cnt > 0 ){
                var cnt = msgs_revoked_cnt + " " + ((msgs_revoked_cnt == 1 )?this.getMessage("zspam_message"):this.getMessage("zspam_messages"));
                this.showMessage(cnt+" "+this.getMessage("zspam_revokedspam"));
        }

	if (this.getUserProperty("moveSpam") == "true" || this.getUserProperty("moveSpam") == true ) {
		var controller =  appCtxt.getCurrentController();
		if (msgs_reported.length)
			controller._doMove(msgs_reported, appCtxt.getTree(ZmOrganizer.FOLDER).getById(ZmFolder.ID_SPAM));
		if (msgs_revoked.length)
			controller._doMove(msgs_revoked, appCtxt.getTree(ZmOrganizer.FOLDER).getById(ZmFolder.ID_INBOX));
	}

	/* Increase Reported and Revoked Message Count */
        this.setUserProperty("reportedMails", parseInt(this.getUserProperty("reportedMails")) + conv_reported_cnt +  msgs_reported_cnt);
	this.setUserProperty("revokedMails", parseInt(this.getUserProperty("revokedMails")) + conv_revoked_cnt +  msgs_revoked_cnt);	
        this.saveUserProperties();
}


com_irontec_zspamH.prototype.onShowView = function (e) {
}

com_irontec_zspamH.prototype.onSearch = function (e) {

        var inSpamFolder = ( e == 'in:"junk"' );
	this.spamButton.setToolTipContent(inSpamFolder ? ZmMsg.notJunkTooltip : ZmMsg.junkTooltip);
        this.spamButton.setText(inSpamFolder ? ZmMsg.notJunk : ZmMsg.junk);

}

com_irontec_zspamH.prototype.onAction = function (i,a,e,t) {
}



/***
 * com_irontec_szspamH.prototype.tag
 * 
 * Tags an Email with the proper TagLabel.
 * Used to tag Exported mails.
 *
 */
com_irontec_zspamH.prototype.tag = function (msg) {
        /* Mark mail as spam if requested */
        var tagname = this.getUserProperty("tagSpam");
        if ( tagname != undefined && tagname != "" )
		this._tagAction(msg, tagname, "tag");
}

com_irontec_zspamH.prototype.untag = function (msg) {
        /* Unmark mail as spam if requested */
        var tagname = this.getUserProperty("tagSpam");
        if ( tagname != undefined && tagname != "" )
		this._tagAction(msg, tagname, "!tag");
}

com_irontec_zspamH.prototype._tagAction = function (msg, tagName, actionType){
	// Get Requested tag
        var tagObj = appCtxt.getActiveAccount().trees.TAG.getByName(tagName);

	// No tag found with that name
       	if(!tagObj) {
		// Create tag
		this.createTag(tagName);
		// Get created Tag
		tagObj = appCtxt.getActiveAccount().trees.TAG.getByName(tagName);
	}

	// Get Tag Command
	var tagId = tagObj.id;
	var axnType = actionType;
	var soapCmd = ZmItem.SOAP_CMD[msg.type] + "Request";

        // Fix for Desktop versions
        if (tagId.indexOf(":") != -1 )
            tagId = tagId.split(":")[1];

	var itemActionRequest = {};
	itemActionRequest[soapCmd] = {_jsns:"urn:zimbraMail"};
	var request = itemActionRequest[soapCmd];

	var action = request.action = {};
	action.id = msg.id;
	action.op = axnType;
	action.tag = tagId;

        // Fix for Desktop versions
        if (action.id.indexOf(":") != -1 ) action.id = action.id.split(":")[1];
        if (action.tag.indexOf(":") != -1 ) action.tag = action.tag.split(":")[1];

	var params = {asyncMode: true, callback: null, jsonObj:itemActionRequest};
	appCtxt.getAppController().sendRequest(params);

};


com_irontec_zspamH.prototype.createTag = function (tagName){
	// Tag Creation Command
        var soapCmd = "CreateTagRequest";

	// Get Tag Request Structure
        var itemActionRequest = {};
        itemActionRequest[soapCmd] = {_jsns:"urn:zimbraMail"};
        var request = itemActionRequest[soapCmd];

	// Fill Tag Structure
        var tag = request.tag = {};
	tag.name = tagName;
	tag.color = 1;		// Blue by default

	// Request Creation
        var params = {asyncMode: false, callback: null, jsonObj:itemActionRequest};
        appCtxt.getAppController().sendRequest(params);
}

	

com_irontec_zspamH.prototype.showError = function(msg) {
        this._showMsg(msg, ZmStatusView.LEVEL_CRITICAL);
}

com_irontec_zspamH.prototype.showMessage = function(msg) {
        this._showMsg(msg, ZmStatusView.LEVEL_INFO);
}

com_irontec_zspamH.prototype.showWarning = function(msg) {
	this._showMsg(msg, ZmStatusView.LEVEL_WARNING);
}

com_irontec_zspamH.prototype._showMsg = function (msg, level) {
        var html = new Array();
        var i = 0;
        html[i++] = msg + "<br>";
        html[i++] = "<small>"+this._appName + " (" + this._appVersion + ")</small>";
        appCtxt.getAppController().setStatusMsg(html.join(""), level);
}

/***************************************************************************
 **
 **                         Messages Process
 **
 **************************************************************************/

com_irontec_zspamH.prototype._reportMessage = function(msg){

	if (msg instanceof ZmConv )
		msg = msg.getFirstHotMsg();

	/* Report using Razor */
	if (this.getUserProperty("razorEnabled") == true || this.getUserProperty("razorEnabled") == "true") {
		/* Prepare Razor data */
		this._runner.razorReport(this.getUserProperty("razorUser"), msg, null);
	}

	/* Report using Pyzor */
	if (this.getUserProperty("pyzorEnabled") == true || this.getUserProperty("pyzorEnabled") == "true") {
		this._runner.pyzorReport(msg, null);
	}

	/* Report using DCC */
	if (this.getUserProperty("dccEnabled") == true || this.getUserProperty("dccEnabled") == "true") {
		this._runner.dccReport(msg, null);
	}
}
 
com_irontec_zspamH.prototype._revokeMessage = function(msg){

	/* Report using Razor */
	if (this.getUserProperty("razorEnabled") == "true" || this.getUserProperty("razorEnabled") == true) {
		/* Prepare Razor data */
		this._runner.razorRevoke(this.getUserProperty("razorUser"), msg, null);
	}

	/* Report using Pyzor */
	if (this.getUserProperty("pyzorEnabled") == "true" || this.getUserProperty("pyzorEnabled") == true) {
		this._runner.pyzorRevoke(msg, null);
	}
}

com_irontec_zspamH.prototype._displayConfigDialog = function() 
{
	/* If not initializated, show a message */
	if (!this._initializated){
                var _view = new DwtComposite(this.getShell());  // Creates an empty div as a child of main shell div
                _view.setSize("350", "230");                                    // Set width and height
                _view.getHtmlElement().innerHTML = this.getMessage("zspam_notInitializated");
                var _dialog = new ZmDialog({title:this.getMessage("zspam_notInitializatedTitle"),
                        view:_view, parent:this.getShell(), standardButtons:[DwtDialog.OK_BUTTON]});
                _dialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, function() {_dialog.popdown();}));
                _dialog.popup();
		return;
	}
	
	/* If Dialog already exists, just show it */
	if (this.configDlg) {
                this._setConfigValues();
                this.configDlg.popup();//simply popup the dialog
                return;
        }

	this._ConfigDlgView = new DwtComposite(this._shell);
	this._ConfigDlgView.setSize("500", "350");
	this._ConfigDlgView.getHtmlElement().style.overflow = "auto";
	this._ConfigDlgView.getHtmlElement().innerHTML = this._createConfigDlgView();
	
	this._btnRegister = new DwtButton(this._shell);
	this._btnRegister.setText(this.getMessage("zspam_register"));
	this._btnRegister.addSelectionListener(new AjxListener(this, this._razorRegister));
        this._btnRegister.setEnabled(this._razorInstalled);
	document.getElementById("zspam_razorRegister").appendChild(this._btnRegister.getHtmlElement());
	
	this.configDlg = this._createDialog({title:this.getMessage("zspam_preferencesTitle"), view:this._ConfigDlgView, standardButtons:[DwtDialog.OK_BUTTON, DwtDialog.CANCEL_BUTTON]});
	this.configDlg.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._configDlgOKBtnListener));
	this.configDlg.setButtonListener(DwtDialog.CANCEL_BUTTON, new AjxListener(this, function() { this.configDlg.popdown(); }));
	
	this._setConfigValues();
	this.configDlg.popup();
}

com_irontec_zspamH.prototype._razorRegister = function()
{
	/* Get Config Screen value */
        var razorUser           = document.getElementById("zspam_razorUser").value;
        var razorPass           = document.getElementById("zspam_razorPass").value;

	if (razorUser == undefined || razorUser == "" || 
	    razorPass == undefined || razorPass == ""){
	        var _dialog = appCtxt.getMsgDialog();   // returns DwtMessageDialog
        	var msg = this.getMessage("zspam_razor_incomplete");
	        _dialog.setMessage(msg, DwtMessageDialog.CRITICAL_STYLE);
        	_dialog.popup();
	}else{
		/* Register Razor Account */
		this._runner.razorRegister(razorUser, razorPass, this._razorRegistered);
	}
}

com_irontec_zspamH.prototype._razorRegistered = function () 
{
        var _dialog = appCtxt.getMsgDialog();   // returns DwtMessageDialog
        var msg = this.getMessage("zspam_razor_registered");
        _dialog.setMessage(msg, DwtMessageDialog.INFO_STYLE);
        _dialog.popup();
}

com_irontec_zspamH.prototype._createConfigDlgView = function () 
{ 
	var _razorInst = this._razorInstalled;
	var _pyzorInst = this._pyzorInstalled;
	var _dccInst = this._dccInstalled;
	var _notInstalled = ' <small><font color="red">('+this.getMessage("zspam_notInstalled")+')</font></small>';
        var html = new Array();
        var i = 0;
	html[i++] = '<fieldset class="gbPreferences"><legend>'+this.getMessage("zspam_spamnetworks")+'</legend><table>';
	html[i++] = '<tr><td style="width:120px;"><input type="checkbox" id="zspam_razorEnabled"'+((_razorInst)?'':'disabled')+'>Razor'+((_razorInst)?'':_notInstalled)+'</td>';
	html[i++] = '    <td style="width:120px;"><input type="checkbox" id="zspam_pyzorEnabled" '+((_pyzorInst)?'':'disabled')+'>Pyzor'+((_pyzorInst)?'':_notInstalled)+'</td>';
	html[i++] = '	 <td style="width:120px;"><input type="checkbox" id="zspam_dccEnabled" '+((_dccInst)?'':'disabled')+'>DCC'+((_dccInst)?'':_notInstalled)+'</td></tr>';
	html[i++] = '</table></fieldset>';
	html[i++] = '<fieldset class="gbPreferences"><legend>'+this.getMessage("zspam_mailoptions")+'</legend><table>';
	html[i++] = '<tr><td colspan=2><input type="checkbox" id="zspam_moveSpam">'+this.getMessage("zspam_movespam")+'</td></tr>';
	html[i++] = '<tr><td colspan=2><input type="checkbox" id="zspam_noSpamOverride">'+this.getMessage("zspam_nospamoverride")+'</td></tr>';
	html[i++] = '<tr><td style="width:180px;">'+this.getMessage("zspam_tagspam")+':</td><td><input type="text" id="zspam_tagSpam"></td></tr>';
	html[i++] = '</table></fieldset>';
	html[i++] = '<fieldset class="gbPreferences"><legend>'+this.getMessage("zspam_razorsettings")+'</legend><table>';
	html[i++] = '<tr><td stype="width:130px;">'+this.getMessage("zspam_razorusername")+':</td><td><input type="text" id="zspam_razorUser" size="40" '+((_razorInst)?'':'disabled')+'></td></tr>';
	html[i++] = '<tr><td>'+this.getMessage("zspam_razorpassword")+':</td><td><input type="password" id="zspam_razorPass" size="40" '+((_razorInst)?'':'disabled')+'></td></tr>';
	html[i++] = '<tr><td id=zspam_razorRegister></td></tr>';
	html[i++] = '</table></fieldset>';
 	html[i++] = '<fieldset class="gbPreferences"><legend>'+this.getMessage("zspam_statistics")+'</legend><table>';
        html[i++] = '<tr><td>'+this.getMessage("zspam_reported")+':</td><td><label id="zspam_reportedMails">0</label> '+this.getMessage("zspam_messages")+'</td></tr>';
	html[i++] = '<tr><td>'+this.getMessage("zspam_revoked")+': </td><td><label id="zspam_revokedMails">0</label> '+this.getMessage("zspam_messages")+'</td></tr>';
        html[i++] = '</table></fieldset>';
        return html.join("");
}

com_irontec_zspamH.prototype._configDlgOKBtnListener = function()
{
        /* Get Preference dialog values */
        var razorEnabled       	= document.getElementById("zspam_razorEnabled").checked;
        var pyzorEnabled       	= document.getElementById("zspam_pyzorEnabled").checked;
        var dccEnabled         	= document.getElementById("zspam_dccEnabled").checked;
        var moveSpam           	= document.getElementById("zspam_moveSpam").checked;
	var noSpamOverride	= document.getElementById("zspam_noSpamOverride").checked;
        var tagSpam            	= document.getElementById("zspam_tagSpam").value;
        var razorUser          	= document.getElementById("zspam_razorUser").value;
        var razorPass          	= document.getElementById("zspam_razorPass").value;
        var reportedMails      	= document.getElementById("zspam_reportedMails").innerHTML;
        var revokedMails       	= document.getElementById("zspam_revokedMails").innerHTML;

	if (razorEnabled == true && (razorUser == "" || razorPass == "" )){
	        var _dialog = appCtxt.getMsgDialog();   // returns DwtMessageDialog
	        var msg = this.getMessage("zspam_razor_incomplete");
	        _dialog.setMessage(msg, DwtMessageDialog.INFO_CRITICAL);
	        _dialog.popup();
		return;
	}

	this.setUserProperty("razorEnabled", razorEnabled);
        this.setUserProperty("pyzorEnabled", pyzorEnabled);
        this.setUserProperty("dccEnabled", dccEnabled);
        this.setUserProperty("moveSpam", moveSpam);
	this.setUserProperty("noSpamOverride", noSpamOverride);
        this.setUserProperty("tagSpam", tagSpam);
        this.setUserProperty("razorUser", razorUser);   
        this.setUserProperty("razorPass", razorPass);
        this.setUserProperty("reportedMails", reportedMails);
        this.setUserProperty("revokedMails", revokedMails);

	/* Save Preferences */
	this.saveUserProperties(new AjxCallback(this, this.showMessage, this.getMessage("zspam_preferencesSaved")));
	this.configDlg.popdown();	//hide the dialog
}

com_irontec_zspamH.prototype._setConfigValues = function(){
	/* Get User properties */
	var razorEnabled   	= this.getUserProperty("razorEnabled");
	var pyzorEnabled   	= this.getUserProperty("pyzorEnabled");
	var dccEnabled 	   	= this.getUserProperty("dccEnabled");
	var moveSpam	   	= this.getUserProperty("moveSpam");
	var tagSpam	   	= this.getUserProperty("tagSpam");
	var razorUser		= this.getUserProperty("razorUser");
	var razorPass		= this.getUserProperty("razorPass");
	var reportedMails	= this.getUserProperty("reportedMails");
	var revokedMails	= this.getUserProperty("revokedMails");
	var noSpamOverride	= this.getUserProperty("noSpamOverride");

        if (razorEnabled == "true")	document.getElementById("zspam_razorEnabled").checked = razorEnabled;
        if (pyzorEnabled == "true")	document.getElementById("zspam_pyzorEnabled").checked = pyzorEnabled;
        if (dccEnabled == "true")	document.getElementById("zspam_dccEnabled").checked = dccEnabled;
        if (moveSpam == "true")		document.getElementById("zspam_moveSpam").checked = moveSpam;
        if (tagSpam != undefined)    	document.getElementById("zspam_tagSpam").value = tagSpam;
	if (noSpamOverride == "true")	document.getElementById("zspam_noSpamOverride").checked = noSpamOverride;
        if (razorUser != undefined)    	document.getElementById("zspam_razorUser").value = razorUser;
		else			document.getElementById("zspam_razorUser").value = appCtxt.getActiveAccount().getEmail();
        if (razorPass != undefined)    	document.getElementById("zspam_razorPass").value = razorPass;
		else			document.getElementById("zspam_razorPass").value = "razorPassword";
        if (reportedMails != undefined) document.getElementById("zspam_reportedMails").innerHTML = reportedMails;
		else			document.getElementById("zspam_reportedMails").innerHTML = 0;
        if (revokedMails != undefined)  document.getElementById("zspam_revokedMails").innerHTML = revokedMails;
		else		 	document.getElementById("zspam_revokedMails").innerHTML = 0;
}

