/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010 Zimbra, Inc.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @class 
 * popup zimlet to configure auto send read receipt for every emails instead
 * of configuring it each time <br><br>
 * See XML file to get informations about versions<br>
 * or visit: http://gallery.zimbra.com/type/zimlet/request-read-receipt<br>
 * mirror site: http://www.hbomb.fr/zimbra   
 * 
 * @version 2.0 - 2013-01-11    
 * 
 * @extends	ZmZimletBase   
 */   
(function() {

ZlPsudReadReceipt=function() {
  this._checked='';
  this._configDialog=null;
};

ZlPsudReadReceipt.prototype = new ZmZimletBase();
ZlPsudReadReceipt.prototype.constructor=ZlPsudReadReceipt;
                                    
ZlPsudReadReceipt.prototype.init=function() {
  if ((this.getUserProperty("turnRequestReadReceiptON") == "true") || (this.getUserProperty("turnRequestReadReceiptON") == -1))
    this._checked='checked';
};

ZlPsudReadReceipt.prototype.onShowView=function(view) {
  if (view.indexOf("COMPOSE") >= 0) {
	  var dwt=appCtxt._shell._children._array;
    for (var index in dwt) {
      if ((dwt[index] == "ZmButtonToolBar") && (dwt[index]._htmlElId.indexOf("ztb__COMPOSE") >= 0))       
        this.requestReadReceipt(dwt[index].getOp("COMPOSE_OPTIONS"));             
    }
  }
};

ZlPsudReadReceipt.prototype.requestReadReceipt=function(button) {       
  var menu=button.getMenu(false);
  
  if (menu && (typeof(menu.getOp("REQUEST_READ_RECEIPT")) != 'undefined' )) {
    if ((this.getUserProperty("turnRequestReadReceiptON") == "true") || (this.getUserProperty("turnRequestReadReceiptON") == -1))
      menu.getOp("REQUEST_READ_RECEIPT").setChecked(true, false);
    else
      menu.getOp("REQUEST_READ_RECEIPT").setChecked(false, false);
  }
};

ZlPsudReadReceipt.prototype.doubleClicked=function() {
	this.showConfigDlg();
};

ZlPsudReadReceipt.prototype.singleClicked=function() {
	this.showConfigDlg();
};

ZlPsudReadReceipt.prototype.showConfigDlg=function() {
	if (!this._configDialog) {
  	var title=this.getMessage("zimletTooltip")+" - "+this.getMessage("currentVersion"); 
	
  	this._configView = new DwtComposite(this.getShell());
  	this._configView.getHtmlElement().style.overflow = "auto";
  	this._configView.getHtmlElement().innerHTML = this.createConfigView();
  	this._configDialog = this._createDialog({title:title, view:this._configView, standardButtons:[DwtDialog.OK_BUTTON, DwtDialog.CANCEL_BUTTON]});
  	this._configDialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this.okDialogBtnListener));
  }

	this._configDialog.popup();
};

ZlPsudReadReceipt.prototype.createConfigView=function() {
	return [
		'<div class="configDialog">',
		'<input id="turnRequestReadReceiptON" type="checkbox" ',
		this._checked,
    ' />',
    this.getMessage("configText"),
		'<br><br>',
		'<i>',
    this.getMessage("configRestart"),
    '</i>',
    '</div>'
	].join("");
};

ZlPsudReadReceipt.prototype.okDialogBtnListener=function() {
	this._configDialog.popdown();
	this.setUserProperty("turnRequestReadReceiptON", document.getElementById("turnRequestReadReceiptON").checked, true);
  
  appCtxt.getAppController().setStatusMsg(this.getMessage("msgText"), ZmStatusView.LEVEL_INFO);
  
	window.onbeforeunload = null;
	setTimeout(function() {ZmZimbraMail.sendRedirect(AjxUtil.formatUrl({}));}, 2000); 
};

}());