/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010 Zimbra, Inc.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */

/**
 * @class 
 * popup zimlet to configure auto send read receipt for every emails instead
 * of configuring it each time <br><br>
 * See XML file to get informations about versions<br>
 * or visit: http://gallery.zimbra.com/type/zimlet/request-read-receipt<br>
 * mirror site: http://www.hbomb.fr/zimbra   
 * 
 * @version 2.0 - 2013-01-11    
 * 
 * @extends	ZmZimletBase   
 */   
ZlPsudReadReceipt = function() {
  _this=this;
  _checked='';
}

ZlPsudReadReceipt.prototype = new ZmZimletBase();

ZlPsudReadReceipt.prototype.init=function() {
  if ((_this.getUserProperty("turnRequestReadReceiptON") == "true") || (_this.getUserProperty("turnRequestReadReceiptON") == -1))
    _this._checked='checked';
}

ZlPsudReadReceipt.prototype.onShowView=function(view) {
  if (view.indexOf("COMPOSE") >= 0) {
	  var dwt=appCtxt._shell._children._array;
    for (var index in dwt) {
      if ((dwt[index] == "ZmButtonToolBar") && (dwt[index]._htmlElId.indexOf("ztb__COMPOSE") >= 0))       
        _this.requestReadReceipt(dwt[index].getOp("COMPOSE_OPTIONS"));             
    }
  }
}

ZlPsudReadReceipt.prototype.requestReadReceipt=function(button) {          
  var menu=button.getMenu(false);
  
  if (menu && (typeof(menu.getOp("REQUEST_READ_RECEIPT")) != 'undefined' )) {
    if ((_this.getUserProperty("turnRequestReadReceiptON") == "true") || (_this.getUserProperty("turnRequestReadReceiptON") == -1))
      menu.getOp("REQUEST_READ_RECEIPT").setChecked(true, false);
    else
      menu.getOp("REQUEST_READ_RECEIPT").setChecked(false, false);
  }
}

ZlPsudReadReceipt.prototype.doubleClicked=function() {
	_this.showConfigDlg();
}

ZlPsudReadReceipt.prototype.singleClicked=function() {
	_this.showConfigDlg();
}

ZlPsudReadReceipt.prototype.showConfigDlg=function() {
	if (!_this.configDialog) {
  	var title=_this.getMessage("configTitle")+" - V."+_this.getMessage("currentVersion"); 
	
  	_this._configView = new DwtComposite(_this.getShell());
  	_this._configView.getHtmlElement().style.overflow = "auto";
  	_this._configView.getHtmlElement().innerHTML = _this.createConfigView();
  	_this._configDialog = _this._createDialog({title:title, view:_this._configView, standardButtons:[DwtDialog.OK_BUTTON, DwtDialog.CANCEL_BUTTON]});
  	_this._configDialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, _this.okDialogBtnListener));
  }

	_this._configDialog.popup();
}

ZlPsudReadReceipt.prototype.createConfigView=function() {
	return [
		'<div class="configDialog">',
		'<input id="turnRequestReadReceiptON" type="checkbox" ',
		_this._checked,
    ' />',
    _this.getMessage("configText"),
		'<br><br>',
		'<i>',
    _this.getMessage("configRestart"),
    '</i>',
    '</div>'
	].join("");
}

ZlPsudReadReceipt.prototype.okDialogBtnListener=function() {
	_this._configDialog.popdown();
	_this.setUserProperty("turnRequestReadReceiptON", document.getElementById("turnRequestReadReceiptON").checked, true);
  
  appCtxt.getAppController().setStatusMsg(_this.getMessage("msgText"), ZmStatusView.LEVEL_INFO);
  
	window.onbeforeunload = null;
	setTimeout(function() {ZmZimbraMail.sendRedirect(AjxUtil.formatUrl({}));}, 2000); 
}

