/*
 * ***** BEGIN LICENSE BLOCK *****
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010 Zimbra, Inc.
 * 
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.3 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * ***** END LICENSE BLOCK *****
 */

com_zimbra_p11_request_read_receipt_handler_object = function() {};
com_zimbra_p11_request_read_receipt_handler_object.prototype = new ZmZimletBase;
com_zimbra_p11_request_read_receipt_handler_object.prototype.constructor = com_zimbra_p11_request_read_receipt_handler_object;

com_zimbra_p11_request_read_receipt_handler_object.prototype.onShowView=
function(view) {
  if (view.indexOf("COMPOSE") >= 0) {
	  var dwt=appCtxt._shell._children._array;
    for (var index in dwt) {
      if ((dwt[index] == "ZmButtonToolBar") && (dwt[index]._htmlElId.indexOf("ztb__COMPOSE") >= 0))       
        this._requestReadReceipt(dwt[index].getOp("COMPOSE_OPTIONS"));             
    }
  }
};

com_zimbra_p11_request_read_receipt_handler_object.prototype._requestReadReceipt =
function(button) {          
  var menu=button.getMenu(false);
  menu.getOp("REQUEST_READ_RECEIPT").setChecked(this.getUserProperty("turnRequestReadReceiptON"), false);
};

com_zimbra_p11_request_read_receipt_handler_object.prototype.doubleClicked =
function() {
	this._showConfigDlg();
};

com_zimbra_p11_request_read_receipt_handler_object.prototype.singleClicked =
function() {
	this._showConfigDlg();
};

com_zimbra_p11_request_read_receipt_handler_object.prototype._showConfigDlg =
function() {
	if (this._configDialog) {
		this._configDialog.popup();
		return;
	}
	var title=this.getMessage("config_title");
	
	this._configView = new DwtComposite(this.getShell());
	this._configView.getHtmlElement().style.overflow = "auto";
	this._configView.getHtmlElement().innerHTML = this._createConfigView();
	this._configDialog = this._createDialog({title:title, view:this._configView, standardButtons:[DwtDialog.OK_BUTTON]});
	this._configDialog.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._okDialogBtnListener));

	document.getElementById("turn_request_read_receipt_on").checked=Boolean(this.getUserProperty("turnRequestReadReceiptON"));
	this._configDialog.popup();
};

com_zimbra_p11_request_read_receipt_handler_object.prototype._createConfigView =
function() {
	return [
		"<div class='configDialog'>",
		"<input id='turn_request_read_receipt_on' type='checkbox'/>",
    this.getMessage("config_text"),
		"</div>"
	].join("");
};

com_zimbra_p11_request_read_receipt_handler_object.prototype._okDialogBtnListener =
function() {
	this._configDialog.popdown();
	this.setUserProperty("turnRequestReadReceiptON", document.getElementById("turn_request_read_receipt_on").checked); 
	
  appCtxt.getAppController().setStatusMsg(this.getMessage("msg_text"), ZmStatusView.LEVEL_INFO); 	
};
