/* * ***** BEGIN LICENSE BLOCK ***** *
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2006-2010 Zimbra, Inc.
 *
 * The contents of this file are subject to the Yahoo! Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 *
 * ***** END LICENSE BLOCK *****
 * @Author Blaise Drayer, based on the Zimlet of Robert Hau
 * 
 */

/**
 * @class
 * This class represents the Tsheetx zimlet.
 * @extends	ZmZimletBase
 */
function com_zimbra_tsheetx() {
}
com_zimbra_tsheetx.prototype = new ZmZimletBase();
com_zimbra_tsheetx.prototype.constructor = com_zimbra_tsheetx;

/**
 * Initializes the zimlet.
 * 
 */
com_zimbra_tsheetx.prototype.init =
function() {
	ZmZimletBase.prototype.init.apply(this, arguments);
	this._createTsheetxApp();
};

// var tsheetxserver = this.getUserProperty("tsheetx_server");

/**
 * Creates the Tsheetx tab application.
 * 
 */
com_zimbra_tsheetx.prototype._createTsheetxApp =
function() {
	this._tsheetxTimeSheetApp = this.createApp("Timesheet", "Time", "Timesheet Next Gen");
};

/**
 * This method is called by the zimlet framework when the tab application is active.
 * 
 * @param	{String}	appName		the application
 * @param	{Boolean}	active		<code>true</code> if the tab application is active
 */
com_zimbra_tsheetx.prototype.appActive =
function(appName, active) {
	if (active) {
		this._appName = appName;
		this._TsheetxlistViews = [];
       		var app = appCtxt.getApp(this._appName);
		this._showDefaultView();
	} else {
		this._hideApp(appName);
	}
};

/**
 * Hides the tab application.
 * 
 */
com_zimbra_tsheetx.prototype._hideApp =
function(appName) {
	// do nothing
};

/**
 * This method is called by the zimlet framework when the tab application is launched.
 * 
 * @param	{String}	appName		the tab application name
 * @param	{Hash}		params		a hash of parameters
 */
com_zimbra_tsheetx.prototype.appLaunch =
function(appName, params) {
	if (this._tsheetxTimeSheetApp != appName)
		return;
	this._createTreeView(appName);
	this._setZimletCurrentPreferences();
};

/**
 * Creates a tree view and call-logs list view.
 * 
 */
com_zimbra_tsheetx.prototype._createTreeView =
function() {
	var html = new Array();
	var i = 0;
	this.expandIconAndFolderTreeMap = new Array();
	var activeApp = appCtxt.getCurrentApp();
	if (activeApp.getName() != this._tsheetxTimeSheetApp)
		return;

	var overview = activeApp ? activeApp.getOverview() : null;
	var element = overview.getHtmlElement();

	var expandIconId = "tsheetx_expandIcon_" + Dwt.getNextId();
	this.expandIconAndFolderTreeMap[expandIconId] = new Array();
	var childExpandIconId = "tweetzi_expandIcon_" + Dwt.getNextId();
	this.expandIconAndFolderTreeMap[childExpandIconId] = new Array();
	html[i++] = this._getTreeHeaderHTML("Timesheet", expandIconId);	//header
/** Will be added in next version of Zimlet
 *	html[i++] = this._getFolderHTML({name:"Stop Watch", icon:"Time", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
 */
	html[i++] = this._getFolderHTML({name:"Daily", icon:"DayView", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Weekly", icon:"WeekView", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Calendar", icon:"MonthView", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Simple", icon:"Date", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Absences", icon:"CalInviteDeclined", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Reports", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Reports", icon:"Page", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
/** Will be added in next version of Zimlet
 *	html[i++] = this._getFolderHTML({name:"Users Reports", icon:"Page", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
 *	html[i++] = this._getFolderHTML({name:"Projects Reports", icon:"Page", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
 *	html[i++] = this._getFolderHTML({name:"Clients Reports", icon:"Page", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
 */
	html[i++] = this._getTreeHeaderHTML("Clients", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Add Client", icon:"ClientAdd", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"List Clients", icon:"Location", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Projects and tasks", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Add a Project", icon:"NewTaskList", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"List Projects", icon:"TaskList", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Project Rates", icon:"ProjectRates", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
/** Will be added in next version of Zimlet
 *	html[i++] = this._getFolderHTML({name:"Add a Task", icon:"NewTask", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
*/
	html[i++] = this._getFolderHTML({name:"List Tasks", icon:"Task", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Users", expandIconId);	//header
/** Will be added in next version of Zimlet
 *	html[i++] = this._getFolderHTML({name:"Add a User", icon:"NewContact", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
*/
	html[i++] = this._getFolderHTML({name:"List Users", icon:"Group", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"User Rates", icon:"ProjectRates", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Preferences", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Configuration", icon:"Preferences", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);	
	html[i++] = this._getFolderHTML({name:"Change Password", icon:"SmallPadLock", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("My Login", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Logout", icon:"Logoff", account:"", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Zimlet", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Preferences", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	element.innerHTML = html.join("");
	element.onclick = AjxCallback.simpleClosure(this._handleTreeClick, this);
};

/**
 * Handles a tree click event.
 * 
 * @param	{Object}		ev		the event
 * @see		#_createTreeView
 */

com_zimbra_tsheetx.prototype._handleTreeClick =
function(ev) {
	if (AjxEnv.isIE) {
		ev = window.event;
	}
	var dwtev = DwtShell.mouseEvent;
	dwtev.setFromDhtmlEvent(ev);
	var el = dwtev.target;
	var origTarget = dwtev.target;
	if (origTarget.className == "ImgNodeExpanded" || origTarget.className == "ImgNodeCollapsed") {
		var display = "block";
		if (origTarget.className == "ImgNodeExpanded") {
			origTarget.className = "ImgNodeCollapsed";
			display = "none";
		} else {
			origTarget.className = "ImgNodeExpanded";
		}
		var foldersId = this.expandIconAndFolderTreeMap[origTarget.id];
		for (var i = 0; i < foldersId.length; i++) {
			document.getElementById(foldersId[i]).style.display = display;
		}
		return;
	}
	while (el && el.className != "DwtTreeItem") {
		el = el.parentNode;
	}
	if (el == null)
		return;

	var tds = el.getElementsByTagName("td");
	var label = "";
	for (var i = 0; i < tds.length; i++) {
		var td = tds[i];
		if (td.className == "DwtTreeItem-selected" || td.className == "DwtTreeItem-Text") {
			label = AjxEnv.isIE ? td.innerText : td.textContent;
			break;
		}
	}
	if (td.className == "DwtTreeItem-Text") {
		if (this.previousFolderCell) {
			this.previousFolderCell.className = "DwtTreeItem-Text";
			td.className = "DwtTreeItem-selected";
			this.previousFolderCell = td;
		} else {
			td.className = "DwtTreeItem-selected";
			this.previousFolderCell = td;
		}
	}
	this._treeClickAction(this.treeIdAndFolderItemMap[el.id]);
};

/**
 * Handles a tree click action.
 * 
 * @param	{Object}	folder		the folder
 */
com_zimbra_tsheetx.prototype._treeClickAction =
function(folder) {
	switch (folder.name) {
		case "Daily":
			this._showTimeSheetDailyView();
			break;
		case "Weekly":
			this._showTimeSheetWeeklyView();
			break;
		case "Calendar":
			this._showTimeSheetCalendarView();
			break;
		case "Simple":
			this._showTimeSheetSimpleView();
			break;
		case "Absences":
			this._showAbsencesView()
			break;
		case "Reports":
			this._showReports();
 			break;					
		case "Add Client":
			this._showAddClient();
			break;
		case "List Clients":
			this._showListClients();
			break;
		case "Add a Project":
			this._showAddProject();
			break;
		case "List Projects":
			this._showListProjects();
			break;
		case "Project Rates":
			this._showProjectRates();
			break;			
		case "List Tasks":
			this._showListTasks();
			break;
		case "List Users":
			this._showListUsers();
			break;
		case "User Rates":
			this._showUserRates();
			break;
		case "Configuration":
			this._showConfiguration();
			break;
		case "Change Password":
			this._showChangePassword();
			break;
		case "Logout":
			this._showLogout();
			break;

			case "Preferences":
			this._showPreferencesView();
                        this._setZimletCurrentPreferences();
                        this._addToolbarBtns({enableSaveBtn:true});
			break;
		case "Logout":
			this._showLogout();
			break;
		default:
	}
};

/**
 * Gets the tree header HTML.
 * 
 * @param	{String}	treeName		the tree name
 * @param	{String}	expandIconId	the expand icon id
 * @return	{String}	the HTML
 */
com_zimbra_tsheetx.prototype._getTreeHeaderHTML =
function(treeName, expandIconId) {
	var html = new Array();
	var i = 0;
	if (expandIconId) {
		html[i++] = "<div  class='overviewHeader'>";
	} else {
		html[i++] = "<div  class='overviewHeader'>";
	}
	html[i++] = "<TABLE cellpadding=\"0\" cellspacing=\"0\">";
	html[i++] = "<TR>";
	html[i++] = "<TD style=\"width:16px;height:16px\" align='center'>";
	html[i++] = "<div class=\"ImgNodeExpanded\" id= '" + expandIconId + "'/>";
	html[i++] = "</TD>";
	html[i++] = "<td class=\"imageCell\" />";
	html[i++] = "<TD  class='overviewHeader-Text'>";
	html[i++] = treeName;
	html[i++] = "</TD>";
	html[i++] = "<TD style=\"width:16px;height:16px\">";
	html[i++] = AjxImg.getImageHtml("Blank_16");
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "</div>";
	return html.join("");
};

/**
 * Gets the folder HTML.
 * 
 * @return	{String}	the HTML
 */
com_zimbra_tsheetx.prototype._getFolderHTML =
function(folder, expandIconId, childExpandIconId, isSubFolder, hasChild) {
	var html = new Array();
	var i = 0;
	if (this.treeIdAndFolderItemMap == undefined) {
		this.treeIdAndFolderItemMap = new Array();
	}

	html[i++] = "<div class='DwtComposite'>";
	var id = "tweetziTreeItem__" + folder.type + "_" + Dwt.getNextId();
	this.treeIdAndFolderItemMap[id] = folder;
	this.expandIconAndFolderTreeMap[expandIconId].push(id);
	if (isSubFolder) {
		this.expandIconAndFolderTreeMap[childExpandIconId].push(id);
	}
	html[i++] = "<div class='DwtTreeItem' id='" + id + "'>";

	html[i++] = "<TABLE width=100% cellpadding=\"1\" cellspacing=\"1\">";
	html[i++] = "<TR>";
	html[i++] = "<TD style=\"width:16px;height:16px\" align='center'>";
	if (hasChild) {
		html[i++] = "<div class=\"ImgNodeExpanded\" id= '" + childExpandIconId + "'/>";
	} else {
		html[i++] = AjxImg.getImageHtml("Blank_16");
	}
	html[i++] = "</TD>";
	if (isSubFolder) {
		html[i++] = "<TD style=\"width:16px;height:16px\" align='center'>";
		html[i++] = AjxImg.getImageHtml("Blank_16");
		html[i++] = "</TD>";
	}
	html[i++] = "<TD style=\"width:16px;height:16px\">";
	html[i++] = AjxImg.getImageHtml(folder.icon);
	html[i++] = "</TD>";
	html[i++] = "<TD class='DwtTreeItem-Text' nowrap=''>";
	html[i++] = folder.name;
	html[i++] = "</TD>";
	html[i++] = "<TD style=\"width:16px;height:16px\">";
	html[i++] = AjxImg.getImageHtml("Blank_16");
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "</div>";
	html[i++] = "</div>";
	return html.join("");
};

/**
 * Sets the current preferences.
 * 
 */
com_zimbra_tsheetx.prototype._setZimletCurrentPreferences =
function() {
};

/**
 * Shows the preferences view.
 * 
 */
com_zimbra_tsheetx.prototype._showDefaultView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" +  this.getUserProperty("tsheetx_server") + "/login.php?username=" + this.getUserProperty("tsheetx_username") + "&password=" + this.getUserProperty("tsheetx_password") + "\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};

/** Will be added in next version of Zimlet
com_zimbra_tsheetx.prototype._showStopWatch =
function() {
	var app = appCtxt.getApp(this._appName);
	var load = window.open(this.getUserProperty("tsheetx_server") + '/stopwatch.php?client_id=0&proj_id=0&task_id=0&destination=monthly.php','reports','scrollbars=no,menubar=no,height=220,width=420,resizable=yes,toolbar=no,location=no,status=no');
};
**/

com_zimbra_tsheetx.prototype._showTimeSheetDailyView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" +  this.getUserProperty("tsheetx_server") + "/daily.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};

com_zimbra_tsheetx.prototype._showTimeSheetWeeklyView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/weekly.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};

com_zimbra_tsheetx.prototype._showTimeSheetCalendarView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/monthly.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showTimeSheetSimpleView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/simple.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showAbsencesView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/absences.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showReports =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" +  this.getUserProperty("tsheetx_server") + "/reports.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

}
com_zimbra_tsheetx.prototype._showProjectsReports =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" +  this.getUserProperty("tsheetx_server") + "/reports.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showClientsReports =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/reports.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showAddClient =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/client_add.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showListClients =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/client_maint.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showAddProject =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/proj_add.php?client_id=0\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showListProjects =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/proj_maint.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showProjectRates =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/project_user_rates.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showListTasks =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/task_maint.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_tsheetx.prototype._showListUsers =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/user_maint.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
};
com_zimbra_tsheetx.prototype._showUserRates =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/rate_maint.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
};
com_zimbra_tsheetx.prototype._showConfiguration =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/config.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
};
com_zimbra_tsheetx.prototype._showChangePassword =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("tsheetx_server") + "/changepwd.php\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
};
//  This is required to keep track of the logout window
var logoutwindow=null;

com_zimbra_tsheetx.prototype._showLogout =
function() {
	logoutwindow = window.open(this.getUserProperty("tsheetx_server") + '/logout.php?logout=true','logoutwindow', 'toolbar=no, status=no, width=0, height=0');
	setTimeout("com_zimbra_tsheetx.prototype._hideLogout()",0);
	this._showTimeSheetCalendarView();
};

com_zimbra_tsheetx.prototype._hideLogout =
function() {
	logoutwindow.close();
};

/**
 * Adds toolbar buttons.
 * 
 * @param       {Hash}  param   a hash of parameters
 */
com_zimbra_tsheetx.prototype._addToolbarBtns =
function(param) {
                var app = appCtxt.getApp(this._appName);
                var toolbar = app.getToolbar();
                if(toolbar.getButton("tsheetx_save_toolbarBtn") == undefined) {
                        this._saveBtn  = toolbar.createButton("tsheetx_save_toolbarBtn", {text:"Save", image:"Save"});
                        toolbar.addSelectionListener("tsheetx_save_toolbarBtn", new AjxListener(this, this._okPreferenceBtnListener));
                }
                this._saveBtn.setEnabled(param.enableSaveBtn);
};


/**
 * Sets the current preferences.
 * 
 */
com_zimbra_tsheetx.prototype._setZimletCurrentPreferences =
function() {
	this.tsheetx_server = this.getUserProperty("tsheetx_server");
	if (document.getElementById("tsheetx_server") != null  && this.tsheetx_server != undefined) {
		document.getElementById("tsheetx_server").value = this.tsheetx_server;
	}
	this.tsheetx_username = this.getUserProperty("tsheetx_username");
	if (document.getElementById("tsheetx_username") != null  && this.tsheetx_username != undefined) {
		document.getElementById("tsheetx_username").value = this.tsheetx_username;
	}	
	this.tsheetx_password = this.getUserProperty("tsheetx_password");
	if (document.getElementById("tsheetx_password") != null  && this.tsheetx_password != undefined) {
		document.getElementById("tsheetx_password").value = this.tsheetx_password;
	}
};

/**
 * Shows the preferences view.
 * 
 */
com_zimbra_tsheetx.prototype._showPreferencesView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent(this._createPreferenceHTML());
};

/**
 * Creates the preferences HTML.
 * 
 * @return	{String}	the HTML
 */
com_zimbra_tsheetx.prototype._createPreferenceHTML =
function() {
	var html = new Array();
	var i = 0;
	html[i++] = "<BR/>";
	html[i++] = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\"><tbody><tr class=\"ZOptionsHeaderRow\"><td class=\"ZOptionsHeaderL\"><div class=\"ImgPrefsHeader_L\"/></td><td class=\"ZOptionsHeader ImgPrefsHeader\">Server Configuration</td><td class=\"ZOptionsHeaderR\"><div class=\"ImgPrefsHeader_R\"/></td></tr></tbody></table>";
	html[i++] = "<TABLE>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	html[i++] = "Timesheet Next Gen Server:";
	html[i++] = "</TD><TD>";
	html[i++] =" <input id='tsheetx_server'  size='50' type='text'/>";
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	html[i++] = "Username:";
	html[i++] = "</TD><TD>";
	html[i++] =" <input id='tsheetx_username'  size='50' type='text'/>";
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	html[i++] = "Password:";
	html[i++] = "</TD><TD>";
	html[i++] =" <input id='tsheetx_password'  size='50' type='password'/>";
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "<BR/>";
	return html.join("");
};

/**
 * Listens for the OK preferences button.
 * 
 * @see		#_addToolbarBtns
 */
com_zimbra_tsheetx.prototype._okPreferenceBtnListener =
function() {
	var _saveRequired = false;
	if (this.tsheetx_server != document.getElementById("tsheetx_server").value) {
		this.setUserProperty("tsheetx_server", document.getElementById("tsheetx_server").value);
		_saveRequired = true;
	}
	if (this.tsheetx_username != document.getElementById("tsheetx_username").value) {
		this.setUserProperty("tsheetx_username", document.getElementById("tsheetx_username").value);
		_saveRequired = true;
	}
	if (this.tsheetx_password != document.getElementById("tsheetx_password").value) {
		this.setUserProperty("tsheetx_password", document.getElementById("tsheetx_password").value);
		_saveRequired = true;
	}
	if (_saveRequired) {
		this.saveUserProperties(new AjxCallback(this, this._showPreferenceSavedMsg));
		this._showDefaultView();
	} 
	else {
		this._showDefaultView();
	}
};

/**
 * Shows the preference saved message.
 * 
 */
com_zimbra_tsheetx.prototype._showPreferenceSavedMsg =
function() {
	var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.FADE_OUT ];
	appCtxt.getAppController().setStatusMsg("Preferences Saved", ZmStatusView.LEVEL_INFO, null, transitions);
};
