/* * ***** BEGIN LICENSE BLOCK ***** *
 * Zimbra Collaboration Suite Zimlets
 * Copyright (C) 2006-2010 Zimbra, Inc.
 *
 * The contents of this file are subject to the Yahoo! Public License
 * Version 1.0 ("License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.zimbra.com/license.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 *
 * ***** END LICENSE BLOCK *****
 * @Author Robert Hau
 * 
 */

/**
 * @class
 * This class represents the Journyx zimlet.
 * @extends	ZmZimletBase
 */
function com_zimbra_journyx() {
}
com_zimbra_journyx.prototype = new ZmZimletBase();
com_zimbra_journyx.prototype.constructor = com_zimbra_journyx;

/**
 * Initializes the zimlet.
 * 
 */
com_zimbra_journyx.prototype.init =
function() {
	ZmZimletBase.prototype.init.apply(this, arguments);
	this._createJournyxApp();
};

// var journyxserver = this.getUserProperty("journyx_server");

/**
 * Creates the Journyx tab application.
 * 
 */
com_zimbra_journyx.prototype._createJournyxApp =
function() {
	this._journyxTimeSheetApp = this.createApp("Journyx", "journyx-panelIcon", "Journyx Time Sheet");
};

/**
 * This method is called by the zimlet framework when the tab application is active.
 * 
 * @param	{String}	appName		the application
 * @param	{Boolean}	active		<code>true</code> if the tab application is active
 */
com_zimbra_journyx.prototype.appActive =
function(appName, active) {
	if (active) {
		this._appName = appName;
		this._JournyxlistViews = [];
       		var app = appCtxt.getApp(this._appName);
		this._showDefaultView();
	} else {
		this._hideApp(appName);
	}
};

/**
 * Hides the tab application.
 * 
 */
com_zimbra_journyx.prototype._hideApp =
function(appName) {
	// do nothing
};

/**
 * This method is called by the zimlet framework when the tab application is launched.
 * 
 * @param	{String}	appName		the tab application name
 * @param	{Hash}		params		a hash of parameters
 */
com_zimbra_journyx.prototype.appLaunch =
function(appName, params) {
	if (this._journyxTimeSheetApp != appName)
		return;
	this._createTreeView(appName);
	this._setZimletCurrentPreferences();
};

/**
 * Creates a tree view and call-logs list view.
 * 
 */
com_zimbra_journyx.prototype._createTreeView =
function() {
	var html = new Array();
	var i = 0;
	this.expandIconAndFolderTreeMap = new Array();
	var activeApp = appCtxt.getCurrentApp();
	if (activeApp.getName() != this._journyxTimeSheetApp)
		return;

	var overview = activeApp ? activeApp.getOverview() : null;
	var element = overview.getHtmlElement();

	var expandIconId = "journyx_expandIcon_" + Dwt.getNextId();
	this.expandIconAndFolderTreeMap[expandIconId] = new Array();
//	html[i++] = this._getTreeHeaderHTML("Journyx", expandIconId);	//header
	var childExpandIconId = "tweetzi_expandIcon_" + Dwt.getNextId();
	this.expandIconAndFolderTreeMap[childExpandIconId] = new Array();
	html[i++] = this._getTreeHeaderHTML("Entry Sheets", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Time Sheet", icon:"Date", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Expenses", icon:"Task", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Mileage", icon:"Date", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Reports", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Standard Reports", icon:"Date", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Scheduled Reports", icon:"Date", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Saved Reports", icon:"Date", account: "", sn:"", type:""}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Approvals", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Time Approvals", icon:"Task", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Expense Approvals", icon:"Task", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Mileage Approvals", icon:"Task", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Management", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Project Notes", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Memorized Entries", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"My Sheets", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Leave Requests", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Preferences", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Reset Password", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"Entry Screens", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getFolderHTML({name:"My Projects", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("My Login", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Logout", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	html[i++] = this._getTreeHeaderHTML("Zimlet", expandIconId);	//header
	html[i++] = this._getFolderHTML({name:"Preferences", icon:"Preferences", account:"", sn:"", type:"preferences"}, expandIconId, childExpandIconId, false);
	element.innerHTML = html.join("");
	element.onclick = AjxCallback.simpleClosure(this._handleTreeClick, this);
};

/**
 * Handles a tree click event.
 * 
 * @param	{Object}		ev		the event
 * @see		#_createTreeView
 */
com_zimbra_journyx.prototype._handleTreeClick =
function(ev) {
	if (AjxEnv.isIE) {
		ev = window.event;
	}
	var dwtev = DwtShell.mouseEvent;
	dwtev.setFromDhtmlEvent(ev);
	var el = dwtev.target;
	var origTarget = dwtev.target;
	if (origTarget.className == "ImgNodeExpanded" || origTarget.className == "ImgNodeCollapsed") {
		var display = "block";
		if (origTarget.className == "ImgNodeExpanded") {
			origTarget.className = "ImgNodeCollapsed";
			display = "none";
		} else {
			origTarget.className = "ImgNodeExpanded";
		}
		var foldersId = this.expandIconAndFolderTreeMap[origTarget.id];
		for (var i = 0; i < foldersId.length; i++) {
			document.getElementById(foldersId[i]).style.display = display;
		}
		return;
	}
	while (el && el.className != "DwtTreeItem") {
		el = el.parentNode;
	}
	if (el == null)
		return;

	var tds = el.getElementsByTagName("td");
	var label = "";
	for (var i = 0; i < tds.length; i++) {
		var td = tds[i];
		if (td.className == "DwtTreeItem-selected" || td.className == "DwtTreeItem-Text") {
			label = AjxEnv.isIE ? td.innerText : td.textContent;
			break;
		}
	}
	if (td.className == "DwtTreeItem-Text") {
		if (this.previousFolderCell) {
			this.previousFolderCell.className = "DwtTreeItem-Text";
			td.className = "DwtTreeItem-selected";
			this.previousFolderCell = td;
		} else {
			td.className = "DwtTreeItem-selected";
			this.previousFolderCell = td;
		}
	}
	this._treeClickAction(this.treeIdAndFolderItemMap[el.id]);
};

/**
 * Handles a tree click action.
 * 
 * @param	{Object}	folder		the folder
 */
com_zimbra_journyx.prototype._treeClickAction =
function(folder) {
	switch (folder.name) {
		case "Time Sheet":
			this._showTimeSheetView();
			break;
		case "Expenses":
			this._showExpensesView();
			break;
		case "Mileage":
			this._showMileageView();
			break;
		case "Standard Reports":
			this._showStandardReports();
			break;
		case "Scheduled Reports":
			this._showScheduledReports();
			break;
		case "Saved Reports":
			this._showSavedReports();
			break;
		case "Project Notes":
			this._showProjectNotes();
			break;
		case "Memorized Entries":
			this._showMemorizedEntries();
			break;
		case "My Sheets":
			this._showMySheets();
			break;
		case "Leave Requests":
			this._showLeaveRequests();
			break;
		case "Reset Password":
			this._showResetPassword();
			break;
		case "Entry Screens":
			this._showEntryScreens();
			break;
		case "Time Approvals":
			this._showTimeApprovals();
			break;
		case "Expense Approvals":
			this._showExpenseApprovals();
			break;
		case "Mileage Approvals":
			this._showMileageApprovals();
			break;
		case "My Projects":
			this._showMyProjects();
			break;
		case "User Details":
			this._showUserDetails();
			break;
		case "Preferences":
			this._showPreferencesView();
                        this._setZimletCurrentPreferences();
                        this._addToolbarBtns({enableSaveBtn:true});
			break;
		case "Logout":
			this._showLogout();
			break;
		default:
	}
};

/**
 * Gets the tree header HTML.
 * 
 * @param	{String}	treeName		the tree name
 * @param	{String}	expandIconId	the expand icon id
 * @return	{String}	the HTML
 */
com_zimbra_journyx.prototype._getTreeHeaderHTML =
function(treeName, expandIconId) {
	var html = new Array();
	var i = 0;
	if (expandIconId) {
		html[i++] = "<div  class='overviewHeader'>";
	} else {
		html[i++] = "<div  class='overviewHeader'>";
	}
	html[i++] = "<TABLE cellpadding=\"0\" cellspacing=\"0\">";
	html[i++] = "<TR>";
	html[i++] = "<TD style=\"width:16px;height:16px\" align='center'>";
	html[i++] = "<div class=\"ImgNodeExpanded\" id= '" + expandIconId + "'/>";
	html[i++] = "</TD>";
	html[i++] = "<td class=\"imageCell\" />";
	html[i++] = "<TD  class='overviewHeader-Text'>";
	html[i++] = treeName;
	html[i++] = "</TD>";
	html[i++] = "<TD style=\"width:16px;height:16px\">";
	html[i++] = AjxImg.getImageHtml("Blank_16");
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "</div>";
	return html.join("");
};

/**
 * Gets the folder HTML.
 * 
 * @return	{String}	the HTML
 */
com_zimbra_journyx.prototype._getFolderHTML =
function(folder, expandIconId, childExpandIconId, isSubFolder, hasChild) {
	var html = new Array();
	var i = 0;
	if (this.treeIdAndFolderItemMap == undefined) {
		this.treeIdAndFolderItemMap = new Array();
	}

	html[i++] = "<div class='DwtComposite'>";
	var id = "tweetziTreeItem__" + folder.type + "_" + Dwt.getNextId();
	this.treeIdAndFolderItemMap[id] = folder;
	this.expandIconAndFolderTreeMap[expandIconId].push(id);
	if (isSubFolder) {
		this.expandIconAndFolderTreeMap[childExpandIconId].push(id);
	}
	html[i++] = "<div class='DwtTreeItem' id='" + id + "'>";

	html[i++] = "<TABLE width=100% cellpadding=\"1\" cellspacing=\"1\">";
	html[i++] = "<TR>";
	html[i++] = "<TD style=\"width:16px;height:16px\" align='center'>";
	if (hasChild) {
		html[i++] = "<div class=\"ImgNodeExpanded\" id= '" + childExpandIconId + "'/>";
	} else {
		html[i++] = AjxImg.getImageHtml("Blank_16");
	}
	html[i++] = "</TD>";
	if (isSubFolder) {
		html[i++] = "<TD style=\"width:16px;height:16px\" align='center'>";
		html[i++] = AjxImg.getImageHtml("Blank_16");
		html[i++] = "</TD>";
	}
	html[i++] = "<TD style=\"width:16px;height:16px\">";
	html[i++] = AjxImg.getImageHtml(folder.icon);
	html[i++] = "</TD>";
	html[i++] = "<TD class='DwtTreeItem-Text' nowrap=''>";
	html[i++] = folder.name;
	html[i++] = "</TD>";
	html[i++] = "<TD style=\"width:16px;height:16px\">";
	html[i++] = AjxImg.getImageHtml("Blank_16");
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "</div>";
	html[i++] = "</div>";
	return html.join("");
};

/**
 * Sets the current preferences.
 * 
 */
com_zimbra_journyx.prototype._setZimletCurrentPreferences =
function() {
};

/**
 * Shows the preferences view.
 * 
 */
com_zimbra_journyx.prototype._showDefaultView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "wte.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showTimeSheetView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "wte.pyc?TE=x&NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};

com_zimbra_journyx.prototype._showExpensesView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "expense.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};

com_zimbra_journyx.prototype._showMileageView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "mileageentry.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showStandardReports =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "wtrptlist.pyc?NoBustFrames=1&SuppressNav=1&Search=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showScheduledReports =
function() {
	var app = appCtxt.getApp(this._appName);
	var load = window.open(this.getUserProperty("journyx_server") + 'scheduleReports.pyc','reports','scrollbars=no,menubar=no,height=600,width=800,resizable=yes,toolbar=no,location=no,status=no');

}
com_zimbra_journyx.prototype._showSavedReports =
function() {
	var app = appCtxt.getApp(this._appName);
	var load = window.open(this.getUserProperty("journyx_server") + 'viewsavedreports.pyc','reports','scrollbars=no,menubar=no,height=600,width=800,resizable=yes,toolbar=no,location=no,status=no');

};
com_zimbra_journyx.prototype._showProjectNotes =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "notes.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showTimeApprovals =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "tsapproval.pyc?sheettype=time&NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showExpenseApprovals =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "tsapproval.pyc?sheettype=expense&NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showMileageApprovals =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "tsapproval.pyc?sheettype=mileage&NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showMemorizedEntries =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "sticky.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showMySheets =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "notes.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showLeaveRequests =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "requests.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showResetPassword =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "chgpass.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showEntryScreens =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "wtuserpref.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
com_zimbra_journyx.prototype._showMyProjects =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"" + this.getUserProperty("journyx_server") + "projectpicker.pyc?NoBustFrames=1&SuppressNav=1\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app

};
//  This is required to keep track of the logout window
var logoutwindow=null;

com_zimbra_journyx.prototype._showLogout =
function() {
	logoutwindow = window.open(this.getUserProperty("journyx_server") + 'wtlogout.pyc','logoutwindow', 'toolbar=no, status=no, width=350, height=475');
	setTimeout("com_zimbra_journyx.prototype._hideLogout()",10000);
	this._showTimeSheetView();
};

com_zimbra_journyx.prototype._hideLogout =
function() {
	logoutwindow.close();
};

/**
 * Adds toolbar buttons.
 * 
 * @param       {Hash}  param   a hash of parameters
 */
com_zimbra_journyx.prototype._addToolbarBtns =
function(param) {
                var app = appCtxt.getApp(this._appName);
                var toolbar = app.getToolbar();
                if(toolbar.getButton("journyx_save_toolbarBtn") == undefined) {
                        this._saveBtn  = toolbar.createButton("journyx_save_toolbarBtn", {text:"Save", image:"Save"});
                        toolbar.addSelectionListener("journyx_save_toolbarBtn", new AjxListener(this, this._okPreferenceBtnListener));
                }
                this._saveBtn.setEnabled(param.enableSaveBtn);
};


/**
 * Sets the current preferences.
 * 
 */
com_zimbra_journyx.prototype._setZimletCurrentPreferences =
function() {
	this.journyx_server = this.getUserProperty("journyx_server");
	if (document.getElementById("journyx_server") != null  && this.journyx_server != undefined) {
		document.getElementById("journyx_server").value = this.journyx_server;
	}
};

/**
 * Shows the preferences view.
 * 
 */
com_zimbra_journyx.prototype._showPreferencesView =
function() {
	var app = appCtxt.getApp(this._appName);
	app.setContent(this._createPreferenceHTML());
};

/**
 * Creates the preferences HTML.
 * 
 * @return	{String}	the HTML
 */
com_zimbra_journyx.prototype._createPreferenceHTML =
function() {
	var html = new Array();
	var i = 0;
	html[i++] = "<BR/>";
	html[i++] = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\"><tbody><tr class=\"ZOptionsHeaderRow\"><td class=\"ZOptionsHeaderL\"><div class=\"ImgPrefsHeader_L\"/></td><td class=\"ZOptionsHeader ImgPrefsHeader\">Server Configuration</td><td class=\"ZOptionsHeaderR\"><div class=\"ImgPrefsHeader_R\"/></td></tr></tbody></table>";
	html[i++] = "<TABLE>";
	html[i++] = "<TR>";
	html[i++] = "<TD>";
	html[i++] = "Journyx Server:";
	html[i++] = "</TD><TD>";
	html[i++] =" <input id='journyx_server'  size='50' type='text'/>";
	html[i++] = "</TD>";
	html[i++] = "</TR>";
	html[i++] = "</TABLE>";
	html[i++] = "<BR/>";
	return html.join("");
};

/**
 * Listens for the OK preferences button.
 * 
 * @see		#_addToolbarBtns
 */
com_zimbra_journyx.prototype._okPreferenceBtnListener =
function() {
	var _saveRequired = false;
	if (this.journyx_server != document.getElementById("journyx_server").value) {
		this.setUserProperty("journyx_server", document.getElementById("journyx_server").value);
		_saveRequired = true;
	}
	if (_saveRequired) {
		this.saveUserProperties(new AjxCallback(this, this._showPreferenceSavedMsg));
		this._showDefaultView();
	} 
	else {
		this._showDefaultView();
	}
};

/**
 * Shows the preference saved message.
 * 
 */
com_zimbra_journyx.prototype._showPreferenceSavedMsg =
function() {
	var transitions = [ ZmToast.FADE_IN, ZmToast.PAUSE,  ZmToast.FADE_OUT ];
	appCtxt.getAppController().setStatusMsg("Preferences Saved", ZmStatusView.LEVEL_INFO, null, transitions);
};
