//////////////////////////////////////////////////////////////////////////////
// Based on the original emaildownloader zimlet this new one allow the user to download also folders.
// @author Lorenzo Fasc
//////////////////////////////////////////////////////////////////////////////

function it_seacom_fbackup() {
}

it_seacom_fbackup.prototype = new ZmZimletBase();
it_seacom_fbackup.prototype.constructor = it_seacom_fbackup;

it_seacom_fbackup.prototype.doDrop =
function(obj) {
	switch (obj.TYPE) {
		case "ZmFolder":
			this._FolderDropped(obj);
			break;
		case "ZmMailMsg":
			this._MessageDropped(obj);
			break;
		case "ZmConv":
			this._MessageDropped(obj);
			break;
		default:this.displayErrorMessage("Oggetto non valido");
 }
};

it_seacom_fbackup.prototype._MessageDropped =
function(msgObj) {
	this.srcMsgObj = msgObj.srcObj;
	if(this.srcMsgObj.type == "CONV"){
		this.srcMsgObj = this.srcMsgObj.getFirstHotMsg();
	}
	var url = [];
	var i = 0;
	var proto = location.protocol;
	var port = Number(location.port);
	url[i++] = proto;
	url[i++] = "//";
	url[i++] = location.hostname;
	if (port && ((proto == ZmSetting.PROTO_HTTP && port != ZmSetting.HTTP_DEFAULT_PORT) 
		|| (proto == ZmSetting.PROTO_HTTPS && port != ZmSetting.HTTPS_DEFAULT_PORT))) {
		url[i++] = ":";
		url[i++] = port;
	}
	url[i++] = "/home/";
	url[i++]= AjxStringUtil.urlComponentEncode(appCtxt.getActiveAccount().name);
	url[i++] = "/message.txt?fmt=zip&id=";
	url[i++] = this.srcMsgObj.id;
	try{
		var subject = this.srcMsgObj.subject.replace(/\*/g, "").replace(/\[/g, "").replace(/\]/g, "").replace(/\</g, "").replace(/\>/g, "").replace(/\=/g, "").replace(/\+/g, "").replace(/\'/g, "").replace(/\"/g, "").replace(/\\/g, "").replace(/\//g, "").replace(/\,/g, "").replace(/\./g, "").replace(/\:/g, "").replace(/\;/g, "").replace(/ /g, "").replace(/!/g, ""); 
		if(subject.length > 16){
			subject = subject.substring(0,15);
        }
		url[i++] = "&filename=" + subject;
	} catch(e) {
	}
	var getUrl = url.join(""); 
	window.open(getUrl, "_blank");
};

it_seacom_fbackup.prototype._FolderDropped =
function(folderObj) {
	this._downloadFolder(folderObj.name,folderObj.url);
};

// Called by the Zimbra framework when the panel item was clicked
it_seacom_fbackup.prototype.singleClicked = function() {
	this._setFolderBtnListener();
}

it_seacom_fbackup.prototype.doubleClicked =
function() {
	this._setFolderBtnListener();
}


it_seacom_fbackup.prototype._setFolderBtnListener =
function() {
	if (!this._chooseFolderDialog) {
		AjxDispatcher.require("Extras");
		this._chooseFolderDialog = new ZmChooseFolderDialog(appCtxt.getShell());
	}
	this._chooseFolderDialog.reset();
	this._chooseFolderDialog.registerCallback(DwtDialog.OK_BUTTON, this._chooseFolderOkBtnListener, this, this._chooseFolderDialog);
	// This doesn't show trash and spam folder
	var omitParam = {};
	omitParam[ZmFolder.ID_TRASH]=true;
	omitParam[ZmFolder.ID_SPAM]=true;
	
	var params = {
		treeIds:		[ZmOrganizer.FOLDER],
		title:			ZmMsg.chooseFolder,
		overviewId:		this.toString(),
		description:	ZmMsg.chooseFolder,
		skipReadOnly:	false,
		hideNewButton:	true,
		appName:		ZmApp.MAIL,
		omit:			omitParam
	};
	this._chooseFolderDialog.popup(params);
};
		
it_seacom_fbackup.prototype._chooseFolderOkBtnListener =
function(dlg, folder) {
	dlg.popdown();
	this._downloadFolder(folder.name,folder.getRestUrl());
};		
		

it_seacom_fbackup.prototype._downloadFolder =
function(folderName, folderUrl) {
	var d = new Date();
	var curr_date = d.getDate();
	var curr_month = d.getMonth()+1;
	var curr_year = d.getFullYear();
	var today = curr_date + "-" + curr_month + "-" + curr_year;
	var url = [];
	var i = 0;
	url[i++] = folderUrl;
	url[i++] = "?fmt=zip";
	var fileName = folderName.replace(/\*/g, "").replace(/\[/g, "").replace(/\]/g, "").replace(/\</g, "").replace(/\>/g, "").replace(/\=/g, "").replace(/\+/g, "").replace(/\'/g, "").replace(/\"/g, "").replace(/\\/g, "").replace(/\//g, "").replace(/\,/g, "").replace(/\./g, "").replace(/\:/g, "").replace(/\;/g, "").replace(/ /g, "").replace(/!/g, ""); 
	url[i++] = "&filename=" + today + '-' + fileName;
	var getUrl = url.join(""); 
	//window.open(getUrl, "_blank");
	// I use an hidden frame
	var rifFrame;
	var idFrame = 'framebackupBackup';
	if (document.getElementById(idFrame)){ 
    	    rifFrame = document.getElementById(idFrame) 
	}else{
	    rifFrame = document.createElement("iframe");
	    rifFrame.id= idFrame;
	    rifFrame.style.width="0px";
	    rifFrame.style.height="0px";
	    rifFrame.style.border="0";
	    document.body.appendChild(rifFrame);
	}	
	rifFrame.contentWindow.location.href = getUrl;
};			
		
		
		
		
		
		
		
		
		
		
		
		