#!/bin/bash

# Results:
#    TRUE: domain have a signature enabled
#    FALSE: domain don't have a signature enabled
#    NONE: domain don't have LDAP attributes for domain signature


ZIMBRA_HOME="/opt/zimbra"
POSTFIX_HOME="$ZIMBRA_HOME/postfix/conf"
DISCLAIMER_HOME="$POSTFIX_HOME/disclaimers"


# check for every domain
for domain in `/opt/zimbra/bin/zmprov gad`; do
   echo -ne "Domain: $domain \t"
   dom=`echo $domain | cut -d "." -f 1`         # get only subdomain

   # check for attribute "zimbraDomainPrefMailSignatureEnabled"
   enable=`/opt/zimbra/bin/zmprov gd $domain | grep zimbraDomainPrefMailSignatureEnabled | awk '{print $2}'`

   if [ ! -z $enable ]; then                    # if not empty
        if [ $enable == "TRUE" ]; then          # if value = TRUE
                echo "TRUE"
                # save the domain signature value into a text file
                $POSTFIX_HOME/read_from_ldap.pl $domain $DISCLAIMER_HOME/$domain
        else
                echo "FALSE"                    # value is FALSE
                # delete text file if exists
                if [ -f $DISCLAIMER_HOME/$domain ]; then
                        rm -f $DISCLAIMER_HOME/$domain
                        rm -f $DISCLAIMER_HOME/$domain.html
                fi
        fi
   else
        echo "NONE"                             # domain doesn't have LDAP attributes
        # delete text file if exists
        if [ -f $DISCLAIMER_HOME/$domain ]; then
                rm -f $DISCLAIMER_HOME/$domain
                rm -f $DISCLAIMER_HOME/$domain.html
        fi
   fi

done

