#!/bin/bash
# version: 0.0.4

ZIMBRA_HOME="/opt/zimbra"
POSTFIX_HOME="$ZIMBRA_HOME/postfix/conf"
DISCLAIMER_HOME="$POSTFIX_HOME/disclaimers"

# util functions
. ./utilfunc.sh


# checking for root user
ROOT_UID=0   # Root has $UID 0.
if [ "$UID" -eq "$ROOT_UID" ]; then
   echo "OK"
else
   echo "You are not root."
   exit 0
fi


title "ALTERMIME INSTALL"

echo "1) Installing Altermime RPM"
# check for Red Hat or CentOS version
if [ `grep 4 /etc/redhat-release` ]; then rhv="4"; else rhv=5; fi

ask "What is your Red Hat/CentOS version? 4 or 5?" "$rhv"
rhversion=$response
if [ "$rhversion" = "4" ]; then
	rpm -ivh rpms4/alterMIME-0.3.8-1_rh$rhversion.i386.rpm
else
	if [ "$rhversion" = "5" ]; then
		rpm -ivh rpms5/alterMIME-0.3.8-1_rh$rhversion.i386.rpm
	else
		echo "You don't have a compatible version... Exiting"
		exit 0
	fi
fi



echo "2) Creating a filter directory..."
# Create a filter directory and set premisions it
mkdir -p /opt/zimbra/var/spool/filter
chown zimbra.zimbra /opt/zimbra/var/spool/filter/
chmod 750 /opt/zimbra/var/spool/filter/


echo "3) Creating disclaimers directory..."
mkdir -p $DISCLAIMER_HOME
chown -R zimbra.zimbra $DISCLAIMER_HOME



title "POSTFIX CONFIGURATION"

echo "4) Backup master.cf file..."
# Postfix configuration
cp -f $POSTFIX_HOME/master.cf $POSTFIX_HOME/master.cf.orig

echo "5) Modifying master.cf configuration"
text0=`echo -ne "smtp\tinet\tn\t-\tn\t-\t-\tsmtpd\n"`
text1="   -o content_filter=dfilt:"
text2=`echo -ne "dfilt\tunix\t-\tn\tn\t-\t-\tpipe\n"`
text3="   flags=Rq user=zimbra argv=/opt/zimbra/postfix/conf/disclaimer -f \${sender} -- \${recipient}"

# getting actual IP
ip=`ifconfig | grep "inet addr" | head -1 | awk '{print $2}' | cut -d ":" -f 2`

ask "What is your email INCOMMING IP?" "$ip"
in_ip=$response
ask "What is your email OUTGOING IP?" "$ip"
out_ip=$response

tfile="temporal"

if [ "$in_ip" = "$out_ip" ] ; then	# if in_ip=out_ip then add dfilt for all emails
	echo "$text0" >> $tfile
	echo "$text1" >> $tfile
	echo "$text2" >> $tfile
	echo "$text3" >> $tfile
else
	echo "$in_ip:$text0" > $tfile
	echo "$out_ip:$text0" >> $tfile
	echo "$text1" >> $tfile
	echo "127.0.0.1:$text0" >> $tfile
	echo "$text1" >> $tfile
	echo "$text2" >> $tfile
	echo "$text3" >> $tfile
fi
cat master.cf.template >> $tfile

cp -f $tfile $POSTFIX_HOME/master.cf
chown root.postfix $POSTFIX_HOME/master.cf
rm -f $tfile

echo "6) Restarting Zimbra Postfix"
su - zimbra -c "zmmtactl stop"
su - zimbra -c "zmmtactl start"



title "EXTENDING LDAP SCHEMA"

# save a backup of original zimbra.schema
echo "7) Changing zimbra.schema"
cp -f $ZIMBRA_HOME/openldap/etc/openldap/schema/zimbra.schema $ZIMBRA_HOME/openldap/etc/openldap/schema/zimbra.schema.orig

cp -f zimbra.schema.5.0.2 $ZIMBRA_HOME/openldap/etc/openldap/schema/zimbra.schema
cp -f zimbra-disclaimer.schema $ZIMBRA_HOME/lib/conf/


# setting permissions
chown zimbra.zimbra $ZIMBRA_HOME/openldap/etc/openldap/schema/zimbra.schema


echo "8) Restarting LDAP service"
# restart LDAP service
su - zimbra -c "/opt/zimbra/bin/ldap stop"
su - zimbra -c "/opt/zimbra/bin/ldap start"



title "DISCLAIMER SCRIPT"

echo "9) Creating disclaimer script"
# Copy scripts and disclaimer files
cp disclaimer $POSTFIX_HOME/disclaimer

# set permisions
chgrp zimbra $POSTFIX_HOME/disclaimer
chmod 750 $POSTFIX_HOME/disclaimer



title "SCRIPT FOR CHECK SIGNATURES"

echo "10) Installing perl RPMS"
# Install perl RPM

if [ "$rhversion" = "4" ]; then
   rpm -i rpms4/perl-Convert-ASN1-*.rpm
   rpm -i rpms4/perl-HTML-Tagset-*.rpm
   rpm -i rpms4/perl-HTML-Parser-*.rpm
   rpm -i rpms4/perl-XML-NamespaceSupport-*.rpm
   rpm -i rpms4/perl-XML-SAX-*.rpm
   rpm -i rpms4/perl-Net-SSLeay-*.rpm
   rpm -i rpms4/perl-IO-Socket-SSL-*.rpm
   #rpm -i rpms4/perl-Compress-Zlib-*.rpm
   rpm -i rpms4/perl-URI-*.rpm
   rpm -i rpms4/perl-libwww-perl-*.rpm
   rpm -i rpms4/perl-LDAP-*.rpm
else
	if [ "$rhversion" = "5" ]; then
	   rpm -i rpms5/perl-Convert-ASN1-*.rpm
	   rpm -i rpms5/perl-HTML-Tagset-*.rpm
	   rpm -i rpms5/perl-HTML-Parser-*.rpm
	   rpm -i rpms5/perl-XML-NamespaceSupport-*.rpm
	   rpm -i rpms5/perl-XML-SAX-*.rpm
	   rpm -i rpms5/perl-Net-SSLeay-*.rpm
	   rpm -i rpms5/perl-IO-Socket-SSL-*.rpm
	   rpm -i rpms5/perl-Compress-Zlib-*.rpm
	   rpm -i rpms5/perl-URI-*.rpm
	   rpm -i rpms5/perl-libwww-perl-*.rpm
	   rpm -i rpms5/perl-LDAP-*.rpm
	fi
fi



echo "11) Creating /opt/zimbra/postfix/conf/check_disclaimers.sh"
# copy check_disclaimers.sh script
cp -f check_disclaimers.sh $POSTFIX_HOME

# check for ldap_host and ldap_root_password into /opt/zimbra/conf/localconfig.xml file
ldap_host=`grep -A1 "ldap_host" $ZIMBRA_HOME/conf/localconfig.xml | tail -1 | cut -d ">" -f 2 | cut -d "<" -f 1`
ldap_root_password=`grep -A1 "ldap_root_password" $ZIMBRA_HOME/conf/localconfig.xml | tail -1 | cut -d ">" -f 2 | cut -d "<" -f 1`

ask "Insert your ldap host" "$ldap_host"
lh=$response
ask "Insert your ldap root password" "$ldap_root_password"
lrp=$response

cat read_from_ldap.template | sed s/X.X.X.X/$lh/g > tempfile
cat tempfile | sed s/xxxxxx/$lrp/g > read_from_ldap.pl
chmod 755 read_from_ldap.pl
rm -f tempfile

echo "12) Creating read_from_ldap.pl script"
# copy read_from_ldap.pl script
mv -f read_from_ldap.pl $POSTFIX_HOME/read_from_ldap.pl

echo "13) Setting permissions"
chmod 755 $POSTFIX_HOME/check_disclaimers.sh
chmod 755 $POSTFIX_HOME/read_from_ldap.pl

echo "14) Creating /etc/cron.hourly/check_disclaimer script"
cat > /etc/cron.hourly/check_disclaimer << EOF
#!/bin/bash

/opt/zimbra/postfix/conf/check_disclaimers.sh
EOF

chmod 755 /etc/cron.hourly/check_disclaimer


title "DEPLOYING DISCLAIMER EXTENSION"
echo "15) Deploying Domain Disclaimer Extension for Admin UI"
$ZIMBRA_HOME/bin/zmzimletctl deploy disclaimer.zip



title "DONE!!!"

echo ""
echo "16) Set an signature for your domains (as zimbra user). For example:"
echo -ne "\tzmprov md mydomain.com zimbraDomainPrefMailSignatureEnabled TRUE\n"
echo -ne "\tzmprov md mydomain.com zimbraDomainPrefMailSignature \"This is a domain disclaimer for mydomain.com\"\n"
echo -ne "\tzmprov md mydomain.com zimbraDomainPrefMailSignatureHTML \"This is a domain disclaimer for <b>mydomain.com</b>\"\n\n"
echo "17) Check your domain signature:"
echo -ne "\tzmprov gd mydomain.com | grep Signature\n\n"
echo "18) Create domain signatures files:"
echo -ne "\t/opt/zimbra/postfix/conf/check_disclaimers.sh\n\n"
echo "19) Logon in Admin interface and check for your Domain Extension..."

