/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.samba;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.ldap.ChangePasswordListener;
import java.security.Key;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SambaChangePasswordListener
extends ChangePasswordListener {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public void preModify(Account acct, String newPassword, Map context, Map<String, Object> attrsToModify) throws ServiceException {
        try {
            String lmPassword = this.calcLMHash(newPassword);
            String ntPassword = this.calcNTLMHash(newPassword);
            attrsToModify.put("sambaLMPassword", lmPassword);
            attrsToModify.put("sambaNTPassword", ntPassword);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void postModify(Account acct, String newPassword, Map context) {
    }

    String calcLMHash(String password) throws Exception {
        return this.hex(this.lmHash(password));
    }

    String calcNTLMHash(String password) throws Exception {
        return this.hex(this.ntlmHash(password));
    }

    byte[] lmHash(String password) throws Exception {
        byte[] oemPassword = password.toUpperCase().getBytes("US-ASCII");
        int length = Math.min(oemPassword.length, 14);
        byte[] keyBytes = new byte[14];
        System.arraycopy(oemPassword, 0, keyBytes, 0, length);
        Key lowKey = this.createDESKey(keyBytes, 0);
        Key highKey = this.createDESKey(keyBytes, 7);
        byte[] magicConstant = "KGS!@#$%".getBytes("US-ASCII");
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, lowKey);
        byte[] lowHash = des.doFinal(magicConstant);
        des.init(1, highKey);
        byte[] highHash = des.doFinal(magicConstant);
        byte[] lmHash = new byte[16];
        System.arraycopy(lowHash, 0, lmHash, 0, 8);
        System.arraycopy(highHash, 0, lmHash, 8, 8);
        return lmHash;
    }

    byte[] ntlmHash(String password) throws Exception {
        byte[] unicodePassword = password.getBytes("UTF-16LE");
        return (SambaChangePasswordListener)this.new MD4((byte[])unicodePassword).hash;
    }

    Key createDESKey(byte[] bytes, int offset) {
        byte[] keyBytes = new byte[7];
        System.arraycopy(bytes, offset, keyBytes, 0, 7);
        byte[] material = new byte[]{keyBytes[0], (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1), (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2), (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3), (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4), (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5), (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6), (byte)(keyBytes[6] << 1)};
        this.oddParity(material);
        return new SecretKeySpec(material, "DES");
    }

    void oddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            boolean needsParity;
            byte b = bytes[i];
            boolean bl = needsParity = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ b >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1);
                continue;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] & 0xFFFFFFFE);
        }
    }

    String hex(byte[] data) throws Exception {
        int len = data.length;
        char[] out = new char[len * 2];
        int index = 0;
        for (int i = 0; i < len; ++i) {
            out[index++] = HEX[data[i] >> 4 & 0xF];
            out[index++] = HEX[data[i] & 0xF];
        }
        return new String(out);
    }

    private class MD4 {
        public final byte[] hash = new byte[16];
        private int A;
        private int B;
        private int C;
        private int D;
        private int[] d;

        public MD4(byte[] in) {
            int i;
            long datalenbits = in.length * 8;
            int endblklen = in.length % 64;
            int pad = endblklen < 56 ? 64 - endblklen : 64 - endblklen + 64;
            int newlen = in.length + pad;
            byte[] b = new byte[newlen];
            for (i = 0; i < in.length; ++i) {
                b[i] = in[i];
            }
            b[in.length] = -128;
            for (i = b.length + 1; i < newlen - 8; ++i) {
                b[i] = 0;
            }
            for (i = 0; i < 8; ++i) {
                b[newlen - 8 + i] = (byte)(datalenbits & 0xFFL);
                datalenbits >>= 8;
            }
            this.A = 1732584193;
            this.B = -271733879;
            this.C = -1732584194;
            this.D = 271733878;
            int numwords = newlen / 4;
            this.d = new int[numwords];
            for (i = 0; i < newlen; i += 4) {
                this.d[i / 4] = (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 3] & 0xFF) << 24);
            }
            for (i = 0; i < numwords / 16; ++i) {
                int AA = this.A;
                int BB = this.B;
                int CC = this.C;
                int DD = this.D;
                this.round(i);
                this.A += AA;
                this.B += BB;
                this.C += CC;
                this.D += DD;
            }
            this.hash[0] = (byte)(this.A & 0xFF);
            this.A >>= 8;
            this.hash[1] = (byte)(this.A & 0xFF);
            this.A >>= 8;
            this.hash[2] = (byte)(this.A & 0xFF);
            this.A >>= 8;
            this.hash[3] = (byte)(this.A & 0xFF);
            this.hash[4] = (byte)(this.B & 0xFF);
            this.B >>= 8;
            this.hash[5] = (byte)(this.B & 0xFF);
            this.B >>= 8;
            this.hash[6] = (byte)(this.B & 0xFF);
            this.B >>= 8;
            this.hash[7] = (byte)(this.B & 0xFF);
            this.hash[8] = (byte)(this.C & 0xFF);
            this.C >>= 8;
            this.hash[9] = (byte)(this.C & 0xFF);
            this.C >>= 8;
            this.hash[10] = (byte)(this.C & 0xFF);
            this.C >>= 8;
            this.hash[11] = (byte)(this.C & 0xFF);
            this.hash[12] = (byte)(this.D & 0xFF);
            this.D >>= 8;
            this.hash[13] = (byte)(this.D & 0xFF);
            this.D >>= 8;
            this.hash[14] = (byte)(this.D & 0xFF);
            this.D >>= 8;
            this.hash[15] = (byte)(this.D & 0xFF);
        }

        private int F(int x, int y, int z) {
            return x & y | ~x & z;
        }

        private int G(int x, int y, int z) {
            return x & y | x & z | y & z;
        }

        private int H(int x, int y, int z) {
            return x ^ y ^ z;
        }

        private int rotate(int val, int numbits) {
            return val << numbits | val >>> 32 - numbits;
        }

        private void round(int blk) {
            this.A = this.rotate(this.A + this.F(this.B, this.C, this.D) + this.d[0 + 16 * blk], 3);
            this.D = this.rotate(this.D + this.F(this.A, this.B, this.C) + this.d[1 + 16 * blk], 7);
            this.C = this.rotate(this.C + this.F(this.D, this.A, this.B) + this.d[2 + 16 * blk], 11);
            this.B = this.rotate(this.B + this.F(this.C, this.D, this.A) + this.d[3 + 16 * blk], 19);
            this.A = this.rotate(this.A + this.F(this.B, this.C, this.D) + this.d[4 + 16 * blk], 3);
            this.D = this.rotate(this.D + this.F(this.A, this.B, this.C) + this.d[5 + 16 * blk], 7);
            this.C = this.rotate(this.C + this.F(this.D, this.A, this.B) + this.d[6 + 16 * blk], 11);
            this.B = this.rotate(this.B + this.F(this.C, this.D, this.A) + this.d[7 + 16 * blk], 19);
            this.A = this.rotate(this.A + this.F(this.B, this.C, this.D) + this.d[8 + 16 * blk], 3);
            this.D = this.rotate(this.D + this.F(this.A, this.B, this.C) + this.d[9 + 16 * blk], 7);
            this.C = this.rotate(this.C + this.F(this.D, this.A, this.B) + this.d[10 + 16 * blk], 11);
            this.B = this.rotate(this.B + this.F(this.C, this.D, this.A) + this.d[11 + 16 * blk], 19);
            this.A = this.rotate(this.A + this.F(this.B, this.C, this.D) + this.d[12 + 16 * blk], 3);
            this.D = this.rotate(this.D + this.F(this.A, this.B, this.C) + this.d[13 + 16 * blk], 7);
            this.C = this.rotate(this.C + this.F(this.D, this.A, this.B) + this.d[14 + 16 * blk], 11);
            this.B = this.rotate(this.B + this.F(this.C, this.D, this.A) + this.d[15 + 16 * blk], 19);
            this.A = this.rotate(this.A + this.G(this.B, this.C, this.D) + this.d[0 + 16 * blk] + 1518500249, 3);
            this.D = this.rotate(this.D + this.G(this.A, this.B, this.C) + this.d[4 + 16 * blk] + 1518500249, 5);
            this.C = this.rotate(this.C + this.G(this.D, this.A, this.B) + this.d[8 + 16 * blk] + 1518500249, 9);
            this.B = this.rotate(this.B + this.G(this.C, this.D, this.A) + this.d[12 + 16 * blk] + 1518500249, 13);
            this.A = this.rotate(this.A + this.G(this.B, this.C, this.D) + this.d[1 + 16 * blk] + 1518500249, 3);
            this.D = this.rotate(this.D + this.G(this.A, this.B, this.C) + this.d[5 + 16 * blk] + 1518500249, 5);
            this.C = this.rotate(this.C + this.G(this.D, this.A, this.B) + this.d[9 + 16 * blk] + 1518500249, 9);
            this.B = this.rotate(this.B + this.G(this.C, this.D, this.A) + this.d[13 + 16 * blk] + 1518500249, 13);
            this.A = this.rotate(this.A + this.G(this.B, this.C, this.D) + this.d[2 + 16 * blk] + 1518500249, 3);
            this.D = this.rotate(this.D + this.G(this.A, this.B, this.C) + this.d[6 + 16 * blk] + 1518500249, 5);
            this.C = this.rotate(this.C + this.G(this.D, this.A, this.B) + this.d[10 + 16 * blk] + 1518500249, 9);
            this.B = this.rotate(this.B + this.G(this.C, this.D, this.A) + this.d[14 + 16 * blk] + 1518500249, 13);
            this.A = this.rotate(this.A + this.G(this.B, this.C, this.D) + this.d[3 + 16 * blk] + 1518500249, 3);
            this.D = this.rotate(this.D + this.G(this.A, this.B, this.C) + this.d[7 + 16 * blk] + 1518500249, 5);
            this.C = this.rotate(this.C + this.G(this.D, this.A, this.B) + this.d[11 + 16 * blk] + 1518500249, 9);
            this.B = this.rotate(this.B + this.G(this.C, this.D, this.A) + this.d[15 + 16 * blk] + 1518500249, 13);
            this.A = this.rotate(this.A + this.H(this.B, this.C, this.D) + this.d[0 + 16 * blk] + 1859775393, 3);
            this.D = this.rotate(this.D + this.H(this.A, this.B, this.C) + this.d[8 + 16 * blk] + 1859775393, 9);
            this.C = this.rotate(this.C + this.H(this.D, this.A, this.B) + this.d[4 + 16 * blk] + 1859775393, 11);
            this.B = this.rotate(this.B + this.H(this.C, this.D, this.A) + this.d[12 + 16 * blk] + 1859775393, 15);
            this.A = this.rotate(this.A + this.H(this.B, this.C, this.D) + this.d[2 + 16 * blk] + 1859775393, 3);
            this.D = this.rotate(this.D + this.H(this.A, this.B, this.C) + this.d[10 + 16 * blk] + 1859775393, 9);
            this.C = this.rotate(this.C + this.H(this.D, this.A, this.B) + this.d[6 + 16 * blk] + 1859775393, 11);
            this.B = this.rotate(this.B + this.H(this.C, this.D, this.A) + this.d[14 + 16 * blk] + 1859775393, 15);
            this.A = this.rotate(this.A + this.H(this.B, this.C, this.D) + this.d[1 + 16 * blk] + 1859775393, 3);
            this.D = this.rotate(this.D + this.H(this.A, this.B, this.C) + this.d[9 + 16 * blk] + 1859775393, 9);
            this.C = this.rotate(this.C + this.H(this.D, this.A, this.B) + this.d[5 + 16 * blk] + 1859775393, 11);
            this.B = this.rotate(this.B + this.H(this.C, this.D, this.A) + this.d[13 + 16 * blk] + 1859775393, 15);
            this.A = this.rotate(this.A + this.H(this.B, this.C, this.D) + this.d[3 + 16 * blk] + 1859775393, 3);
            this.D = this.rotate(this.D + this.H(this.A, this.B, this.C) + this.d[11 + 16 * blk] + 1859775393, 9);
            this.C = this.rotate(this.C + this.H(this.D, this.A, this.B) + this.d[7 + 16 * blk] + 1859775393, 11);
            this.B = this.rotate(this.B + this.H(this.C, this.D, this.A) + this.d[15 + 16 * blk] + 1859775393, 15);
        }
    }
}

