#!/bin/bash

ID=`id -u`
MYDIR=`dirname $0`
UNINSTALL="no"
INSTALLED="NN"
JARINSTALLED="N"
BININSTALLED="N"

if [ "x$ID" != "x0" ]; then
        echo "User must be root!"
        exit 1
fi

usage() {
  echo "$0 -[hiu]"
  echo ""
  echo "-h|--help             Usage"
  echo "-i|--install          Install extension"
  echo "-u|--uninstall        Uninstall extension"
  echo ""
  exit
}

runAsZimbra() {
  su - zimbra -c "$1"
}

shutDownSystem() {
  echo ""
  echo "Shutting down Zimbra"
  runAsZimbra "zmcontrol shutdown"
}

startUpSystem() {
	echo ""
	echo "Starting up Zimbra"
	runAsZimbra "zmcontrol startup"
}

ask() {
  PROMPT=$1
  DEFAULT=$2

  echo ""
  echo -n "$PROMPT [$DEFAULT] "
  read response

  if [ -z $response ]; then
    response=$DEFAULT
  fi
}

askYN() {
  PROMPT=$1
  DEFAULT=$2

  if [ "x$DEFAULT" = "xyes" -o "x$DEFAULT" = "xYes" -o "x$DEFAULT" = "xy" -o "x$DEFAULT" = "xY" ]; then
    DEFAULT="Y"
  else
    DEFAULT="N"
  fi

  while [ 1 ]; do
    ask "$PROMPT" "$DEFAULT"
    if [ -z $response ]; then
      :
    else
      if [ $response = "yes" -o $response = "YES" -o $response = "y" -o $response = "Y" ]; then
        response="yes"
        break
      else
        if [ $response = "no" -o $response = "NO" -o $response = "n" -o $response = "N" ]; then
          response="no"
          break
        fi
      fi
    fi
    echo "A Yes/No answer is required"
  done
}

checkExistingInstall() {
  echo "Checking for existing installation..."
  if [ -f "/opt/zimbra/lib/ext/sambapassword/sambapassword.jar" ]; then
  	JARINSTALLED="Y"
  fi
  if [ -f "/opt/zimbra/bin/mkntpwd" ]; then
  	BININSTALLED="Y"
  fi
	INSTALLED="$JARINSTALLED$BININSTALLED"
}

unRegisterExtension() {
  echo ""
  echo "Unregistering zimbraSambaPassword extension"
	runAsZimbra "zmprov modifyConfig zimbraPasswordChangeListener ''"
}

registerExtension() {
  echo ""
	echo "Registering zimbraSambaPassword extension"
	runAsZimbra "zmprov modifyConfig zimbraPasswordChangeListener sambapassword"
}

installMkntpwd() {
  echo ""
  echo "Installing mkntpwd binary"
	if [ "x$BININSTALLED" = "xY" ]; then
  	echo "Skipped: mkntpwd is already installed..."
  else
		if [ -f "mkntpwd.tar.gz" ]; then
			/bin/rm -rf mkntpwd
			tar zxf mkntpwd.tar.gz
			cd mkntpwd; make; cd ..
			if [ -f "mkntpwd/mkntpwd" ]; then
	  		cp mkntpwd/mkntpwd /opt/zimbra/bin/
	  	else
	  		echo "ERROR: can't make mkntpwd binary. Aborting installation..."
	  		exit 1
	  	fi
	  else
  		echo "ERROR: can't found mkntpwd package. Aborting installation..."
  		exit 1
	  fi
  fi
}

installJar() {
  echo ""
  echo "Installing zimbraSambaPassword extension"
  mkdir /opt/zimbra/lib/ext/sambapassword
	cp sambapassword.jar /opt/zimbra/lib/ext/sambapassword/
}

removeMkntpwd() {
  echo ""
  echo "Removing mkntpwd binary"
  /bin/rm -f /opt/zimbra/bin/mkntpwd
  /bin/rm -rf ./mkntpwd
}

removeJar() {
  echo ""
  echo "Removing zimbraSambaPassword extension"
  /bin/rm -rf /opt/zimbra/lib/ext/sambapassword
}

removeExtension() {
  if [ "x$INSTALLED" = "xYY" ]; then
  	unRegisterExtension
    shutDownSystem
		removeJar
		removeMkntpwd
    echo ""
		askYN "Startup Zimbra?" "N"
		if [ $response = "yes" ]; then
    	startUpSystem
		fi
		exit
	else
		if [ "x$BININSTALLED" = "xY" ]; then
	  	removeMkntpwd
	  fi
		if [ "x$JARINSTALLED" = "xY" ]; then
	  	unRegisterExtension
	    shutDownSystem
	  	removeJar
	    echo ""
			askYN "Startup Zimbra?" "N"
			if [ $response = "yes" ]; then
	    	startUpSystem
			fi
	  fi
	fi
}

installExtension() {
  shutDownSystem
	installJar
	installMkntpwd
  startUpSystem
	registerExtension
}

case $1 in
	-i|--install)
		checkExistingInstall
  	if [ $INSTALLED = "YY" ]; then
  		echo "zimbraSambaPassword is already installed!"
  		exit
  	fi
  	installExtension
    ;;
	-u|--uninstall)
		checkExistingInstall
  	if [ $INSTALLED = "NN" ]; then
  		echo "zimbraSambaPassword is NOT installed!"
  		exit
  	fi
    askYN "Completely remove existing installation?" "N"
    if [ $response = "yes" ]; then
			removeExtension
    fi
    exit 1
    ;;
  -h|-help|--help)
    usage
    ;;
	*)
		echo "ERROR: Unknown option $1"
		usage
    ;;
esac
