function eu_newtec_mailcontact() {
}

eu_newtec_mailcontact.prototype = new ZmZimletBase();

eu_newtec_mailcontact.prototype.constructor = eu_newtec_mailcontact;

eu_newtec_mailcontact.prototype.init = function() {
};

eu_newtec_mailcontact.prototype.doDrop =
function(obj) {
    	//if previous process is still running in background, show that dlg
	if (this.pbDialog) {
		if (this.pbDialog.runInBackground) {
			this.pbDialog.popup();
			this.pbDialog.runInBackground = false;
			return;
		}
	}

    if (this.conOrgDialog) {
		this._resetStaleDialog(obj);
		this.conOrgDialog.popup();
		return;
	}

	this._initializeEmptyDlg();
	this._parentView.getHtmlElement().innerHTML = this.constructMailContactView(obj);
	this.addMailContactButtons();
	this.conOrgDialog.popup();
    
};


eu_newtec_mailcontact.prototype.getUserDisplayName =
function() {
    if(!appCtxt.get(ZmSetting.DISPLAY_NAME)) return "";
    return appCtxt.get(ZmSetting.DISPLAY_NAME);
}; 

eu_newtec_mailcontact.prototype.getUserReplyTo =
function() {
    return appCtxt.get(ZmSetting.REPLY_TO_ADDRESS);
};

eu_newtec_mailcontact.prototype.getUserId =
function() {
    return appCtxt.get(ZmSetting.USERID);
};

eu_newtec_mailcontact.prototype.constructMailContactView =
function(mailContact) {

	var m;
	var html = new Array();
	var i = 0;
	
	html[i++] = "<table>";
	html[i++] = "<tr><td width=100>To:</td><td><input type=\"text\" id=\"pm_to\" name=\"caller\" size=40></td></tr>";
	html[i++] = "<tr><td width=100>Subject:</td><td><input type=\"text\" id=\"pm_subject\" name=\"caller\" size=40></td></tr>";
	html[i++] = "<input type=\"hidden\" id=\"pm_contactid\" value=\""+mailContact.id+"\">";
	html[i++] = "<tr><td width=100>Contact:</td><td><div id=\"pm_contactinfo\">"+this._getDisplayName(mailContact)+"</div></td></tr>";
	html[i++] = "<tr><td colspan=2 width=140><textarea id=\"pm_bodymessage\" rows=3 cols=60></textarea></td></tr>";
	html[i++] = "</table>";

	return html.join("");
};

eu_newtec_mailcontact.prototype._getDisplayName =
function(mailContact) {
	var displayName="";
	if ((! mailContact.firstName || ! mailContact.lastName) && mailContact.email){
	    displayName=mailContact.email;
	}else{
	    displayName=mailContact.firstName+" "+mailContact.lastName;
	}
	return displayName;
};

eu_newtec_mailcontact.prototype._resetStaleDialog =
function(mailContact) {
    document.getElementById("pm_to").value="";
    document.getElementById("pm_subject").value="";
    document.getElementById("pm_contactinfo").innerHTML=this._getDisplayName(mailContact);
    document.getElementById("pm_contactid").value=mailContact.id;
    document.getElementById("pm_bodymessage").value="";
};

eu_newtec_mailcontact.prototype._initializeEmptyDlg =
function() {
	this._parentView = new DwtComposite(this.getShell());
	this._parentView.setSize("350", "145");
	this._parentView.getHtmlElement().style.overflow = "auto";
};

eu_newtec_mailcontact.prototype.addMailContactButtons =
function() {
	if (this.conOrgDialog) return;

	this._ProcessButtonId = Dwt.getNextId();
	var blk = "";
	for (var k = 0; k < 15; k++)
		blk = blk + "&nbsp;";
	var processButton = new DwtDialog_ButtonDescriptor(this._ProcessButtonId, (blk + "Send Contact Message" + blk), DwtDialog.ALIGN_RIGHT);
	this.conOrgDialog = this._createDialog({title:"Contact Message", view:this._parentView, standardButtons : [ DwtDialog.CANCEL_BUTTON],extraButtons:[processButton]});
	this.conOrgDialog.setButtonListener(this._ProcessButtonId, new AjxListener(this, this.prepareContactMessage));
};

eu_newtec_mailcontact.prototype.prepareContactMessage =
function(ev) {
        var pm_to=document.getElementById("pm_to").value;

        var pm_subject=document.getElementById("pm_subject").value;
        var pm_contactid=document.getElementById("pm_contactid").value;
        var pm_body=document.getElementById("pm_bodymessage").value;
        this._sendMsg(pm_to, pm_subject, pm_body, pm_contactid);
        this.conOrgDialog.popdown();
        return;
};

eu_newtec_mailcontact.prototype._sendMsg =
function(destEmail, subject, body, contactId) {
    var soapDoc = AjxSoapDoc.create("SendMsgRequest", "urn:zimbraMail");
    var m = soapDoc.set("m");
    m.setAttribute("idnt", this.getUserId());
    var node_e = soapDoc.set("e", null, m);
    node_e.setAttribute("t", "t");
    node_e.setAttribute("p", destEmail);
    node_e.setAttribute("a", destEmail);
    node_e.setAttribute("add", "0");
    var node_s = soapDoc.set("su",subject , m);
    var node = soapDoc.set("mp", null, m);
    node.setAttribute("ct", "text/plain");
    var subnode = soapDoc.set("content", body, node);
    var node_attach = soapDoc.set("attach", null, m);
    var subnode_attach = soapDoc.set("cn", null, node_attach);
    subnode_attach.setAttribute("id", contactId);
    var command = new ZmCsfeCommand();
    var resp = command.invoke({soapDoc: soapDoc});
	appCtxt.getAppController().setStatusMsg("Message sent", ZmStatusView.LEVEL_INFO);
	return;
};
