/*
 * Decompiled with CFR 0.152.
 */
package com.gr.zimbra;

import com.gr.Logger;
import com.gr.api.Connection;
import com.gr.api.GRAPIException;
import com.gr.api.ObjectKey;
import com.gr.api.SearchObject;
import com.gr.zimbra.ABI;
import com.gr.zimbra.GRDocumentHandler;
import com.zimbra.common.mailbox.ContactConstants;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;
import java.util.TreeMap;

public class SyncContacts
extends GRDocumentHandler {
    private static final int ALL_FOLDERS = -1;

    protected ParsedContact gr2pc(com.gr.api.Contact contact, String string) throws ServiceException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(ContactConstants.A_email, contact.email());
        treeMap.put(ContactConstants.A_firstName, contact.firstName());
        treeMap.put(ContactConstants.A_lastName, contact.lastName());
        treeMap.put(ContactConstants.A_jobTitle, contact.title());
        treeMap.put(ContactConstants.A_company, contact.company());
        treeMap.put(ContactConstants.A_imAddress1, contact.address1());
        treeMap.put(ContactConstants.A_imAddress2, contact.address2());
        treeMap.put(ContactConstants.A_homeCity, contact.city());
        treeMap.put(ContactConstants.A_homeState, contact.state());
        treeMap.put(ContactConstants.A_homePostalCode, contact.zip());
        treeMap.put(ContactConstants.A_homeCountry, contact.country());
        treeMap.put(ContactConstants.A_homePhone, contact.phone());
        treeMap.put(ContactConstants.A_mobilePhone, contact.mobile());
        treeMap.put(ContactConstants.A_homeFax, contact.fax());
        treeMap.put(ContactConstants.A_homeURL, contact.webSite());
        treeMap.put("Greenropeid", contact.id());
        if (null != string && string.length() > 0) {
            treeMap.put("GRAccountid", string);
        }
        return new ParsedContact(treeMap);
    }

    protected static String mVal(Map<String, String> map, String string) {
        if (map.containsKey(string)) {
            return map.get(string);
        }
        return "";
    }

    protected void createGRContact(Contact contact, ObjectKey objectKey, Connection connection) throws GRAPIException {
        com.gr.api.Contact contact2 = new com.gr.api.Contact();
        Map map = contact.getFields();
        contact2.setEmail(SyncContacts.mVal(map, ContactConstants.A_email));
        contact2.setFirstName(SyncContacts.mVal(map, ContactConstants.A_firstName));
        contact2.setLastName(SyncContacts.mVal(map, ContactConstants.A_lastName));
        contact2.setTitle(SyncContacts.mVal(map, ContactConstants.A_jobTitle));
        contact2.setCompany(SyncContacts.mVal(map, ContactConstants.A_company));
        contact2.setAddress1(SyncContacts.mVal(map, ContactConstants.A_imAddress1));
        contact2.setAddress2(SyncContacts.mVal(map, ContactConstants.A_imAddress2));
        contact2.setCity(SyncContacts.mVal(map, ContactConstants.A_homeCity));
        contact2.setState(SyncContacts.mVal(map, ContactConstants.A_homeState));
        contact2.setZip(SyncContacts.mVal(map, ContactConstants.A_homePostalCode));
        contact2.setCountry(SyncContacts.mVal(map, ContactConstants.A_homeCountry));
        contact2.setPhone(SyncContacts.mVal(map, ContactConstants.A_homePhone));
        contact2.setMobile(SyncContacts.mVal(map, ContactConstants.A_mobilePhone));
        contact2.setFax(SyncContacts.mVal(map, ContactConstants.A_homeFax));
        contact2.setWebSite(SyncContacts.mVal(map, ContactConstants.A_homeURL));
        contact2.groups().add(objectKey);
        connection.addContact(contact2);
    }

    protected void add2gr4zm(OperationContext operationContext, GRContactMap gRContactMap, ZMContactMap zMContactMap, ObjectKey objectKey, Connection connection) throws GRAPIException {
        for (String string : zMContactMap.keySet()) {
            Contact contact = (Contact)zMContactMap.get(string);
            if (gRContactMap.containsKey(string)) continue;
            Logger.debug("ADD TO GR: " + string);
            this.createGRContact(contact, objectKey, connection);
        }
    }

    protected void sync2zm4gr(OperationContext operationContext, GRContactMap gRContactMap, ZMContactMap zMContactMap, Mailbox mailbox, int n, String string) throws ServiceException {
        for (String string2 : gRContactMap.keySet()) {
            com.gr.api.Contact contact = (com.gr.api.Contact)gRContactMap.get(string2);
            if (zMContactMap.containsKey(string2)) {
                Logger.debug("Update Contact: " + string2);
                mailbox.modifyContact(operationContext, ((Contact)zMContactMap.get(string2)).getId(), this.gr2pc(contact, string));
                continue;
            }
            Logger.debug("ADD TO ZM: " + string2);
            mailbox.createContact(operationContext, this.gr2pc(contact, string), n, null);
        }
    }

    @Override
    public Element grHandle(Element element, ZimbraSoapContext zimbraSoapContext) throws GRAPIException, ServiceException {
        OperationContext operationContext = SyncContacts.getOperationContext((ZimbraSoapContext)zimbraSoapContext, (Map)this.m_context);
        Connection connection = this.grConnection(element);
        ObjectKey objectKey = this.getGroupKey(element);
        Mailbox mailbox = SyncContacts.getRequestedMailbox((ZimbraSoapContext)zimbraSoapContext);
        Folder folder = ABI.get().getFolder(operationContext, mailbox, objectKey.name);
        if (null == folder) {
            folder = ABI.get().createContactFolder(operationContext, mailbox, objectKey.name);
        }
        ZMContactMap zMContactMap = new ZMContactMap();
        GRContactMap gRContactMap = new GRContactMap();
        for (Object object : mailbox.getContactList(operationContext, folder.getId(), SortBy.NONE)) {
            if (!object.isGroup()) {
                Object object2 = object.getEmailAddresses();
                if (object2.isEmpty()) continue;
                zMContactMap.put(object2.get(0), object);
                Logger.debug("ZM Contact: " + (String)object2.get(0));
                continue;
            }
            Logger.debug("ZM Group: " + object);
        }
        SearchObject searchObject = new SearchObject();
        searchObject.put("group_id", objectKey.id);
        for (Object object2 : connection.getContacts(searchObject)) {
            gRContactMap.put(((com.gr.api.Contact)object2).email(), object2);
            Logger.debug("GR Contact: " + ((com.gr.api.Contact)object2).email());
        }
        this.sync2zm4gr(operationContext, gRContactMap, zMContactMap, mailbox, folder.getId(), connection.saaID());
        Element element2 = this.createOK(zimbraSoapContext);
        return element2;
    }

    static class ZMContactMap
    extends TreeMap<String, Contact> {
        ZMContactMap() {
        }
    }

    static class GRContactMap
    extends TreeMap<String, com.gr.api.Contact> {
        GRContactMap() {
        }
    }
}

