/*
    This file is part of Inova Parcel Tracker.

    Inova Parcel Tracker is free software: you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.

    Inova Parcel Tracker is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Inova Parcel Tracker. If not, see <http://www.gnu.org/licenses/>.

    Authors:
	Bruno Santos <bruno.santos@inova.net>, Inova Tecnologias Ltda.
	Marcelo Bezerra <marcelo.bezerra@inova.net>, Inova Tecnologias Ltda.
*/

function Net_Inova_Correios() {
}

Net_Inova_Correios.prototype = new ZmZimletBase();
Net_Inova_Correios.prototype.constructor = Net_Inova_Correios;

Net_Inova_Correios.prototype._getTrackingUrl = function(country, numero, produto) {
	var url = "http://websro.correios.com.br/sro_bin/txect01$.QueryList?P_LINGUA=001&P_TIPO=001&P_COD_UNI="+encodeURI(produto+numero+country);
	if(country == "HK") {
		url = "http://app3.hongkongpost.com/CGI/mt/genresult.jsp?tracknbr="+encodeURI(produto+numero+country);
	} else if(country == "US") {
		url = "http://trkcnfrm1.smi.usps.com/PTSInternetWeb/InterLabelInquiry.do?origTrackNum="+encodeURI(produto+numero+country);
	} else if(country == "ES") {
		url="http://www.correos.es/contenido/13-MenuRec2/01-MenuRec21/track.asp?accion=LocalizaUno&numeros=&ecorreo=&numero="+encodeURI(produto+numero+country);
	} else if(country == "AR" && numero != null && produto != null) {
		//url="http://www3.correoargentino.com.ar/scriptsN/ips/ips2.asp?pieza="+encodeURI(produto+numero+country);
		url="http://www3.correoargentino.com.ar/scriptsN/tyt/tyt.pl?producto="+ encodeURI(producto) + "&numero=" + encodeURI(numero) + "&pais=" + encodeURI(country);
	}
	return url;
}

Net_Inova_Correios.prototype.toolTipPoppedUp = function(spanElement, contentObjText, matchContext, canvas) {
        if(canvas != null) {
		var winW = 630, winH = 460;

		if (parseInt(navigator.appVersion)>3) {
			if (navigator.appName=="Netscape") {
				winW = window.innerWidth;
				winH = window.innerHeight;
			}
			if (navigator.appName.indexOf("Microsoft")!=-1) {
				winW = document.body.offsetWidth;
				winH = document.body.offsetHeight;
			}

			winH = (winH / 3) * 2;
			winW = (winW / 3) * 2;
		}

                var id = ZmZimletBase.encodeId(contentObjText);
		var url = this._getTrackingUrl(matchContext[4], matchContext[3], matchContext[2]);
                canvas.innerHTML = "<iframe frameborder=\"0\" style=\"width:"+winW+"px;height:"+winH+"px\" id=\""+
			id+"\" src=\"" + url + "\"></iframe>";
                if(window.console) {
                        console.log("Correios: Tracking Number="+matchContext[1]);
                }
        }
}

Net_Inova_Correios.prototype.clicked = function(spanElement, contentObjText, matchContext, canvas) {
	if(matchContext && matchContext[3]) {
		var url = this._getTrackingUrl(matchContext[4], matchContext[3], matchContext[2]);
		var win = window.open(url, null, "width=640,height=480,scrollbars=1,toolbar=1,resizable=1,status=1,menubar=1,location=1"); 
	}
}

Net_Inova_Correios.prototype.match = function(content, startIndex) {
	var ret = null;
	var regexps = new Array();
// Regex for most common tracking codes.
// When adding new countries, modify _getTrackingUrl accordingly.
	regexps[0] = new RegExp("\\b((AR|C[CEPR]|E[BCEHNRS]|F[EFHR]|I[CFNR]|L[ESV]|M[ABCFIKMPSTWYZ]|P[AR]|R[ABCEFHIKLOPRTZ]|S[ACDEHIJLMNPQRSTOWX]|TE|VC|X[MRX])(\\d{7,11})(BR|US|HK|ES|AR))\\b", "gim");
	regexps[1] = new RegExp("\\b((AR|C[CEPR]|E[BCEHNRS]|F[EFHR]|I[CFNR]|L[ESV]|M[ABCFIKMPSTWYZ]|P[AR]|R[ABCEFHIKLOPRTZ]|S[ACDEHIJLMNPQRSTOWX]|TE|VC|X[MRX])\\s*(\\d{7,11})\\s*(BR|US|HK|ES|AR))\\b", "gim");
	// EH38 5356 703U S
	regexps[2] = new RegExp("\\b((AR|C[CEPR]|E[BCEHNRS]|F[EFHR]|I[CFNR]|L[ESV]|M[ABCFIKMPSTWYZ]|P[AR]|R[ABCEFHIKLOPRTZ]|S[ACDEHIJLMNPQRSTOWX]|TE|VC|X[MRX])([ \\t0-9]+)(B\\s*R|U\\sS|H\\s*K|E\\s*S|A\\s*R))\\b", "gim");

	if(window.console) {
		console.log("Correios: "+content);
	}

	var i;

	for(i=0;(i < regexps.length);i++) {
		this.RE = regexps[i];
		this.RE.lastIndex = startIndex;
		ret = regexps[i].exec(content);
		// noop
		if(ret != null) {
			ret.context = ret;
			if(window.console) {
				console.log("Correios: matched regexps["+i+"]: "+content);
			}
			var z;
			for(z=1;z<ret.context.length;z++) {
				if(ret.context[z]) {
					ret.context[z] = ret.context[z].replace(/\s/g, ""); 
				}
			}
			break;
		}
	}

	if(window.console && ret!=null) {
		console.log("Correios: match: "+content+" = "+(ret != null? "true":"false"));
	}

	return ret;
}

Net_Inova_Correios.prototype.doubleClicked = function() {
	this.singleClicked();
}

Net_Inova_Correios.prototype.singleClicked = function() {
	var formProp = [
		{
			label : this.getMessage("dialogTrackingLabel"),
			name : "track",
			type : "string",
			minLength : 3,
			maxLength : 999
		}
	];

	if (!this._dlg_propertyEditor) {
		var view = new DwtComposite(this.getShell());
		this._propertyEditor = new DwtPropertyEditor(view, true);
		var pe = this._propertyEditor;
		pe.initProperties(formProp);
		var dialog_args = {
			title : this.getMessage("dialogTitle"),
			view  : view
		};
		this._dlg_propertyEditor = this._createDialog(dialog_args);
		var dlg = this._dlg_propertyEditor;
		pe.setFixedLabelWidth();
		pe.setFixedFieldWidth();
		dlg.setButtonListener(
				DwtDialog.OK_BUTTON,
				new AjxListener(this,
					function() {
						if (!pe.validateData()) {
							return;
						}
						this.doTracking();
					}
				)
		);
	}
	this._dlg_propertyEditor.popup();
}

Net_Inova_Correios.prototype.doTracking = function() {
        this._dlg_propertyEditor.popdown();
	var track = this._propertyEditor.getProperties().track;
	var reg = new RegExp("\\b((AR|C[CEPR]|E[BCEHNRS]|F[EFHR]|I[CFNR]|L[ESV]|M[ABCFIKMPSTWYZ]|P[AR]|R[ABCEFHIKLOPRTZ]|S[ACDEHIJLMNPQRSTWX]|TE|VC|X[MRX])(\\d{7,11})(BR|US|HK|ES|AR))\\b", "gim");
	var ret = reg.exec(track);
	if(ret != null) {
		var url = this._getTrackingUrl(ret[4], ret[3], ret[2]);
		var win = window.open(url, null, "width=640,height=480,scrollbars=1,toolbar=1,resizable=1,status=1,menubar=1,location=1"); 
	}


        this._dlg_propertyEditor.dispose();
        this._dlg_propertyEditor = null;
}
