/*
 * ***** BEGIN LICENSE BLOCK *****
 * Version: ZPL 1.1
 *
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.1 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.zimbra.com/license
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is: Zimbra Collaboration Suite.
 *
 * The Initial Developer of the Original Code is Zimbra, Inc.
 * Portions created by Zimbra are Copyright (C) 2005 Zimbra, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK *****
 */


function com_processmaker_zimbra_overviewtree_app() {};

com_processmaker_zimbra_overviewtree_app.prototype = new ZmZimletBase();
com_processmaker_zimbra_overviewtree_app.prototype.constructor = com_processmaker_zimbra_overviewtree_app;

//var activeApp1 = appCtxt.getCurrentApp();






// ------ INIT AND APP CREATION ---------------------------------------------------------


/**
 * Init method
 * @public
 */
var ApplicationName1 = this._tabsampleapp;
var a = com_processmaker_zimbra_overviewtree_app.prototype ;
var thisval;
var DELInd;
var SID;
var flag = true;
com_processmaker_zimbra_overviewtree_app.prototype.init = function() {
	if(window.console){ 
	 console.info("********** ProcessMaker Zimlet Started ("+this.getServerHost()+") **********");
		}
    //The WS Server will be formed by what User setup in Preferences
    //this.SERVER = this.getServerHost("casesList");

    this.XMLNS = "http://processmaker.com";
	//this._tabsampleapp = this.createApp('ProcessMaker', 'PM-panelIcon', 'OverView Tree using Zimlet');
	ApplicationName1 = this.createApp('ProcessMaker', 'PM-panelIcon', 'OverView Tree using Zimlet');
	//alert("Init Object Name:" +this);
	thisval = this;
};


//var a = com_processmaker_zimbra_overviewtree_app.prototype ;
//a = new ZmZimletBase();
/**
 * AppLaunch runs the first time a tab is clicked
 * @public
 * @param {String} appName the application name
 */
 var flg=0;
 var app;
 var urlOpenCase;
 var target;
 //var name1;
 com_processmaker_zimbra_overviewtree_app.prototype.appLaunch = function(appName,target) {
// alert("before switch case"+name1);
//this = thisval;
	switch(appName) {
		case ApplicationName1: {
			//app=appCtxt.getApp(ApplicationName1);
			app = appCtxt.getCurrentApp();
			//alert("AppName :-" + app.getName());
			this._view = app.getController().getView();
			//if(Object.isString(name1)){
			//if(name1 != 'undefined'){
			//if(this.is_string(name1)){
//			if(name1){
			//alert("Inside IF");
			//this.name = name1;
			//}
			//thisval=this;
			//alert("Application Name:- " + this);
			if (flg==0){
				this.buildOverview();
				//alert("Hello There");
				this._groupTwoHandler("CASELIST");
				//app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"http://enterprisetrial.processmaker.com/sys/en/classic/login/login.html\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
			}else if(flg==1){
					//alert("Inside the Launch Flag=1");
					//http://enterprisetrial.processmaker.com/sysbrian/en/green/cases/cases_Open?APP_UID="+caseNumber+"&DEL_INDEX=1&sid="+SID+"";
					var Cnos=window.CID;
					//urlOpenCase=this.getServerHost("openCase","APP_UID="+CID+"&DEL_INDEX=1&sid="+this.sessionId);
					//urlOpenCase = "http://enterprisetrial.processmaker.com/sysbrian/en/green/cases/cases_New";
					urlOpenCase = "http://enterprisetrial.processmaker.com/sysbrian/en/green/cases/casesStartPage?action=startCase";
//					urlOpenCase=this.getServerHost("openCase","action=startCase");
					//urlOpenCase=this.getServerHost("startCase","action=startCase");
									
					//urlOpenCase = "http://jhl.pmos.colosa.net/sysworkflow/en/classic/cases/casesStartPage?action=startCase"
					var link=urlOpenCase;
				app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src="+link+" width=\"100%\" height=\"100%\" frameBorder=\"0\"/></iframe>"); // write HTML to app
			}else if(flg==2){
			//alert("Inside the Launch Flag=2");
					var Dindex=window.DELInd;
					//alert("DelIndex :- " + Dindex);
					//alert("CID :-" +CID);
					//urlOpenCase=this.getServerHost("openCase","APP_UID="+CID+"&DEL_INDEX="+Dindex+"&sid="+this.sessionId);
					urlOpenCase = "http://enterprisetrial.processmaker.com/sysbrian/en/green/cases/casesListExtJs";
					//urlOpenCase= this.getServerHost("openCase","");
					var link=urlOpenCase;
					app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src="+link+" width=\"100%\" height=\"100%\" frameBorder=\"0\" /></iframe>"); // write HTML to app
			}else if(flg==3){
					//app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"http://www.processmaker.com/\" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
					urlOpenCase= "http://wiki.processmaker.com/index.php/Zimbra";
					app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src="+urlOpenCase+" width=\"100%\" height=\"100%\" frameBorder=\"0\"/></iframe>"); // write HTML to app
					
			}else if(flg==4){
			//alert("Value of target:"+target);
			//if(!target) target="casesList";
					urlOpenCase=this.getServerHost(target,"sid="+this.sessionId);
					var link=urlOpenCase;
					app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src="+link+" width=\"100%\" height=\"100%\" frameBorder=\"0\"/></iframe>"); // write HTML to app
			}
			
			break;
		}
	}
}
/*var urlOpenCase;
com_processmaker_zimbra_overviewtree_app.prototype.appLaunch =
function(appName) {
console.log(appName);
	switch (appName) {
		case ApplicationName: {
			// do something
			app = appCtxt.getCurrentApp();
			//var app = appCtxt.getApp(appName); // get access to ZmZimletApp
			console.log(app);
			console.log(flg);
			this._view = app.getController().getView();
			if (flg==0){
			alert("Flag is 0");
			this.buildOverview();
			urlOpenCase= "http://processmaker.com";
			//urlOpenCase=this.getServerHost("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src=\"http://processmaker.com\" width=\"100%\" height=\"100%\" /></iframe>");
			}else if (flg==1){
					//this.buildOverview();
					alert("Flag is 1");
					var Cnos=window.CID;
					urlOpenCase=this.getServerHost("openCase","APP_UID="+CID+"&DEL_INDEX=1&sid="+this.sessionId);
				}else if(flg==2){
					alert("Flag is 2");
					var Dindex=window.DELInd;
					urlOpenCase=this.getServerHost("openCase","APP_UID="+CID+"&DEL_INDEX="+Dindex+"&sid="+this.sessionId);
				}else if(flg==3){
				alert("Flag is 3");
				urlOpenCase="http://www.google.com"
				}
				
		
			var link=urlOpenCase;
			app.setContent("<iframe id=\"tabiframe-app\" name=\"tabiframe-app\" src="+link+" width=\"100%\" height=\"100%\" /></iframe>"); // write HTML to app
			
			break;
		}
	}

};*/

/**
 * Runs each time the application is opened or closed (e.g. when tab is clicked into or away from)
 * 
 * @public
 * @param {String} appName the application name
 * @@param {String} active if true, the application status is open; otherwise false
 */
com_processmaker_zimbra_overviewtree_app.prototype.appActive = function(appName, active) {
	switch(appName) {
		case ApplicationName1: {
			if (active) {
					app = appCtxt.getApp(appName);
					//user.login();
					// do something when the tab is clicked
			} else {
				// do something when we switch to another tab
			}
			break;
		}
	}
};

// ------ OVERVIEW CREATION -------------------------------------------------------------

/**
 * Builds an tab overview tree view from an object literal of "folder items".
 * Folder items are grouped into Groups.
 * Each folder item can have an icon (or not) and an arbitrary number of subfolders.
 * Subfolder items can have an icon (or not) and an arbitrary number of subfolders (and so on...)
 * 
 * A group can have a handler function associated with it. The handler function receives click events on items within the folder group.
 * The handler function is specified in the folderGroup object literal as either a reference to an existing function or as an inline anonymous function.
 * 
 * @public
 */


var folderGroups=[];
var group;
com_processmaker_zimbra_overviewtree_app.prototype.buildOverview = function() {
		
		var activeApp = appCtxt.getCurrentApp();
			if (activeApp.getName() != ApplicationName1)
				return;
			var overview = activeApp ? activeApp.getOverview() : null;
			var overviewEl = overview.getHtmlElement();
			

		folderGroups = [
	
		{
			name: "ProcessMaker",
			id: "",
			handler: this._groupTwoHandler,
			folders: [
				/*{
					name: "Login",
					//icon: "ImgMailApp",
					icon: null,
					id: "LOGIN"
				},
				{
					name: "Setup",
					//icon: "ImgMailApp",
					icon: null,
					id: "PREFERENCES"
				},*/
				{
					//name: "New Case",
					//name: "New Case",this.getMessage("help")
					name: this.getMessage("NewCase"),
					//icon: "ImgContactsApp",
					icon: "ImgADD-panelIcon",
					id: "PROCESSLIST"
				},
				{
					name: this.getMessage("CasesInbox"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgFDP-panelIcon",
					id: "CASELIST"
				},
				/*{
					name: "Go to your Webspace",
					//icon: "ImgContactsApp",
					icon: "ImgPM-panelIcon",
					id: "PM_WEBSPACE"
				},*/
				{
					name: this.getMessage("Draft"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgDFT-panelIcon",
					id: "DRAFT"
				},
				{
					name: this.getMessage("Participated"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgPRT-panelIcon",
					id: "PARTICIPATED"
				},
				{
					name: this.getMessage("Unassigned"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgUAS-panelIcon",
					id: "UNASSIGNED"
				},
				{
					name: this.getMessage("Paused"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgPSD-panelIcon",
					id: "PAUSED"
				},
				{
					name: this.getMessage("Completed"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgCMP-panelIcon",
					id: "CASELIST"
				},
				{
					name: this.getMessage("Canceled"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgCNL-panelIcon",
					id: "CASELIST"
				},
				{
					name: this.getMessage("Documents"),
					//name: "Cases Inbox",
					//icon: "ImgCalendarApp",
					icon: "ImgDOC-panelIcon",
					id: "DOCUMENTS"
				},
				{
					name: this.getMessage("Manual"),
					//name: "Manual",
					//icon: "ImgContactsApp",
					icon: "ImgPM-panelIcon",
					id: "PMCOM"
				},
				{
					name: this.getMessage("Setup"),
					//name : "Setup",
					//icon: "ImgMailApp",
					icon: "ImgPM-panelIcon",
					id: "PREFERENCES"
				}
			]
		}
	];
	
	overviewEl.innerHTML = '';
	for (group in folderGroups) {
	
	var buildoverviewHtml = [];
		var	i = buildoverviewHtml.length;
		var thisGroup = folderGroups[group];
		
		buildoverviewHtml[i++] = this._buildFolderGroupHtml(thisGroup);
		var folderGroupNode = document.createElement('div')
		,	id = folderGroups[group].id
		,	className = 'DwtComposite overviewFolderGroup'
		,	stylet= 'display: block;';
				
		folderGroupNode.setAttribute('id', id);
		folderGroupNode.setAttribute('class', className);
		folderGroupNode.setAttribute('style', stylet);
		folderGroupNode.innerHTML = buildoverviewHtml.join('');
		var folderGroupClickHandler = thisGroup.handler ? thisGroup.handler : null;
		folderGroupNode.onclick = AjxCallback.simpleClosure(this._overviewClickHandler, thisGroup);
		overviewEl.appendChild(folderGroupNode);		
	}
	
};




/**
 * Creates the HTML for a folder group element in the tab zimlet overview tree view.
 * Recursively calls this._renderFoldersHtml for each folder (and subfolder) contained in the group.
 * 
 * @private
 * @see #com_processmaker_zimbra_overviewtree_app.prototype.buildOverview
 * @param {Object}	folderGroup		The individual folder group object
 * @returns HTML fragment
 * @type String
 */
 var folder;
com_processmaker_zimbra_overviewtree_app.prototype._buildFolderGroupHtml = function(folderGroup) {
	this.overviewHtml = [];
	this.__i = this.overviewHtml.length;
	// HEADER
	var headerId = "overview_expandIcon_" + Dwt.getNextId();
	var name = folderGroup.name;
	//,	fgTemplateData = {headerId: headerId, name: folderGroup.name};	
	var subs = {
				headerId: headerId,
				name: name
			};
	//this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra_overviewtree.template.overview#folderGroup", fgTemplateData);
	this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra.template.overview#folderGroup", subs);
	
	// FOLDERS/ITEMS
	//for (var folder in folderGroup.folders) {
	for (folder in folderGroup.folders) {
		this._renderFoldersHtml(folderGroup.folders[folder]);
	}
	this.overviewHtml[this.__i++] = '</div>';
	return this.overviewHtml.join('');
};



/**
 * Called recursively by this._buildFolderGroupHtml to generate HTML for individual folder items and subfolders.
 * 
 * @private
 * @param {Object}	folder		Folder object
 * @param {Number} level		Indicates the level of indentation in subfolders. Only passed in by this function when it calls itself recursively.
 */
com_processmaker_zimbra_overviewtree_app.prototype._renderFoldersHtml = function(folder, level) {
var fn = folder.name;
	var collapsable = folder.hasOwnProperty('subfolders') ? true : false,
		level = level ? level : 1,
		id = folder.id ? folder.id : Dwt.getNextId();
	var sid = "overview_expandIcon_" + Dwt.getNextId();
		
	var sub1={id:id};
	var sub2={id:sid};
	var sub3={icon: folder.icon};
	var sub4= {name: folder.name};
		
	//this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra_overviewtree.template.overview#folderItemOpen", {id:id});
	this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra.template.overview#folderItemOpen", sub1);
	
	if (collapsable) { var restoreLevel = level; level -= 1; }

	for (var i = level - 1; i >= 0; i--){
		this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra.template.overview#folderItemLevel", {});
	};

	if (collapsable) {
		//this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra_overviewtree.template.overview#folderItemCollapsable", {id: Dwt.getNextId()});
		this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra.template.overview#folderItemCollapsable", sub2);
	}

	if (folder.icon) {
		//this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra_overviewtree.template.overview#folderItemIcon", {icon: folder.icon});
		this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra.template.overview#folderItemIcon", sub3 );
	}

	//this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra_overviewtree.template.overview#folderItemClose", {name: folder.name});
	this.overviewHtml[this.__i++] = AjxTemplate.expand("com_processmaker_zimbra.template.overview#folderItemClose", sub4);
	
	if (folder.subfolders) {
		level = restoreLevel ? restoreLevel : level;
		level += 1;  // level up!
		this.overviewHtml[this.__i++] = '<div class="containerGroup">';
		for (var sf in folder.subfolders) {
			this._renderFoldersHtml(folder.subfolders[sf], level);
		}
		//this.overviewHtml[this.__i++] = "</div>";
		this.overviewHtml[this._i++]="</div>";
	}
	
};



// ------ CLICK HANDLERS ----------------------------------------------------------------                                  

/**
 * Main click handler for overview items.
 * If the user clicked on a collapse/expand handle, collapse or expand the folder group.
 * If the user clicked something else AND a click handler was specified, run the handler, passing in the ID of the overview item.
 * 
 * @private
 * @param {Object} ev Event object
 * @param {Function} handlerFunc Click handler function
 */
//var ApplicationName=ApplicationName1;
var elId;
 com_processmaker_zimbra_overviewtree_app.prototype._overviewClickHandler = function(ev) {
	
	if (AjxEnv.isIE) {
		ev = window.event;
	}
	var dwtev = DwtShell.mouseEvent;
	dwtev.setFromDhtmlEvent(ev);
	var el = dwtev.target;
	var origTarget = dwtev.target;
	if (origTarget.className == "ImgNodeExpanded" || origTarget.className == "ImgNodeCollapsed") {
		//var toHide = $(el).parent().parentsUntil('.DwtComposite').parent().next().first();		
		var toHide="block";
		//toHide.toggle();
		if (origTarget.className == "ImgNodeExpanded") {
			origTarget.className = "ImgNodeCollapsed";
			toHide="none";
		} else {
			origTarget.className = "ImgNodeExpanded";
		}
	} else if (this.handler && origTarget.className !== 'overviewHeader-Text') {
		//var elId;
		//while (el && (el.className != 'DwtTreeItem')) {

		while (el && el.className !='DwtTreeItem') {
			el = el.parentNode;
			elId = el.id;
						
		}
		
		this.handler(elId);
		
	}
	
	
};

/**
 * Click handler for "folder group two". Displays a DwtMsgDialog showing the ID of the selected node.
 * 
 * @private
 * @param {String}	elId		ID of the node clicked on in the overview
 */

com_processmaker_zimbra_overviewtree_app.prototype._groupTwoHandler = function(elId){
	
				
	switch (elId) {
	  case "PREFERENCES":
		//thisval.displayStatusMessage("Clicked on Preferences");
		thisval.createPropertyEditor(new AjxCallback(thisval, thisval.login));
			
	break;
	  case "LOGIN":
			//thisval.displayStatusMessage("Clicked on Login");
			thisval.login();
		break;
		case "PROCESSLIST":
		
			//thisval.displayStatusMessage("Clicked on Start New Case");
			
			//thisval.login();
			//thisval.appActive(ApplicationName1);
			//flg=1;
			//thisval.appLaunch(ApplicationName1);
			//thisval.processList();
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("startCase");
		break;
		case "CASELIST":
			//thisval.displayStatusMessage("Clicked on Cases Inbox");
			//thisval.login();
			//flg=2;
			//thisval.appLaunch(ApplicationName1);
			//thisval.caseList();
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("casesList");
		break;
		case "DRAFT":
			//flg=2;
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("casesDraft");
		break;
		case "PARTICIPATED":
			//flg=2;
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("casesSent");
		break;
		case "UNASSIGNED":
			//flg=2;
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("casesSelfService");
		break;
		case "PAUSED":
			//flg=2;
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("casesPaused");
		break;
		case "DOCUMENTS":
			//flg=2;
			thisval.appActive(ApplicationName1);
			thisval.openWebspace("casesDoc");
		break;
		
		
		
		
		
		case "PM_WEBSPACE":
			//thisval.displayStatusMessage("Clicked on Go to Your Webspace");
			thisval.openWebspace();
		break;
		case "OPENCASE_EMAIL":
		  if(window.console){
		    console.log(thisval._actionObject);
			}
		break;
		case "DIRECTRESPONSE_CASE":
		  if(window.console){
		    console.log(thisval._actionObject);
			}
		case "PMCOM":
		{	
			//thisval.displayStatusMessage("Clicked on Visit ProcessMaker");
			flg=3;
			thisval.appLaunch(ApplicationName1);
			
		}
		break;
		



	}

};

com_processmaker_zimbra_overviewtree_app.prototype.getNodeValue = function(obj,tag){
	return obj.getElementsByTagName(tag)[0].firstChild.nodeValue;
};


com_processmaker_zimbra_overviewtree_app.prototype.openExternalWindow = function(browserUrl,windowName){
var props = [ "toolbar=no,location=no,status=yes,menubar=yes,scrollbars=yes,resizable=yes" ];
	props = props.join(",");
	var canvas = window.open(browserUrl, windowName, props);
};
com_processmaker_zimbra_overviewtree_app.prototype.openExternalWindowNew = function(browserUrl,windowName) {
	var view = new DwtComposite(this.getShell());
	var el = view.getHtmlElement();
	var h3 = document.createElement("h3");
	
	var pmosIframe = document.createElement("iframe");
	pmosIframe.src=browserUrl;
	pmosIframe.width="650px";
	pmosIframe.height="500px";  
	
  h3.className = "PM-sec-label PM-icon-right";
	//h3.innerHTML = "A = Account, O = Opportunity, C = Contact";
	//h3.innerHTML = "A = Account or O = Opportunity";
	h3.innerHTML = windowName+"<br>&nbsp;<br>&nbsp;<br>&nbsp;";
	
	el.appendChild(h3);

	
	el.appendChild(pmosIframe);

	var dialog_args = {
		view  : view,
		title : "ProcessMaker Window"
	};
	var dlg = this._createDialog(dialog_args);
	dlg.popup();
	
	dlg.setButtonListener(DwtDialog.OK_BUTTON,
			      new AjxListener(a, function() {
				      dlg.popdown();
				      dlg.dispose();
			      }));

	dlg.setButtonListener(DwtDialog.CANCEL_BUTTON,
			      new AjxListener(a, function() {
				      dlg.popdown();
				      dlg.dispose();
			      }));
			      
};



var pwd;
com_processmaker_zimbra_overviewtree_app.prototype.getServerHost = function(targetMethod,params) {
	//skin="green";
	skinPM="classic";
  //skin="blank";
	serverHost=this.getUserProperty("server");
	workspace=this.getUserProperty("workspace");
	lang=this.getUserProperty("lang");
	//alert("Language:"+lang);
	//lang="en";
	protocol=this.getUserProperty("protocol");
	if(window.location.protocol == "https:" && protocol == "https" && typeof this.sessionId == "undefined") {
	    protocol="http";
	} else {
	    protocol="https";
	} 
	protocol=protocol+"://";
	port=this.getUserProperty("port");
	//pwd=this.getUserProperty("passwd");
	serverHostFinal="";
	//Protocol
	serverHostFinal=serverHostFinal+protocol;
	//Server Host
	serverHostFinal=serverHostFinal+serverHost;
	//Port
	if(port!=""){
		serverHostFinal=serverHostFinal+":"+port;
	}
	//workspace
	serverHostFinal=serverHostFinal+"/sys"+workspace+"/";
	//Lang
	serverHostFinal=serverHostFinal+lang+"/";
	//Skin
	serverHostFinal=serverHostFinal+skinPM+"/";

	//Target

	if(!targetMethod) targetMethod="WS";

	switch(targetMethod){
		case "WS":

			serverHostFinal=serverHostFinal+"services/soap";
			//alert("Server url:"+serverHostFinal);
		break;
		case "WS_AAT":
			serverHostFinal=serverHostFinal+"aat_telemarketing/services/soap";
		break;
		case "openCase":
			/*if(flg=1){
					serverHostFinal=serverHostFinal+"cases/casesStartPage";
			}else */if (flg=2){
			serverHostFinal=serverHostFinal+"cases/casesListExtJs";
			}else{
			serverHostFinal=serverHostFinal+"cases/cases_Open";
			}
			if(params!=""){
				serverHostFinal=serverHostFinal+"?"+params;
				
			}
		break;
		case "startCase":
			serverHostFinal=serverHostFinal+"cases/casesStartPage?action=startCase";
			
			if(params){
				serverHostFinal=serverHostFinal+"&"+params;
				
			}
		break;
		case "casesList":

			serverHostFinal=serverHostFinal+"cases/casesListExtJs";
			if(params){
				serverHostFinal=serverHostFinal+"?"+params;
			}
		break;
		case "casesDoc":

			serverHostFinal=serverHostFinal+"cases/casesStartPage?action=documents";
			if(params){
				serverHostFinal=serverHostFinal+"&"+params;
			}
		break;
		case "casesPaused":
			serverHostFinal=serverHostFinal+"cases/casesListExtJs?action=paused";
			if(params){
				serverHostFinal=serverHostFinal+"&"+params;
			}
		break;
		case "casesSelfService":
			serverHostFinal=serverHostFinal+"cases/casesListExtJs?action=selfservice";
			if(params){
				serverHostFinal=serverHostFinal+"&"+params;
			}
		break;
		case "casesSent":
			serverHostFinal=serverHostFinal+"cases/casesListExtJs?action=sent";
			if(params){
				serverHostFinal=serverHostFinal+"&"+params;
			}
		break;
		case "casesDraft":
			serverHostFinal=serverHostFinal+"cases/casesListExtJs?action=draft";
			if(params){
				serverHostFinal=serverHostFinal+"&"+params;
			}
		break;
	}

	return serverHostFinal;
	
}


// SOAP utils

/// Utility function that creates a SOAP envelope.  This will also insert the
/// session header if we already have a session.
com_processmaker_zimbra_overviewtree_app.prototype._makeEnvelope = function(method) {
	var soap = AjxSoapDoc.create(
		method, this.XMLNS, null,
		"http://schemas.xmlsoap.org/soap/envelope/");
	var envEl = soap.getDoc().firstChild;
	// Seems we need to set these or otherwise will get a "VersionMismatch"
	// message from SForce
	envEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
	envEl.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
	if (this.sessionId) {
		var header = soap.ensureHeader();
		var sessionEl = soap.getDoc().createElement("SessionHeader");
		header.appendChild(sessionEl);
		sessionEl.setAttribute("xmlns:ns1", this.XMLNS);
		soap.set("sessionId", this.sessionId, sessionEl);
		//For PM WS the sessionId must be part of the SOAP params instead of header param.
		//Let's have both options
		//soap.set("sessionId", this.sessionId);
	}
	return soap;
};

com_processmaker_zimbra_overviewtree_app.prototype.xmlToObject = function(result) {
    try {
        var xd = new AjxXmlDoc.createFromDom(result.xml).toJSObject(true, false);

    } catch(ex) {
        this.displayErrorMessage(ex, result.text, "Problem contacting ProcessMaker ("+this.getUserProperty("server")+")");
    }
    return xd;
};

/// Utility function that calls the PM server with the given SOAP data
	com_processmaker_zimbra_overviewtree_app.prototype.rpc = function(soap, callback, passErrors, serverType) {

	this.sendRequest(soap, this.getServerHost(serverType), {SOAPAction: "m", "Content-Type": "text/xml"}, callback, false, passErrors);
};


// SOAP METHOD: login

/// login to PM.  The given callback will be called in the case of a
/// successful login.  Note that callback is a plain function (not AjxCallback)
com_processmaker_zimbra_overviewtree_app.prototype.login = function(callback) {
	if (!callback) {
		callback = false;
    }

    //this.SERVER = this.getServerHost("casesList");
//alert("Inside Login");
        this.sessionId = undefined;
        var user = this.getUserProperty("user");
		var passwd = this.getUserProperty("passwd");
		var server = this.getUserProperty("server");
		var workspace = this.getUserProperty("workspace");

		errorMessage="";
		if (!user){
			errorMessage=errorMessage+"<b>-</b> User<br>";
		}

		if (!passwd){
			errorMessage=errorMessage+"<b>-</b> Password<br>";
		}

		if (!server){
			errorMessage=errorMessage+"<b>-</b> Server<br>";
		}

		if (!workspace){
			errorMessage=errorMessage+"<b>-</b> Workspace<br>";
		}



	//if (!user || !passwd || !server || !workspace) {
	if(errorMessage!=""){
	errorMessage="Please complete your ProcessMaker preferences first <hr><br>"+errorMessage;
		//errorMessage= this.getMessage("Pleasecompleteyourpreferencesfirst")+" <hr><br>"+errorMessage;
		//this.displayStatusMessage("Please fill your ProcessMaker credentials first");
		this.displayErrorMessage(errorMessage);
		this.createPropertyEditor(new AjxCallback(this, this.login, [ callback ]));
	} else {
		this._do_login(callback, user, passwd, server, workspace);
	}
};

com_processmaker_zimbra_overviewtree_app.prototype._do_login = function(callback, user, passwd, server, workspace) {
	var soap = this._makeEnvelope("login");
	soap.set("userid", user);
	soap.set("password", passwd);

	if (callback == null)
		callback = false;
	this.rpc(soap, new AjxCallback(this, this.done_login, [ callback ]), true,"WS");
};

com_processmaker_zimbra_overviewtree_app.prototype.done_login = function(callback, result) {
	var ans = this.xmlToObject(result);
	if (ans && ans.Body && ans.Body.pmResponse) {// Seems that there is a correct answer
		ans = ans.Body.pmResponse;

		if(ans.status_code==0){//successful login
			this.loginStatus = String(ans.status_code);
			this.sessionId = String(ans.message);
			this.loginTime=ans.timestamp;
			// Added this line
			SID = this.sessionId;
			var user = this.getUserProperty("user");		
		  var server = this.getUserProperty("server");
		  var workspace = this.getUserProperty("workspace");
			//this.displayStatusMessage("ProcessMaker Sessionstarted.<br /><br /><b>Server: </b>"+ server+"<br /><b>Workspace: </b>"+ workspace+"<br /><b>User: </b>"+ user);		
			this.displayStatusMessage("ProcessMaker "+this.getMessage("Sessionstarted")+".<br /><br /><b>"+this.getMessage("Server")+": </b>"+ server+"<br /><b>"+this.getMessage("Workspace")+": </b>"+ workspace+"<br /><b>"+this.getMessage("User")+": </b>"+ user);		
			//if(window.console){ 
	      //console.log("ProcessMaker Session started: "+ this.sessionId);
	    //}
			if (callback)
				callback.call(this);
		}else{// login error, get PM message
			var fault = "";
			fault = ans.message +"("+ans.status_code+")"+ "<br />";
			//this.displayErrorMessage("<b>Login to ProcessMaker failed!</b><br /><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />Review your preferences.");
			this.displayErrorMessage("<b>"+this.getMessage("LogintoProcessMakerfailed!")+"</b><br /><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />"+this.getMessage("Reviewyourpreferences")+".");
		}



    } else {//Another login problem
        var fault = " -Connection Error- <br />";
		//var fault = " -"+this.getMessage("ConnectionError")+"- <br />";
		
       //this.displayErrorMessage("<b>Login to ProcessMaker failed!</b><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />Check your internet connection and review your preferences.");
		this.displayErrorMessage("<b>"+this.getMessage("LogintoProcessMakerfailed!")+"</b><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />"+this.getMessage("Checkyourinternetconnection")+" "+this.getMessage("and")+" "+this.getMessage("Reviewyourpreferences")+".");
    }
};

// SOAP METHOD: logout

/// There's no explicit logout command to ProcessMaker, we just clear session data
/// and user information.
com_processmaker_zimbra_overviewtree_app.prototype.logout = function() {

	this.loginStatus = null;
	this.sessionId = null;
	this.loginTime = null;
};


//SOAP method : processList
com_processmaker_zimbra_overviewtree_app.prototype.processList = function(callback) {
	// make sure we are logged in first
	//alert("hello");
	if (!this.sessionId)
	
		this.login(function() {
			this._do_processList(callback);
		});
	else
		this._do_processList(callback);
};

com_processmaker_zimbra_overviewtree_app.prototype._do_processList = function(callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("processList");
    //alert(this.sessionId);
    soap.set("sessionId", this.sessionId);
    this.rpc(soap, new AjxCallback(this, this.done_processList, [ callback ]),true,"WS");
};




com_processmaker_zimbra_overviewtree_app.prototype.done_processList = function(callback, result) {

	var xmlResponse = new AjxXmlDoc.createFromDom(result.xml);
	//alert(result.text);
	this.dlg_processList(xmlResponse);
};

com_processmaker_zimbra_overviewtree_app.prototype.dlg_processList = function(xmlResponse) {
	var view = new DwtComposite(this.getShell());
//alert(xmlResponse.text);
var items = xmlResponse.getElementsByTagName('item');
//alert(items.length);
var processList = [];
processList.push({ label : "- Available Process -",  value : "0" });
for (var i=0;i<items.length;i++){
	//alert(this.getNodeValue(items[i],'key'));
	//alert(this.getNodeValue(items[i],'value'));
	if(this.getNodeValue(items[i],'key')=="guid"){
		processGuid=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="name"){
	  
	  if(window.console){ 
	      console.log("Process: "+ this.getNodeValue(items[i],'value')+" ("+processGuid+")");
	    }
	  
		processName=this.getNodeValue(items[i],'value');
		//alert(processName);
		//alert(processGuid);

		//processList.push({ label : this.getNodeValue(items[i],'key').toString(),  value: this.getNodeValue(items[i],'value').toString() });
		processList.push({ label : processName,  value: processGuid });
	}
}
//alert(processList);



//processList.push({ label : " 234324 Yes 1231243123",  value : "yes1212" });
	/// Create a PropertyEditor for the Process List
	var pe_processlist = new DwtPropertyEditor(view, true);

  //alert(processList);

  //alert(processList.length);
//alert(items.length);

	if(items.length>0){//There are Process
		var pe_props = [

		{ label     : "Process",
            name      : "process",
            type      : "enum",
            value     : "",
            item      : processList
             }

	];



	pe_processlist.initProperties(pe_props);
	var dialog_args = {
		title : "Select process to start",
		view  : view
	};


	var dlg = this._createDialog(dialog_args);
 	pe_processlist.setFixedLabelWidth();
 	pe_processlist.setFixedFieldWidth();

	dlg.popup();

	// handle some events

	dlg.setButtonListener(
		DwtDialog.OK_BUTTON,
		new AjxListener(this, function() {
			if (!( pe_processlist.validateData()  ))
				return;
			var acct = pe_processlist.getProperties();

			this.displayStatusMessage("Initiating new case...");
// This place needs to be changed - OnClick of Ok Button New Window is opened (for Tab Conversion)
			if(window.console){ 
	      console.log("Initiating new case..."+acct.process);
	    }
			//Create case via WS


			this.newCase(acct.process);

			dlg.popdown();
			dlg.dispose();
		}));

	// We don't really want to mess with things like cache-ing this
	// dialog...
	dlg.setButtonListener(
		DwtDialog.CANCEL_BUTTON,
		new AjxListener(a, function() {
			dlg.popdown();
			dlg.dispose();
		}));


	}else{//there aren't
		this.displayErrorMessage("You cannot initiate a new case.");
}


};

//SOAP method : newCase
com_processmaker_zimbra_overviewtree_app.prototype.newCase = function(processId,callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_newCase(processId,callback);
		});
	else
		this._do_newCase(processId,callback);
};

com_processmaker_zimbra_overviewtree_app.prototype._do_newCase = function(processId,callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("newCase");
    //alert(this.sessionId);
    soap.set("sessionId", this.sessionId);
    soap.set("processId", processId);
    soap.set("taskId", "");
    soap.set("variables", "");

    this.rpc(soap, new AjxCallback(this, this.done_newCase, [ callback ]),true,"WS");
	//this.rpc(soap, new AjxCallback(this, this.done_newCase, [ callback ]),true,"openCase");
};



var ans;
var CID;

//var ApplicationName=this._simpleAppName;
com_processmaker_zimbra_overviewtree_app.prototype.done_newCase = function(callback, result) {
	//this.displayStatusMessage(result);
	//var ans = this.xmlToObject(result);
	
	ans = this.xmlToObject(result);
	if (ans && ans.Body && ans.Body.newCaseResponse) {// Seems that there is a correct answer
		ans = ans.Body.newCaseResponse;
		//alert("New Response :" +window.ans);
		if(ans.status_code==0){//case successful created
			caseStatus = String(ans.status_code);
			//alert("Case Status :" +window.caseStatus);
			
			caseMessage = String(ans.message);
			//alert("Case Message :" +window.caseMessage);
			
			caseId=String(ans.caseId);
			//alert("Case ID :" +window.caseId);
			CID=caseId;
			//alert ("Global Case Id :"+ window.CID);
			caseNumber=ans.caseNumber;
			//alert("Case Number :" +window.caseNumber);
			
			caseTimeStamp=ans.timestamp;
			//alert("Time Stamp :" +window.caseTimeStamp);
			
			this.displayStatusMessage("Case <b>#"+caseNumber+"</b> started");
			//ApplicationName = this.createApp("Tab for Process", "PM-panelIcon", "This tab starts a new case");
					
				

		//if(window.console){ 
	      //console.log("Case#..."+caseNumber);
	    //}
			//var SID=this.sessionId;
			//this.displayStatusMessage("Session Id :-" + SID);
			urlOpenCase=this.getServerHost("openCase","APP_UID="+caseId+"&DEL_INDEX=1&sid="+this.sessionId);
			//alert("Session Id :"  + wiindow.SID);
			//urlOpenCase=this.getUserProperty("server")+"/sys"+this.getUserProperty("workspace")+"/en/green/cases/cases_Open?APP_UID="+caseId+"&DEL_INDEX=1&sid="+this.sessionId;
			//urlOpenCase="http://enterprisetrial.processmaker.com/sysbrian/en/green/cases/cases_Open?APP_UID="+caseNumber+"&DEL_INDEX=1&sid="+SID+"";
			//alert("URL OpenCase :" + window.urlOpenCase);
			//this.displayStatusMessage("Link Value "+urlOpenCase);
			//this.displayStatusMessage("Param: APP_UID="+caseId+"&DEL_INDEX=1&sid="+this.sessionId);
			
			//window.open(urlOpenCase , "PM_ZIMLET_WINDOW" , "width=600,height=500");
			//this.appActive(appName,flag);
			//var app = appCtxt.getApp(appName); // get access to ZmZimletApp
			//alert(window.app);
			//var cID=String(ans.caseId);
			thisval.appActive(ApplicationName1);
			flg=1;
			thisval.appLaunch(ApplicationName1);
				
			
			//alert(urlOpenCase);
			//this.openExternalWindowNew(urlOpenCase , "ProcessMaker Case#...");


			if (callback)
				callback.call(this);
		}else{// case error, get PM message
			var fault = "";
			fault = ans.message +"("+ans.status_code+")"+ "<br />";
			this.displayErrorMessage("<b>Start new Case in ProcessMaker failed!</b><br /><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "");
		}



    } else {//Another case problem
        var fault = " -Connection Error- <br />";

        this.displayErrorMessage("<b>Start new Case in ProcessMaker failed!</b><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />Check your internet connection and review your preferences.");
    }







};


//SOAP method : caseList
com_processmaker_zimbra_overviewtree_app.prototype.caseList = function(callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_caseList(callback);
		});
	else
		this._do_caseList(callback);
};

com_processmaker_zimbra_overviewtree_app.prototype._do_caseList = function(callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("caseList");
    //alert(this.sessionId);
    soap.set("sessionId", this.sessionId);
    this.rpc(soap, new AjxCallback(this, this.done_caseList, [ callback ]),true,"WS");
};




com_processmaker_zimbra_overviewtree_app.prototype.done_caseList = function(callback, result) {

	var xmlResponse = new AjxXmlDoc.createFromDom(result.xml);
	//alert(result.text);
	this.dlg_caseList(xmlResponse);
};

com_processmaker_zimbra_overviewtree_app.prototype.dlg_caseList = function(xmlResponse) {
	var view = new DwtComposite(this.getShell());
	//alert(view);
	var items = xmlResponse.getElementsByTagName('item');
//alert(items.length);
var caseList = [];
caseList.push({ label : "- Available Cases -",  value : "0" });
for (var i=0;i<items.length;i++){
	//alert(this.getNodeValue(items[i],'key'));
	//alert(this.getNodeValue(items[i],'value'));
	if(this.getNodeValue(items[i],'key')=="guid"){
		caseGuid=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="name"){
		caseName=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="status"){
		caseStatus=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="delIndex"){
		caseDelIndex=this.getNodeValue(items[i],'value');
		//alert(processName);
		//alert(processGuid);
//alert(caseStatus);

		//processList.push({ label : this.getNodeValue(items[i],'key').toString(),  value: this.getNodeValue(items[i],'value').toString() });
		if(window.console){ 
	      console.log(" Case: "+caseName + " Status: "+caseStatus + " Guid: "+caseGuid);
	    }
	  if(caseStatus=="TO_DO"){
		 caseList.push({ label : caseName,  value: caseGuid+"|"+caseDelIndex });
		}
	}
}
//alert(caseList);



//processList.push({ label : " 234324 Yes 1231243123",  value : "yes1212" });
	/// Create a PropertyEditor for the Process List
	var pe_caselist = new DwtPropertyEditor(view, true);

  //alert(processList);

  //alert(processList.length);
//alert(items.length);

	if(items.length>0){//There are Process
		var pe_props = [

		{ label     : "Cases",
            name      : "caseId",
            type      : "enum",
            value     : "",
            item      : caseList
             }

	];

//alert(pe_props);

	pe_caselist.initProperties(pe_props);
	var dialog_args = {
		title : "Select case to view",
		view  : view
	};
	
	var dlg = this._createDialog(dialog_args);
 	pe_caselist.setFixedLabelWidth();
 	pe_caselist.setFixedFieldWidth();

	dlg.popup();
	
	// handle some events

	dlg.setButtonListener(
		DwtDialog.OK_BUTTON,
		new AjxListener(a, function() {
		  
		  if (!( pe_caselist.validateData()  ))
				return;
			var acct = pe_caselist.getProperties();
			this.displayStatusMessage("Opening case..."+acct.caseId);
			caseId=acct.caseId;
			splitedValue=caseId.split("|");
			caseId=splitedValue[0];
			delId=splitedValue[1];
			DELInd=delId;
			//alert("Case ID from CaseList :- " + window.DELInd);
			//var SID=this.sessionId;
			//this.displayStatusMessage("Session Id :-" + SID);
			//this.displayStatusMessage("Session Id with window :-" + window.SID);
			//urlOpenCase=this.getServerHost("openCase","APP_UID="+caseId+"&DEL_INDEX=1&sid="+this.sessionId);
			
			
			CID=window.caseId;
			//alert("Case ID from CaseList :- " + CID);
			//urlOpenCase=this.getServerHost("openCase","APP_UID="+CID+"&DEL_INDEX="+delId+"&sid="+this.sessionId);
			//urlOpenCase=this.getServerHost("openCase","APP_UID="+CID+"&DEL_INDEX="+delId+"&sid="+SID);
			//this.displayStatusMessage("Inside URL :-" + urlOpenCase);
			//window.open(urlOpenCase , "PM_ZIMLET_WINDOW" , "width=600,height=500");
			
			// this place needs attention for tab Conversion
			//this.openExternalWindowNew(urlOpenCase , "ProcessMaker Case# "+caseId);
			dlg.popdown();
			dlg.dispose();
			//ApplicationName = this.createApp("Tab for Cases", "PM-panelIcon", "This tab starts a Existing Case");
			thisval.appActive(ApplicationName1);
			flg=2;
			thisval.appLaunch(ApplicationName1);
		}));
		
		
		// We don't really want to mess with things like cache-ing this
	// dialog...
	dlg.setButtonListener(
		DwtDialog.CANCEL_BUTTON,
		new AjxListener(a, function() {
			dlg.popdown();
			dlg.dispose();
		}));


	}else{//there aren't
		this.displayErrorMessage("You cannot initiate a new case.");
}



};

com_processmaker_zimbra_overviewtree_app.prototype.openWebspace = function(target) {
	 if (!this.sessionId)
		this.login(function() {
			this._do_openWebspace(target);
		});
	else
		this._do_openWebspace(target);  
	
};

com_processmaker_zimbra_overviewtree_app.prototype._do_openWebspace = function(target) {
//alert("Target :-"+target);
//if(!target) target="casesList";
	urlOpenCase=this.getServerHost(target,"sid="+this.sessionId);
	//window.open(urlOpenCase , "PM_ZIMLET_WINDOW" , "width=600,height=500");
	// This place also needs attention for tab Conversion
	this.appActive(ApplicationName1);
	flg=4;
	this.appLaunch(ApplicationName1,target);
	//this.appLaunch(ApplicationName1);
	//this.openExternalWindowNew(urlOpenCase , "ProcessMaker Case List");
		
};




// UI handlers

/// Called by the Zimbra framework upon an accepted drag'n'drop
com_processmaker_zimbra_overviewtree_app.prototype.doDrop = function(obj) {
	switch (obj.TYPE) {
	    case "ZmMailMsg":
	    case "ZmConv":
	    this.displayStatusMessage("Not Implemented yet. Mail or Conversation");
		break;

	  case "ZmContact":
	   	this.displayStatusMessage("Not Implemented yet. Contact");
		break;

	  case "ZmAppt":
	  	this.displayStatusMessage("Not Implemented yet. Appt");
		break;

	    default:
		this.displayErrorMessage("You somehow managed to drop a \"" + obj.TYPE
					 + "\" but however the PM Zimlet does't support it for drag'n'drop.");
	}
};

com_processmaker_zimbra_overviewtree_app.prototype.clicked = 
 function(spanElement,contentObjText,matchContext,canvas){
 	if(window.console){
 	  console.log("clicked!!!");
 	  console.log(spanElement);
 	  console.log(contentObjText);
 	  console.log(matchContext);
 	  console.log(canvas);
 	}
 };



com_processmaker_zimbra_overviewtree_app.prototype.conversationDropped = function(note) {
    if(!note) {return;}
  	if(note.TYPE=="ZmConv") {	    
      //note  = note.getFirstHotMsg();
    }
    if(window.console){
      console.log("***the note ****");
      console.log(note);
    }

    // check out some domains, exclude user's domain
    var ignoreDomain = this.getUserProperty("ignoreDomain");
    var emails = [];
    function addEmails(a) {
        if (a) {
            if (typeof a == "string") {
                if (this.indexOf(ignoreDomain) != -1) {
                    return;
                }
                emails.push(a);
            } else if (a instanceof Array) {
                for (var i = 0; i < this.length; ++i) {
                    if(a[i].address && a[i].address.indexOf(ignoreDomain) == -1) {
                        emails.push(a[i].address);
                    }
                }
            }
        }
    };
    
    if(note._addrs) {
      if(window.console){
        console.log("** _addrs ***");
        console.log(note._addrs);
      }
      if(note._addrs.BCC && note._addrs.BCC._array.length > 0) {
        addEmails(note._addrs.BCC._array);        
      }
      if(note._addrs.CC && note._addrs.CC._array.length > 0) {
        addEmails(note._addrs.CC._array);
      }
      if(note._addrs.FROM && note._addrs.FROM._array.length > 0) {
        addEmails(note._addrs.FROM._array);
      }
      if(note._addrs.REPLY_TO && note._addrs.REPLY_TO._array.length > 0) {
        addEmails(note._addrs.REPLY_TO._array);
      }
      if(note._addrs.SENDER && note._addrs.SENDER._array.length > 0) {
        addEmails(note._addrs.SENDER._array);
      }
      if(note._addrs.TO && note._addrs.TO._array.length > 0) {
        addEmails(note._addrs.TO._array);
      }
        
    } else {
      if(window.console){
          console.log("-- PART EMAILS ");         
          console.log("participants: "+note.participants);
          console.log("from: "+note.from);
          console.log("to: "+note.to);
          console.log("cc: "+note.cc);
        }
        
        addEmails(note.participants);
        addEmails(note.from);
        addEmails(note.to);
        addEmails(note.cc);
        
    }
    var domains = [], tmp = {};
	for (var i = 0; i < emails.length; ++i) {
        DBG.println(AjxDebug.DBG3, emails[i]);
        if (/@([^>]+)>?$/.test(emails[i])) {
			var d = RegExp.$1;
			if (!tmp[d]) {
				tmp[d] = 1;
				// kind of pointless, but let's make sure we
				// backslash any apostrophes
				domains.push(d.replace(/\x27/, "\\'"));
			}
		}
	}
   if(window.console){
    console.log(emails);
    console.log(domains);
   }
   
   
   function $search_contact(records) {    
        if (records.length == 0) {
            this.displayErrorMessage(
                    [ "There are no matching contacts for these email domains:", domains ].join("<br />"));
        } else {
            //this.displayStatusMessage(records.length);
            this.dlg_addNoteToAccounts(records, note);
        }
    }
   
   
   
   if (domains.length == 0) {
		this.displayErrorMessage("No email addresses.<br />"
					 + "We can't determine a Contact to add this note to.");
	} else {        
        this.contactMailMatch(emails, $search_contact);
	}
   
   
   
};
com_processmaker_zimbra_overviewtree_app.prototype._sendPM_CRM = function(ev) {  
    if(window.console){
      console.log("****Event");
      console.log(ev);
      console.log("****this");
      console.log(a);
    
    }
    this._composeView = AjxDispatcher.run("GetComposeController");
    this._composeView._toolbar.enableAll(false);
    
    
    if(window.console){
      console.log("****this _composeView");
      console.log(this._composeView);      
    }
    
    var msg = this._composeView._composeView.getMsg();
    //var msg = this._pmo.getMessage();
    //var msg = this._composeView.getMsg();
    
    if(window.console){
      console.log("****Message");
      console.log(msg);
    }
    this._composeView.sendMsg();
    //this._pmo.noteDropped(msg);
    this._pmo.conversationDropped(msg);
};
//SOAP method : contact Search
com_processmaker_zimbra_overviewtree_app.prototype.contactMailMatch = function(emails,callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_contactMailMatch(emails,callback);
		});
	else
		this._do_contactMailMatch(emails,callback);
};

com_processmaker_zimbra_overviewtree_app.prototype._do_contactMailMatch = function(emails,callback) {
    if (!callback) {
        callback = false;
    }
    if(window.console){ 
    console.log("Before create SOAP");    
    }
    var soap = this._makeEnvelope("matchContactEmails");    
    //alert(this.sessionId);
    if(window.console){ 
    console.log("Set session id..");    
    }
    soap.set("sessionId", this.sessionId);
    if(window.console){ 
    console.log("Session id: "+this.sessionId);    
    console.log("Set emails");
    }
    soap.set("mails", emails.join(","));
    if(window.console){ 
    console.log("mails: "+emails);    
    }
    if(window.console){ 
    console.log(soap);
    console.log("Now call service: "+this.getServerHost("WS_AAT"));
    }
    this.rpc(soap, new AjxCallback(this, this.done_contactMailMatch, [ callback ]),true,"WS_AAT");
};
com_processmaker_zimbra_overviewtree_app.prototype.done_contactMailMatch = function(callback, result) {
  if(window.console){ 
    console.log(result);
  }
  var xmlResponse = new AjxXmlDoc.createFromDom(result.xml);
  //var xmlResponse = this.xmlToObject(result);
   if(window.console){ 
    console.log(xmlResponse);
  } 
  //var accounts = xmlResponse.getElementsByTagName('item');
  if(window.console){
    console.log("xmlResponse typeof: "+typeof(xmlResponse));
    
    
  }
  var accounts = xmlResponse.getElementsByTagName('ns1:accounts');
  if(window.console){
    console.log("xmlResponse typeof: "+typeof(accounts));
    
  }
  var accountsArray=[ ];
if(window.console){ 
    console.log(accounts);
  }
  
  if(window.console){ 
    console.log("tamano: "+accounts.length);
  }

  
  for (var i=0;i<accounts.length;i++){
	//alert(this.getNodeValue(accounts[i],'key'));
	//alert(this.getNodeValue(accounts[i],'value'));	
	
	var item = accounts[i].getElementsByTagName('item');
	if(window.console){ 
    console.log(item);
  }
 itemObject = new Object();
  for (var j=0;j<item.length;j++){
    if(window.console){ 
      console.log("key: "+this.getNodeValue(item[j],'key'));
      console.log("value: "+this.getNodeValue(item[j],'value'));
      
    }
    itemObject[this.getNodeValue(item[j],'key')]=this.getNodeValue(item[j],'value');
  }
  if(window.console){ 
    console.log(itemObject);
  }
	
	
	
	//accountsArray.push({ id : this.getNodeValue(accounts[i],'key'),  value: this.getNodeValue(accounts[i],'value') });
	accountsArray.push(itemObject);
	/*
	if(this.getNodeValue(items[i],'key')=="contact_id"){
		contact_id=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="name"){
		caseName=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="status"){
		caseStatus=this.getNodeValue(items[i],'value');
	}
	*/
	
  }
  if(window.console){
    console.log(accountsArray);
  }
	/*
	var xd = this.xmlToObject(result);
	var qr = xd.Body.queryResponse.result.records;
	if (qr != null) {
		if (!(qr instanceof Array))
			qr = [ qr ];
		// sometimes SForce returns a duplicate <Id> tag
		for (var i = qr.length; --i >= 0;) {
			if (qr[i].Id && (qr[i].Id instanceof Array))
				qr[i].Id = qr[i].Id[0];
			qr[i].get = com_processmaker_zimbra_overviewtree_app.__query_result_get;
		}
	} else {
		qr = [];
	}
	*/
	qr = [];
	qr[0] = [];
	qr[1] = [];
	qr[0].Id = 1;
	qr[0].get = "asdasd";
	
	qr[1].Id = 2;
	qr[1].get = "dsfsdfsd";
	callback.call(a, accountsArray);
};


com_processmaker_zimbra_overviewtree_app.prototype.dlg_addNoteToAccounts = function(accounts, note) {
	var view = new DwtComposite(this.getShell());
	var el = view.getHtmlElement();
	var h3 = document.createElement("h3");
	
	var i;
  h3.className = "PM-sec-label PM-icon-right";
	//h3.innerHTML = "A = Account, O = Opportunity, C = Contact";
	//h3.innerHTML = "A = Account or O = Opportunity";
	h3.innerHTML = "Contact Name [Contact Email] (Customer Name)";
	el.appendChild(h3);

	var checkboxes = [];

    var div = document.createElement("div");
    var html = [ "<table><tbody>" ];
    DBG.dumpObj(AjxDebug.DBG3, accounts);
     if(window.console){
      console.log("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
    }
    for (acctId in accounts) {
      if(window.console){
        console.log(acctId);
        console.log(accounts);
      }
        DBG.dumpObj(AjxDebug.DBG3, acctId);
        var acct = accounts[acctId];
        DBG.dumpObj(AjxDebug.DBG3, acct);
        var cbid = Dwt.getNextId();
        checkboxes.push(cbid);
        html = this._checkBoxHtml(acct, cbid, 0, false, html);
        var chkContact = true;
        if (acct.Opp && acct.Opp.length > 0) {
            for (i = 0; i < acct.Opp.length; i++) {
                cbid = Dwt.getNextId();
                checkboxes.push(cbid);
                html = this._checkBoxHtml(acct.Opp[i], cbid, 2, true, html);
                chkContact = false;
            }
        }
        // Limit the number of contacts shown to 5
		// REMOVE LISTING OF CONTACTS, just list account/opportunity
		/**
		var displayLimit = acct.Con.length;
        if(displayLimit > 5) {
            displayLimit = 5;
            DBG.println(AjxDebug.DBG3, "Setting contact limit to 5 returned " + acct.Con.length);
        }
        if (acct.Con && displayLimit > 0) {
            for (i = 0; i < displayLimit; i++) {
                cbid = Dwt.getNextId();
                checkboxes.push(cbid);
                html = this._checkBoxHtml(acct.Con[i], cbid, 2, chkContact, html);
            }
        }
        **/
    }
    html.push("</tbody></table>");
	div.innerHTML = html.join("");
	el.appendChild(div);

	h3 = document.createElement("h3");
	h3.className = "PM-sec-label";
	h3.innerHTML = "Note details";
	el.appendChild(h3);

	div = document.createElement("div");
	var subjectId = Dwt.getNextId();
	var messageId = Dwt.getNextId();
	var noteId = Dwt.getNextId();
	var fromEmail = Dwt.getNextId();
	var toEmail = Dwt.getNextId();
    var body;
    if(window.console){ 
      console.log("note....");
      console.log(note);
    }
    if (note.body) {
        body = AjxStringUtil.htmlEncode(note.body);
    } else if (note._topPart && note._topPart.getContentForType) {
        body = AjxStringUtil.htmlEncode(note._topPart.getContentForType(ZmMimeTable.TEXT_PLAIN));
    } else {
		body = "Error - No body found!"
	}
    div.innerHTML =
		[ "<table><tbody>",
		  "<tr>",
		  "<td align='right'><label for='", subjectId, "'>Subject:</td>",
		  "<td>",
		  "<input style='width:35em' type='text' id='", subjectId, "' value='",
		  AjxStringUtil.htmlEncode(note.subject), "' autocomplete='off' />",
		  "<input type='hidden' id='",noteId,"' value='",note.id,"'>",
		  "<input type='hidden' id='",fromEmail,"' value='",note.from,"'>",
		  "<input type='hidden' id='",toEmail,"' value='",note.to,"'>",
		  "</td>",
		  "</tr>",
		  "<td colspan='2'>",
          "<textarea style='width:40em;height:200px' id='", messageId, "'>",
           body, "</textarea>",
          "</td>",
		  "<tr>",
		  "</tr></tbody></table>" ].join("");
	el.appendChild(div);
	
	

	var dialog_args = {
		view  : view,
		title : "Adding email to AAT CRM in Processmaker"
	};
	var dlg = this._createDialog(dialog_args);
	dlg.popup();

	el = document.getElementById(subjectId);
	el.select();
	el.focus();

	dlg.setButtonListener(DwtDialog.OK_BUTTON,
			      new AjxListener(a, function() {
				      var ids = [];
				      for (i = 0; i < checkboxes.length; ++i) {
					      var cb = document.getElementById(checkboxes[i]);
					      if (cb.checked) {
							  //ids.push({ ContactCustomerID: cb.value });
							  ids.push(cb.value);
						  }
				      }
				      if (ids.length == 0) {
					      this.displayErrorMessage("You must select at least one account");
				      } else {
					      var props = {
						      Title : document.getElementById(subjectId).value,
						      Body  : document.getElementById(messageId).value,
						      NoteID  : document.getElementById(noteId).value,
						      From  : document.getElementById(fromEmail).value,
						      To  : document.getElementById(toEmail).value
						      
					      };
					      /*
					      for (i = 0; i < ids.length; ++i) {
							  ids[i].Subject = props.Title;
						    ids[i].Body = props.Body;
						    ids[i].NoteID = props.NoteID;
							  
					      }
					      */
					      this.saveEmailToContacts(ids, props, function() {
						      this.displayStatusMessage("Email saved for " + ids.length + " accounts.");
					      });
					      dlg.popdown();
					      dlg.dispose();
				      }
			      }));

	dlg.setButtonListener(DwtDialog.CANCEL_BUTTON,
			      new AjxListener(a, function() {
				      dlg.popdown();
				      dlg.dispose();
			      }));
};


com_processmaker_zimbra_overviewtree_app.prototype.saveEmailToContacts = function(accounts, email, callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_saveEmailToContacts(accounts, email, callback);
		});
	else
		this._do_saveEmailToContacts(accounts, email, callback);
};

com_processmaker_zimbra_overviewtree_app.prototype._do_saveEmailToContacts = function(accounts, email, callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("saveEmailToContacts");
    accountsString=accounts.join("|");
    if(window.console){
      console.log("_____________________ READY!!___________________");
      console.log(accounts);
      console.log(accountsString);
    }
    soap.set("from", email.From);
    soap.set("to", email.To);
    soap.set("subject", email.Title);
    soap.set("body", email.Body);
    soap.set("emailId", email.NoteID);
    soap.set("contacts", accountsString);
    
    this.rpc(soap, new AjxCallback(this, this.done_saveEmailToContacts, [ callback ]),true,"WS_AAT");    
    
};

com_processmaker_zimbra_overviewtree_app.prototype.done_saveEmailToContacts = function(callback, result) {
	/*
	var xd = this.xmlToObject(result);
	if (xd && callback) {
		result = xd.Body.createResponse.result;
		var id;
		if (result instanceof Array) {
			id = [];
			for (var i = 0; i < result.length; ++i)
				id.push(result[i].id.toString());
		} else {
			id = result.id.toString();
		}
		callback.call(this, id);
	}
	*/
	if (callback) {
	  callback.call(a, "1");
	}
};



com_processmaker_zimbra_overviewtree_app.prototype._checkBoxHtml = function(rec, cbid, indent, checked, html) {

    html.push("<tr><td><input type='checkbox' value='",
            rec.contact_id+","+rec.customer_id,
            "' id='",
            cbid);

    if (checked) {
        html.push("' checked='checked'/>");
    } else {
        html.push("' />");
    }

    html.push("</td>",
            "<td>",
            "<label for='", cbid, "'>");

    switch (indent) {
        case 1:
            html.push("&nbsp;&nbsp;");
            break;
        case 2:
            html.push("&nbsp;&nbsp;&nbsp;&nbsp;");
            break;
    }

    if (rec.TYPE)
        html.push(rec.TYPE + ":");

    if (rec.Name)
        html.push(" " + rec.Name);

    if (rec.FirstName)
        html.push(" " + rec.FirstName);

    if (rec.LastName)
        html.push(" " + rec.LastName);

    if (rec.Email)
        html.push(" [" + rec.Email + "]");

    if (rec.Website)
        html.push(" [" + rec.Website + "]");

    if (rec.Phone)
        html.push(" [" + rec.Phone + "]");
    
    if (rec.contact_name)
        html.push(" " + rec.contact_name);
        
    if (rec.contact_email)
        html.push(" [" + rec.contact_email + "]");
        
    if (rec.customer_name)
        html.push(" (" + rec.customer_name + ")");

    html.push("</label></td></tr>");
    return html;
};



/*com_processmaker_zimbra_overviewtree_app.prototype.createPropertyEditor =
function (callback) {
	var dlg = this.getAppCtxt().getErrorDialog();
	var userprop = this.xmlObj().userProperties;

	if (!userprop) {return;}

	if (!this._dlg_propertyEditor) {
		var view = new DwtComposite(this.getShell());
		var pe = this._propertyEditor = new DwtPropertyEditor(view, true);
		pe.initProperties(userprop);
		var dialog_args = {
			title : this._zimletContext.processMessage(this.xmlObj("description")) + " preferences",
			view  : view
		};
		var dlg = this._dlg_propertyEditor = this._createDialog(dialog_args);
		pe.setFixedLabelWidth();
		pe.setFixedFieldWidth();
		dlg.setButtonListener(DwtDialog.OK_BUTTON,
				      new AjxListener(this, function() {
					      this.saveUserProperties(callback);
				      }));
	}
	this._dlg_propertyEditor.popup();
};*/




com_processmaker_zimbra_overviewtree_app.prototype.Test=function(){
alert("This Test Function Works");
}

com_processmaker_zimbra_overviewtree_app.prototype.is_string=function (input){
    return typeof(input)=='string';
  }





















































































