/*
 * ***** BEGIN LICENSE BLOCK *****
 * Version: ZPL 1.1
 *
 * The contents of this file are subject to the Zimbra Public License
 * Version 1.1 ("License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.zimbra.com/license
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is: Zimbra Collaboration Suite.
 *
 * The Initial Developer of the Original Code is Zimbra, Inc.
 * Portions created by Zimbra are Copyright (C) 2005 Zimbra, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK *****
 */

////////////////////////////////////////////////////////////////
///  Zimlet to handle integration with ProcessMaker          ///
///  @product ProcessMaker, <www.processmaker.com>           ///
///  @author Hugo Loza, <hugo@colosa.com>                    ///
////////////////////////////////////////////////////////////////


function Com_Processmaker_Zimbra() {

}

/// Zimlet handler objects, such as Com_Processmaker_Zimbra, must inherit from
/// ZmZimletBase.  The 2 lines below achieve this.
Com_Processmaker_Zimbra.prototype = new ZmZimletBase();
Com_Processmaker_Zimbra.prototype.constructor = Com_Processmaker_Zimbra;


Com_Processmaker_Zimbra.prototype.getNodeValue = function(obj,tag){
	return obj.getElementsByTagName(tag)[0].firstChild.nodeValue;
};


Com_Processmaker_Zimbra.prototype.openExternalWindow = function(browserUrl,windowName){
var props = [ "toolbar=no,location=no,status=yes,menubar=yes,scrollbars=yes,resizable=yes" ];
	props = props.join(",");
	var canvas = window.open(browserUrl, windowName, props);
};
Com_Processmaker_Zimbra.prototype.openExternalWindowNew = function(browserUrl,windowName) {
	var view = new DwtComposite(this.getShell());
	var el = view.getHtmlElement();
	var h3 = document.createElement("h3");
	
	var pmosIframe = document.createElement("iframe");
	pmosIframe.src=browserUrl;
	pmosIframe.width="650px";
	pmosIframe.height="500px";  
	
  h3.className = "PM-sec-label PM-icon-right";
	//h3.innerHTML = "A = Account, O = Opportunity, C = Contact";
	//h3.innerHTML = "A = Account or O = Opportunity";
	h3.innerHTML = windowName+"<br>&nbsp;<br>&nbsp;<br>&nbsp;";
	
	el.appendChild(h3);

	
	el.appendChild(pmosIframe);

	var dialog_args = {
		view  : view,
		title : "ProcessMaker Window"
	};
	var dlg = this._createDialog(dialog_args);
	dlg.popup();
	
	dlg.setButtonListener(DwtDialog.OK_BUTTON,
			      new AjxListener(this, function() {
				      dlg.popdown();
				      dlg.dispose();
			      }));
/*
	dlg.setButtonListener(DwtDialog.CANCEL_BUTTON,
			      new AjxListener(this, function() {
				      dlg.popdown();
				      dlg.dispose();
			      }));
			      */
};




Com_Processmaker_Zimbra.prototype.getServerHost = function(targetMethod,params) {
  skin="green";
  skin="blank";
	serverHost=this.getUserProperty("server");
	workspace=this.getUserProperty("workspace");
	lang=this.getUserProperty("lang");
	protocol=this.getUserProperty("protocol");
	port=this.getUserProperty("port");
	serverHostFinal="";
	//Protocol
	serverHostFinal=serverHostFinal+protocol+"://";
	//Server Host
	serverHostFinal=serverHostFinal+serverHost;
	//Port
	if(port!=""){
		serverHostFinal=serverHostFinal+":"+port;
	}
	//workspace
	serverHostFinal=serverHostFinal+"/sys"+workspace+"/";
	//Lang
	serverHostFinal=serverHostFinal+lang+"/";
	//Skin
	serverHostFinal=serverHostFinal+skin+"/";

	//Target

	if(!targetMethod) targetMethod="WS";

	switch(targetMethod){
		case "WS":

			serverHostFinal=serverHostFinal+"services/soap";
		break;
		case "WS_AAT":
			serverHostFinal=serverHostFinal+"aat_telemarketing/services/soap";
		break;
		case "openCase":

			serverHostFinal=serverHostFinal+"cases/cases_Open";
			if(params){
				serverHostFinal=serverHostFinal+"?"+params;
			}
		break;
		case "casesList":

			serverHostFinal=serverHostFinal+"cases/cases_List";
			if(params){
				serverHostFinal=serverHostFinal+"?"+params;
			}
		break;
	}

	//alert(serverHostFinal);
	return serverHostFinal;
}

/// Called by the Zimbra framework when the SForce panel item was clicked
Com_Processmaker_Zimbra.prototype.singleClicked = function() {
	this.login();
};

Com_Processmaker_Zimbra.prototype.init = function() {

	//alert("test");
	//alert(this.getServerHost());
	if(window.console){ 
	  console.info("********** ProcessMaker Zimlet Started ("+this.getServerHost()+") **********");
	}
    //The WS Server will be formed by what User setup in Preferences
    //this.SERVER = this.getServerHost("casesList");

    this.XMLNS = "http://processmaker.com";











/*
For next version -- Register with Zimbra Assistant
*/
/*
    // Register with Zimbra Assistant
    var asst = new Com_Processmaker_Zimbra_Asst(this._appCtxt, this);
    this._asst = asst;
    if (ZmAssistant && ZmAssistant.register) ZmAssistant.register(asst);
*/
};

/// Called by the Zimbra framework when some menu item that doesn't have an
/// <actionURL> was selected
Com_Processmaker_Zimbra.prototype.menuItemSelected = function(itemId) {
	switch (itemId) {
	  case "PREFERENCES":
			this.createPropertyEditor(new AjxCallback(this, this.login));
		break;
	  case "LOGIN":
			this.login();
		break;
		case "PROCESSLIST":
			this.processList();
		break;
		case "CASELIST":
			this.caseList();
		break;
		case "PM_WEBSPACE":
			this.openWebspace();
		break;
		case "OPENCASE_EMAIL":
		  if(window.console){
		    console.log(this._actionObject);
			}
		break;
		case "DIRECTRESPONSE_CASE":
		  if(window.console){
		    console.log(this._actionObject);
			}
		break;
		



	}
};

// UI handlers

/// Called by the Zimbra framework upon an accepted drag'n'drop
Com_Processmaker_Zimbra.prototype.doDrop = function(obj) {
	switch (obj.TYPE) {
	    case "ZmMailMsg":
	    case "ZmConv":
	    this.displayStatusMessage("Not Implemented yet. Mail or Conversation");
		break;

	  case "ZmContact":
	   	this.displayStatusMessage("Not Implemented yet. Contact");
		break;

	  case "ZmAppt":
	  	this.displayStatusMessage("Not Implemented yet. Appt");
		break;

	    default:
		this.displayErrorMessage("You somehow managed to drop a \"" + obj.TYPE
					 + "\" but however the PM Zimlet does't support it for drag'n'drop.");
	}
};

// SOAP utils

/// Utility function that creates a SOAP envelope.  This will also insert the
/// session header if we already have a session.
Com_Processmaker_Zimbra.prototype._makeEnvelope = function(method) {
	var soap = AjxSoapDoc.create(
		method, this.XMLNS, null,
		"http://schemas.xmlsoap.org/soap/envelope/");
	var envEl = soap.getDoc().firstChild;
	// Seems we need to set these or otherwise will get a "VersionMismatch"
	// message from SForce
	envEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
	envEl.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
	if (this.sessionId) {
		var header = soap.ensureHeader();
		var sessionEl = soap.getDoc().createElement("SessionHeader");
		header.appendChild(sessionEl);
		sessionEl.setAttribute("xmlns:ns1", this.XMLNS);
		soap.set("sessionId", this.sessionId, sessionEl);
		//For PM WS the sessionId must be part of the SOAP params instead of header param.
		//Let's have both options
		//soap.set("sessionId", this.sessionId);
	}
	return soap;
};

Com_Processmaker_Zimbra.prototype.xmlToObject = function(result) {
    try {
        var xd = new AjxXmlDoc.createFromDom(result.xml).toJSObject(true, false);

    } catch(ex) {
        this.displayErrorMessage(ex, result.text, "Problem contacting ProcessMaker ("+this.getUserProperty("server")+")");
    }
    return xd;
};

/// Utility function that calls the PM server with the given SOAP data
	Com_Processmaker_Zimbra.prototype.rpc = function(soap, callback, passErrors, serverType) {

	this.sendRequest(soap, this.getServerHost(serverType), {SOAPAction: "m", "Content-Type": "text/xml"}, callback, false, passErrors);
};


// SOAP METHOD: login

/// Login to PM.  The given callback will be called in the case of a
/// successful login.  Note that callback is a plain function (not AjxCallback)
Com_Processmaker_Zimbra.prototype.login = function(callback) {
	if (!callback) {
		callback = false;
    }

    //this.SERVER = this.getServerHost("casesList");

    var user = this.getUserProperty("user");
		var passwd = this.getUserProperty("passwd");
		var server = this.getUserProperty("server");
		var workspace = this.getUserProperty("workspace");

		errorMessage="";
		if (!user){
			errorMessage=errorMessage+"<b>-</b> User<br>";
		}

		if (!passwd){
			errorMessage=errorMessage+"<b>-</b> Password<br>";
		}

		if (!server){
			errorMessage=errorMessage+"<b>-</b> Server<br>";
		}

		if (!workspace){
			errorMessage=errorMessage+"<b>-</b> Workspace<br>";
		}



	//if (!user || !passwd || !server || !workspace) {
	if(errorMessage!=""){
		errorMessage="Please complete your ProcessMaker preferences first<hr><br>"+errorMessage;
		//this.displayStatusMessage("Please fill your ProcessMaker credentials first");
		this.displayErrorMessage(errorMessage);
		this.createPropertyEditor(new AjxCallback(this, this.login, [ callback ]));
	} else {
		this._do_login(callback, user, passwd, server, workspace);
	}
};

Com_Processmaker_Zimbra.prototype._do_login = function(callback, user, passwd, server, workspace) {
	var soap = this._makeEnvelope("login");
	soap.set("ns1:userid", user);
	soap.set("ns1:password", passwd);

	if (callback == null)
		callback = false;
	this.rpc(soap, new AjxCallback(this, this.done_login, [ callback ]), true,"WS");
};

Com_Processmaker_Zimbra.prototype.done_login = function(callback, result) {
	var ans = this.xmlToObject(result);
	if (ans && ans.Body && ans.Body.pmResponse) {// Seems that there is a correct answer
		ans = ans.Body.pmResponse;

		if(ans.status_code==0){//successful login
			this.loginStatus = String(ans.status_code);
			this.sessionId = String(ans.message);
			this.loginTime=ans.timestamp;

			var user = this.getUserProperty("user");		
		  var server = this.getUserProperty("server");
		  var workspace = this.getUserProperty("workspace");
			this.displayStatusMessage("ProcessMaker Session started.<br /><br /><b>Server: </b>"+ server+"<br /><b>Workspace: </b>"+ workspace+"<br /><b>User: </b>"+ user);		
			if(window.console){ 
	      console.log("ProcessMaker Session started: "+ this.sessionId);
	    }
			if (callback)
				callback.call(this);
		}else{// login error, get PM message
			var fault = "";
			fault = ans.message +"("+ans.status_code+")"+ "<br />";
			this.displayErrorMessage("<b>Login to ProcessMaker failed!</b><br /><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />Review your preferences.");
		}



    } else {//Another login problem
        var fault = " -Connection Error- <br />";

        this.displayErrorMessage("<b>Login to ProcessMaker failed!</b><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />Check your internet connection and review your preferences.");
    }
};

// SOAP METHOD: logout

/// There's no explicit logout command to ProcessMaker, we just clear session data
/// and user information.
Com_Processmaker_Zimbra.prototype.logout = function() {

	this.loginStatus = null;
	this.sessionId = null;
	this.loginTime = null;
};


//SOAP method : processList
Com_Processmaker_Zimbra.prototype.processList = function(callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_processList(callback);
		});
	else
		this._do_processList(callback);
};

Com_Processmaker_Zimbra.prototype._do_processList = function(callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("processList");
    //alert(this.sessionId);
    soap.set("sessionId", this.sessionId);
    this.rpc(soap, new AjxCallback(this, this.done_processList, [ callback ]),true,"WS");
};




Com_Processmaker_Zimbra.prototype.done_processList = function(callback, result) {

	var xmlResponse = new AjxXmlDoc.createFromDom(result.xml);
	//alert(result.text);
	this.dlg_processList(xmlResponse);
};

Com_Processmaker_Zimbra.prototype.dlg_processList = function(xmlResponse) {
	var view = new DwtComposite(this.getShell());
//alert(xmlResponse.text);
var items = xmlResponse.getElementsByTagName('item');
//alert(items.length);
var processList = [];
processList.push({ label : "- Available Process -",  value : "0" });
for (var i=0;i<items.length;i++){
	//alert(this.getNodeValue(items[i],'key'));
	//alert(this.getNodeValue(items[i],'value'));
	if(this.getNodeValue(items[i],'key')=="guid"){
		processGuid=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="name"){
	  
	  if(window.console){ 
	      console.log("Process: "+ this.getNodeValue(items[i],'value')+" ("+processGuid+")");
	    }
	  
		processName=this.getNodeValue(items[i],'value');
		//alert(processName);
		//alert(processGuid);

		//processList.push({ label : this.getNodeValue(items[i],'key').toString(),  value: this.getNodeValue(items[i],'value').toString() });
		processList.push({ label : processName,  value: processGuid });
	}
}
//alert(processList);



//processList.push({ label : " 234324 Yes 1231243123",  value : "yes1212" });
	/// Create a PropertyEditor for the Process List
	var pe_processlist = new DwtPropertyEditor(view, true);

  //alert(processList);

  //alert(processList.length);
//alert(items.length);

	if(items.length>0){//There are Process
		var pe_props = [

		{ label     : "Process",
            name      : "process",
            type      : "enum",
            value     : "",
            item      : processList
             }

	];



	pe_processlist.initProperties(pe_props);
	var dialog_args = {
		title : "Select process to start",
		view  : view
	};


	var dlg = this._createDialog(dialog_args);
 	pe_processlist.setFixedLabelWidth();
 	pe_processlist.setFixedFieldWidth();

	dlg.popup();

	// handle some events

	dlg.setButtonListener(
		DwtDialog.OK_BUTTON,
		new AjxListener(this, function() {
			if (!( pe_processlist.validateData()  ))
				return;
			var acct = pe_processlist.getProperties();

			this.displayStatusMessage("Initiating new case...");
			if(window.console){ 
	      console.log("Initiating new case..."+acct.process);
	    }
			//Create case via WS


			this.newCase(acct.process);

			dlg.popdown();
			dlg.dispose();
		}));

	// We don't really want to mess with things like cache-ing this
	// dialog...
	dlg.setButtonListener(
		DwtDialog.CANCEL_BUTTON,
		new AjxListener(this, function() {
			dlg.popdown();
			dlg.dispose();
		}));


	}else{//there aren't
		this.displayErrorMessage("You cannot initiate a new case.");
}


};

//SOAP method : newCase
Com_Processmaker_Zimbra.prototype.newCase = function(processId,callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_newCase(processId,callback);
		});
	else
		this._do_newCase(processId,callback);
};

Com_Processmaker_Zimbra.prototype._do_newCase = function(processId,callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("newCase");
    //alert(this.sessionId);
    soap.set("sessionId", this.sessionId);
    soap.set("processId", processId);
    soap.set("taskId", "");
    soap.set("variables", "");

    this.rpc(soap, new AjxCallback(this, this.done_newCase, [ callback ]),true,"WS");
};




Com_Processmaker_Zimbra.prototype.done_newCase = function(callback, result) {

	var ans = this.xmlToObject(result);
	if (ans && ans.Body && ans.Body.newCaseResponse) {// Seems that there is a correct answer
		ans = ans.Body.newCaseResponse;

		if(ans.status_code==0){//case successful created
			caseStatus = String(ans.status_code);
			caseMessage = String(ans.message);
			caseId=String(ans.caseId);
			caseNumber=ans.caseNumber;
			caseTimeStamp=ans.timestamp;

			this.displayStatusMessage("Case <b>#"+caseNumber+"</b> started (opening in new window)");
			if(window.console){ 
	      console.log("Case#..."+caseNumber);
	    }

			//urlOpenCase=this.getUserProperty("server")+"/sys"+this.getUserProperty("workspace")+"/en/green/cases/cases_Open?APP_UID="+caseId+"&DEL_INDEX=1&sid="+this.sessionId;
			urlOpenCase=this.getServerHost("openCase","APP_UID="+caseId+"&DEL_INDEX=1&sid="+this.sessionId);

			//window.open(urlOpenCase , "PM_ZIMLET_WINDOW" , "width=600,height=500");
			this.openExternalWindowNew(urlOpenCase , "ProcessMaker Case#...");


			if (callback)
				callback.call(this);
		}else{// case error, get PM message
			var fault = "";
			fault = ans.message +"("+ans.status_code+")"+ "<br />";
			this.displayErrorMessage("<b>Start new Case in ProcessMaker failed!</b><br /><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "");
		}



    } else {//Another case problem
        var fault = " -Connection Error- <br />";

        this.displayErrorMessage("<b>Start new Case in ProcessMaker failed!</b><br />&nbsp;&nbsp;&nbsp;&nbsp;" + fault + "<br />Check your internet connection and review your preferences.");
    }







};


//SOAP method : caseList
Com_Processmaker_Zimbra.prototype.caseList = function(callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_caseList(callback);
		});
	else
		this._do_caseList(callback);
};

Com_Processmaker_Zimbra.prototype._do_caseList = function(callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("caseList");
    //alert(this.sessionId);
    soap.set("sessionId", this.sessionId);
    this.rpc(soap, new AjxCallback(this, this.done_caseList, [ callback ]),true,"WS");
};




Com_Processmaker_Zimbra.prototype.done_caseList = function(callback, result) {

	var xmlResponse = new AjxXmlDoc.createFromDom(result.xml);
	//alert(result.text);
	this.dlg_caseList(xmlResponse);
};

Com_Processmaker_Zimbra.prototype.dlg_caseList = function(xmlResponse) {
	var view = new DwtComposite(this.getShell());
	//alert(view);
	var items = xmlResponse.getElementsByTagName('item');
//alert(items.length);
var caseList = [];
caseList.push({ label : "- Available Cases -",  value : "0" });
for (var i=0;i<items.length;i++){
	//alert(this.getNodeValue(items[i],'key'));
	//alert(this.getNodeValue(items[i],'value'));
	if(this.getNodeValue(items[i],'key')=="guid"){
		caseGuid=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="name"){
		caseName=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="status"){
		caseStatus=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="delIndex"){
		caseDelIndex=this.getNodeValue(items[i],'value');
		//alert(processName);
		//alert(processGuid);
//alert(caseStatus);

		//processList.push({ label : this.getNodeValue(items[i],'key').toString(),  value: this.getNodeValue(items[i],'value').toString() });
		if(window.console){ 
	      console.log(" Case: "+caseName + " Status: "+caseStatus + " Guid: "+caseGuid);
	    }
	  if(caseStatus=="TO_DO"){
		 caseList.push({ label : caseName,  value: caseGuid+"|"+caseDelIndex });
		}
	}
}
//alert(caseList);



//processList.push({ label : " 234324 Yes 1231243123",  value : "yes1212" });
	/// Create a PropertyEditor for the Process List
	var pe_caselist = new DwtPropertyEditor(view, true);

  //alert(processList);

  //alert(processList.length);
//alert(items.length);

	if(items.length>0){//There are Process
		var pe_props = [

		{ label     : "Cases",
            name      : "caseId",
            type      : "enum",
            value     : "",
            item      : caseList
             }

	];

//alert(pe_props);

	pe_caselist.initProperties(pe_props);
	var dialog_args = {
		title : "Select case to view",
		view  : view
	};
	
	var dlg = this._createDialog(dialog_args);
 	pe_caselist.setFixedLabelWidth();
 	pe_caselist.setFixedFieldWidth();

	dlg.popup();
	
	// handle some events

	dlg.setButtonListener(
		DwtDialog.OK_BUTTON,
		new AjxListener(this, function() {
		  
		  if (!( pe_caselist.validateData()  ))
				return;
			var acct = pe_caselist.getProperties();
			
			this.displayStatusMessage("Opening case..."+acct.caseId);
			caseId=acct.caseId;
			splitedValue=caseId.split("|");
			caseId=splitedValue[0];
			delId=splitedValue[1];
			urlOpenCase=this.getServerHost("openCase","APP_UID="+caseId+"&DEL_INDEX="+delId+"&sid="+this.sessionId);
			//window.open(urlOpenCase , "PM_ZIMLET_WINDOW" , "width=600,height=500");
			this.openExternalWindowNew(urlOpenCase , "ProcessMaker Case# "+caseId);
			
			

			dlg.popdown();
			dlg.dispose();
		}));
		
		// We don't really want to mess with things like cache-ing this
	// dialog...
	dlg.setButtonListener(
		DwtDialog.CANCEL_BUTTON,
		new AjxListener(this, function() {
			dlg.popdown();
			dlg.dispose();
		}));


	}else{//there aren't
		this.displayErrorMessage("You cannot initiate a new case.");
}



};

Com_Processmaker_Zimbra.prototype.openWebspace = function() {
  if (!this.sessionId)
		this.login(function() {
			this._do_openWebspace();
		});
	else
		this._do_openWebspace();  
	
};

Com_Processmaker_Zimbra.prototype._do_openWebspace = function() {
  urlOpenCase=this.getServerHost("casesList","sid="+this.sessionId);
	//window.open(urlOpenCase , "PM_ZIMLET_WINDOW" , "width=600,height=500");
	this.openExternalWindowNew(urlOpenCase , "ProcessMaker Case List");
};

Com_Processmaker_Zimbra.prototype.clicked = 
 function(spanElement,contentObjText,matchContext,canvas){
 	if(window.console){
 	  console.log("clicked!!!");
 	  console.log(spanElement);
 	  console.log(contentObjText);
 	  console.log(matchContext);
 	  console.log(canvas);
 	}
 };



Com_Processmaker_Zimbra.prototype.conversationDropped = function(note) {
    if(!note) {return;}
  	if(note.TYPE=="ZmConv") {	    
      //note  = note.getFirstHotMsg();
    }
    if(window.console){
      console.log("***the note ****");
      console.log(note);
    }

    // check out some domains, exclude user's domain
    var ignoreDomain = this.getUserProperty("ignoreDomain");
    var emails = [];
    function addEmails(a) {
        if (a) {
            if (typeof a == "string") {
                if (a.indexOf(ignoreDomain) != -1) {
                    return;
                }
                emails.push(a);
            } else if (a instanceof Array) {
                for (var i = 0; i < a.length; ++i) {
                    if(a[i].address && a[i].address.indexOf(ignoreDomain) == -1) {
                        emails.push(a[i].address);
                    }
                }
            }
        }
    };
    
    if(note._addrs) {
      if(window.console){
        console.log("** _addrs ***");
        console.log(note._addrs);
      }
      if(note._addrs.BCC && note._addrs.BCC._array.length > 0) {
        addEmails(note._addrs.BCC._array);        
      }
      if(note._addrs.CC && note._addrs.CC._array.length > 0) {
        addEmails(note._addrs.CC._array);
      }
      if(note._addrs.FROM && note._addrs.FROM._array.length > 0) {
        addEmails(note._addrs.FROM._array);
      }
      if(note._addrs.REPLY_TO && note._addrs.REPLY_TO._array.length > 0) {
        addEmails(note._addrs.REPLY_TO._array);
      }
      if(note._addrs.SENDER && note._addrs.SENDER._array.length > 0) {
        addEmails(note._addrs.SENDER._array);
      }
      if(note._addrs.TO && note._addrs.TO._array.length > 0) {
        addEmails(note._addrs.TO._array);
      }
        
    } else {
      if(window.console){
          console.log("-- PART EMAILS ");         
          console.log("participants: "+note.participants);
          console.log("from: "+note.from);
          console.log("to: "+note.to);
          console.log("cc: "+note.cc);
        }
        
        addEmails(note.participants);
        addEmails(note.from);
        addEmails(note.to);
        addEmails(note.cc);
        
    }
    var domains = [], tmp = {};
	for (var i = 0; i < emails.length; ++i) {
        DBG.println(AjxDebug.DBG3, emails[i]);
        if (/@([^>]+)>?$/.test(emails[i])) {
			var d = RegExp.$1;
			if (!tmp[d]) {
				tmp[d] = 1;
				// kind of pointless, but let's make sure we
				// backslash any apostrophes
				domains.push(d.replace(/\x27/, "\\'"));
			}
		}
	}
   if(window.console){
    console.log(emails);
    console.log(domains);
   }
   
   
   function $search_contact(records) {    
        if (records.length == 0) {
            this.displayErrorMessage(
                    [ "There are no matching contacts for these email domains:", domains ].join("<br />"));
        } else {
            //this.displayStatusMessage(records.length);
            this.dlg_addNoteToAccounts(records, note);
        }
    }
   
   
   
   if (domains.length == 0) {
		this.displayErrorMessage("No email addresses.<br />"
					 + "We can't determine a Contact to add this note to.");
	} else {        
        this.contactMailMatch(emails, $search_contact);
	}
   
   
   
};
Com_Processmaker_Zimbra.prototype._sendPM_CRM = function(ev) {  
    if(window.console){
      console.log("****Event");
      console.log(ev);
      console.log("****this");
      console.log(this);
    
    }
    this._composeView = AjxDispatcher.run("GetComposeController");
    this._composeView._toolbar.enableAll(false);
    
    
    if(window.console){
      console.log("****this _composeView");
      console.log(this._composeView);      
    }
    
    var msg = this._composeView._composeView.getMsg();
    //var msg = this._pmo.getMessage();
    //var msg = this._composeView.getMsg();
    
    if(window.console){
      console.log("****Message");
      console.log(msg);
    }
    this._composeView.sendMsg();
    //this._pmo.noteDropped(msg);
    this._pmo.conversationDropped(msg);
};
//SOAP method : contact Search
Com_Processmaker_Zimbra.prototype.contactMailMatch = function(emails,callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_contactMailMatch(emails,callback);
		});
	else
		this._do_contactMailMatch(emails,callback);
};

Com_Processmaker_Zimbra.prototype._do_contactMailMatch = function(emails,callback) {
    if (!callback) {
        callback = false;
    }
    if(window.console){ 
    console.log("Before create SOAP");    
    }
    var soap = this._makeEnvelope("matchContactEmails");    
    //alert(this.sessionId);
    if(window.console){ 
    console.log("Set session id..");    
    }
    soap.set("sessionId", this.sessionId);
    if(window.console){ 
    console.log("Session id: "+this.sessionId);    
    console.log("Set emails");
    }
    soap.set("mails", emails.join(","));
    if(window.console){ 
    console.log("mails: "+emails);    
    }
    if(window.console){ 
    console.log(soap);
    console.log("Now call service: "+this.getServerHost("WS_AAT"));
    }
    this.rpc(soap, new AjxCallback(this, this.done_contactMailMatch, [ callback ]),true,"WS_AAT");
};
Com_Processmaker_Zimbra.prototype.done_contactMailMatch = function(callback, result) {
  if(window.console){ 
    console.log(result);
  }
  var xmlResponse = new AjxXmlDoc.createFromDom(result.xml);
  //var xmlResponse = this.xmlToObject(result);
   if(window.console){ 
    console.log(xmlResponse);
  } 
  //var accounts = xmlResponse.getElementsByTagName('item');
  if(window.console){
    console.log("xmlResponse typeof: "+typeof(xmlResponse));
    
    
  }
  var accounts = xmlResponse.getElementsByTagName('ns1:accounts');
  if(window.console){
    console.log("xmlResponse typeof: "+typeof(accounts));
    
  }
  var accountsArray=[ ];
if(window.console){ 
    console.log(accounts);
  }
  
  if(window.console){ 
    console.log("tamano: "+accounts.length);
  }

  
  for (var i=0;i<accounts.length;i++){
	//alert(this.getNodeValue(accounts[i],'key'));
	//alert(this.getNodeValue(accounts[i],'value'));	
	
	var item = accounts[i].getElementsByTagName('item');
	if(window.console){ 
    console.log(item);
  }
 itemObject = new Object();
  for (var j=0;j<item.length;j++){
    if(window.console){ 
      console.log("key: "+this.getNodeValue(item[j],'key'));
      console.log("value: "+this.getNodeValue(item[j],'value'));
      
    }
    itemObject[this.getNodeValue(item[j],'key')]=this.getNodeValue(item[j],'value');
  }
  if(window.console){ 
    console.log(itemObject);
  }
	
	
	
	//accountsArray.push({ id : this.getNodeValue(accounts[i],'key'),  value: this.getNodeValue(accounts[i],'value') });
	accountsArray.push(itemObject);
	/*
	if(this.getNodeValue(items[i],'key')=="contact_id"){
		contact_id=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="name"){
		caseName=this.getNodeValue(items[i],'value');
	}
	if(this.getNodeValue(items[i],'key')=="status"){
		caseStatus=this.getNodeValue(items[i],'value');
	}
	*/
	
  }
  if(window.console){
    console.log(accountsArray);
  }
	/*
	var xd = this.xmlToObject(result);
	var qr = xd.Body.queryResponse.result.records;
	if (qr != null) {
		if (!(qr instanceof Array))
			qr = [ qr ];
		// sometimes SForce returns a duplicate <Id> tag
		for (var i = qr.length; --i >= 0;) {
			if (qr[i].Id && (qr[i].Id instanceof Array))
				qr[i].Id = qr[i].Id[0];
			qr[i].get = Com_Processmaker_Zimbra.__query_result_get;
		}
	} else {
		qr = [];
	}
	*/
	qr = [];
	qr[0] = [];
	qr[1] = [];
	qr[0].Id = 1;
	qr[0].get = "asdasd";
	
	qr[1].Id = 2;
	qr[1].get = "dsfsdfsd";
	callback.call(this, accountsArray);
};


Com_Processmaker_Zimbra.prototype.dlg_addNoteToAccounts = function(accounts, note) {
	var view = new DwtComposite(this.getShell());
	var el = view.getHtmlElement();
	var h3 = document.createElement("h3");
	
	var i;
  h3.className = "PM-sec-label PM-icon-right";
	//h3.innerHTML = "A = Account, O = Opportunity, C = Contact";
	//h3.innerHTML = "A = Account or O = Opportunity";
	h3.innerHTML = "Contact Name [Contact Email] (Customer Name)";
	el.appendChild(h3);

	var checkboxes = [];

    var div = document.createElement("div");
    var html = [ "<table><tbody>" ];
    DBG.dumpObj(AjxDebug.DBG3, accounts);
     if(window.console){
      console.log("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
    }
    for (acctId in accounts) {
      if(window.console){
        console.log(acctId);
        console.log(accounts);
      }
        DBG.dumpObj(AjxDebug.DBG3, acctId);
        var acct = accounts[acctId];
        DBG.dumpObj(AjxDebug.DBG3, acct);
        var cbid = Dwt.getNextId();
        checkboxes.push(cbid);
        html = this._checkBoxHtml(acct, cbid, 0, false, html);
        var chkContact = true;
        if (acct.Opp && acct.Opp.length > 0) {
            for (i = 0; i < acct.Opp.length; i++) {
                cbid = Dwt.getNextId();
                checkboxes.push(cbid);
                html = this._checkBoxHtml(acct.Opp[i], cbid, 2, true, html);
                chkContact = false;
            }
        }
        // Limit the number of contacts shown to 5
		// REMOVE LISTING OF CONTACTS, just list account/opportunity
		/**
		var displayLimit = acct.Con.length;
        if(displayLimit > 5) {
            displayLimit = 5;
            DBG.println(AjxDebug.DBG3, "Setting contact limit to 5 returned " + acct.Con.length);
        }
        if (acct.Con && displayLimit > 0) {
            for (i = 0; i < displayLimit; i++) {
                cbid = Dwt.getNextId();
                checkboxes.push(cbid);
                html = this._checkBoxHtml(acct.Con[i], cbid, 2, chkContact, html);
            }
        }
        **/
    }
    html.push("</tbody></table>");
	div.innerHTML = html.join("");
	el.appendChild(div);

	h3 = document.createElement("h3");
	h3.className = "PM-sec-label";
	h3.innerHTML = "Note details";
	el.appendChild(h3);

	div = document.createElement("div");
	var subjectId = Dwt.getNextId();
	var messageId = Dwt.getNextId();
	var noteId = Dwt.getNextId();
	var fromEmail = Dwt.getNextId();
	var toEmail = Dwt.getNextId();
    var body;
    if(window.console){ 
      console.log("note....");
      console.log(note);
    }
    if (note.body) {
        body = AjxStringUtil.htmlEncode(note.body);
    } else if (note._topPart && note._topPart.getContentForType) {
        body = AjxStringUtil.htmlEncode(note._topPart.getContentForType(ZmMimeTable.TEXT_PLAIN));
    } else {
		body = "Error - No body found!"
	}
    div.innerHTML =
		[ "<table><tbody>",
		  "<tr>",
		  "<td align='right'><label for='", subjectId, "'>Subject:</td>",
		  "<td>",
		  "<input style='width:35em' type='text' id='", subjectId, "' value='",
		  AjxStringUtil.htmlEncode(note.subject), "' autocomplete='off' />",
		  "<input type='hidden' id='",noteId,"' value='",note.id,"'>",
		  "<input type='hidden' id='",fromEmail,"' value='",note.from,"'>",
		  "<input type='hidden' id='",toEmail,"' value='",note.to,"'>",
		  "</td>",
		  "</tr>",
		  "<td colspan='2'>",
          "<textarea style='width:40em;height:200px' id='", messageId, "'>",
           body, "</textarea>",
          "</td>",
		  "<tr>",
		  "</tr></tbody></table>" ].join("");
	el.appendChild(div);
	
	

	var dialog_args = {
		view  : view,
		title : "Adding email to AAT CRM in Processmaker"
	};
	var dlg = this._createDialog(dialog_args);
	dlg.popup();

	el = document.getElementById(subjectId);
	el.select();
	el.focus();

	dlg.setButtonListener(DwtDialog.OK_BUTTON,
			      new AjxListener(this, function() {
				      var ids = [];
				      for (i = 0; i < checkboxes.length; ++i) {
					      var cb = document.getElementById(checkboxes[i]);
					      if (cb.checked) {
							  //ids.push({ ContactCustomerID: cb.value });
							  ids.push(cb.value);
						  }
				      }
				      if (ids.length == 0) {
					      this.displayErrorMessage("You must select at least one account");
				      } else {
					      var props = {
						      Title : document.getElementById(subjectId).value,
						      Body  : document.getElementById(messageId).value,
						      NoteID  : document.getElementById(noteId).value,
						      From  : document.getElementById(fromEmail).value,
						      To  : document.getElementById(toEmail).value
						      
					      };
					      /*
					      for (i = 0; i < ids.length; ++i) {
							  ids[i].Subject = props.Title;
						    ids[i].Body = props.Body;
						    ids[i].NoteID = props.NoteID;
							  
					      }
					      */
					      this.saveEmailToContacts(ids, props, function() {
						      this.displayStatusMessage("Email saved for " + ids.length + " accounts.");
					      });
					      dlg.popdown();
					      dlg.dispose();
				      }
			      }));

	dlg.setButtonListener(DwtDialog.CANCEL_BUTTON,
			      new AjxListener(this, function() {
				      dlg.popdown();
				      dlg.dispose();
			      }));
};


Com_Processmaker_Zimbra.prototype.saveEmailToContacts = function(accounts, email, callback) {
	// make sure we are logged in first
	if (!this.sessionId)
		this.login(function() {
			this._do_saveEmailToContacts(accounts, email, callback);
		});
	else
		this._do_saveEmailToContacts(accounts, email, callback);
};

Com_Processmaker_Zimbra.prototype._do_saveEmailToContacts = function(accounts, email, callback) {
    if (!callback) {
        callback = false;
    }
    var soap = this._makeEnvelope("saveEmailToContacts");
    accountsString=accounts.join("|");
    if(window.console){
      console.log("_____________________ READY!!___________________");
      console.log(accounts);
      console.log(accountsString);
    }
    soap.set("from", email.From);
    soap.set("to", email.To);
    soap.set("subject", email.Title);
    soap.set("body", email.Body);
    soap.set("emailId", email.NoteID);
    soap.set("contacts", accountsString);
    
    this.rpc(soap, new AjxCallback(this, this.done_saveEmailToContacts, [ callback ]),true,"WS_AAT");    
    
};

Com_Processmaker_Zimbra.prototype.done_saveEmailToContacts = function(callback, result) {
	/*
	var xd = this.xmlToObject(result);
	if (xd && callback) {
		result = xd.Body.createResponse.result;
		var id;
		if (result instanceof Array) {
			id = [];
			for (var i = 0; i < result.length; ++i)
				id.push(result[i].id.toString());
		} else {
			id = result.id.toString();
		}
		callback.call(this, id);
	}
	*/
	if (callback) {
	  callback.call(this, "1");
	}
};



Com_Processmaker_Zimbra.prototype._checkBoxHtml = function(rec, cbid, indent, checked, html) {

    html.push("<tr><td><input type='checkbox' value='",
            rec.contact_id+","+rec.customer_id,
            "' id='",
            cbid);

    if (checked) {
        html.push("' checked='checked'/>");
    } else {
        html.push("' />");
    }

    html.push("</td>",
            "<td>",
            "<label for='", cbid, "'>");

    switch (indent) {
        case 1:
            html.push("&nbsp;&nbsp;");
            break;
        case 2:
            html.push("&nbsp;&nbsp;&nbsp;&nbsp;");
            break;
    }

    if (rec.TYPE)
        html.push(rec.TYPE + ":");

    if (rec.Name)
        html.push(" " + rec.Name);

    if (rec.FirstName)
        html.push(" " + rec.FirstName);

    if (rec.LastName)
        html.push(" " + rec.LastName);

    if (rec.Email)
        html.push(" [" + rec.Email + "]");

    if (rec.Website)
        html.push(" [" + rec.Website + "]");

    if (rec.Phone)
        html.push(" [" + rec.Phone + "]");
    
    if (rec.contact_name)
        html.push(" " + rec.contact_name);
        
    if (rec.contact_email)
        html.push(" [" + rec.contact_email + "]");
        
    if (rec.customer_name)
        html.push(" (" + rec.customer_name + ")");

    html.push("</label></td></tr>");
    return html;
};