/*
 * Decompiled with CFR 0.152.
 */
package ca.immail;

import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.extension.ExtensionHttpHandler;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Immail
extends ExtensionHttpHandler {
    private String immailApiKey;
    private String immailURL;
    private String immailCreateTokenPath;

    public String getPath() {
        return "/immail";
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        resp.getOutputStream().print("ca.immail is installed. HTTP POST method is not supported");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String authTokenStr = null;
        Account zimbraAccount = null;
        try {
            Cookie[] cookies = req.getCookies();
            for (int n = 0; n < cookies.length; ++n) {
                Cookie cookie = cookies[n];
                if (!cookie.getName().equals("ZM_AUTH_TOKEN")) continue;
                authTokenStr = cookie.getValue();
                break;
            }
            if (authTokenStr == null) {
                this.responseWriter("unauthorized", resp, null);
                return;
            }
            AuthToken authToken = AuthToken.getAuthToken(authTokenStr);
            Provisioning prov = Provisioning.getInstance();
            zimbraAccount = Provisioning.getInstance().getAccountById(authToken.getAccountId());
            Cos cos = prov.getCOS(zimbraAccount);
            Set set = cos.getMultiAttrSet("zimbraProxyAllowedDomains");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.responseWriter("unauthorized", resp, null);
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (req.getQueryString() != null) {
            String[] params;
            for (String param : params = req.getQueryString().split("&")) {
                String[] subParam = param.split("=");
                paramsMap.put(subParam[0], subParam[1]);
            }
        } else {
            this.responseWriter("ok", resp, null);
            return;
        }
        if (this.initializeImmailAPI(zimbraAccount.getName()).booleanValue()) {
            switch ((String)paramsMap.get("action")) {
                case "signOn": {
                    String token;
                    int port = req.getServerPort();
                    String url = req.getScheme() + "://" + req.getServerName();
                    if (port != 80 && port != 443) {
                        url = url.concat(":" + String.valueOf(port));
                    }
                    if (!"".equals(token = this.createAuthToken(zimbraAccount.getName(), url))) {
                        resp.setHeader("Content-Type", "application/json");
                        this.responseWriter("ok", resp, "{\"token\":\"" + token + "\"}");
                        break;
                    }
                    this.responseWriter("error", resp, null);
                    break;
                }
                case "test": {
                    try {
                        String apiKeyStr = "Ok :) 3 - " + String.valueOf(req.getServerPort()) + req.getRequestURL().toString();
                        this.responseWriter("ok", resp, apiKeyStr);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.responseWriter("unauthorized", resp, null);
                        return;
                    }
                }
            }
        } else {
            this.responseWriter("error", resp, null);
        }
    }

    private void responseWriter(String action, HttpServletResponse resp, String message) {
        try {
            resp.setHeader("Access-Control-Allow-Origin", this.immailURL);
            resp.setHeader("Access-Control-Allow-Credentials", "true");
            switch (action) {
                case "ok": {
                    resp.setStatus(200);
                    if (message == null) {
                        resp.getWriter().write("OK");
                        break;
                    }
                    resp.getWriter().write(message);
                    break;
                }
                case "unauthorized": {
                    resp.setHeader("Content-Type", "text/html");
                    resp.getWriter().write("<html><head></head><body><div style=\"background-color:white;color:black;padding:10px\">Unauthorized. Let's do something.</div></body>");
                    break;
                }
                case "error": {
                    resp.setStatus(500);
                    resp.getWriter().write("The request did not succeed successfully.");
                }
            }
            resp.getWriter().flush();
            resp.getWriter().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean initializeImmailAPI(String email) {
        Properties prop = new Properties();
        try {
            FileInputStream input = new FileInputStream("/opt/zimbra/lib/ext/immail/config.properties");
            prop.load(input);
            this.immailApiKey = this.getApiKey(email);
            this.immailURL = prop.getProperty("immailURL");
            this.immailCreateTokenPath = prop.getProperty("immailCreateTokenPath");
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public String getApiKey(String email) {
        String[] arrOfStr = email.split("@");
        String currentDomain = arrOfStr[1];
        try {
            FileInputStream is = new FileInputStream("/opt/zimbra/lib/ext/immail/config.domains.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            JSONTokener tokener = new JSONTokener(builder.toString());
            JSONArray arr = new JSONArray(tokener);
            String apiKeyDomain = "";
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject domainObj = (JSONObject)arr.get(i);
                String domain = (String)domainObj.get("domain");
                String apiKey = (String)domainObj.get("apiKey");
                if (!domain.equals(currentDomain)) continue;
                apiKeyDomain = apiKey;
            }
            return apiKeyDomain;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Error getting Api Key";
        }
    }

    public String createAuthToken(String email, String hostUrl) {
        HttpURLConnection connection = null;
        StringBuffer response = new StringBuffer();
        try {
            String urlParameters = "{\"email\": \"" + email + "\", \"alternative_auth\": {\"name\": \"ZIMBRA\",\"url\": \"" + hostUrl + "\",\"method\": \"GET\"}}";
            byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
            int postDataLength = postData.length;
            URL url = new URL(this.immailURL + this.immailCreateTokenPath);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
            connection.setRequestProperty("X-Auth-Token", this.immailApiKey);
            connection.setUseCaches(false);
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(postData);
            }
            if (connection.getResponseCode() == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JSONObject obj = new JSONObject(response.toString());
                String token = obj.getString("token");
                return token;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

