'use strict';

console.log("IntalioZiKnock [loaded]");

function PortKnocking_loadScript(url, callback) {
    var head = document.getElementsByTagName('head')[0];
    var script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = url;

    script.onreadystatechange = callback;
    script.onload = callback;

    // Fire the loading
    head.appendChild(script);
}

/*
 * DEFAULT ZIMLET INIT
 * */
function IntalioZiKnock_HandlerObject() {}

IntalioZiKnock_HandlerObject.prototype = new ZmZimletBase();
IntalioZiKnock_HandlerObject.prototype.constructor = IntalioZiKnock_HandlerObject;
var IntalioZiKnock = IntalioZiKnock_HandlerObject;
// settingsExists = true;
IntalioZiKnock.prototype.checkUserProperties = function () {
    var showMissing = {
        "ports": false,
        "ip": false
    };
    if (this.getUserProperty("IntalioPortKnocking_ports") == undefined || this.getUserProperty("IntalioPortKnocking_ports") == "") {
        // console.log("IntalioPortKnocking_ports is not defined.");
        showMissing.ports = true;
    }
    if (this.getUserProperty("IntalioPortKnocking_ip") == undefined || this.getUserProperty("IntalioPortKnocking_ip") == "") {
        // console.log("IntalioPortKnocking_ip is not defined.");
        showMissing.ip = true;
    }

    if (showMissing.ports || showMissing.ip) {
        settingsExists = false;
        var txt = "";
        if (showMissing.ports) {
            txt += "<br/>-" + intalio_zi_knock["no_port_settings"];
        }
        if (showMissing.ip) {
            txt += "<br/>-" + intalio_zi_knock["no_ip_settings"];
        }
        var errDialog = appCtxt.getErrorDialog();
        errDialog.setMessage(intalio_zi_knock["configuration_does_not_exist"], intalio_zi_knock["required_setup_does_not_exits"] + txt, DwtMessageDialog.WARNING_STYLE);
        errDialog.popup();
        return false;
    } else {
        return true;
    }
};
IntalioZiKnock.prototype.init = function () {
    IntalioZiKnock.version = this._zimletContext.version;

    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        for (var _iterator = appCtxt.getActiveAccount().settings._settings.USER_PROPS.defaultValue[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var x = _step.value;

            if (x.zimlet == "intalio_port_knocking") {
                console.log(x.name + " - " + x._content);
            }
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    if (!this.checkUserProperties()) {
        console.log("[Intalio KnockD] User properties is not defined :(");
    }
    PortKnocking_loadScript("/service/zimlet/intalio_zi_knock/thirdParty/axios.min.js", function () {});
};
IntalioZiKnock.prototype.singleClicked = function () {
    if (this.checkUserProperties()) {
        knocking(this.getUserProperty("IntalioPortKnocking_ports"), this.getUserProperty("IntalioPortKnocking_ip"));
        this._showDialog(intalio_zi_knock["admin_port_is_being_opened"] + "...", true);
    }
};

var count = 4;
var timer = {};
var test = {};

function endCountdown() {
    // logic to finish the countdown here
    console.log("Finish!");
}

function handleTimer(id, yesButton) {
    console.log(yesButton);
    test = yesButton;
    var timerTextId = document.getElementById(id).childNodes[0];
    var timerId = document.getElementById(id).childNodes[1];
    if (count === 0) {
        timerId.innerText = intalio_zi_knock["opened"];
        timerId.classList.remove("closed");
        timerId.classList.add("opened");
        timerTextId.innerText = intalio_zi_knock["opening_activities_have_been_completed"];
        yesButton.setEnabled(true);
        clearInterval(timer);
    } else {
        // console.log("Odliczanie minus ", count);
        count--;
        timerId.innerText = count;
        timerId.classList.remove("opened");
        timerId.classList.add("closed");
        yesButton.setEnabled(false);
        timerTextId.innerText = intalio_zi_knock["admin_port_is_being_opened"] + "...";
    }
}

IntalioZiKnock.prototype._showDialog = function (text, redirect) {

    this.pView = new DwtComposite(this.getShell());
    this.pView.setSize("250", "150");
    this.pView.getHtmlElement().style.overflow = "auto";

    this.pView.getHtmlElement().innerHTML = "<div id='timerText' style='text-align: center'>" + text + "</div><div id='timer' class='portKnockingTimer closed'>4</div>";

    // Timer
    var self = this;
    timer = setInterval(function () {
        handleTimer(self.pbDialog._contentDiv.id, self.pbDialog.getButton(DwtDialog.YES_BUTTON));
        // console.log("Timer odpalony")
    }, 1000);

    this.pbDialog = new ZmDialog({ title: "Intalio ZI-Knock", view: this.pView, parent: this.getShell(), standardButtons: [DwtDialog.DISMISS_BUTTON, DwtDialog.YES_BUTTON] });

    this.pbDialog.getButton(DwtDialog.DISMISS_BUTTON).setText(intalio_zi_knock["close"]);
    this.pbDialog.setButtonListener(DwtDialog.DISMISS_BUTTON, new AjxListener(this, function () {
        this.pbDialog.popdown();
    }));

    this.pbDialog.getButton(DwtDialog.YES_BUTTON).setText(intalio_zi_knock["go_to_the_admin_panel"]);
    this.pbDialog.getButton(DwtDialog.YES_BUTTON).setEnabled(false);
    this.pbDialog.setButtonListener(DwtDialog.DISMISS_BUTTON, new AjxListener(this, function () {
        this.pbDialog.popdown();
        count = 4;
    }));
    this.pbDialog.setButtonListener(DwtDialog.YES_BUTTON, new AjxListener(this, function () {
        this.pbDialog.popdown();
        count = 4;
        console.log(redirect);
        if (redirect) {

            window.open(window.location.protocol + "//" + window.location.host.split(":")[0] + ":7071", '_blank');
        }
    }));

    this.pbDialog.popup(); // pokazanie okna

};
IntalioZiKnock.prototype._createDialog = function (params) {
    params.parent = this.getShell();
    return new ZmDialog(params);
};

function knocking(ports, ip) {
    // let ports = ["7000", "7001", "7002"];
    var parsed_Ports = ports.split(",");
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
        for (var _iterator2 = parsed_Ports[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var port = _step2.value;

            console.log('Trying knock ' + ip + ' :: ' + port);
            axios.get('https://' + ip + ':' + port).catch(function (err) {
                console.log("Knock!");
            });
        }
    } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion2 && _iterator2.return) {
                _iterator2.return();
            }
        } finally {
            if (_didIteratorError2) {
                throw _iteratorError2;
            }
        }
    }
}
"use strict";
"use strict";