/**
This file is part of the imMail Zimlet
Copyright (C) 2015-2019  Rafael Menezes

Bugs and feedback: support@immail.com.br

**/

/**
* Defines the Zimlet handler class.
*/


var imUserAuthenticated = false;
var listButtonsAddMeetCalendar = [];

function ca_immail_HandlerObject() {
}

/**
* Makes the Zimlet class a subclass of ZmZimletBase.
*/
ca_immail_HandlerObject.prototype = new ZmZimletBase();
ca_immail_HandlerObject.prototype.constructor = ca_immail_HandlerObject;

var ZimbraImmailZimlet = ca_immail_HandlerObject;
var calendarTimeout = null;

/**
* This method gets called by the Zimlet framework when the zimlet loads.
*/
ZimbraImmailZimlet.prototype.init = function() {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  zimletInstance.iframeURL = zimletInstance._zimletContext.getConfig("iframeURL");
  zimletInstance.apiURL = zimletInstance._zimletContext.getConfig("apiURL");
  zimletInstance.appName = zimletInstance._zimletContext.getConfig("appName");
  zimletInstance.appDescription = zimletInstance._zimletContext.getConfig("appDescription");

  ZimbraImmailZimlet.prototype.setEventListeners();

  ZimbraImmailZimlet.prototype.sso();

};

/**
* This method gets called by the Zimlet framework when the application is opened for the first time.
*
* @param	{String}	appName		the application name
*/
ZimbraImmailZimlet.prototype.appLaunch = function(appName) {
  // console.log('opened for the first time...');
};

ZimbraImmailZimlet.prototype.sso = function() {
  try {
    var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
    var xhr = new XMLHttpRequest();
    xhr.open('GET', '/service/extension/immail?action=signOn');

    xhr.onerror = function (err) {
      console.error(err);
      return false;
    };

    xhr.send();
    xhr.onreadystatechange = function (oEvent) {
      if (xhr.readyState === 4) {
        if (xhr.status === 200) {
          var response = JSON.parse(xhr.response);
          zimletInstance.immailAuthToken = response.token;
          ZimbraImmailZimlet.prototype.loadIframe();

          return true;
        }

        ZimbraImmailZimlet.prototype.loadIframe();
      }
    }
  } catch (err) {
    console.log(err);
    return false;
  }
};

ZimbraImmailZimlet.prototype.loadIframe = function() {
  try {
    var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;

    if (zimletInstance.immailAuthToken) {
      var token = zimletInstance.immailAuthToken;
      var iframeURL = zimletInstance.iframeURL + '/v1/#!/login?token=' + token;
    } else {
      var iframeURL = zimletInstance.iframeURL;
    }

    zimletInstance.ZimbraImmailApp = zimletInstance.createApp(zimletInstance.appName, "", zimletInstance.appDescription);
    var app = appCtxt.getApp(zimletInstance.ZimbraImmailApp);

    var appPosition = document.getElementById('skin_container_app_new_button').getBoundingClientRect();
    app.setContent('<div id="ZimbraImmailFrameWrapper" style="position: fixed; top:' + appPosition.y + 'px; left:0; width:100%; height: calc(100vh - 71px); border:0px; display: none"><iframe id="ZimbraImmailFrame" style="z-index:2; left:0; width:100%; height:100%; border:0px;" src=\"'+ iframeURL +'\"></div>');

    Notification.requestPermission().then();
  } catch (err) { console.log (err)}

};

ZimbraImmailZimlet.prototype.appActive = function(appName, active) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  var ZimbraImmailFrameWrapper = document.getElementById("ZimbraImmailFrameWrapper");

  if (active) {
    ZimbraImmailFrameWrapper.style.display = "block";

    document.title = 'Zimbra: ' + 'imMail';
    //In the Zimbra tab hide the left menu bar that is displayed by default in Zimbra, also hide the mini calendar
    document.getElementById('z_sash').style.display = "none";
    //Users that click the tab directly after logging in, will still be served with the calendar, as it is normal
    //it takes some time to be displayed, so if that occurs, try to remove the calender again after 10 seconds.
    try {
      var cal = document.getElementsByClassName("DwtCalendar");
      var chat = document.getElementsByClassName("DwtBaseDialog");
      cal[0].style.display = "none";
      chat[0].style.display = "none";
    } catch (err) {
      calendarTimeout = setTimeout(
        function(){
          try {
            var cal = document.getElementsByClassName("DwtCalendar");
            var chat = document.getElementsByClassName("DwtBaseDialog");
            cal[0].style.display = "none";
            chat[0].style.display = "none";
          }
          catch(err){}
        }, 5000);
    }

    var app = appCtxt.getApp(zimletInstance.ZimbraImmailApp);

    var overview = app.getOverview(); // returns ZmOverview
    overview.setContent("&nbsp;");
    try {
      var child = document.getElementById(overview._htmlElId);
      child.parentNode.removeChild(child);
    } catch(err) {
      // already gone
    }
  } else {
    clearTimeout(calendarTimeout);

    ZimbraImmailFrameWrapper.style.display = "none";
    document.getElementById('z_sash').style.display = "block";
    try {
      var cal = document.getElementsByClassName("DwtCalendar");
      var chat = document.getElementsByClassName("DwtBaseDialog");
      cal[0].style.display = "block";
      chat[0].style.display = "block";
    } catch (err) { }
  }
};

ZimbraImmailZimlet.prototype.setEventListeners = function () {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  var iframeURL = zimletInstance.iframeURL;

  window.addEventListener('message', receiveMessage, false);

  function receiveMessage(event) {
    if (event.origin != iframeURL) {
      console.log('origin not match', iframeURL + ' - ' + event.origin);
      return false;
    }

    switch (event.data.type) {
      case 'unread-messages':
        if (event.data.count > 0) {
          var label = zimletInstance.appName + ' <b>(' + event.data.count + ')</b>';
        } else {
          var label = zimletInstance.appName;
        }

        ZimbraImmailZimlet.prototype.setTabLabel(label);
        break;
      case 'message-notification':
        var message = JSON.parse(event.data.message);
        var notification = new Notification(message.title, message);

        notification.onclick = function(event) {
          window.focus();
          appCtxt.getAppController().activateApp(zimletInstance.ZimbraImmailApp);

          var iframeElement = document.getElementById('ZimbraImmailFrame');
          var targetWindow = iframeElement.contentWindow;
          var src = iframeElement.src;
          targetWindow.postMessage({ type: 'load-conversation', conversationId: message.conversationId }, src);
        }
        break;
      case 'cb-meet-new':
        if(!!event.data.message) ZimbraImmailZimlet.prototype._insertUrlMeetInTheBody(event.data.message);
        break;
      case 'online-profile':
        ZimbraImmailZimlet.prototype._immailHandleUserStatusOnline(event.data.message);
        break;
      default:
        console.log('unknown event: ', event);
    }
  }
}

ZimbraImmailZimlet.prototype._immailHandleUserStatusOnline = function (userStatus) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;

  // update global variable of authenticated user status
  imUserAuthenticated = userStatus;

  var tooltipTextButton = userStatus
    ? zimletInstance.getMessage('VcCalendar_tooltip_button_enabled')
    : zimletInstance.getMessage('VcCalendar_tooltip_button_disabled');

  listButtonsAddMeetCalendar.forEach( function(element, index, array) {
    var btnItem = DwtControl.fromElementId(element);
    btnItem.setEnabled(userStatus);
    btnItem.setToolTipContent(tooltipTextButton);
  });
}

ZimbraImmailZimlet.prototype.setTabLabel = function (label) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;

  var controller = appCtxt.getAppController();
  var appChooser = controller.getAppChooser();

  var appButton = appChooser.getButton(zimletInstance.ZimbraImmailApp);
  appButton.setText(label);
};



/** This method is called when a message is viewed in Zimbra. 
 * See {@link https://files.zimbra.com/docs/zimlet/zcs/8.6.0/jsapi-zimbra-doc/symbols/ZmZimletBase.html#onMsgView}.
 * @param {ZmMailMsg} msg - an email in {@link https://files.zimbra.com/docs/zimlet/zcs/8.6.0/jsapi-zimbra-doc/symbols/ZmMailMsg.html ZmMailMsg} format
 * @param {ZmMailMsg} oldMsg - unused
 * @param {ZmMailMsgView} msgView - the current ZmMailMsgView (upstream documentation needed)
 * */
// ZimbraImmailZimlet.prototype.onMsgView = function (msg, oldMsg, msgView) {};

/** DwtControlmailZimlet.prototype.singleClicked = function() {
  alert('click');
  this.prefDialog();
};

/** 
 * This method gets called by the Zimlet framework when double-click is performed.
 */
// ZimbraImmailZimlet.prototype.doubleClicked = function() {
//   this.prefDialog();
// };


/** 
 * This method gets called by the Zimlet framework when double-click is performed.
 */
ZimbraImmailZimlet.prototype.onAction = function(type, action, currentViewId, lastViewId) {
  /*
    console.log(type);
    console.log(action);
    console.log(currentViewId);
    console.log(lastViewId);
    console.log(appCtxt.getCurrentView());
  */
};

/**
 * Check when appointment view is called
 */
ZimbraImmailZimlet.prototype.initializeToolbar = function(app, toolbar, controller, viewId) {
  if (appCtxt.getViewTypeFromId(viewId) != ZmId.VIEW_APPOINTMENT) return;
  this._initCalendarImmailVCButtonToolbar(toolbar, controller);
};

/**
 * Add button to Calendar toolbar
 * @param {*} toolbar 
 * @param {*} controller 
 */
ZimbraImmailZimlet.prototype._initCalendarImmailVCButtonToolbar = function (toolbar, controller) {

  if (toolbar.getButton("IMMAILVCBUTTON")) {
    var btnAddMeetImmail = toolbar.getButton("IMMAILVCBUTTON");
    btnAddMeetImmail.setEnabled(imUserAuthenticated, imUserAuthenticated);
    return;
  };

  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  var buttonIndex = toolbar.opList.length++;

  var params = {
    index:              buttonIndex,
    text:               this.getMessage('VcCalendar_text_button'),
    tooltip:            imUserAuthenticated ? this.getMessage('VcCalendar_tooltip_button_enabled') : this.getMessage('VcCalendar_tooltip_button_disabled'),
    image:              "ca_immail_panelIcon",
    className:          "ca_immail_vcButton",
    style:              "background-color: red",
    enabled:            imUserAuthenticated,
    showImageInToolbar: true,
    showTextInToolbar:  true,
  };

  var button = toolbar.createOp("IMMAILVCBUTTON", params);
  listButtonsAddMeetCalendar.push(button.__internalId);
  toolbar.addOp("IMMAILVCBUTTON", buttonIndex);
  button.addSelectionListener(new AjxListener(this, this._addMeetCalendarButtonHandler, [controller]));
}

/**
 * Request via postMessage an imMail Meet link
 */
ZimbraImmailZimlet.prototype._addMeetCalendarButtonHandler = function () {
  var iframeElement = document.getElementById('ZimbraImmailFrame');
  var targetWindow = iframeElement.contentWindow;
  targetWindow.postMessage({type: 'meet-new',}, iframeElement.src);
}

/**
 * Get immail meet link from api
 * @param {*} res 
 */
ZimbraImmailZimlet.prototype._getImmailVCLink = function (res) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;

  var xhr = new XMLHttpRequest();
  xhr.open("POST", zimletInstance.apiURL + '/v2/videoconference/private', true);
  xhr.setRequestHeader('authorization', 'Bearer ' + zimletInstance.immailAuthToken);
  xhr.send();
  xhr.onreadystatechange = function (oEvent) {  
    if (xhr.readyState === 4 && xhr.status === 201) {
      try {
        var data = JSON.parse(xhr.response);
        res({ link: zimletInstance.iframeURL + '/meet/' + data.name });
      } catch(err) {
        res({ err: err })
      }
    }
  }
}

ZimbraImmailZimlet.prototype._insertUrlMeetInTheBody = function (link) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  var currentContent = appCtxt.getCurrentController()._composeView.getHtmlEditor().getContent();
  var controller = appCtxt.getCurrentController();

  // Avoid insert the link twice
  var regexLinkMeet = new RegExp(zimletInstance.iframeURL + '/meet/[a-zA-Z0-9]{1,15}');
  if (regexLinkMeet.test(currentContent)) return;

  var currentContent = controller._composeView.getHtmlEditor().getContent();
  var message = zimletInstance.getMessage('VcCalendar_message_link');
  var editorType = controller._composeView.getComposeMode() != "text/html" ? "PLAIN_TEXT" : "HTML";
  var newContent = [];

  switch (editorType) {
    case 'PLAIN_TEXT':
      newContent.push(currentContent + '\r\n\r\n' + message.replace('[vclink]', link));
      break;
    case 'HTML':
      newContent.push(currentContent.substr(0, currentContent.lastIndexOf("</body></html>")));
      newContent.push(message
        .replace(/\r\n/g,'<br>')
        .replace('[vclink]','<a href="' + link + '" target="_blank">' + link + '</a>')
      );
      newContent.push("</body></html>");
      break;
    default: break;
  }

  controller._composeView.getHtmlEditor().setContent(newContent.join(""));
}
