/**
This file is part of the imMail Zimlet
Copyright (C) 2015-2019  Rafael Menezes

Bugs and feedback: support@immail.com.br

**/

/**
* Defines the Zimlet handler class.
*/
function ca_immail_HandlerObject() {
}

/**
* Makes the Zimlet class a subclass of ZmZimletBase.
*/
ca_immail_HandlerObject.prototype = new ZmZimletBase();
ca_immail_HandlerObject.prototype.constructor = ca_immail_HandlerObject;

var ZimbraImmailZimlet = ca_immail_HandlerObject;
var calendarTimeout = null;

/**
* This method gets called by the Zimlet framework when the zimlet loads.
*/
ZimbraImmailZimlet.prototype.init = function() {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  zimletInstance.iframeURL = zimletInstance._zimletContext.getConfig("iframeURL");
  zimletInstance.appName = zimletInstance._zimletContext.getConfig("appName");
  zimletInstance.appDescription = zimletInstance._zimletContext.getConfig("appDescription");

  ZimbraImmailZimlet.prototype.setEventListeners();

  ZimbraImmailZimlet.prototype.sso();

};

/**
* This method gets called by the Zimlet framework when the application is opened for the first time.
*
* @param	{String}	appName		the application name
*/
ZimbraImmailZimlet.prototype.appLaunch = function(appName) {
  console.log('opened for the first time...');
};

ZimbraImmailZimlet.prototype.sso = function() {
  try {
    var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
    var xhr = new XMLHttpRequest();
    xhr.open('GET', '/service/extension/immail?action=signOn');

    xhr.onerror = function (err) {
      console.log(err);
      return false;
    };

    xhr.send();
    xhr.onreadystatechange = function (oEvent) {
      if (xhr.readyState === 4) {
        if (xhr.status === 200) {
          var response = JSON.parse(xhr.response);
          zimletInstance.immailAuthToken = response.token;
          ZimbraImmailZimlet.prototype.loadIframe();

          return true;
        }

        ZimbraImmailZimlet.prototype.loadIframe();
      }
    }
  } catch (err) {
    console.log(err);
    return false;
  }
};

ZimbraImmailZimlet.prototype.loadIframe = function() {
  console.log('load iframe....');
  try {
    var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;

    if (zimletInstance.immailAuthToken) {
      var token = zimletInstance.immailAuthToken;
      var iframeURL = zimletInstance.iframeURL + '/v1/#!/login?token=' + token;
    } else {
      var iframeURL = zimletInstance.iframeURL;
    }

    zimletInstance.ZimbraImmailApp = zimletInstance.createApp(zimletInstance.appName, "", zimletInstance.appDescription);
    var app = appCtxt.getApp(zimletInstance.ZimbraImmailApp);

    var appPosition = document.getElementById('skin_container_app_new_button').getBoundingClientRect();
    app.setContent('<div id="ZimbraImmailFrameWrapper" style="position: relative; top:-36px; left:-273px; width:100vw; height: calc(100vh - 71px); border:0px; display: none"><iframe id="ZimbraImmailFrame" style="z-index:2; left:0; width:100%; height:100%; border:0px;" src=\"'+ iframeURL +'\"></div>');

    Notification.requestPermission().then();
  } catch (err) { console.log (err)}

};

ZimbraImmailZimlet.prototype.appActive = function(appName, active) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  var ZimbraImmailFrameWrapper = document.getElementById("ZimbraImmailFrameWrapper");

  if (active) {
    ZimbraImmailFrameWrapper.style.display = "block";

    document.title = 'Zimbra: ' + 'imMail';
    //In the Zimbra tab hide the left menu bar that is displayed by default in Zimbra, also hide the mini calendar
    document.getElementById('z_sash').style.display = "none";
    //Users that click the tab directly after logging in, will still be served with the calendar, as it is normal
    //it takes some time to be displayed, so if that occurs, try to remove the calender again after 10 seconds.
    try {
      var cal = document.getElementsByClassName("DwtCalendar");
      var chat = document.getElementsByClassName("DwtBaseDialog");
      cal[0].style.display = "none";
      chat[0].style.display = "none";
    } catch (err) {
      calendarTimeout = setTimeout(
        function(){
          try {
            var cal = document.getElementsByClassName("DwtCalendar");
            var chat = document.getElementsByClassName("DwtBaseDialog");
            cal[0].style.display = "none";
            chat[0].style.display = "none";
          }
          catch(err){}
        }, 5000);
    }

    var app = appCtxt.getApp(zimletInstance.ZimbraImmailApp);

    var overview = app.getOverview(); // returns ZmOverview
    overview.setContent("&nbsp;");
    try {
      var child = document.getElementById(overview._htmlElId);
      child.parentNode.removeChild(child);
    } catch(err) {
      // already gone
    }
  } else {
    clearTimeout(calendarTimeout);

    ZimbraImmailFrameWrapper.style.display = "none";
    document.getElementById('z_sash').style.display = "block";
    try {
      var cal = document.getElementsByClassName("DwtCalendar");
      var chat = document.getElementsByClassName("DwtBaseDialog");
      cal[0].style.display = "block";
      chat[0].style.display = "block";
    } catch (err) { }
  }
};

ZimbraImmailZimlet.prototype.setEventListeners = function() {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;
  var iframeURL = zimletInstance.iframeURL;

  window.addEventListener('message', receiveMessage, false);

  function receiveMessage(event) {
    if (event.origin != iframeURL) {
      console.log('origin not match', iframeURL + ' - ' + event.origin);
      return false;
    }

    switch (event.data.type) {
      case 'unread-messages':
        if (event.data.count > 0) {
          var label = zimletInstance.appName + ' <b>(' + event.data.count + ')</b>';
        } else {
          var label = zimletInstance.appName;
        }

        ZimbraImmailZimlet.prototype.setTabLabel(label);
        break;
      case 'message-notification':
        const message = JSON.parse(event.data.message);
        const notification = new Notification(message.title, message);

        notification.onclick = function(event) {
          window.focus();
          appCtxt.getAppController().activateApp(zimletInstance.ZimbraImmailApp);

          const iframeElement = document.getElementById('ZimbraImmailFrame');
          const targetWindow = iframeElement.contentWindow;
          const src = iframeElement.src;
          targetWindow.postMessage({ type: 'load-conversation', conversationId: message.conversationId }, src);
        }
        break;
      default:
        console.log('unknown event: ', event);
    }
  }
}

ZimbraImmailZimlet.prototype.setTabLabel = function(label) {
  var zimletInstance = appCtxt._zimletMgr.getZimletByName('ca_immail').handlerObject;

  var controller = appCtxt.getAppController();
  var appChooser = controller.getAppChooser();

  var appButton = appChooser.getButton(zimletInstance.ZimbraImmailApp);
  appButton.setText(label);
};
