/*
    This file is part of Inova Google Maps Zimlet (Inova Maps).

    Inova Maps is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Inova Maps is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Inova Maps.  If not, see <http://www.gnu.org/licenses/>.

        Authors:
                Bruno Santos, Inova Tecnologias Ltda.
                Marcelo Bezerra, Inova Tecnologias Ltda.

*/

function Net_Inova_GMaps() {
}

Net_Inova_GMaps.prototype = new ZmZimletBase();
Net_Inova_GMaps.prototype.constructor = Net_Inova_GMaps;

Net_Inova_GMaps.prototype.doDrop = function(zmObject, canvas) {
	if(zmObject) {
		var addr = null;
		if(zmObject.workStreet) {
			addr = zmObject.workStreet;
			if(zmObject.workCity) {
				addr += ", "+zmObject.workCity;
			}
			if(zmObject.workState) {
				addr += ", "+zmObject.workState;
			}
			if(zmObject.workCountry) {
				addr += ", "+zmObject.workCountry;
			}
			if(zmObject.workPostalCode) {
				addr += ", "+zmObject.workPostalCode;
			}
		} else if(zmObject.homeStreet) {
			addr = zmObject.homeStreet;
			if(zmObject.homeCity) {
				addr += ", "+zmObject.homeCity;
			}
			if(zmObject.homeState) {
				addr += ", "+zmObject.homeState;
			}
			if(zmObject.homeCountry) {
				addr += ", "+zmObject.homeCountry;
			}
			if(zmObject.homePostalCode) {
				addr += ", "+zmObject.homePostalCode;
			}
		} else if(zmObject.otherStreet) {
			addr = zmObject.otherStreet;
			if(zmObject.otherCity) {
				addr += ", "+zmObject.otherCity;
			}
			if(zmObject.otherState) {
				addr += ", "+zmObject.otherState;
			}
			if(zmObject.otherCountry) {
				addr += ", "+zmObject.otherCountry;
			}
			if(zmObject.otherPostalCode) {
				addr += ", "+zmObject.otherPostalCode;
			}
		}
		if(addr != null) {
			var win = window.open("http://maps.google.com/maps?q="+encodeURI(addr), null, "width=640,height=480,scrollbars=1,toolbar=1,resizable=1,status=1,menubar=1,location=1"); 
		}
	}
}

Net_Inova_GMaps.prototype.toolTipPoppedUp = function(spanElement, contentObjText, matchContext, canvas) {
	if(canvas != null) {
		var id = ZmZimletBase.encodeId(contentObjText);
		canvas.innerHTML = "<iframe frameborder=\"0\" style=\"width:345px;height:245px\" id=\""+id+"\" src=\"" +
			this.getResource('map_frame.jsp')+'?addr='+
			encodeURI(matchContext[1])+
			"\"></iframe>";
		if(window.console) {
			console.log("GMaps: addr="+encodeURI(matchContext[1]) );
		}
	}
}

Net_Inova_GMaps.prototype.match = function(content, startIndex) {
	var ret = null;
	var regexps = new Array();
// Regex Brasil #1
	regexps[0] = new RegExp("\\b((Aeroporto|Alameda|Al|Área|Avenida|Av|Campo|Chácara|Colônia|Condomínio|Conjunto|Cj|Distrito|Esplanada|Estação|Estrada|Favela|Fazenda|Feira|Jardim|Ladeira|Lago|Lg|Lagoa|Largo|Loteamento|Lot|Morro|Núcleo|Parque|Passarela|Pátio|Praça|Pç|Quadra|Qd|Recanto|Residencial|Res|Rodovia|Rua|R|Setor|Sítio|Travessa|Trecho|Trevo|Vale|Vereda|Via|Viaduto|Viela|Vila)(\\.\\s|\\s)[^.]+)", "gim");
// Regex CEP Brasil
	regexps[1] = new RegExp("\\b(\\d{5}-\\d{3})\\b", "gim");
// Regex USA
	regexps[2] = new RegExp("(\\b\\d+[A-Za-z]?[ ]+([ewns]\\.?[ ]+)?[A-Za-z0-9]+([ ]+[A-Za-z0-9]+)*[\\s,\\.](\\s*(\\#|[A-Za-z]+[,\\.]?)[ ]*\\d+[\\s,\\.])?\\s*[A-Za-z]+([ ]+[A-Za-z]+)*[ ,][ ]*[A-Za-z]{2}([A-Za-z]+([ ][A-Za-z]+)?)?[ ]+\\d{5}(-\\d{4})?\\b)", "gim");

	var i;

	for(i=0;(i < regexps.length) && (ret == null);i++) {
		this.RE = regexps[i];
		this.RE.lastIndex = startIndex;
		ret = regexps[i].exec(content);
		// noop
		if(ret != null) {
			ret.context = ret;
			if(window.console) {
				console.log("GMaps: matched regexps["+i+"]: "+content);
			}
			break;
		}
	}

	if(ret!=null) {
		if(window.console) {
			console.log("GMaps: match: "+content+" = "+(ret != null? "true":"false"));
		}
	}

	return ret;
}


Net_Inova_GMaps.prototype.doubleClicked = function() {
	this.doubleClicked();
}

Net_Inova_GMaps.prototype.singleClicked = function() {
	var formProp = [
		{
			label : this.getMessage("dialogAddrLabel"),
			name : "addr",
			type : "string",
			minLength : 3,
			maxLength : 999
		}
	];

	if (!this._dlg_propertyEditor) {
		var view = new DwtComposite(this.getShell());
		this._propertyEditor = new DwtPropertyEditor(view, true);
		var pe = this._propertyEditor;
		pe.initProperties(formProp);
		var dialog_args = {
			title : this.getMessage("dialogTitle"),
			view  : view
		};
		this._dlg_propertyEditor = this._createDialog(dialog_args);
		var dlg = this._dlg_propertyEditor;
		pe.setFixedLabelWidth();
		pe.setFixedFieldWidth();
		dlg.setButtonListener(
				DwtDialog.OK_BUTTON,
				new AjxListener(this,
					function() {
						if (!pe.validateData()) {
							return;
						}
						this.doAddrSearch();
					}
				)
		);
	}
	this._dlg_propertyEditor.popup();
}

Net_Inova_GMaps.prototype.doAddrSearch = function() {
        this._dlg_propertyEditor.popdown();
	var win = window.open("http://maps.google.com/maps?q="+encodeURI(this._propertyEditor.getProperties().addr), null, "width=800,height=580,scrollbars=1,toolbar=1,resizable=1,status=1,menubar=1,location=1"); 
        this._dlg_propertyEditor.dispose();
        this._dlg_propertyEditor = null;
};
