<%--
    This file is part of Inova Google Maps Zimlet (Inova Maps).

    Inova Maps is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Inova Maps is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Inova Maps.  If not, see <http://www.gnu.org/licenses/>.

        Authors:
                Bruno Santos, Inova Tecnologias Ltda.
                Marcelo Bezerra, Inova Tecnologias Ltda.
--%>
<%@ page import="java.util.*,java.net.*,java.io.*,java.sql.*,javax.sql.*" %>
<%@ taglib uri="/WEB-INF/zimbra.tld" prefix="z" %>
<z:zimletconfig zimlet="net_inova_gmaps" action="list" var="conf"/>
<%

String base = "http://maps.google.com/maps?file=api&v=2&key=";
String dbuser = null;
String dbpass = null;
String dbname = null;
String dbhost = null;
String key = null;
String baseCountry = null;
String markerIcon = "http://maps.google.com/intl/en_ALL/mapfiles/marker.png";
String markerIconW = "20";
String markerIconH = "34";
String markerIconAnchorX = "9";
String markerIconAnchorY = "34";

//Map conf = (Map) request.getAttribute("conf");
Map conf = (Map) pageContext.getRequest().getAttribute("conf");
if(conf != null) {
	Map gconf = (Map) conf.get("global");
	Map lconf = (Map) conf.get("local");
	if(gconf != null) {
		dbuser = (String) gconf.get("dbuser");
		dbpass = (String) gconf.get("dbpass");
		dbname = (String) gconf.get("dbname");
		dbhost = (String) gconf.get("dbhost");
		baseCountry = (String) gconf.get("baseCountry");
		markerIcon = (String) gconf.get("markerIcon");
		markerIconH = (String) gconf.get("markerIconH");
		markerIconW = (String) gconf.get("markerIconW");
		markerIconAnchorX = (String) gconf.get("markerIconAnchorX");
		markerIconAnchorY = (String) gconf.get("markerIconAnchorY");
	} else {
		out.println("// gconf == null");
	}
} else {
	out.println("// conf == null");
}

dbuser = (dbuser != null) ? dbuser : "inovamaps";
dbpass = (dbpass != null) ? dbpass : "inovamaps";
dbname = (dbname != null) ? dbname : "inovamaps";
dbhost = (dbhost != null) ? dbhost : "h166.sp.inova.com.br";
baseCountry = (baseCountry != null) ? baseCountry : "br";
markerIcon = (markerIcon != null) ? markerIcon : "http://maps.google.com/intl/en_ALL/mapfiles/marker.png";
markerIconH = (markerIconH != null) ? markerIconH : "34";
markerIconW = (markerIconW != null) ? markerIconW : "20";
markerIconAnchorX = (markerIconAnchorX != null) ? markerIconAnchorX : "9";
markerIconAnchorY = (markerIconAnchorY != null) ? markerIconAnchorY : "34";

Connection conn = null;
PreparedStatement sth = null;
ResultSet res = null;
try {
	String dsn = "jdbc:mysql://"+dbhost+"/"+dbname;
	System.out.println("dsn: "+dsn);
	Class.forName ("com.mysql.jdbc.Driver").newInstance ();
	conn = DriverManager.getConnection (dsn, dbuser, dbpass);
	System.out.println ("Database connection established");
	sth = conn.prepareStatement("SELECT apiKey FROM keymap WHERE host = ?");
	sth.setString(1, request.getServerName());
	res = sth.executeQuery();

	while(res.next()) {
		if(res != null) {
			key = res.getString(1);
		}
	}

	res.close();
	sth.close();

} catch(Exception e) {
	System.out.println(e);
} finally {
	if(res != null) {
		try {
			res.close();
		} catch(Exception e) {}
	}
	if(sth != null) {
		try {
			sth.close();
		} catch(Exception e) {}
	}
	if(conn != null) {
		try {
			conn.close();
		} catch(Exception e) {}
	}
}
%>
<html>
<head>
<%
	if(key != null) {
		out.println("<script type=\"text/javascript\" src=\""+base+key+"\"></script>");
	}
%>
<script type="text/javascript">
var map;
function api_key_not_found() {
	var div = document.getElementById("map");
	div.innerHTML = "Google Maps API key for <%= request.getServerName() %> not found!";
}

function net_inova_gmaps_showmap() {
	if (GBrowserIsCompatible()) {

		var client = new GClientGeocoder();
		client.setBaseCountryCode("<%= baseCountry %>");
		client.getLatLng("<%= request.getParameter("addr") %>", geocoderCallback);


		var lat = <%= request.getParameter("lat") %>;
		var lng = <%= request.getParameter("lng") %>;
		var point = new GLatLng(lat, lng);

		map = new GMap2(document.getElementById("map"));
		map.setCenter(point, 16);
		var customIcon = new GIcon(G_DEFAULT_ICON);
		customIcon.image = "<%= markerIcon %>";
		customIcon.iconSize = new GSize(<%= markerIconW %>, <%= markerIconH %>);
		customIcon.iconAnchor = new GPoint(<%= markerIconAnchorX %>, <%= markerIconAnchorY %>);
		customIcon.shadow = null;
		var marker = new GMarker(point, {icon:customIcon});
		map.addOverlay(marker);
	}
}

function net_inova_gmaps_showmap_lat_lng() {
	if (GBrowserIsCompatible()) {

		var lat = "<%= request.getParameter("lat") %>";
		var lng = "<%= request.getParameter("lng") %>";
		var point = new GLatLng(lat, lng);
		map = new GMap2(document.getElementById("map"));
		map.setCenter(point, 16);
		var customIcon = new GIcon(G_DEFAULT_ICON);
		customIcon.image = "<%= markerIcon %>";
		customIcon.iconSize = new GSize(<%= markerIconW %>, <%= markerIconH %>);
		customIcon.iconAnchor = new GPoint(<%= markerIconAnchorX %>, <%= markerIconAnchorY %>);
		customIcon.shadow = null;
		var marker = new GMarker(point, {icon:customIcon});
		map.addOverlay(marker);
	}
}

function geocoderCallback(latLng) {
	if(latLng != null) {
		if(map) {
			map.setCenter(latLng, 16);
			var customIcon = new GIcon(G_DEFAULT_ICON);
			customIcon.image = "<%= markerIcon %>";
			customIcon.iconSize = new GSize(<%= markerIconW %>, <%= markerIconH %>);
			customIcon.iconAnchor = new GPoint(<%= markerIconAnchorX %>, <%= markerIconAnchorY %>);
			customIcon.shadow = null;
			var marker = new GMarker(latLng, {icon:customIcon});
			map.addOverlay(marker);
		}
	}
}
</script>
</head>
<%
String func = "net_inova_gmaps_showmap()";
if(key == null) {
	func = "api_key_not_found()";
} else if(request.getParameter("addr") == null) {
	func = "net_inova_gmaps_showmap_lat_lng()";
}
%>
<body onload="<%= func %>" onunload="GUnload()" style="margin: 0px 0px 0px 0px">
<div style="width:345px;height:245px" id="map">
	<img width="345" heigth="245" src="blank_pixel.gif" />
</div>
</div>
</div>
</body>
</html>
