
//////////////////////////////////////////////////////////////
//  Resource Admin Zimlet                                   //
//  Wayne State University (http://wayne.edu)               //
//  @author Robert Thompson                                 //
//////////////////////////////////////////////////////////////

function Com_Zimbra_Resourceadmin() {
};

//Com_Zimbra_Resourceadmin.CACHE = new Array();
Com_Zimbra_Resourceadmin.URL = "/service/zimlet/com_zimbra_resourceadmin/com_zimbra_resourceadmin.jsp";

Com_Zimbra_Resourceadmin.prototype = new ZmZimletBase;
Com_Zimbra_Resourceadmin.prototype.constructor = Com_Zimbra_Resourceadmin;
Com_Zimbra_Resourceadmin.prototype.toString =
function() {
        return "Com_Zimbra_Resourceadmin";
};

Com_Zimbra_Resourceadmin.prototype.getUsername =
function() {
return appCtxt.get(ZmSetting.USERNAME);
};

Com_Zimbra_Resourceadmin.prototype.init = function() {
	(new Image()).src = this.getResource('blank_pixel.gif');
	if (ZmAssistant && ZmAssistant.register) ZmAssistant.register(new Com_Zimbra_Resourceadmin_Asst());
};

function Com_Zimbra_Resourceadmin_Asst() {
	ZmAssistant.call(this, "Admin Resources", "map", "And what is this too?");
};

Com_Zimbra_Resourceadmin_Asst.prototype.handle =
function(dialog, verb, args) {
	this._address = args;
	var valid = args.length > 0;
	dialog._setOkButton("Map", true, valid);
};

Com_Zimbra_Resourceadmin_Asst.prototype.okHandler =
function(dialog) {
	// get reference to the ymaps zimlet
	var zm = appCtxt.getZimletMgr();
	var zimlet = zm ? zm._ZIMLETS_BY_ID["com_zimbra_resourceadmin"] : null;
	if (zimlet && this._address) {
		zimlet.handlerObject.toolTipPoppedUp(null, this._address, null, dialog.getAssistantDiv());
	}
	return false;
};

Com_Zimbra_Resourceadmin.prototype.toolTipPoppedUp =
function(spanElement, args, context, canvas) {
	canvas.innerHTML = '<div style="width:300px;height:100px;" id="results">Loading...</div>';	
	var url = Com_Zimbra_Resourceadmin.URL + "?" + args;
	DBG.println(AjxDebug.DBG2, "Com_Zimbra_Resourceadmin URL: " + url);
	AjxRpc.invoke(null, url, null, new AjxCallback(this, Com_Zimbra_Resourceadmin._callback, "results"), true);		
};

Com_Zimbra_Resourceadmin._callback = 
function(obj, result) {
	var r = result.text;
	var errorstart = r.search(/HTTP ERROR: 500/);
	if (errorstart > 0)
	   {
	   var prestart = r.search(/<pre>/);
	   var preend = r.search(/<\/pre>/);
    r = "<b>Error: </b>" + result.text.substring(prestart + 5, preend);
    }
 Com_Zimbra_Resourceadmin._displayText(r,obj);
};

Com_Zimbra_Resourceadmin._displayText = 
function(r, obj) {
	var divEl = document.getElementById(ZmZimletBase.encodeId(obj));
	divEl.innerHTML = r;
};

Com_Zimbra_Resourceadmin.prototype.menuItemSelected =
function(itemId) {
        switch (itemId) {
                case "ADD_EQUIPMENT":    this.add_equipment();              break;
                case "ADD_LOCATION":     this.add_location();               break;
                case "DELETE_RESOURCE":  this.delete_resource();            break;
                case "ABOUT":            this.about();                      break;
                default:                 alert("no function");              break;
        }
};

// Popup box for the Add Equipment Dialog
Com_Zimbra_Resourceadmin.prototype.add_equipment = function() {
	var editorProps = [
		{ label 		       : "Equipment Name",
		  name           : "equipment_name",
		  type           : "string",
		  value          : "",
		  minLength      : 3,
		  maxLength      : 40
		},
		{ label 		       : "Description",
		  name           : "equipment_description",
		  type           : "string",
		  value          : "",
		  minLength      : 3,
		  maxLength      : 40
		}
		];
	if (!this._dlg_propertyEditor1) {
		var view1 = new DwtComposite(this.getShell());
		this._propertyEditor1 = new DwtPropertyEditor(view1, true);
		var pe1 = this._propertyEditor1;
		pe1.initProperties(editorProps);
		var dialog_args = {
			title : "Add Equipment Resource",
			view  : view1
		};
		this._dlg_propertyEditor1 = this._createDialog(dialog_args);
		var dlg1 = this._dlg_propertyEditor1;
		pe1.setFixedLabelWidth();
		pe1.setFixedFieldWidth();
		dlg1.setButtonListener(DwtDialog.OK_BUTTON,
				      new AjxListener(this, function() {
				          if (!pe1.validateData()) {return;}
					      this._do_add_equipment();
				      }));
	}
	this._dlg_propertyEditor1.popup();
};

// Popup box for the Add Location Dialog
Com_Zimbra_Resourceadmin.prototype.add_location = function() {
	var editorProps = [
		{ label 		       : "Location Name",
		  name           : "location_name",
		  type           : "string",
		  value          : "",
		  minLength      : 3,
		  maxLength      : 40
		},
		{ label 		       : "Description",
		  name           : "location_description",
		  type           : "string",
		  value          : "",
		  minLength      : 3,
		  maxLength      : 40
		}
		];
	if (!this._dlg_propertyEditor3) {
		var view3 = new DwtComposite(this.getShell());
		this._propertyEditor3 = new DwtPropertyEditor(view3, true);
		var pe1 = this._propertyEditor3;
		pe1.initProperties(editorProps);
		var dialog_args = {
			title : "Add Location Resource",
			view  : view3
		};
		this._dlg_propertyEditor3 = this._createDialog(dialog_args);
		var dlg1 = this._dlg_propertyEditor3;
		pe1.setFixedLabelWidth();
		pe1.setFixedFieldWidth();
		dlg1.setButtonListener(DwtDialog.OK_BUTTON,
				      new AjxListener(this, function() {
				          if (!pe1.validateData()) {return;}
					      this._do_add_location();
				      }));
	}
	this._dlg_propertyEditor3.popup();
};

Com_Zimbra_Resourceadmin._parsemycals =
function(result) {
  	 var raw = result.text;
    // Need to dynamically generate a list of checkboxes from some SOAP data here
   	this._parentView = new DwtComposite(this.getShell());   	
   	raw2 = raw.split("||");   	
   	mycals = [];   	
    for (var i=0;i<raw2.length -1;i++)
   	    {
   	    var raw3 = raw2[i].split("|");
   	    var thisvalue = "'" + raw3[0] + "'";
   	    var thislabel = "'" + raw3[1] + "'";   	          
     	  mycals.push( { value: escape(raw3[0]), label: escape(raw3[1]) } );               	    
        }
            
    this._resources = mycals;           
   
   	var selectId = Dwt.getNextId();   
   	var div = document.createElement("div");
   	var html = [];
   	var i = 0;
   	html[i++] = "<table border=0 width=100%><tr>";
   	html[i++] = "<td width=100% id='";
   	html[i++] = selectId;
   	html[i++] = "'></td></tr></table>";
   	div.innerHTML = html.join("");
   	this._parentView.getHtmlElement().appendChild(div);
   
   	this._langSelect = new DwtSelect(this._parentView);
   	this._langSelect.reparentHtmlElement(selectId);
   	for (i = 0; i < this._resources.length; i++) {
   		var option = this._resources[i];
   		this._langSelect.addOption(option.label, i==0, option.value);
     	}
   
   	this._g = this._createDialog({title:"Select Resource to Delete", view:this._parentView});
   	this._g.setButtonListener(DwtDialog.OK_BUTTON, new AjxListener(this, this._deleteOKListener));
    this._g.popup(); 	
};

// delete OKListener event
Com_Zimbra_Resourceadmin.prototype._deleteOKListener = function() {
  	//this._dlg_propertyEditor3.popdown();
  	//var urlargs = "action=add_location&" + 
  	//              "name=" + this._propertyEditor3.getProperties().location_name + "&" +
  	//              "desc=" + this._propertyEditor3.getProperties().location_description + "&" +
  	//              "prohibitrecurring=" + this._propertyEditor3.getProperties().equipment_prohibitrecurring;  	
  	//this._displaySearchResult_add_equipment(urlargs);
  	//this._dlg_propertyEditor3.dispose();
  	//this._dlg_propertyEditor3 = null;
	  this._g.popdown();	  	  
   var urlargs = "action=delcal&calid=" + this._langSelect.getValue();
   this._showdelete(urlargs);
   this._g.dispose();
   this._langSelect.dispose();
   this._g = null;
             
	  //AjxRpc.invoke(null, url, null, new AjxCallback(this, Com_Zimbra_Resourceadmin._showdelete2), true);          		
};

// Popup box for the Delete Resource Dialog
Com_Zimbra_Resourceadmin.prototype.delete_resource = function() {
  	var url = "/service/zimlet/com_zimbra_resourceadmin/com_zimbra_resourceadmin.jsp?action=getmine";
	  AjxRpc.invoke(null, url, null, new AjxCallback(this, Com_Zimbra_Resourceadmin._parsemycals), true);        		
};

// Popup box for the About Dialog
Com_Zimbra_Resourceadmin.prototype.about = function() {
	
 var editorProps = [];
	if (!this._dlg_propertyEditor2) 
    {
  		var view2 = new DwtComposite(this.getShell());
  		this._propertyEditor2 = new DwtPropertyEditor(view2, true);
  		var pe2 = this._propertyEditor2;
  		pe2.initProperties(editorProps);
  		var dialog_args = {
    			title : "About",
    			view  : view2
  		   };
  
  		this._dlg_propertyEditor2 = this._createDialog(dialog_args);
  		var dlg2 = this._dlg_propertyEditor2;
  		pe2.setFixedLabelWidth();
  		pe2.setFixedFieldWidth();
  	 this._do_about();
	   }
	 else
	   {
	   this._do_about();
	   }
};

// Action for add equipment dialog
Com_Zimbra_Resourceadmin.prototype._do_add_equipment =
function() {
	this._dlg_propertyEditor1.popdown();
	var urlargs = "action=add_equipment&" + 
	              "name=" + this._propertyEditor1.getProperties().equipment_name + "&" +
	              "desc=" + this._propertyEditor1.getProperties().equipment_description + "&" +
	              "allowoverlap=" + this._propertyEditor1.getProperties().equipment_allowoverlap + "&" +
	              "prohibitrecurring=" + this._propertyEditor1.getProperties().equipment_prohibitrecurring;  	
	this._displaySearchResult_add_equipment(urlargs);
	this._dlg_propertyEditor1.dispose();
	this._dlg_propertyEditor1 = null;
};

// Action for add location dialog
Com_Zimbra_Resourceadmin.prototype._do_add_location =
function() {
	this._dlg_propertyEditor3.popdown();
	var urlargs = "action=add_location&" + 
	              "name=" + this._propertyEditor3.getProperties().location_name + "&" +
	              "desc=" + this._propertyEditor3.getProperties().location_description + "&" +
	              "prohibitrecurring=" + this._propertyEditor3.getProperties().equipment_prohibitrecurring;  	
	this._displaySearchResult_add_equipment(urlargs);
	this._dlg_propertyEditor3.dispose();
	this._dlg_propertyEditor3 = null;
};

// Action for About dialog
Com_Zimbra_Resourceadmin.prototype._do_about =
function() {
	var urlargs = "action=about";
	this._displaySearchResult_about(urlargs);	
};

// Display result of action: add_equipment
Com_Zimbra_Resourceadmin.prototype._displaySearchResult_add_equipment = 
function(args) {
	var view1 = new DwtComposite(this.getShell());
	var dialog_args = {
		view  : view1,
		title : "Resource Action Result"
	};
	var dlg1 = this._createDialog(dialog_args);
	dlg1.popup();
	dlg1.setButtonListener(DwtDialog.OK_BUTTON,
		      new AjxListener(this, function() {
			      dlg1.popdown();
			      dlg1.dispose();
		      }));
	dlg1.setButtonListener(DwtDialog.CANCEL_BUTTON,
		      new AjxListener(this, function() {
			      dlg1.popdown();
			      dlg1.dispose();
		      }));
    var el1 = view1.getHtmlElement();
    var div1 = document.createElement("div");
    el1.appendChild(div1);
    this.toolTipPoppedUp(null, args, null, div1);
};

// Display result of action: add_location
Com_Zimbra_Resourceadmin.prototype._displaySearchResult_add_location = 
function(args) {
	var view1 = new DwtComposite(this.getShell());
	var dialog_args = {
		view  : view1,
		title : "Location Action Result"
	};
	var dlg1 = this._createDialog(dialog_args);
	dlg1.popup();
	dlg1.setButtonListener(DwtDialog.OK_BUTTON,
		      new AjxListener(this, function() {
			      dlg1.popdown();
			      dlg1.dispose();
		      }));
	dlg1.setButtonListener(DwtDialog.CANCEL_BUTTON,
		      new AjxListener(this, function() {
			      dlg1.popdown();
			      dlg1.dispose();
		      }));
    var el1 = view1.getHtmlElement();
    var div1 = document.createElement("div");
    el1.appendChild(div1);
    this.toolTipPoppedUp(null, args, null, div1);
};

// Display result of action: delete resource
Com_Zimbra_Resourceadmin.prototype._showdelete =                                    
function(args) {
	var view7 = new DwtComposite(this.getShell());
	var dialog_args = {
  		view  : view7,
  		title : "Delete Action Result"
  	};
	var dlg7 = this._createDialog(dialog_args);
	dlg7.popup();
	dlg7.setButtonListener(DwtDialog.OK_BUTTON,
		      new AjxListener(this, function() {
			      dlg7.popdown();
			      dlg7.dispose();
		      }));
	dlg7.setButtonListener(DwtDialog.CANCEL_BUTTON,
		      new AjxListener(this, function() {
			      dlg7.popdown();
			      dlg7.dispose();
		      }));
    var el7 = view7.getHtmlElement();
    var div7 = document.createElement("div");
    el7.appendChild(div7);
    this.toolTipPoppedUp(null, args, null, div7);
};


// Display result of action: about
Com_Zimbra_Resourceadmin.prototype._displaySearchResult_about = 
function(args) {
	var view2 = new DwtComposite(this.getShell());
	var dialog_args = {
  		view  : view2,
  		title : "About"
  	 };
	var dlg2 = this._createDialog(dialog_args);
	dlg2.popup();
	dlg2.setButtonListener(DwtDialog.OK_BUTTON,
		      new AjxListener(this, function() {
			      dlg2.popdown();
			      dlg2.dispose();
		      }));
    var el2 = view2.getHtmlElement();
    var div2 = document.createElement("div");
    el2.appendChild(div2);
    this.toolTipPoppedUp(null, args, null, div2);
};