<%@ page import="com.zimbra.cs.account.soap.*" %>
<%@ page import="com.zimbra.common.soap.*" %>
<%@ page import="com.zimbra.common.soap.Element.XMLElement" %>
<%@ page import="com.zimbra.common.service.ServiceException" %>
<%@ page import="java.util.regex.*" %>
<%
response.setHeader("Pragma", "no-cache");
response.setHeader("Cache-Control", "no-store");
response.setHeader("Expires", "0");
//
// Resource Admin Zimlet
// Wayne State University
// Author: Rob Thompson
// Version: 0.2
//
// ** about: com_zimbra_resourceadmin.jsp **
// -----------------------------------------
// This file performs the actions necessary to support the resourceadmin zimlet.  It performs resource calendar
// creations, resource calendar deletions and gets information about current calendars.  Also, this file
// keeps track of who "owns" calendars by appending the username before the calendarname.  Users are only
// permitted to delete calendars that start with their username.
//
// Resource calendar creation requires administrator privileges, which must be entered in the config area below 
// for user-based calendar management to work through the zimlet.  A user with at least domain administration 
// rights is required.  The special permissions granted to this script are NOT shared with the user that calls it.
//
// If you only want certain users to be able to create resources via this tool, create a class-of-service for 
// those users who have access to this zimlet.
// 
// ******** CONFIG AREA ********
// A user with at least domain-admin privs is necessary to create calendars.
// -------------------------------------------------------------------------
String adminuser = "";
String adminpassword = "";
// Generally, the below settings should be fine, but change them if you need to.
// ------------------------------------------------------------------------------
// Standard SOAP URL on the local host
String soapurl = "https://127.0.0.1/service/soap/";
// Admin SOAP URL on the local host
String adminsoapurl = "https://127.0.0.1:7071/service/admin/soap/";
// ******** END CONFIG AREA *********

Cookie cookies[] = request.getCookies();
if (cookies != null)
   {
   String authcookie = null;
   for (int i = 0; i < cookies.length; i++) 
      {
      if (cookies[i].getName().equals("ZM_AUTH_TOKEN"))
         {                  
         authcookie = cookies[i].getValue();
         }
      }
   if (authcookie != null)
      {      
      if (authcookie.length() > 0)
         {
         // Get the user attached to this authcookie         
         SoapHttpTransport trans = null;
         trans = new SoapHttpTransport(soapurl);
         trans.setAuthToken(authcookie);
         Element trequest = Element.XMLElement.mFactory.createElement("GetInfoRequest").addAttribute("xmlns", "urn:zimbraAccount");                
         Element tresponse = trans.invoke(trequest);
         String user = tresponse.getElement("name").toString();
            
         CharSequence inputStr = user;
         String patternStr = "<name>(\\S+)@(\\S+)<";
         Pattern pattern = Pattern.compile(patternStr);
         Matcher matcher = pattern.matcher(inputStr);
         boolean matchFound = matcher.find();
         String uuid = null;
         String thisserver = null;
         if (matchFound) 
            {
            uuid = matcher.group(1);
            thisserver = matcher.group(2);
            }
         
         if (user != null)
            {      
            if (request.getParameter("action") == null) 
                {
                out.println("<b>Error:</b> Missing action URL parameter<br>");
                } 
            else 
                {                                                 
                // Authenticate as the admin user
                SoapProvisioning sp = new SoapProvisioning();
                sp.soapSetURI(adminsoapurl);                      
                sp.soapAdminAuthenticate(adminuser,adminpassword);       
                SoapHttpTransport soapHttpTransport = new SoapHttpTransport(sp.soapGetURI());
                soapHttpTransport.setAuthToken(sp.getAuthToken());
                
                if (request.getParameter("action").equals("add_equipment"))
                   {
                   out.println("<b>Add Equipment Resource</b><br>");
                   if (request.getParameter("name") != null)
                      {                      
                      String resname = uuid.concat("_").concat(request.getParameter("name")).replace(" ","_");
                             
                      XMLElement req = new XMLElement("CreateCalendarResourceRequest");
                      req.addAttribute("xmlns", "urn:zimbraAdmin");                      
                      Element name = req.addElement("name").setText(resname.concat("@").concat(thisserver));                      
                      
                      //Generate a reandom password for this calendar
                      int n1 = 30;
                      char[] pw1 = new char[n1];
                      int c1  = 'A';
                      int r11 = 0;
                      for (int i1=0; i1 < n1; i1++) {
                        r11 = (int)(Math.random() * 3);
                        switch(r11) {
                          case 0: c1 = '0' +  (int)(Math.random() * 10); break;
                          case 1: c1 = 'a' +  (int)(Math.random() * 26); break;
                          case 2: c1 = 'A' +  (int)(Math.random() * 26); break; }
                        pw1[i1] = (char)c1; }
                      
                      Element pass = req.addElement("password").setText(pw1.toString());
                      req.addElement("a").addAttribute("n","displayName").setText(request.getParameter("name"));
                      req.addElement("a").addAttribute("n","zimbraCalResType").setText("Equipment");                                            
                                                    
                      Element tagsResponse = soapHttpTransport.invoke(req);
                      out.println("Created: ".concat(resname));                      
                      }
                   else
                      {
                      out.println("<b>Error:</b> No name given for equipment<br>");                      
                      }
                   }
                else if (request.getParameter("action").equals("add_location"))
                   {
                   out.println("<b>Add Location Resource</b><br>");
                   if (request.getParameter("name") != null)
                      {                      
                      String thislocresname = uuid.concat("_").concat(request.getParameter("name")).replace(" ","_");                             
                      XMLElement req = new XMLElement("CreateCalendarResourceRequest");
                      req.addAttribute("xmlns", "urn:zimbraAdmin");                      
                      Element thislocname = req.addElement("name").setText(thislocresname.concat("@").concat(thisserver));

                      //Generate a reandom password for this calendar
                      int n2 = 30;
                      char[] pw2 = new char[n2];
                      int c2  = 'A';
                      int r12 = 0;
                      for (int i2=0; i2 < n2; i2++) {
                        r12 = (int)(Math.random() * 3);
                        switch(r12) {
                          case 0: c2 = '0' +  (int)(Math.random() * 10); break;
                          case 1: c2 = 'a' +  (int)(Math.random() * 26); break;
                          case 2: c2 = 'A' +  (int)(Math.random() * 26); break; }
                        pw2[i2] = (char)c2; }
                        
                      Element pass = req.addElement("password").setText(pw2.toString());
                      req.addElement("a").addAttribute("n","displayName").setText(request.getParameter("name"));
                      req.addElement("a").addAttribute("n","zimbraCalResType").setText("Location");                                            
                                                    
                      Element tagsResponse = soapHttpTransport.invoke(req);
                      out.println("Created: ".concat(thislocresname));                      
                      }                      
                   else
                      {
                      out.println("<b>Error:</b> No name given for equipment<br>");                      
                      }
                   }
                else if (request.getParameter("action").equals("getmine"))
                   {
                   // Get all my resources and return in a manner that is easy to digest in Javascript (split())
                   XMLElement req = new XMLElement("GetAllCalendarResourcesRequest");
                   req.addAttribute("xmlns", "urn:zimbraAdmin");                                                                       
                   Element tagsResponse = soapHttpTransport.invoke(req);
                   String allcals = tagsResponse.toString();
                   allcals = allcals.replaceAll("\"", "");   
   
                   CharSequence cals_inputStr = allcals;
                   String cals_patternStr = "<calresource id=(\\S+) name=(\\S+)>";
                   Pattern cals_pattern = Pattern.compile(cals_patternStr);
                   Matcher cals_matcher = cals_pattern.matcher(cals_inputStr);
                   
                   String outdata = "";
                   
                   int uuidlen = uuid.trim().length();
                   while(cals_matcher.find())
                      {
                      String rid = cals_matcher.group(1);
                      String rname = cals_matcher.group(2); 
                      if (rname.trim().substring(0,uuidlen).equals(uuid))
                         {
                         outdata = outdata.concat(rid.trim().concat("|").concat(rname.trim().concat("||")));
                         }
                      }
                   out.println(outdata);
                   }   
                else if (request.getParameter("action").equals("delcal"))
                   {                          
                   if (request.getParameter("calid") != null)
                      {
                      if (request.getParameter("calid").length() > 0)
                         {
                         // Get the calendar resource details                                            
                         String thiscal = "";
                         XMLElement thiscalreq = new XMLElement("GetCalendarResourceRequest");
                         thiscalreq.addAttribute("xmlns", "urn:zimbraAdmin");
                         thiscalreq.addElement("calresource").addAttribute("by","id").setText(request.getParameter("calid"));                                                                                          
                         Element thiscaltagsResponse = soapHttpTransport.invoke(thiscalreq); 
                         thiscal = thiscaltagsResponse.toString();                   
                         
                         thiscal = thiscal.replaceAll("\"", "");                            
                         CharSequence thiscal_inputStr = thiscal;
                         String thiscal_patternStr = "name=(\\S+)>";
                         Pattern thiscal_pattern = Pattern.compile(thiscal_patternStr);
                         Matcher thiscal_matcher = thiscal_pattern.matcher(thiscal_inputStr);                   
                   
                         String thiscalname = "";
                         while(thiscal_matcher.find())
                            {
                            thiscalname = thiscal_matcher.group(1).toString(); 
                            }
                   
                         // Now match up the username from the start of the calendar name and make sure that this user "owns" it
                         int uuidlen = uuid.trim().length();
                         if (thiscalname.substring(0,uuidlen).equals(uuid))
                            {
                            out.println("<b>Delete Resource</b><br>");
                            XMLElement req = new XMLElement("DeleteCalendarResourceRequest");
                            req.addAttribute("xmlns", "urn:zimbraAdmin");
                            Element calid = req.addElement("id").setText(request.getParameter("calid"));                                                                                          
                            Element tagsResponse = soapHttpTransport.invoke(req);
                            String delcals = tagsResponse.toString();            
                            out.println("Deleted: ".concat(thiscalname));
                            }
                         else {
                            out.println("<b>Error:</b> You do not own this calendar!<br>");           
                            }                            
                         }
                      else {
                         out.println("<b>Error:</b> Calendar ID cannot be empty<br>");                         
                         }                         
                      }
                   else {
                      out.println("<b>Error:</b> No calendar selected to delete<br>");                      
                      }                                            
                   }                                    
                else if (request.getParameter("action").equals("about")) {
                   out.println("<center><b>Resource Administrator v0.2</b><br><a href='http://wayne.edu'>Wayne State University</a><br></center><br>The Resource Administrator is a tool that allows you to create and delete your own resource calendars.  These resources are accessible to other users system-wide and can be scheduled by other users.");
                   }
                else {
                   out.println("<b>Error:</b> Unknown Action<br>");                   
                   }       
               }
            }
         else {
            out.println("<b>Error:</b> I don't know who you are!<br>");            
            }   
         }
      else {
         out.println("<b>Error:</b> Your authentication cookie is empty?<br>");      
         }
      }
   else {
      out.println("<b>Error:</b> Your are not authenticated<br>");      
      }      
   }      
else {
   out.println("<b>Error:</b> You have no cookies<br>");
   }
         
%>
